/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.creation;

import br.ufrj.labma.enibam.creation.CreationManagerException;
import br.ufrj.labma.enibam.graphic.GraphicAngle;
import br.ufrj.labma.enibam.graphic.GraphicArc;
import br.ufrj.labma.enibam.graphic.GraphicArcInteriorSector;
import br.ufrj.labma.enibam.graphic.GraphicArcInteriorSegment;
import br.ufrj.labma.enibam.graphic.GraphicArea;
import br.ufrj.labma.enibam.graphic.GraphicAxes;
import br.ufrj.labma.enibam.graphic.GraphicCircle;
import br.ufrj.labma.enibam.graphic.GraphicCircleInterior;
import br.ufrj.labma.enibam.graphic.GraphicCircleLocus;
import br.ufrj.labma.enibam.graphic.GraphicCircularSector;
import br.ufrj.labma.enibam.graphic.GraphicCircularSegment;
import br.ufrj.labma.enibam.graphic.GraphicConic;
import br.ufrj.labma.enibam.graphic.GraphicExpression;
import br.ufrj.labma.enibam.graphic.GraphicFunction;
import br.ufrj.labma.enibam.graphic.GraphicLength;
import br.ufrj.labma.enibam.graphic.GraphicLine;
import br.ufrj.labma.enibam.graphic.GraphicLineLocus;
import br.ufrj.labma.enibam.graphic.GraphicLocus;
import br.ufrj.labma.enibam.graphic.GraphicObject;
import br.ufrj.labma.enibam.graphic.GraphicPoint;
import br.ufrj.labma.enibam.graphic.GraphicPolygon;
import br.ufrj.labma.enibam.graphic.GraphicRatio;
import br.ufrj.labma.enibam.graphic.GraphicRay;
import br.ufrj.labma.enibam.graphic.GraphicRayLocus;
import br.ufrj.labma.enibam.graphic.GraphicSegment;
import br.ufrj.labma.enibam.graphic.GraphicSegmentLocus;
import br.ufrj.labma.enibam.graphic.GraphicState;
import br.ufrj.labma.enibam.graphic.GraphicText;
import br.ufrj.labma.enibam.graphic.GraphicTriangle;
import br.ufrj.labma.enibam.graphic.GraphicUnitaryMeasure;
import br.ufrj.labma.enibam.graphic.GraphicVector;
import br.ufrj.labma.enibam.gui.ViewportInterface;
import br.ufrj.labma.enibam.history.RelationshipTable;
import br.ufrj.labma.enibam.history.ae.MakeElement;
import br.ufrj.labma.enibam.history.exception.RelationshipException;
import br.ufrj.labma.enibam.kernel.FactoryCreationParameter;
import br.ufrj.labma.enibam.kernel.KernelProxy;
import br.ufrj.labma.enibam.kernel.expression.ExpressionNode;
import br.ufrj.labma.enibam.kernel.expression.KernelOperand;
import br.ufrj.labma.enibam.kernel.expression.Syntactic;
import br.ufrj.labma.enibam.kernel.operations.CoorSys;
import br.ufrj.labma.enibam.kernel.state.AngleState;
import br.ufrj.labma.enibam.kernel.state.AreaState;
import br.ufrj.labma.enibam.kernel.state.LengthState;
import br.ufrj.labma.enibam.kernel.state.LocusState;
import br.ufrj.labma.enibam.kernel.state.PointState;
import br.ufrj.labma.enibam.kernel.state.PolygonState;
import br.ufrj.labma.enibam.kernel.state.RatioState;
import br.ufrj.labma.enibam.kernel.state.State;
import br.ufrj.labma.enibam.kernel.state.TextState;
import br.ufrj.labma.enibam.macro.MacroInspector;
import br.ufrj.labma.enibam.util.EngineRule;
import br.ufrj.labma.enibam.util.Identification;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CreationManager {
    private RelationshipTable itsTable;
    private List itsList;
    private int itsID;
    private Set itsSet = new HashSet();
    private CoorSys coord = new CoorSys();
    private State objectState;
    private PointState pointState;
    private static List possibilityList = new ArrayList();
    private static List ambiguityList = new ArrayList();

    public CreationManager() {
        this.itsTable = new RelationshipTable();
        this.itsList = new ArrayList();
    }

    public void copy(Integer OID, GraphicState graphicState, State state, FactoryCreationParameter FCP, KernelProxy kp, ViewportInterface vp) {
        List graphicObjects = this.create(OID, (FactoryCreationParameter)FCP.clone(), state, graphicState, kp, vp, true, false, 0);
        if (graphicObjects != null) {
            int i = 0;
            while (i < graphicObjects.size()) {
                GraphicObject graphic = (GraphicObject)graphicObjects.get(i);
                if (graphic != null) {
                    vp.insert(graphic);
                }
                ++i;
            }
            vp.getTM().register(graphicObjects);
        }
        vp.getTM().disturb(0, 0);
    }

    private List create(Integer OID, FactoryCreationParameter FCP, State objectState, GraphicState graphicState, KernelProxy kp, ViewportInterface vp, boolean relationship, boolean all, int order) {
        String function_exp = "";
        ArrayList<GraphicObject> graphicList = new ArrayList<GraphicObject>();
        try {
            GraphicObject GO;
            int length;
            GraphicObject graphic;
            List list = relationship ? this.getID(FCP.getParentsList()) : FCP.getParentsList();
            FCP.setParentsList(list);
            int[] itsVector = kp.create(FCP);
            if (objectState instanceof PointState) {
                if (order > 0 && order < itsVector.length) {
                    this.itsID = itsVector[order];
                } else {
                    this.itsID = itsVector[0];
                    int j = 0;
                    while (j < itsVector.length) {
                        PointState itsState = (PointState)kp.getState(itsVector[j]);
                        this.pointState = (PointState)objectState;
                        if (Math.abs(itsState.itsX - this.pointState.itsX) < 10.0 && Math.abs(itsState.itsY - this.pointState.itsY) < 10.0) {
                            this.itsID = itsVector[j];
                            break;
                        }
                        ++j;
                    }
                }
            } else {
                this.itsID = order >= 0 && order < itsVector.length ? itsVector[order] : itsVector[0];
            }
            if (all && objectState instanceof PointState || FCP.getConstructionID() == 5020 || FCP.getConstructionID() == 5100 || FCP.getConstructionID() == 5039) {
                this.itsTable.insert((int)OID, this.itsID);
                this.pointState = (PointState)objectState;
                this.coord.itsX = this.pointState.itsX;
                this.coord.itsY = this.pointState.itsY;
                kp.move(this.itsID, this.coord, this.itsSet);
                GraphicObject GO2 = vp.getAt(this.itsID);
                if (GO2 == null && (graphic = new GraphicPoint()) != null) {
                    graphic.setState(vp, objectState);
                    if (graphicState != null) {
                        graphic.setGraphicState((GraphicState)graphicState.clone());
                    }
                    graphic.setID(this.itsID);
                    graphic.setConstructionID(FCP.getConstructionID());
                    graphicList.add(graphic);
                }
                return graphicList;
            }
            if (FCP.getConstructionID() == 4240) {
                this.itsTable.insert((int)OID, itsVector);
                boolean more = kp.getImediateParents((Integer)list.get(1)).contains((Integer)list.get(0));
                int i = 0;
                while (i < itsVector.length) {
                    GraphicObject graphic2;
                    GraphicObject GO3 = vp.getAt(itsVector[i]);
                    if (GO3 == null && (graphic2 = CreationManager.getGraphicObject(FCP.getConstructionID())) != null) {
                        graphic2.setState(vp, objectState);
                        if (graphicState != null) {
                            graphic2.setGraphicState((GraphicState)graphicState.clone());
                        }
                        graphic2.setID(itsVector[i]);
                        graphic2.setConstructionID(FCP.getConstructionID());
                        graphicList.add(graphic2);
                    }
                    if (more) break;
                    ++i;
                }
                return graphicList;
            }
            this.itsTable.insert((int)OID, this.itsID);
            if (objectState instanceof LocusState && (length = FCP.getParameters().size()) >= 2) {
                LocusState _st = (LocusState)kp.getState(itsVector[0]);
                int param1 = (Integer)FCP.getParameters().get(1);
                int type = (Integer)FCP.getParameters().get(0);
                switch (type) {
                    case 8010: {
                        param1 *= 5;
                        break;
                    }
                    case 5010: 
                    case 5011: 
                    case 5014: 
                    case 5017: 
                    case 5021: 
                    case 5024: 
                    case 5027: 
                    case 8020: 
                    case 8070: {
                        break;
                    }
                    case 5012: 
                    case 5013: 
                    case 5015: 
                    case 5016: 
                    case 5018: 
                    case 5019: 
                    case 5022: 
                    case 5023: 
                    case 5025: 
                    case 5026: 
                    case 5028: 
                    case 5029: 
                    case 5033: 
                    case 5034: 
                    case 5035: 
                    case 5036: 
                    case 5037: 
                    case 5038: 
                    case 5043: 
                    case 5044: 
                    case 5045: 
                    case 5046: 
                    case 5047: 
                    case 5048: 
                    case 8030: 
                    case 8040: 
                    case 8050: 
                    case 8060: {
                        param1 *= 2;
                    }
                }
                _st.sizeIt(param1);
                objectState = _st;
            }
            if (objectState instanceof PolygonState) {
                PolygonState _st = (PolygonState)kp.getState(itsVector[0]);
                _st.sizeIt(list.size());
                objectState = _st;
            }
            if (objectState instanceof PointState) {
                this.pointState = (PointState)objectState;
                this.coord.itsX = this.pointState.itsX;
                this.coord.itsY = this.pointState.itsY;
                kp.move(this.itsID, this.coord, this.itsSet);
            }
            if ((GO = vp.getAt(this.itsID)) != null) {
                return graphicList;
            }
            graphic = CreationManager.getGraphicObject(FCP.getConstructionID());
            if (graphic != null) {
                graphic.setState(vp, objectState);
                if (graphic.getClassID() == 5033) {
                    ((GraphicFunction)graphic).setExpression(function_exp);
                } else if (graphic.getClassID() == 5070) {
                    int numpoints = list.size();
                    int i = 0;
                    while (i < list.size()) {
                        GO = vp.getAt((Integer)list.get(i));
                        if (GO instanceof GraphicPolygon) {
                            GraphicPolygon GP = (GraphicPolygon)GO;
                            numpoints = GP.getNPoints();
                            break;
                        }
                        ++i;
                    }
                    ((GraphicPolygon)graphic).setNPoints(numpoints);
                } else if (graphic.getClassID() == 5034) {
                    ((GraphicExpression)graphic).setTokens(FCP.getParameters());
                }
                if (graphicState != null) {
                    graphic.setGraphicState((GraphicState)graphicState.clone());
                }
                graphic.setID(this.itsID);
                graphic.setConstructionID(FCP.getConstructionID());
                graphicList.add(graphic);
                return graphicList;
            }
            return null;
        }
        catch (Exception e) {
            System.out.println(e + "  CreationManager - 115\n");
            e.printStackTrace();
            return null;
        }
    }

    public List create(MakeElement me, KernelProxy kp, ViewportInterface vp, boolean relationship, boolean all) {
        List graphicList;
        FactoryCreationParameter FCP = new FactoryCreationParameter(new Integer(me.getActionID()), me.getParents());
        this.objectState = me.getState();
        if (this.objectState instanceof LocusState) {
            int length = me.getParameterList().size();
            if (length >= 1) {
                FCP.setParamI0((Integer)me.getParameterList().get(0));
            }
            if (length >= 2) {
                FCP.setParamI1((Integer)me.getParameterList().get(1));
            }
        } else if (me.getActionID() == 5020 || me.getActionID() == 5039 || me.getActionID() == 5100) {
            int length = me.getParameterList().size();
            if (length >= 1) {
                FCP.setParamI0((Integer)me.getParameterList().get(0));
            }
        } else if (me.getActionID() == 5042) {
            int length = me.getParameterList().size();
            if (length >= 1) {
                String function_exp = (String)me.getParameterList().get(0);
                FCP.setParamI2(function_exp);
            }
        } else if (me.getActionID() == 5200) {
            try {
                if (relationship) {
                    me.setParameterList(this.changeCalculatorId(me.getParameterList(), 5200));
                }
            }
            catch (RelationshipException e) {
                e.printStackTrace();
            }
            FCP.setExpressionNode(Syntactic.mountTree(me.getParameterList()));
        } else if (me.getActionID() == 1091) {
            FCP.setParamI2(((TextState)this.objectState).itsText);
        } else if (me.getActionID() == 1050) {
            FCP.setParamI3(((AngleState)me.getState()).itsAngle);
        } else if (me.getActionID() == 1051) {
            FCP.setParamI3(((AreaState)me.getState()).itsArea);
        } else if (me.getActionID() == 1052) {
            LengthState ss = (LengthState)me.getState();
            RatioState rs = new RatioState();
            rs.itsRatio = ss.itsLength;
            rs.itsDefinedStatus = ss.itsDefinedStatus;
            rs.itsDeletedStatus = ss.itsDeletedStatus;
            rs.itsMID = new Integer(ss.itsMID);
            me.setActionID(1040);
            me.setState(rs);
            FCP.setParamI3(((RatioState)me.getState()).itsRatio);
        } else if (me.getActionID() == 1040) {
            FCP.setParamI3(((RatioState)me.getState()).itsRatio);
        }
        if ((graphicList = this.create(new Integer(me.getObjectID()), FCP, me.getState(), me.getGraphicState(), kp, vp, relationship, all, me.getOrder())) != null && graphicList.size() > 0) {
            me.setObjectID(((GraphicObject)graphicList.get(0)).getID(), MacroInspector.identifyOrder(((GraphicObject)graphicList.get(0)).getID(), kp));
            me.setParents(FCP.getParentsList());
            me.setState(kp.getState(((GraphicObject)graphicList.get(0)).getID()));
        }
        return graphicList;
    }

    public RelationshipTable getRelationship() {
        return new RelationshipTable(this.itsTable);
    }

    public void updateIDMap(int oldId, int newId) {
        this.itsTable.insert(oldId, newId);
    }

    private List getID(List list) throws RelationshipException {
        if (list == null || list.isEmpty() || this.itsTable.isEmpty()) {
            return list;
        }
        this.itsList.clear();
        int i = 0;
        while (i < list.size()) {
            try {
                Integer id = (Integer)list.get(i);
                int kernel_id = this.itsTable.getKernelID(id);
                if (kernel_id < 0) {
                    this.itsList.add(id);
                } else {
                    this.itsList.add(new Integer(kernel_id));
                }
            }
            catch (Exception e) {
                this.itsList.addAll(list.subList(i, list.size()));
                return this.itsList;
            }
            ++i;
        }
        return this.itsList;
    }

    private Integer getID(Integer old_id) throws RelationshipException {
        if (old_id == null || this.itsTable.isEmpty()) {
            throw new RelationshipException("Erro no relacionamento.");
        }
        try {
            int kernel_id = this.itsTable.getKernelID(old_id);
            return new Integer(kernel_id);
        }
        catch (Exception e) {
            throw new RelationshipException("Erro no relacionamento. ERROR:" + e);
        }
    }

    private List changeCalculatorId(List parentlist, int CID) throws RelationshipException {
        ArrayList<KernelOperand> list = new ArrayList<KernelOperand>(parentlist);
        if (CID == 5200) {
            int i = 0;
            while (i < list.size()) {
                ExpressionNode node = (ExpressionNode)list.get(i);
                if (node instanceof KernelOperand) {
                    Integer mid = ((KernelOperand)node).getMID();
                    KernelOperand n = new KernelOperand(this.getID(mid));
                    n.setRight(node.getRight());
                    n.setLeft(node.getLeft());
                    list.set(i, n);
                }
                ++i;
            }
        }
        return list;
    }

    public static boolean hasLocusState(int CID) {
        return CID == 8030 || CID == 8040 || CID == 8050 || CID == 8060 || CID == 8010 || CID == 5010 || CID == 8070 || CID == 8020 || CID == 5048 || CID == 5047 || CID == 5045 || CID == 5043 || CID == 5044 || CID == 5046 || CID == 5038 || CID == 5037 || CID == 5035 || CID == 5033 || CID == 5034 || CID == 5036 || CID == 5015 || CID == 5012 || CID == 5028 || CID == 5018 || CID == 5022 || CID == 5025 || CID == 5016 || CID == 5013 || CID == 5029 || CID == 5019 || CID == 5023 || CID == 5026 || CID == 5014 || CID == 5011 || CID == 5027 || CID == 5017 || CID == 5021 || CID == 5024;
    }

    public static GraphicObject getGraphicObject(int CID) {
        switch (CreationManager.getGraphicID(CID)) {
            case 5000: {
                return new GraphicPoint();
            }
            case 5005: {
                return new GraphicLine();
            }
            case 5010: {
                return new GraphicSegment();
            }
            case 5015: {
                return new GraphicRay();
            }
            case 5020: {
                return new GraphicCircle();
            }
            case 5025: {
                return new GraphicRatio();
            }
            case 5030: {
                return new GraphicAngle();
            }
            case 5031: {
                return new GraphicLength();
            }
            case 5032: {
                return new GraphicArea();
            }
            case 5033: {
                return new GraphicFunction();
            }
            case 5034: {
                return new GraphicExpression();
            }
            case 5035: {
                return new GraphicVector();
            }
            case 5040: {
                return new GraphicLocus();
            }
            case 5050: {
                return new GraphicConic();
            }
            case 5060: {
                return new GraphicTriangle();
            }
            case 5070: {
                return new GraphicPolygon();
            }
            case 5080: 
            case 5085: {
                return new GraphicArc();
            }
            case 5086: {
                return new GraphicCircularSector();
            }
            case 5087: {
                return new GraphicCircularSegment();
            }
            case 5021: {
                return new GraphicCircleInterior();
            }
            case 5022: {
                return new GraphicArcInteriorSector();
            }
            case 5023: {
                return new GraphicArcInteriorSegment();
            }
            case 5090: {
                return new GraphicLineLocus();
            }
            case 5095: {
                return new GraphicCircleLocus();
            }
            case 5099: {
                return new GraphicRayLocus();
            }
            case 5097: {
                return new GraphicSegmentLocus();
            }
            case 5110: {
                return new GraphicUnitaryMeasure();
            }
            case 9050: {
                return new GraphicText();
            }
            case 5200: {
                return new GraphicAxes();
            }
        }
        return null;
    }

    public static int getGraphicID(int CID) {
        switch (CID) {
            case 1000: 
            case 2000: 
            case 2001: 
            case 2002: 
            case 2010: 
            case 2011: 
            case 2020: 
            case 2030: 
            case 3000: 
            case 3010: 
            case 3020: 
            case 3030: 
            case 3040: 
            case 3050: 
            case 3100: 
            case 3101: 
            case 4010: 
            case 4060: 
            case 4110: 
            case 4151: 
            case 4170: 
            case 4190: 
            case 4233: 
            case 4241: 
            case 4242: 
            case 5020: 
            case 5039: 
            case 5100: 
            case 5300: 
            case 5301: 
            case 5302: 
            case 7009: {
                return 5000;
            }
            case 1010: 
            case 3200: 
            case 3210: 
            case 4020: 
            case 4070: 
            case 4120: 
            case 4210: 
            case 4230: 
            case 4235: 
            case 4240: 
            case 5030: 
            case 6010: 
            case 6061: {
                return 5005;
            }
            case 1011: 
            case 4040: 
            case 4090: 
            case 4140: 
            case 4211: 
            case 4231: 
            case 4236: 
            case 6011: 
            case 7101: 
            case 7102: 
            case 7103: 
            case 7104: 
            case 7105: {
                return 5010;
            }
            case 1012: 
            case 3220: 
            case 4030: 
            case 4080: 
            case 4130: 
            case 4212: 
            case 4232: 
            case 4237: 
            case 6012: 
            case 6060: {
                return 5015;
            }
            case 1020: 
            case 4050: 
            case 4100: 
            case 4150: 
            case 4200: 
            case 4220: 
            case 4234: 
            case 6020: 
            case 6021: 
            case 6022: 
            case 6023: 
            case 7005: 
            case 7006: {
                return 5020;
            }
            case 1030: 
            case 5031: 
            case 5032: 
            case 6030: {
                return 5035;
            }
            case 1040: 
            case 4160: 
            case 4162: {
                return 5025;
            }
            case 1050: 
            case 4180: 
            case 5201: {
                return 5030;
            }
            case 5010: 
            case 5011: 
            case 5014: 
            case 5017: 
            case 5021: 
            case 5024: 
            case 5027: 
            case 8010: 
            case 8020: 
            case 8070: {
                return 5040;
            }
            case 6050: 
            case 6051: 
            case 6052: 
            case 6053: 
            case 6054: 
            case 6055: 
            case 6056: 
            case 7106: 
            case 7107: {
                return 5050;
            }
            case 6070: {
                return 5060;
            }
            case 4185: {
                return 5080;
            }
            case 5012: 
            case 5015: 
            case 5018: 
            case 5022: 
            case 5025: 
            case 5028: 
            case 8030: {
                return 5090;
            }
            case 5013: 
            case 5016: 
            case 5019: 
            case 5023: 
            case 5026: 
            case 5029: 
            case 8040: {
                return 5095;
            }
            case 5033: 
            case 5034: 
            case 5035: 
            case 5036: 
            case 5037: 
            case 5038: 
            case 8050: {
                return 5097;
            }
            case 5043: 
            case 5044: 
            case 5045: 
            case 5046: 
            case 5047: 
            case 5048: 
            case 8060: {
                return 5099;
            }
            case 6090: 
            case 6091: 
            case 6092: 
            case 6093: 
            case 6094: 
            case 6095: 
            case 6096: {
                return 5070;
            }
            case 1052: 
            case 5041: 
            case 5203: {
                return 5031;
            }
            case 5040: 
            case 5202: {
                return 5032;
            }
            case 5200: {
                return 5034;
            }
            case 5042: {
                return 5033;
            }
            case 6100: 
            case 6101: 
            case 6102: 
            case 6103: 
            case 6104: 
            case 6105: 
            case 6106: 
            case 7001: 
            case 7002: 
            case 7003: 
            case 7004: 
            case 7007: 
            case 7008: {
                return 5085;
            }
            case 5066: {
                return 5022;
            }
            case 5067: {
                return 5023;
            }
            case 5065: {
                return 5021;
            }
            case 1091: {
                return 9050;
            }
            case 5050: {
                return 5086;
            }
            case 5055: {
                return 5087;
            }
            case 5060: {
                return 5110;
            }
            case 5400: {
                return 5200;
            }
        }
        System.out.println("Mapeamento com erro: getGraphicID(" + CID + ") - CreationManager");
        return -1;
    }

    public static final List filterPossibility(List objects, List expected) {
        if (objects == null || expected == null) {
            return objects;
        }
        possibilityList.clear();
        int i = 0;
        while (i < objects.size()) {
            Identification ID = (Identification)objects.get(i);
            int j = 0;
            while (j < expected.size()) {
                if ((Integer)expected.get(j) == ID.itsClassID) {
                    possibilityList.add(ID);
                }
                ++j;
            }
            ++i;
        }
        return possibilityList;
    }

    public static final List checkAmbiguity(List objects, List expected) throws CreationManagerException {
        if (objects == null || expected == null) {
            throw new CreationManagerException("CreationManager => expectedList: " + expected + " objectList: " + objects);
        }
        ambiguityList.clear();
        int i = 0;
        while (i < expected.size()) {
            if (((EngineRule)expected.get(i)).check(objects)) {
                ambiguityList.addAll(((EngineRule)expected.get(i)).getRulePossibilityList());
            }
            ++i;
        }
        return ambiguityList;
    }
}

