/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.creation;

import br.ufrj.labma.enibam.creation.AbstractCreationMachine;
import br.ufrj.labma.enibam.creation.AbstractEngine;
import br.ufrj.labma.enibam.creation.CreationMachine;
import br.ufrj.labma.enibam.creation.CreationMachineProxyBase;
import br.ufrj.labma.enibam.creation.CreationMachineStore;
import br.ufrj.labma.enibam.creation.accelerator.ConstructionsAccelerator;
import br.ufrj.labma.enibam.creation.accelerator.PolarCoordinateAccelerator;
import br.ufrj.labma.enibam.creation.engine.PolarCoordinateEngine;
import br.ufrj.labma.enibam.creation.text.PolarCoordinateCreationMachineText;
import br.ufrj.labma.enibam.gui.ButtonMachineComponent;
import br.ufrj.labma.enibam.gui.MenuMachineComponent;
import br.ufrj.labma.enibam.tm.TransactionInterface;
import java.awt.Insets;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class PolarCoordinateCreationMachine
extends AbstractCreationMachine
implements CreationMachine,
CreationMachineProxyBase {
    private int IDENTIFICATION;
    private static final Insets itsMARGIN = new Insets(1, 1, 1, 1);
    private static CreationMachine theInstance;

    static {
        CreationMachineStore.getInstance().Register((CreationMachineProxyBase)new PolarCoordinateCreationMachine());
    }

    public PolarCoordinateCreationMachine(TransactionInterface ti) {
        this.acceleratorList.add(new PolarCoordinateAccelerator(ti));
        this.engine = new PolarCoordinateEngine(ti);
        this.rulePossibilityList.addAll(((AbstractEngine)this.engine).getRulePossibilityList());
        this.expectedIDList.addAll(((AbstractEngine)this.engine).getClassIDExpectedList());
        this.abort();
    }

    public PolarCoordinateCreationMachine() {
        this.abort();
    }

    public void abort() {
        if (this.engine != null) {
            this.engine.stop();
        }
    }

    public String action(List obj, double x, double y) {
        return this.engine.run(obj, x, y);
    }

    public boolean canBuild(List obj) {
        Iterator i = this.acceleratorList.iterator();
        while (i.hasNext()) {
            if (!((ConstructionsAccelerator)i.next()).accept(obj)) continue;
            return true;
        }
        return true;
    }

    public ConstructionsAccelerator getAccelerator(List obj) {
        for (ConstructionsAccelerator CA : this.acceleratorList) {
            if (!CA.accept(obj)) continue;
            return CA;
        }
        return null;
    }

    public JComponent getComponent() {
        ButtonMachineComponent _tmp = new ButtonMachineComponent(this.getIcon32(), this.IDENTIFICATION, "Criar uma Coordenada : clique em um eixo ");
        _tmp.setMargin(itsMARGIN);
        _tmp.setToolTipText("Criar Ponto referente ao eixo ...");
        _tmp.setFamily("POINT");
        return _tmp;
    }

    public Icon getIcon16() {
        return new ImageIcon(PolarCoordinateCreationMachineText.Icon16);
    }

    public Icon getIcon32() {
        return new ImageIcon(PolarCoordinateCreationMachineText.Icon32);
    }

    public Icon getIcon32Selected() {
        return new ImageIcon(PolarCoordinateCreationMachineText.Icon32S);
    }

    public JLabel getLabel() {
        return new JLabel("Coordenada referente a um eixo ");
    }

    public String getMenuBase() {
        return "Ponto";
    }

    public JMenuItem getMenuComponent() {
        MenuMachineComponent mi = new MenuMachineComponent("Coordenada referente a um eixo ", this.getIcon16(), this.IDENTIFICATION, "Criar uma Coordenada : clique em um eixo ");
        mi.setMnemonic(-1);
        mi.setAccelerator(KeyStroke.getKeyStroke(48, 2));
        return mi;
    }

    public Set getUpDateList() {
        return this.engine.getUpDateList();
    }

    public boolean isRootFamily() {
        return false;
    }

    public List simulate() {
        return null;
    }

    public List simulationUpdate(int x, int y) {
        return null;
    }

    public CreationMachine CreateObject(TransactionInterface ti) {
        if (theInstance == null) {
            theInstance = new PolarCoordinateCreationMachine();
        }
        return theInstance;
    }

    public int getIdentification() {
        return this.IDENTIFICATION;
    }
}

