/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.graphic;

import br.ufrj.labma.enibam.graphic.GraphicLabel;
import br.ufrj.labma.enibam.graphic.GraphicObject;
import br.ufrj.labma.enibam.graphic.GraphicParameters;
import br.ufrj.labma.enibam.graphic.GraphicState;
import br.ufrj.labma.enibam.gui.ConversionFunctions;
import br.ufrj.labma.enibam.kernel.state.AngleState;
import br.ufrj.labma.enibam.kernel.state.State;
import br.ufrj.labma.enibam.tm.EPSGraphics2D;
import br.ufrj.labma.enibam.util.GraphicUtilities;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;

public final class GraphicAngle
extends GraphicObject
implements GraphicParameters {
    private double itsAngle = 0.0;
    private String AngleStr = "";
    private FontMetrics fm;
    private int itsLength;
    private int precision = 3;
    private boolean degree = true;
    private AngleState itsTmp;
    private Rectangle2D rect2D = new Rectangle2D.Float();

    public GraphicAngle() {
        this.GS = new GraphicState("angle: ");
        this.setDotState(this.GS.itsDotStatus);
        this.graphicLabel = new GraphicLabel(this);
    }

    public GraphicAngle(int x, int y) {
        this.GS = new GraphicState("angle: ");
        this.GS.itsX = x - 10;
        this.GS.itsY = y - 10;
        this.setDotState(this.GS.itsDotStatus);
        this.graphicLabel = new GraphicLabel(this);
    }

    public final double getAngle() {
        return this.itsAngle;
    }

    @Override
    public final void Move(int x, int y) {
        this.GS.itsX = x;
        this.GS.itsY = y;
    }

    @Override
    public final void translate(int dx, int dy) {
        this.GS.itsX += dx;
        this.GS.itsY += dy;
    }

    @Override
    public final boolean atMe(int x, int y) {
        if (!this.GS.itsDefinedStatus || !this.GS.itsVisibleStatus) {
            return false;
        }
        double _x0 = this.GS.itsX;
        double _x1 = this.GS.itsX + this.itsLength;
        double _y0 = this.GS.itsY - 20;
        double _y1 = this.GS.itsY + 5;
        boolean _b = _x0 < (double)x && _x1 > (double)x && _y0 < (double)y && _y1 > (double)y;
        return _b;
    }

    private void drawHideMode(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setPaint(GraphicObject.STROKE_COLOR);
        g2.setStroke(GraphicObject.STROKE_HIDE_MODE);
        this.AngleStr = this.degree ? this.toDegree(this.itsAngle) : this.valueOf(this.itsAngle);
        g2.drawString("<" + this.GS.itsLabel + " = " + this.AngleStr, this.GS.itsX, this.GS.itsY);
    }

    @Override
    public final void draw(Graphics g) {
        if (this.GS.hideMode) {
            this.drawHideMode(g);
            return;
        }
        if (!this.GS.itsDefinedStatus || !this.GS.itsVisibleStatus) {
            return;
        }
        g.setFont(this.GS.itsFont);
        this.fm = g.getFontMetrics(this.GS.itsFont);
        this.AngleStr = this.degree ? this.toDegree(this.itsAngle) : this.valueOf(this.itsAngle);
        if (!this.isSelected) {
            if (this.GS.itsLabelStatus) {
                g.setColor(this.GS.labelColor);
                if (this.debug) {
                    g.drawString("ID: " + this.getID(), this.GS.itsX, this.GS.itsY);
                } else {
                    g.drawString("<" + this.GS.itsLabel + " = ", this.GS.itsX, this.GS.itsY);
                }
                g.setColor(this.GS.myColor);
                g.drawString(this.AngleStr, this.GS.itsX + this.fm.stringWidth("<" + this.GS.itsLabel + " = "), this.GS.itsY);
                this.itsLength = this.fm.stringWidth("<" + this.GS.itsLabel + " = " + this.AngleStr);
            } else {
                g.setColor(this.GS.myColor);
                g.drawString(this.AngleStr, this.GS.itsX, this.GS.itsY);
                this.itsLength = this.fm.stringWidth(this.AngleStr);
            }
        } else if (this.GS.itsLabelStatus) {
            g.setColor(this.GS.colorWhenSelected);
            if (this.debug) {
                g.drawString("ID: " + this.getID(), this.GS.itsX, this.GS.itsY);
            } else {
                g.drawString("<" + this.GS.itsLabel + " = " + this.AngleStr, this.GS.itsX, this.GS.itsY);
            }
            this.itsLength = this.fm.stringWidth("<" + this.GS.itsLabel + " = " + this.AngleStr);
        } else {
            g.setColor(this.GS.colorWhenSelected);
            g.drawString(this.AngleStr, this.GS.itsX, this.GS.itsY);
            this.itsLength = this.fm.stringWidth(this.AngleStr);
        }
        if (this.decoratorOverMe) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setPaint(GraphicObject.DECORATOR_STROKE_COLOR);
            g2.setStroke(GraphicObject.DECORATOR_SOLID_STROKE);
            this.rect2D = this.GS.itsLabelStatus ? this.fm.getStringBounds(("<" + this.GS.itsLabel + " = " + this.AngleStr).trim(), g) : this.fm.getStringBounds(this.AngleStr.trim(), g);
            this.rect2D.setFrame(this.GS.itsX - 5, this.GS.itsY - 15, this.rect2D.getWidth() + 10.0, this.rect2D.getHeight() + 5.0);
            g2.draw(this.rect2D);
        }
    }

    @Override
    public void toEPS(EPSGraphics2D g) {
        if (!this.GS.itsDefinedStatus || !this.GS.itsVisibleStatus) {
            return;
        }
        g.setFont(this.GS.itsFont);
        this.AngleStr = this.degree ? this.toDegree(this.itsAngle) : this.valueOf(this.itsAngle);
        if (!this.isSelected) {
            if (this.GS.itsLabelStatus) {
                g.setColor(this.GS.labelColor);
                if (this.debug) {
                    g.drawString("ID: " + this.getID(), this.GS.itsX, this.GS.itsY);
                } else {
                    g.drawString("<" + this.GS.itsLabel + " = ", this.GS.itsX, this.GS.itsY);
                }
                g.setColor(this.GS.myColor);
                g.drawString(this.AngleStr, this.GS.itsX + this.fm.stringWidth("<" + this.GS.itsLabel + " = "), this.GS.itsY);
            } else {
                g.setColor(this.GS.myColor);
                g.drawString(this.AngleStr, this.GS.itsX, this.GS.itsY);
            }
        } else if (this.GS.itsLabelStatus) {
            g.setColor(this.GS.colorWhenSelected);
            if (this.debug) {
                g.drawString("ID: " + this.getID(), this.GS.itsX, this.GS.itsY);
            } else {
                g.drawString("<" + this.GS.itsLabel + " = " + this.AngleStr, this.GS.itsX, this.GS.itsY);
            }
        } else {
            g.setColor(this.GS.colorWhenSelected);
            g.drawString(this.AngleStr, this.GS.itsX, this.GS.itsY);
        }
    }

    @Override
    public final int getClassID() {
        return 5030;
    }

    @Override
    public void setState(ConversionFunctions view, State s) {
        this.itsTmp = (AngleState)s;
        this.itsAngle = this.itsTmp.itsAngle;
        this.GS.itsDefinedStatus = this.itsTmp.itsDefinedStatus;
    }

    @Override
    public State getState(ConversionFunctions view) {
        AngleState ls = new AngleState();
        ls.itsMID = this.itsID;
        ls.itsDefinedStatus = this.GS.itsDefinedStatus;
        ls.itsAngle = this.itsAngle;
        return ls;
    }

    @Override
    public boolean inside(Rectangle rect) {
        if (!this.GS.itsDefinedStatus || !this.GS.itsVisibleStatus) {
            return false;
        }
        return this.GS.itsX >= rect.x && this.GS.itsX <= rect.x + rect.width && this.GS.itsY >= rect.y && this.GS.itsY <= rect.y + rect.height && this.GS.itsX + this.itsLength >= rect.x && this.GS.itsX + this.itsLength <= rect.x + rect.width && this.GS.itsY - 20 >= rect.y && this.GS.itsY - 20 <= rect.y + rect.height;
    }

    public String toString() {
        return "ID: " + this.getID() + " ClassID: " + this.getClassID() + " Construction: " + this.getConstructionID() + "\n";
    }

    public void setDegree(boolean b) {
        this.degree = b;
    }

    private String toDegree(double x) {
        x = 180.0 * x / Math.PI;
        int grau = (int)x;
        int minuto = (int)((x - (double)grau) * 60.0);
        int segundo = (int)(((x - (double)grau) * 60.0 - (double)minuto) * 60.0);
        return grau + "\u00b0" + Math.abs(minuto) + "'" + Math.abs(segundo) + "''";
    }

    private String valueOf(double x) {
        return GraphicUtilities.roundValue(x, this.precision);
    }

    @Override
    public boolean hasKernelState() {
        return true;
    }

    @Override
    public boolean GUIonly() {
        return true;
    }

    @Override
    public String getDescription() {
        return "Angulo " + this.GS.itsLabel;
    }

    @Override
    public float getXSource() {
        return this.GS.itsX;
    }

    @Override
    public float getYSource() {
        return this.GS.itsY;
    }
}

