/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.graphic;

import br.ufrj.labma.enibam.graphic.GraphicObject;
import br.ufrj.labma.enibam.graphic.GraphicState;
import br.ufrj.labma.enibam.graphic.label.CircularObjectLabel;
import br.ufrj.labma.enibam.graphic.label.GraphicCircleLabel;
import br.ufrj.labma.enibam.gui.ConversionFunctions;
import br.ufrj.labma.enibam.kernel.state.ArcState;
import br.ufrj.labma.enibam.kernel.state.State;
import br.ufrj.labma.enibam.tm.EPSGraphics2D;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Arc2D;

public final class GraphicArc
extends GraphicObject
implements CircularObjectLabel {
    private ArcState itsTmp;
    public double itsCenterX;
    public double itsCenterY;
    public double itsRadius;
    public double itsStartingAngle;
    public double itsArcAngle;
    private Arc2D arc2D = new Arc2D.Float();

    public GraphicArc() {
        this.GS = new GraphicState("arc: ");
        this.setDotState(this.GS.itsDotStatus);
        this.graphicLabel = new GraphicCircleLabel(this);
    }

    public GraphicArc(int x, int y) {
        this.GS = new GraphicState("arc: ");
        this.GS.itsX = x - 10;
        this.GS.itsY = y - 10;
        this.setDotState(this.GS.itsDotStatus);
        this.graphicLabel = new GraphicCircleLabel(this);
    }

    @Override
    public final void Move(int x, int y) {
        this.GS.itsX = x;
        this.GS.itsY = y;
    }

    @Override
    public final void translate(int dx, int dy) {
        this.GS.itsX += dx;
        this.GS.itsY += dy;
    }

    @Override
    public final boolean atMe(int x, int y) {
        if (!this.GS.itsDefinedStatus || !this.GS.itsVisibleStatus) {
            return false;
        }
        double _d = Math.sqrt(Math.pow((double)x - this.itsCenterX, 2.0) + Math.pow((double)y - this.itsCenterY, 2.0));
        if (Math.abs(_d - this.itsRadius) <= 5.0) {
            double vec_x = (double)x - this.itsCenterX;
            double vec_y = (double)y - this.itsCenterY;
            double vec_rx = this.rotateX(vec_x, vec_y, -this.itsStartingAngle);
            double vec_ry = this.rotateY(vec_x, vec_y, -this.itsStartingAngle);
            double ang_r = this.angle(vec_rx, vec_ry);
            if (this.itsArcAngle < 0.0) {
                return ang_r <= -this.itsArcAngle;
            }
            return (ang_r = Math.PI * 2 - ang_r) <= this.itsArcAngle;
        }
        return false;
    }

    private final double rotateX(double vecx, double vecy, double theta) {
        return vecx * Math.cos(theta) - vecy * Math.sin(theta);
    }

    private final double rotateY(double vecx, double vecy, double theta) {
        return vecx * Math.sin(theta) + vecy * Math.cos(theta);
    }

    private final double angle(double v2x, double v2y) {
        double innerP = v2x;
        double cosang = innerP / Math.sqrt(v2x * v2x + v2y * v2y);
        double ang = Math.acos(cosang);
        if (v2y > 0.0) {
            ang = Math.PI * 2 - ang;
        }
        return ang;
    }

    private void drawHideMode(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setPaint(GraphicObject.STROKE_COLOR);
        g2.setStroke(GraphicObject.STROKE_HIDE_MODE);
        double start = this.itsStartingAngle * 180.0 / Math.PI;
        double angle = this.itsArcAngle * 180.0 / Math.PI;
        this.arc2D.setArc(this.itsCenterX - this.itsRadius, this.itsCenterY - this.itsRadius, 2.0 * this.itsRadius, 2.0 * this.itsRadius, -start, -angle, 0);
        g2.draw(this.arc2D);
    }

    @Override
    public final void draw(Graphics g) {
        if (this.GS.hideMode) {
            this.drawHideMode(g);
            return;
        }
        if (!this.GS.itsDefinedStatus || !this.GS.itsVisibleStatus) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        if (this.isSelected) {
            g2.setPaint(this.GS.colorWhenSelected);
        } else {
            g2.setPaint(this.GS.myColor);
        }
        g2.setStroke(this.stroke);
        double start = this.itsStartingAngle * 180.0 / Math.PI;
        double angle = this.itsArcAngle * 180.0 / Math.PI;
        this.arc2D.setArc(this.itsCenterX - this.itsRadius, this.itsCenterY - this.itsRadius, 2.0 * this.itsRadius, 2.0 * this.itsRadius, -start, -angle, 0);
        g2.draw(this.arc2D);
        this.graphicLabel.draw((Graphics2D)g);
        if (this.decoratorOverMe) {
            g2.setPaint(GraphicObject.DECORATOR_STROKE_COLOR);
            g2.setStroke(GraphicObject.DECORATOR_SOLID_STROKE);
            this.arc2D.setArc(this.itsCenterX - this.itsRadius - 5.0, this.itsCenterY - this.itsRadius - 5.0, 2.0 * this.itsRadius + 10.0, 2.0 * this.itsRadius + 10.0, -start, -angle, 0);
            g2.draw(this.arc2D);
        }
    }

    @Override
    public void toEPS(EPSGraphics2D g2) {
        if (!this.GS.itsDefinedStatus || !this.GS.itsVisibleStatus) {
            return;
        }
        if (this.isSelected) {
            g2.setPaint(this.GS.colorWhenSelected);
        } else {
            g2.setPaint(this.GS.myColor);
        }
        g2.setStroke(this.stroke);
        double start = this.itsStartingAngle * 180.0 / Math.PI;
        double angle = this.itsArcAngle * 180.0 / Math.PI;
        this.arc2D.setArc(this.itsCenterX - this.itsRadius, this.itsCenterY - this.itsRadius, 2.0 * this.itsRadius, 2.0 * this.itsRadius, start, angle, 0);
        g2.draw(this.arc2D);
        this.graphicLabel.draw(g2);
    }

    @Override
    public final int getClassID() {
        return 5085;
    }

    @Override
    public void setState(ConversionFunctions view, State s) {
        this.itsTmp = (ArcState)s;
        this.world.itsX = this.itsTmp.itsCenterX;
        this.world.itsY = this.itsTmp.itsCenterY;
        view.ToScreen(this.world, this.coord);
        this.itsCenterX = this.coord.itsX;
        this.itsCenterY = this.coord.itsY;
        this.itsRadius = Math.round((float)this.itsTmp.itsRadius / (float)view.getZoom());
        this.itsStartingAngle = this.itsTmp.itsStartingAngle;
        this.itsArcAngle = this.itsTmp.itsArcAngle;
        this.GS.itsDefinedStatus = this.itsTmp.itsDefinedStatus;
    }

    @Override
    public State getState(ConversionFunctions view) {
        ArcState ls = new ArcState();
        ls.itsMID = this.itsID;
        ls.itsDefinedStatus = this.GS.itsDefinedStatus;
        this.coord.itsX = this.itsCenterX;
        this.coord.itsY = this.itsCenterY;
        view.ToWorld(this.coord, this.world);
        ls.itsCenterX = this.world.itsX;
        ls.itsCenterY = this.world.itsY;
        ls.itsRadius = this.itsRadius * view.getZoom();
        ls.itsStartingAngle = this.itsStartingAngle;
        ls.itsArcAngle = this.itsArcAngle;
        return ls;
    }

    @Override
    public boolean inside(Rectangle rect) {
        if (!this.GS.itsDefinedStatus || !this.GS.itsVisibleStatus) {
            return false;
        }
        return this.itsCenterX - this.itsRadius >= (double)rect.x && this.itsCenterX + this.itsRadius <= (double)(rect.x + rect.width) && this.itsCenterY - this.itsRadius >= (double)rect.y && this.itsCenterY + this.itsRadius <= (double)(rect.y + rect.height);
    }

    public String toString() {
        return "ID: " + this.getID() + " ClassID: " + this.getClassID() + " Construction: " + this.getConstructionID() + "\n";
    }

    @Override
    public String getDescription() {
        return "arco " + this.GS.itsLabel;
    }

    @Override
    public boolean hasKernelState() {
        return true;
    }

    @Override
    public boolean GUIonly() {
        return false;
    }

    @Override
    public float getXSource() {
        return (float)this.itsCenterX;
    }

    @Override
    public float getYSource() {
        return (float)this.itsCenterY;
    }

    @Override
    public final int getRadius() {
        return (int)this.itsRadius;
    }
}

