/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.graphic;

import br.ufrj.labma.enibam.graphic.GraphicObject;
import br.ufrj.labma.enibam.graphic.GraphicState;
import br.ufrj.labma.enibam.graphic.label.CircularObjectLabel;
import br.ufrj.labma.enibam.graphic.label.GraphicCircleLabel;
import br.ufrj.labma.enibam.gui.ConversionFunctions;
import br.ufrj.labma.enibam.kernel.state.ArcInteriorSegmentState;
import br.ufrj.labma.enibam.kernel.state.State;
import br.ufrj.labma.enibam.tm.EPSGraphics2D;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Arc2D;

public final class GraphicArcInteriorSegment
extends GraphicObject
implements CircularObjectLabel {
    private ArcInteriorSegmentState itsTmp;
    public double itsCenterX;
    public double itsCenterY;
    public double itsRadius;
    public double itsStartingAngle;
    public double itsAngle;
    private Arc2D arc2D = new Arc2D.Float(1);

    public GraphicArcInteriorSegment() {
        this.GS = new GraphicState("arc: ");
        this.setDotState(this.GS.itsDotStatus);
        this.graphicLabel = new GraphicCircleLabel(this);
    }

    public GraphicArcInteriorSegment(int x, int y) {
        this.GS = new GraphicState("arc: ");
        this.GS.itsX = x - 10;
        this.GS.itsY = y - 10;
        this.setDotState(this.GS.itsDotStatus);
        this.graphicLabel = new GraphicCircleLabel(this);
    }

    @Override
    public final void Move(int x, int y) {
        this.GS.itsX = x;
        this.GS.itsY = y;
    }

    @Override
    public final void translate(int dx, int dy) {
        this.GS.itsX += dx;
        this.GS.itsY += dy;
    }

    @Override
    public final boolean atMe(int x, int y) {
        if (!this.GS.itsDefinedStatus || !this.GS.itsVisibleStatus) {
            return false;
        }
        this.arc2D.setArcType(2);
        boolean containsArc = this.arc2D.contains(x, y);
        this.arc2D.setArcType(1);
        if (!containsArc) {
            return false;
        }
        int[] xPoints = new int[3];
        int[] yPoints = new int[3];
        xPoints[0] = (int)this.itsCenterX;
        yPoints[0] = (int)this.itsCenterY;
        xPoints[1] = (int)this.arc2D.getStartPoint().getX();
        yPoints[1] = (int)this.arc2D.getStartPoint().getY();
        xPoints[2] = (int)this.arc2D.getEndPoint().getX();
        yPoints[2] = (int)this.arc2D.getEndPoint().getY();
        Polygon triangle = new Polygon(xPoints, yPoints, xPoints.length);
        return !triangle.contains(x, y);
    }

    private void drawHideMode(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setPaint(GraphicObject.STROKE_COLOR);
        g2.setStroke(GraphicObject.STROKE_HIDE_MODE);
        double start = this.itsStartingAngle * 180.0 / Math.PI;
        double angle = this.itsAngle * 180.0 / Math.PI;
        this.arc2D.setArc(this.itsCenterX - this.itsRadius, this.itsCenterY - this.itsRadius, 2.0 * this.itsRadius, 2.0 * this.itsRadius, start, angle, 1);
        g2.fill(this.arc2D);
    }

    @Override
    public final void draw(Graphics g) {
        if (this.GS.hideMode) {
            this.drawHideMode(g);
            return;
        }
        if (!this.GS.itsDefinedStatus || !this.GS.itsVisibleStatus) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        if (this.isSelected) {
            g2.setPaint(this.GS.colorWhenSelected);
        } else {
            g2.setPaint(this.GS.myColor);
        }
        g2.setStroke(this.stroke);
        double start = this.itsStartingAngle * 180.0 / Math.PI;
        double angle = this.itsAngle * 180.0 / Math.PI;
        this.arc2D.setArc(this.itsCenterX - this.itsRadius, this.itsCenterY - this.itsRadius, 2.0 * this.itsRadius, 2.0 * this.itsRadius, start, angle, 1);
        g2.fill(this.arc2D);
        this.graphicLabel.draw((Graphics2D)g);
    }

    @Override
    public void toEPS(EPSGraphics2D g2) {
        if (!this.GS.itsDefinedStatus || !this.GS.itsVisibleStatus) {
            return;
        }
        if (this.isSelected) {
            g2.setPaint(this.GS.colorWhenSelected);
        } else {
            g2.setPaint(this.GS.myColor);
        }
        g2.setStroke(this.stroke);
        double start = this.itsStartingAngle * 180.0 / Math.PI;
        double angle = this.itsAngle * 180.0 / Math.PI;
        this.arc2D.setArc(this.itsCenterX - this.itsRadius, this.itsCenterY - this.itsRadius, 2.0 * this.itsRadius, 2.0 * this.itsRadius, start, angle, 1);
        g2.fill(this.arc2D);
        this.graphicLabel.draw(g2);
    }

    @Override
    public final int getClassID() {
        return 5022;
    }

    @Override
    public void setState(ConversionFunctions view, State s) {
        this.itsTmp = (ArcInteriorSegmentState)s;
        this.world.itsX = this.itsTmp.itsCenterX;
        this.world.itsY = this.itsTmp.itsCenterY;
        view.ToScreen(this.world, this.coord);
        this.itsCenterX = this.coord.itsX;
        this.itsCenterY = this.coord.itsY;
        this.itsRadius = Math.round((float)this.itsTmp.itsRadius / (float)view.getZoom());
        this.itsStartingAngle = this.itsTmp.itsStartingAngle;
        this.itsAngle = this.itsTmp.itsAngle;
        this.GS.itsDefinedStatus = this.itsTmp.itsDefinedStatus;
    }

    @Override
    public State getState(ConversionFunctions view) {
        ArcInteriorSegmentState ls = new ArcInteriorSegmentState();
        ls.itsMID = this.itsID;
        ls.itsDefinedStatus = this.GS.itsDefinedStatus;
        this.coord.itsX = this.itsCenterX;
        this.coord.itsY = this.itsCenterY;
        view.ToWorld(this.coord, this.world);
        ls.itsCenterX = this.world.itsX;
        ls.itsCenterY = this.world.itsY;
        ls.itsRadius = this.itsRadius * view.getZoom();
        ls.itsStartingAngle = this.itsStartingAngle;
        ls.itsAngle = this.itsAngle;
        return ls;
    }

    @Override
    public boolean inside(Rectangle rect) {
        if (!this.GS.itsDefinedStatus || !this.GS.itsVisibleStatus) {
            return false;
        }
        return rect.contains((int)this.arc2D.getStartPoint().getX(), (int)this.arc2D.getStartPoint().getY()) && rect.contains((int)this.arc2D.getEndPoint().getX(), (int)this.arc2D.getEndPoint().getY());
    }

    public String toString() {
        return "ID: " + this.getID() + " ClassID: " + this.getClassID() + " Construction: " + this.getConstructionID() + "\n";
    }

    @Override
    public String getDescription() {
        return "arco " + this.GS.itsLabel;
    }

    @Override
    public boolean hasKernelState() {
        return true;
    }

    @Override
    public boolean GUIonly() {
        return false;
    }

    @Override
    public float getXSource() {
        return (float)this.itsCenterX;
    }

    @Override
    public float getYSource() {
        return (float)this.itsCenterY;
    }

    @Override
    public final int getRadius() {
        return (int)this.itsRadius;
    }
}

