/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.graphic;

import br.ufrj.labma.enibam.graphic.GraphicLabel;
import br.ufrj.labma.enibam.graphic.GraphicLine;
import br.ufrj.labma.enibam.graphic.GraphicObject;
import br.ufrj.labma.enibam.graphic.GraphicParameters;
import br.ufrj.labma.enibam.graphic.GraphicPoint;
import br.ufrj.labma.enibam.graphic.GraphicState;
import br.ufrj.labma.enibam.gui.ConversionFunctions;
import br.ufrj.labma.enibam.kernel.state.AxesState;
import br.ufrj.labma.enibam.kernel.state.GenericLineState;
import br.ufrj.labma.enibam.kernel.state.State;
import br.ufrj.labma.enibam.tm.EPSGraphics2D;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;

public final class GraphicAxes
extends GraphicObject
implements GraphicParameters {
    private GenericLineState state = new GenericLineState();
    private AxesState itsTmp;
    private GraphicLine line1 = new GraphicLine();
    private GraphicLine line2 = new GraphicLine();

    public GraphicAxes() {
        this.GS = new GraphicState("eixo");
        this.line1 = new GraphicLine();
        this.line2 = new GraphicLine();
        this.setDotState(this.GS.itsDotStatus);
        this.graphicLabel = new GraphicLabel(this);
    }

    public GraphicAxes(GraphicPoint p1, GraphicPoint p2, GraphicPoint p3) {
        this.GS = new GraphicState("eixo");
        this.line1 = new GraphicLine(p1, p2);
        this.line2 = new GraphicLine(p3, p2);
        this.setDotState(this.GS.itsDotStatus);
        this.graphicLabel = new GraphicLabel(this);
    }

    @Override
    public void selected(boolean b) {
        super.selected(b);
        this.line1.selected(b);
        this.line2.selected(b);
    }

    @Override
    public final void Move(int x, int y) {
        this.line1.Move(x, y);
    }

    @Override
    public final void translate(int dx, int dy) {
        this.line1.translate(dx, dy);
    }

    @Override
    public final boolean atMe(int x, int y) {
        if (!this.GS.itsDefinedStatus || !this.GS.itsVisibleStatus) {
            return false;
        }
        return this.line1.atMe(x, y) || this.line2.atMe(x, y);
    }

    private void drawHideMode(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setPaint(GraphicObject.STROKE_COLOR);
        g2.setStroke(GraphicObject.STROKE_HIDE_MODE);
        this.line1.drawHideMode(g);
        this.line2.drawHideMode(g);
    }

    @Override
    public final void draw(Graphics g) {
        if (this.GS.hideMode) {
            this.drawHideMode(g);
            return;
        }
        if (!this.GS.itsDefinedStatus || !this.GS.itsVisibleStatus) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        if (this.isSelected) {
            g2.setPaint(this.GS.colorWhenSelected);
        } else {
            g2.setPaint(this.GS.myColor);
        }
        g2.setStroke(this.stroke);
        this.line1.draw(g);
        this.line2.draw(g);
        this.graphicLabel.draw((Graphics2D)g);
    }

    @Override
    public final void toEPS(EPSGraphics2D g2) {
        if (!this.GS.itsDefinedStatus || !this.GS.itsVisibleStatus) {
            return;
        }
        if (this.isSelected) {
            g2.setPaint(this.GS.colorWhenSelected);
        } else {
            g2.setPaint(this.GS.myColor);
        }
        g2.setStroke(this.stroke);
        this.line1.toEPS(g2);
        this.line2.toEPS(g2);
        this.graphicLabel.draw(g2);
    }

    @Override
    public final int getClassID() {
        return 5200;
    }

    @Override
    public void setState(ConversionFunctions view, State s) {
        this.itsTmp = (AxesState)s;
        this.state.itsDefinedStatus = this.itsTmp.itsDefinedStatus;
        this.state.itsDeletedStatus = this.itsTmp.itsDeletedStatus;
        this.state.itsX1 = this.itsTmp.itsX1;
        this.state.itsX2 = this.itsTmp.itsOriginX;
        this.state.itsY1 = this.itsTmp.itsY1;
        this.state.itsY2 = this.itsTmp.itsOriginY;
        this.line1.setState(view, this.state);
        this.state.itsX1 = this.itsTmp.itsX2;
        this.state.itsX2 = this.itsTmp.itsOriginX;
        this.state.itsY1 = this.itsTmp.itsY2;
        this.state.itsY2 = this.itsTmp.itsOriginY;
        this.line2.setState(view, this.state);
        this.GS.itsDefinedStatus = this.itsTmp.itsDefinedStatus;
    }

    @Override
    public State getState(ConversionFunctions view) {
        AxesState as = new AxesState();
        as.itsMID = this.itsID;
        as.itsDefinedStatus = this.GS.itsDefinedStatus;
        as.itsX1 = this.line1.getP1().itsX;
        as.itsY1 = this.line1.getP1().itsY;
        as.itsX2 = this.line2.getP1().itsX;
        as.itsY2 = this.line2.getP1().itsY;
        as.itsOriginX = this.line1.getP2().itsX;
        as.itsOriginY = this.line1.getP2().itsY;
        return as;
    }

    @Override
    public boolean inside(Rectangle rect) {
        if (!this.GS.itsDefinedStatus || !this.GS.itsVisibleStatus) {
            return false;
        }
        return this.line1.inside(rect) || this.line2.inside(rect);
    }

    @Override
    public String getDescription() {
        return "eixo " + this.GS.itsLabel;
    }

    public String toString() {
        return "ID: " + this.getID() + " ClassID: " + this.getClassID() + " Construction: " + this.getConstructionID() + "\n";
    }

    @Override
    public boolean hasKernelState() {
        return true;
    }

    @Override
    public boolean GUIonly() {
        return false;
    }

    @Override
    public float getXSource() {
        return (float)this.line1.getP1().itsX;
    }

    @Override
    public float getYSource() {
        return (float)this.line1.getP1().itsY;
    }

    public int getRadius() {
        return 0;
    }
}

