/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.graphic;

import br.ufrj.labma.enibam.graphic.GraphicObject;
import br.ufrj.labma.enibam.graphic.GraphicPoint;
import br.ufrj.labma.enibam.graphic.GraphicState;
import br.ufrj.labma.enibam.graphic.label.CircularObjectLabel;
import br.ufrj.labma.enibam.graphic.label.GraphicCircleLabel;
import br.ufrj.labma.enibam.gui.ConversionFunctions;
import br.ufrj.labma.enibam.kernel.operations.CoorSys;
import br.ufrj.labma.enibam.kernel.state.CircleState;
import br.ufrj.labma.enibam.kernel.state.State;
import br.ufrj.labma.enibam.tm.EPSGraphics2D;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Ellipse2D;

public final class GraphicCircle
extends GraphicObject
implements CircularObjectLabel {
    private int itsRadius;
    private int itsDiameter;
    private int itsPx = 0;
    private int itsPy = 0;
    private CoorSys Center = new CoorSys();
    private CoorSys P = new CoorSys();
    private double _d;
    private CircleState itsTmp;
    private Ellipse2D circle2D = new Ellipse2D.Float();

    public GraphicCircle() {
        this.GS = new GraphicState("circle");
        this.Center.itsX = 10.0;
        this.Center.itsY = 10.0;
        this.P.itsX = 10.0;
        this.P.itsY = 10.0;
        this.itsRadius = (int)Math.sqrt(Math.pow(this.Center.itsX - this.P.itsX, 2.0) + Math.pow(this.Center.itsY - this.P.itsY, 2.0));
        this.itsDiameter = 2 * this.itsRadius;
        this.setDotState(this.GS.itsDotStatus);
        this.graphicLabel = new GraphicCircleLabel(this);
    }

    public GraphicCircle(GraphicPoint p1, GraphicPoint p2) {
        this.GS = new GraphicState("circle");
        this.Center.itsX = p1.get_X();
        this.Center.itsY = p1.get_Y();
        this.P.itsX = p2.get_X();
        this.P.itsY = p2.get_Y();
        this.itsRadius = (int)Math.sqrt(Math.pow(this.Center.itsX - this.P.itsX, 2.0) + Math.pow(this.Center.itsY - this.P.itsY, 2.0));
        this.itsDiameter = 2 * this.itsRadius;
        this.setDotState(this.GS.itsDotStatus);
        this.graphicLabel = new GraphicCircleLabel(this);
    }

    @Override
    public final void Move(int x, int y) {
        this.P.itsX = x;
        this.P.itsY = y;
        this.itsRadius = (int)Math.sqrt(Math.pow(this.Center.itsX - this.P.itsX, 2.0) + Math.pow(this.Center.itsY - this.P.itsY, 2.0));
        this.itsDiameter = 2 * this.itsRadius;
    }

    @Override
    public final void translate(int dx, int dy) {
    }

    @Override
    public final boolean atMe(int x, int y) {
        if (!this.GS.itsDefinedStatus || !this.GS.itsVisibleStatus) {
            return false;
        }
        this._d = Math.sqrt(Math.pow((double)x - this.Center.itsX, 2.0) + Math.pow((double)y - this.Center.itsY, 2.0));
        this.itsPx = x;
        this.itsPy = y;
        return Math.abs(this._d - (double)this.itsRadius) <= 5.0;
    }

    private void drawHideMode(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setPaint(GraphicObject.STROKE_COLOR);
        g2.setStroke(GraphicObject.STROKE_HIDE_MODE);
        this.circle2D.setFrame(this.Center.itsX - (double)this.itsRadius, this.Center.itsY - (double)this.itsRadius, this.itsDiameter, this.itsDiameter);
        g2.draw(this.circle2D);
    }

    @Override
    public final void draw(Graphics g) {
        if (this.GS.hideMode) {
            this.drawHideMode(g);
            return;
        }
        if (!this.GS.itsDefinedStatus || !this.GS.itsVisibleStatus) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        if (this.isSelected) {
            g2.setPaint(this.GS.colorWhenSelected);
        } else {
            g2.setPaint(this.GS.myColor);
        }
        g2.setStroke(this.stroke);
        if (this.itsRadius < 50000 && this.itsRadius > -50000) {
            this.circle2D.setFrame(this.Center.itsX - (double)this.itsRadius, this.Center.itsY - (double)this.itsRadius, this.itsDiameter, this.itsDiameter);
            g2.draw(this.circle2D);
        }
        this.graphicLabel.draw((Graphics2D)g);
        if (this.decoratorOverMe) {
            g2.setPaint(GraphicObject.DECORATOR_STROKE_COLOR);
            g2.setStroke(GraphicObject.DECORATOR_SOLID_STROKE);
            if (this.itsRadius < 50000 && this.itsRadius > -50000) {
                this.circle2D.setFrame(this.Center.itsX - (double)this.itsRadius - 5.0, this.Center.itsY - (double)this.itsRadius - 5.0, this.itsDiameter + 10, this.itsDiameter + 10);
                g2.draw(this.circle2D);
            }
        }
    }

    @Override
    public final void toEPS(EPSGraphics2D g2) {
        if (!this.GS.itsDefinedStatus || !this.GS.itsVisibleStatus) {
            return;
        }
        if (this.isSelected) {
            g2.setPaint(this.GS.colorWhenSelected);
        } else {
            g2.setPaint(this.GS.myColor);
        }
        g2.setStroke(this.stroke);
        this.circle2D.setFrame(this.Center.itsX - (double)this.itsRadius, this.Center.itsY - (double)this.itsRadius, this.itsDiameter, this.itsDiameter);
        g2.draw(this.circle2D);
        this.graphicLabel.draw(g2);
    }

    @Override
    public final int getClassID() {
        return 5020;
    }

    @Override
    public void setState(ConversionFunctions view, State s) {
        this.itsTmp = (CircleState)s;
        this.world.itsX = this.itsTmp.itsCenterX;
        this.world.itsY = this.itsTmp.itsCenterY;
        view.ToScreen(this.world, this.Center);
        this.itsRadius = Math.round((float)this.itsTmp.itsRadius / (float)view.getZoom());
        this.itsDiameter = 2 * this.itsRadius;
        this.GS.itsDefinedStatus = this.itsTmp.itsDefinedStatus;
    }

    @Override
    public State getState(ConversionFunctions view) {
        CircleState cs = new CircleState();
        cs.itsMID = this.itsID;
        cs.itsDefinedStatus = this.GS.itsDefinedStatus;
        this.coord.itsX = this.Center.itsX;
        this.coord.itsY = this.Center.itsY;
        view.ToWorld(this.coord, this.world);
        cs.itsCenterX = this.world.itsX;
        cs.itsCenterY = this.world.itsY;
        cs.itsRadius = (double)this.itsRadius * view.getZoom();
        return cs;
    }

    @Override
    public boolean inside(Rectangle rect) {
        if (!this.GS.itsDefinedStatus || !this.GS.itsVisibleStatus) {
            return false;
        }
        return this.Center.itsX - (double)this.itsRadius >= (double)rect.x && this.Center.itsX + (double)this.itsRadius <= (double)(rect.x + rect.width) && this.Center.itsY - (double)this.itsRadius >= (double)rect.y && this.Center.itsY + (double)this.itsRadius <= (double)(rect.y + rect.height);
    }

    @Override
    public String getDescription() {
        return "c\u00edrculo " + this.GS.itsLabel;
    }

    public String toString() {
        return "ID: " + this.getID() + " ClassID: " + this.getClassID() + " Construction: " + this.getConstructionID() + "\n";
    }

    @Override
    public boolean hasKernelState() {
        return true;
    }

    @Override
    public boolean GUIonly() {
        return false;
    }

    @Override
    public float getXSource() {
        return (float)this.Center.itsX;
    }

    @Override
    public float getYSource() {
        return (float)this.Center.itsY;
    }

    @Override
    public final int getRadius() {
        return this.itsRadius;
    }
}

