/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.graphic;

import br.ufrj.labma.enibam.graphic.GraphicLabel;
import br.ufrj.labma.enibam.graphic.GraphicObject;
import br.ufrj.labma.enibam.graphic.GraphicParameters;
import br.ufrj.labma.enibam.graphic.GraphicState;
import br.ufrj.labma.enibam.gui.ConversionFunctions;
import br.ufrj.labma.enibam.gui.ViewportInterface;
import br.ufrj.labma.enibam.kernel.operations.CoorSys;
import br.ufrj.labma.enibam.kernel.state.LocusState;
import br.ufrj.labma.enibam.kernel.state.State;
import br.ufrj.labma.enibam.tm.EPSGraphics2D;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Ellipse2D;
import java.util.ArrayList;
import java.util.List;

public final class GraphicCircleLocus
extends GraphicObject
implements GraphicParameters {
    private List itsPointList;
    private List itsCircleList;
    private CoorSys would;
    private CoorSys could = new CoorSys();
    private double _d;
    private LocusState itsTmp;
    private boolean itsVisiblePoints;
    private int NPOINTS = 0;
    private Ellipse2D circle2D = new Ellipse2D.Float();

    public GraphicCircleLocus() {
        this.GS = new GraphicState("Lugar Geometrico");
        this.setDotState(this.GS.itsDotStatus);
        this.itsPointList = new ArrayList();
        this.graphicLabel = new GraphicLabel(this);
    }

    public GraphicCircleLocus(int n) {
        this.GS = new GraphicState("Lugar Geometrico");
        this.NPOINTS = n + n;
        this.itsPointList = new ArrayList(this.NPOINTS);
        this.setDotState(this.GS.itsDotStatus);
        this.graphicLabel = new GraphicLabel(this);
    }

    @Override
    public final void Move(int x, int y) {
    }

    @Override
    public final void translate(int dx, int dy) {
    }

    @Override
    public final boolean atMe(int x, int y) {
        if (!this.GS.itsDefinedStatus || !this.GS.itsVisibleStatus) {
            return false;
        }
        boolean _found = false;
        int _l = this.itsCircleList.size();
        int _i = 0;
        while (_i < _l) {
            locCircle _s = (locCircle)this.itsCircleList.get(_i);
            _found = _s.atMe(x, y);
            if (_found) {
                return true;
            }
            ++_i;
        }
        return false;
    }

    private void drawHideMode(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setPaint(GraphicObject.STROKE_COLOR);
        g2.setStroke(GraphicObject.STROKE_HIDE_MODE);
        int _l = this.itsCircleList.size();
        int _i = 0;
        while (_i < _l) {
            locCircle _s = (locCircle)this.itsCircleList.get(_i);
            _s.draw(g2);
            ++_i;
        }
    }

    @Override
    public final void draw(Graphics g) {
        if (this.GS.hideMode) {
            this.drawHideMode(g);
            return;
        }
        if (!this.GS.itsDefinedStatus || !this.GS.itsVisibleStatus) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        if (this.isSelected) {
            g2.setPaint(this.GS.colorWhenSelected);
        } else {
            g2.setPaint(this.GS.myColor);
        }
        g2.setStroke(this.stroke);
        int _l = this.itsCircleList.size();
        int _i = 0;
        while (_i < _l) {
            locCircle _s = (locCircle)this.itsCircleList.get(_i);
            _s.draw(g2);
            ++_i;
        }
    }

    @Override
    public final void toEPS(EPSGraphics2D g2) {
        if (!this.GS.itsDefinedStatus || !this.GS.itsVisibleStatus) {
            return;
        }
        if (this.isSelected) {
            g2.setPaint(this.GS.colorWhenSelected);
        } else {
            g2.setPaint(this.GS.myColor);
        }
        g2.setStroke(this.stroke);
        int _l = this.itsCircleList.size();
        int _i = 0;
        while (_i < _l) {
            locCircle _s = (locCircle)this.itsCircleList.get(_i);
            _s.toEPS(g2);
            ++_i;
        }
    }

    @Override
    public final int getClassID() {
        return 5095;
    }

    @Override
    public boolean inside(Rectangle rect) {
        if (!this.GS.itsDefinedStatus || !this.GS.itsVisibleStatus) {
            return false;
        }
        return false;
    }

    public String toString() {
        return "ID: " + this.getID() + " ClassID: " + this.getClassID() + " Construction: " + this.getConstructionID() + "\n";
    }

    @Override
    public boolean hasKernelState() {
        return true;
    }

    @Override
    public boolean GUIonly() {
        return false;
    }

    @Override
    public String getDescription() {
        return "locus de c\u00edrculo " + this.GS.itsLabel;
    }

    @Override
    public float getXSource() {
        return 0.0f;
    }

    @Override
    public float getYSource() {
        return 0.0f;
    }

    @Override
    public void setState(ConversionFunctions view, State s) {
        this.itsTmp = (LocusState)s;
        if (this.itsPointList.size() == 0) {
            this.mountList(this.itsTmp.pointList);
        }
        int i = 0;
        while (i < this.itsPointList.size()) {
            this.would = (CoorSys)this.itsTmp.pointList.get(i);
            this.could = (CoorSys)this.itsPointList.get(i);
            if (i % 2 == 0) {
                view.ToScreen(this.would, this.could);
            } else {
                this.could.itsX = this.would.itsX / ((ViewportInterface)view).getZoom();
            }
            ++i;
        }
        this.GS.itsDefinedStatus = this.itsTmp.itsDefinedStatus;
    }

    @Override
    public State getState(ConversionFunctions view) {
        LocusState cs = new LocusState();
        cs.itsMID = this.itsID;
        cs.itsDefinedStatus = this.GS.itsDefinedStatus;
        cs.sizeIt(this.itsPointList.size());
        int i = 0;
        while (i < this.itsPointList.size()) {
            this.would = (CoorSys)cs.pointList.get(i);
            this.could = (CoorSys)this.itsPointList.get(i);
            if (i % 2 == 0) {
                view.ToWorld(this.could, this.would);
            } else {
                this.would.itsX = this.could.itsX * ((ViewportInterface)view).getZoom();
            }
            ++i;
        }
        return cs;
    }

    private void mountList(List p) {
        this.itsVisiblePoints = false;
        int _i = 0;
        int _s = p.size();
        if (_s < 2) {
            return;
        }
        if (this.NPOINTS == 0) {
            this.NPOINTS = _s;
        }
        if (this.itsPointList == null) {
            this.itsPointList = new ArrayList(this.NPOINTS);
        }
        this.itsCircleList = new ArrayList(this.NPOINTS / 2);
        while (_i < this.NPOINTS) {
            CoorSys _tmp1 = (CoorSys)p.get(_i);
            _tmp1 = new CoorSys(_tmp1.itsX, _tmp1.itsY);
            this.itsPointList.add(_tmp1);
            if (++_i >= this.NPOINTS) continue;
            CoorSys _tmp2 = (CoorSys)p.get(_i);
            _tmp2 = new CoorSys(_tmp1.itsX, _tmp1.itsY);
            this.itsPointList.add(_tmp2);
            locCircle _e = new locCircle(_tmp1, _tmp2);
            this.itsCircleList.add(_e);
            ++_i;
        }
    }

    private final class locCircle {
        public CoorSys Center;
        public CoorSys radix;
        public double itsRadius;
        public double itsDiameter;

        private locCircle(CoorSys c1, CoorSys c2) {
            this.Center = c1;
            this.radix = c2;
        }

        private boolean atMe(double x, double y) {
            GraphicCircleLocus.this._d = Math.sqrt(Math.pow(x - this.Center.itsX, 2.0) + Math.pow(y - this.Center.itsY, 2.0));
            return Math.abs(GraphicCircleLocus.this._d - this.itsRadius) <= 5.0;
        }

        private void draw(Graphics2D g) {
            this.itsRadius = this.radix.itsX;
            this.itsDiameter = 2.0 * this.itsRadius;
            GraphicCircleLocus.this.circle2D.setFrame(this.Center.itsX - this.itsRadius, this.Center.itsY - this.itsRadius, this.itsDiameter - 1.0, this.itsDiameter - 1.0);
            g.draw(GraphicCircleLocus.this.circle2D);
        }

        private void toEPS(EPSGraphics2D g2) {
            this.itsRadius = this.radix.itsX;
            this.itsDiameter = 2.0 * this.itsRadius;
            GraphicCircleLocus.this.circle2D.setFrame(this.Center.itsX - this.itsRadius, this.Center.itsY - this.itsRadius, this.itsDiameter - 1.0, this.itsDiameter - 1.0);
            g2.draw(GraphicCircleLocus.this.circle2D);
        }
    }
}

