/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.graphic;

import br.ufrj.labma.enibam.graphic.GraphicLabel;
import br.ufrj.labma.enibam.graphic.GraphicObject;
import br.ufrj.labma.enibam.graphic.GraphicParameters;
import br.ufrj.labma.enibam.graphic.GraphicState;
import br.ufrj.labma.enibam.gui.ConversionFunctions;
import br.ufrj.labma.enibam.kernel.operations.CoorSys;
import br.ufrj.labma.enibam.kernel.state.CoordinateState;
import br.ufrj.labma.enibam.kernel.state.State;
import br.ufrj.labma.enibam.tm.EPSGraphics2D;
import br.ufrj.labma.enibam.util.GraphicUtilities;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;

public final class GraphicCoord
extends GraphicObject
implements GraphicParameters {
    private Rectangle2D rect2D = new Rectangle2D.Float();
    private FontMetrics fm;
    private int itsX = 4700;
    private int itsY = 4700;
    private CoordinateState itsTmp;
    private CoorSys coordtemp = new CoorSys();
    private String itsText1;
    private String itsText2;
    private int whoselected;
    private int tru;
    private Integer itsID;

    public GraphicCoord() {
        this.GS = new GraphicState("coord: ");
        this.setDotState(this.GS.itsDotStatus);
        this.graphicLabel = new GraphicLabel(this);
    }

    public GraphicCoord(int x, int y) {
        this.GS = new GraphicState("coord: ");
        this.graphicLabel = new GraphicLabel(this);
        this.setDotState(this.GS.itsDotStatus);
        this.itsX = x;
        this.itsY = y;
    }

    @Override
    public boolean GUIonly() {
        return true;
    }

    @Override
    public final void Move(int x, int y) {
        this.itsX = x;
        this.itsY = y;
    }

    private final boolean clickInLine(int x, int y) {
        if (this.itsID != null && this.fm != null) {
            int y1 = this.itsY - this.fm.getHeight();
            int y0 = y1 + this.fm.getHeight();
            int x0 = this.itsX;
            int x1 = this.itsX + this.fm.stringWidth(String.valueOf(this.itsText1) + " , " + this.itsText2);
            return x0 < x && x1 > x && y0 > y && y1 < y;
        }
        return false;
    }

    @Override
    public boolean atMe(int x, int y) {
        return this.clickInLine(x, y);
    }

    @Override
    public void draw(Graphics g) {
        if (this.GS.hideMode) {
            this.drawHideMode(g);
            return;
        }
        if (!this.isSelected) {
            if (this.debug) {
                g.drawString("ID:" + this.getID(), this.GS.itsX - 20, this.GS.itsY);
                this.drawText(g, this.GS.myColor);
            } else {
                this.drawText(g, this.GS.myColor);
            }
        } else if (this.debug) {
            g.drawString("ID:" + this.getID(), this.GS.itsX - 20, this.GS.itsY);
            this.drawText(g, this.GS.colorWhenSelected);
        } else {
            this.drawText(g, this.GS.colorWhenSelected);
        }
        if (this.decoratorOverMe) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setPaint(GraphicObject.DECORATOR_STROKE_COLOR);
            g2.setStroke(GraphicObject.DECORATOR_SOLID_STROKE);
            double width = 0.0;
            double height = 0.0;
            String temp15 = "(" + this.itsText1 + " , " + this.itsText2 + ")";
            this.rect2D = this.fm.getStringBounds(temp15.trim(), g);
            width = this.rect2D.getWidth() > width ? this.rect2D.getWidth() : width;
            this.rect2D.setFrame(this.itsX - 5, this.itsY - 15, width + 5.0, (height += this.rect2D.getHeight() + 1.0) + 5.0);
            g2.draw(this.rect2D);
        }
    }

    private void drawHideMode(Graphics g) {
        ((Graphics2D)g).setStroke(GraphicObject.STROKE_HIDE_MODE);
        this.drawText(g, GraphicObject.STROKE_COLOR);
    }

    private void drawText(Graphics g, Color c) {
        this.setText();
        g.setFont(this.GS.itsFont);
        this.fm = g.getFontMetrics(this.GS.itsFont);
        int offset = this.fm.getHeight();
        this.graphicLabel.draw((Graphics2D)g);
        g.setColor(c);
        g.drawString("(" + this.itsText1 + " , " + this.itsText2 + ")", this.itsX, this.itsY);
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public State getState(ConversionFunctions view) {
        CoordinateState ts = new CoordinateState();
        ts.itsMID = this.itsID;
        ts.itsDefinedStatus = this.GS.itsDefinedStatus;
        return ts;
    }

    @Override
    public boolean hasKernelState() {
        return true;
    }

    @Override
    public void setState(ConversionFunctions view, State s) {
        this.itsTmp = (CoordinateState)s;
        this.coordtemp.itsX = this.itsTmp.itsX;
        this.coordtemp.itsY = this.itsTmp.itsY;
        this.GS.itsDefinedStatus = this.itsTmp.itsDefinedStatus;
        if (this.itsID == null) {
            this.itsTmp = (CoordinateState)s;
            this.itsID = s.itsMID;
            this.GS.itsDefinedStatus = this.itsTmp.itsDefinedStatus;
        }
    }

    @Override
    public void toEPS(EPSGraphics2D g2) {
    }

    @Override
    public void translate(int dx, int dy) {
        this.itsX += dx;
        this.itsY += dy;
    }

    @Override
    public boolean inside(Rectangle rect) {
        int y1 = this.itsY - this.fm.getHeight();
        int y0 = y1 + this.fm.getHeight();
        int x0 = this.itsX;
        int x1 = this.itsX + this.fm.stringWidth(String.valueOf(this.itsText1) + " , " + this.itsText2);
        return x0 < rect.x + rect.width && x1 > rect.x && y0 > rect.y && y1 < rect.y + rect.height;
    }

    @Override
    public float getXSource() {
        return this.GS.itsX;
    }

    @Override
    public float getYSource() {
        return this.GS.itsY;
    }

    @Override
    public int getClassID() {
        return 5055;
    }

    public String toString() {
        return "ID: " + this.getID() + " ClassID: " + this.getClassID() + " Construction: " + this.getConstructionID() + "(" + this.itsX + "," + this.itsY + " ) \n";
    }

    public void setReferenceName(String s) {
        this.GS.itsReferenceName = s;
    }

    public String getReferenceName() {
        return this.GS.itsReferenceName;
    }

    public void setText() {
        if (this.itsID != null) {
            this.itsText1 = GraphicUtilities.roundValue(this.coordtemp.itsX, 3);
            this.itsText2 = GraphicUtilities.roundValue(this.coordtemp.itsY, 3);
        }
    }
}

