/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.graphic;

import br.ufrj.labma.enibam.graphic.GraphicObject;
import br.ufrj.labma.enibam.graphic.GraphicParameters;
import br.ufrj.labma.enibam.tm.EPSGraphics2D;
import java.awt.FontMetrics;
import java.awt.Graphics2D;

public class GraphicLabel {
    protected GraphicParameters theObject;
    private double length = 0.0;

    public GraphicLabel(GraphicParameters o) {
        this.theObject = o;
    }

    public void translate(int x, int y) {
        this.theObject.getGraphicState().itsXLabel = (int)(this.theObject.getXSource() - (float)x);
        this.theObject.getGraphicState().itsYLabel = (int)(this.theObject.getYSource() - (float)y);
        this.correctIt();
    }

    public boolean atMe(int x, int y) {
        if (!this.theObject.getDefinedStatus() || !this.theObject.getLabelStatus()) {
            return false;
        }
        double _x0 = this.theObject.getXSource() - (float)this.theObject.getGraphicState().itsXLabel;
        double _x1 = (double)(this.theObject.getXSource() - (float)this.theObject.getGraphicState().itsXLabel) + this.length;
        double _y0 = this.theObject.getYSource() - (float)this.theObject.getGraphicState().itsYLabel - 20.0f;
        double _y1 = this.theObject.getYSource() - (float)this.theObject.getGraphicState().itsYLabel + 5.0f;
        return _x0 < (double)x && _x1 > (double)x && _y0 < (double)y && _y1 > (double)y;
    }

    public void draw(Graphics2D g) {
        if (!this.theObject.getDefinedStatus() || !this.theObject.getLabelStatus()) {
            return;
        }
        this.correctIt();
        g.setFont(this.theObject.getFont());
        FontMetrics fm = g.getFontMetrics(this.theObject.getFont());
        if (((GraphicObject)this.theObject).isSelected()) {
            g.setColor(this.theObject.getColorWhenSelected());
        } else {
            g.setColor(this.theObject.getLabelColor());
        }
        String constraint = ((GraphicObject)this.theObject).isDebugMode() ? " (" + ((GraphicObject)this.theObject).getID() + ")" : "";
        g.drawString(String.valueOf(this.theObject.getLabel()) + constraint, this.theObject.getXSource() - (float)this.theObject.getGraphicState().itsXLabel, this.theObject.getYSource() - (float)this.theObject.getGraphicState().itsYLabel);
        this.length = fm.stringWidth(String.valueOf(this.theObject.getLabel()) + constraint);
    }

    public void draw(EPSGraphics2D g) {
        if (this.theObject.getLabelStatus()) {
            this.correctIt();
            g.setFont(this.theObject.getFont());
            if (((GraphicObject)this.theObject).isSelected()) {
                g.setColor(this.theObject.getColorWhenSelected());
            } else {
                g.setColor(this.theObject.getLabelColor());
            }
            g.drawString(this.theObject.getLabel(), this.theObject.getXSource() - (float)this.theObject.getGraphicState().itsXLabel, this.theObject.getYSource() - (float)this.theObject.getGraphicState().itsYLabel);
        }
    }

    protected void correctIt() {
    }
}

