/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.graphic;

import br.ufrj.labma.enibam.graphic.GraphicLabel;
import br.ufrj.labma.enibam.graphic.GraphicObject;
import br.ufrj.labma.enibam.graphic.GraphicParameters;
import br.ufrj.labma.enibam.graphic.GraphicState;
import br.ufrj.labma.enibam.gui.ConversionFunctions;
import br.ufrj.labma.enibam.kernel.state.LengthState;
import br.ufrj.labma.enibam.kernel.state.State;
import br.ufrj.labma.enibam.tm.EPSGraphics2D;
import br.ufrj.labma.enibam.util.GraphicUtilities;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;

public final class GraphicLength
extends GraphicObject
implements GraphicParameters {
    private double itsLength = 0.0;
    private String LengthStr = "";
    private FontMetrics fm;
    private int length;
    private int precision = 3;
    private LengthState itsTmp;
    private String UNITARY_MEASURE = "cm";
    private boolean showUM = true;
    private Rectangle2D rect2D = new Rectangle2D.Float();

    public GraphicLength() {
        this.GS = new GraphicState("length: ");
        this.setDotState(this.GS.itsDotStatus);
        this.showUM = true;
        this.graphicLabel = new GraphicLabel(this);
    }

    public GraphicLength(boolean showUnity) {
        this.GS = new GraphicState("length: ");
        this.setDotState(this.GS.itsDotStatus);
        this.showUM = showUnity;
        this.graphicLabel = new GraphicLabel(this);
    }

    public GraphicLength(int x, int y) {
        this.GS = new GraphicState("length: ");
        this.GS.itsX = x - 10;
        this.GS.itsY = y - 10;
        this.setDotState(this.GS.itsDotStatus);
        this.showUM = true;
        this.graphicLabel = new GraphicLabel(this);
    }

    public GraphicLength(int x, int y, boolean showUnity) {
        this.GS = new GraphicState("length: ");
        this.GS.itsX = x - 10;
        this.GS.itsY = y - 10;
        this.setDotState(this.GS.itsDotStatus);
        this.showUM = showUnity;
        this.graphicLabel = new GraphicLabel(this);
    }

    public final double getLength() {
        return this.itsLength;
    }

    @Override
    public final void Move(int x, int y) {
        this.GS.itsX = x;
        this.GS.itsY = y;
    }

    @Override
    public final void translate(int dx, int dy) {
        this.GS.itsX += dx;
        this.GS.itsY += dy;
    }

    @Override
    public final boolean atMe(int x, int y) {
        if (!this.GS.itsDefinedStatus || !this.GS.itsVisibleStatus) {
            return false;
        }
        double _x0 = this.GS.itsX;
        double _x1 = this.GS.itsX + this.length;
        double _y0 = this.GS.itsY - 20;
        double _y1 = this.GS.itsY + 5;
        boolean _b = _x0 < (double)x && _x1 > (double)x && _y0 < (double)y && _y1 > (double)y;
        return _b;
    }

    private void drawHideMode(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setPaint(GraphicObject.STROKE_COLOR);
        g2.setStroke(GraphicObject.STROKE_HIDE_MODE);
        this.LengthStr = this.valueOf(this.itsLength);
        g2.drawString(String.valueOf(this.GS.itsLabel) + " = " + this.LengthStr, this.GS.itsX, this.GS.itsY);
    }

    @Override
    public final void draw(Graphics g) {
        if (this.GS.hideMode) {
            this.drawHideMode(g);
            return;
        }
        if (!this.GS.itsDefinedStatus || !this.GS.itsVisibleStatus) {
            return;
        }
        g.setFont(this.GS.itsFont);
        this.fm = g.getFontMetrics(this.GS.itsFont);
        this.LengthStr = this.valueOf(this.itsLength);
        if (!this.isSelected) {
            if (this.GS.itsLabelStatus) {
                g.setColor(this.GS.labelColor);
                if (this.debug) {
                    g.drawString("ID: " + this.getID(), this.GS.itsX, this.GS.itsY);
                } else {
                    g.drawString(String.valueOf(this.GS.itsLabel) + " = ", this.GS.itsX, this.GS.itsY);
                }
                g.setColor(this.GS.myColor);
                g.drawString(this.LengthStr, this.GS.itsX + this.fm.stringWidth(String.valueOf(this.GS.itsLabel) + " = "), this.GS.itsY);
                this.length = this.fm.stringWidth(String.valueOf(this.GS.itsLabel) + " = " + this.LengthStr);
            } else {
                g.setColor(this.GS.myColor);
                g.drawString(this.LengthStr, this.GS.itsX, this.GS.itsY);
                this.length = this.fm.stringWidth(this.LengthStr);
            }
        } else if (this.GS.itsLabelStatus) {
            g.setColor(this.GS.colorWhenSelected);
            if (this.debug) {
                g.drawString("ID: " + this.getID(), this.GS.itsX, this.GS.itsY);
            } else {
                g.drawString(String.valueOf(this.GS.itsLabel) + " = " + this.LengthStr, this.GS.itsX, this.GS.itsY);
            }
            this.length = this.fm.stringWidth(String.valueOf(this.GS.itsLabel) + " = " + this.LengthStr);
        } else {
            g.setColor(this.GS.colorWhenSelected);
            g.drawString(this.LengthStr, this.GS.itsX, this.GS.itsY);
            this.length = this.fm.stringWidth(this.LengthStr);
        }
        if (this.decoratorOverMe) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setPaint(GraphicObject.DECORATOR_STROKE_COLOR);
            g2.setStroke(GraphicObject.DECORATOR_SOLID_STROKE);
            this.rect2D = this.GS.itsLabelStatus ? this.fm.getStringBounds((String.valueOf(this.GS.itsLabel) + " = " + this.LengthStr).trim(), g) : this.fm.getStringBounds(this.LengthStr.trim(), g);
            this.rect2D.setFrame(this.GS.itsX - 5, this.GS.itsY - 15, this.rect2D.getWidth() + 10.0, this.rect2D.getHeight() + 5.0);
            g2.draw(this.rect2D);
        }
    }

    @Override
    public final void toEPS(EPSGraphics2D g) {
        if (!this.GS.itsDefinedStatus || !this.GS.itsVisibleStatus) {
            return;
        }
        g.setFont(this.GS.itsFont);
        this.LengthStr = this.valueOf(this.itsLength);
        if (!this.isSelected) {
            if (this.GS.itsLabelStatus) {
                g.setColor(this.GS.labelColor);
                if (this.debug) {
                    g.drawString("ID: " + this.getID(), this.GS.itsX, this.GS.itsY);
                } else {
                    g.drawString(String.valueOf(this.GS.itsLabel) + " = ", this.GS.itsX, this.GS.itsY);
                }
                g.setColor(this.GS.myColor);
                g.drawString(this.LengthStr, this.GS.itsX + this.fm.stringWidth(String.valueOf(this.GS.itsLabel) + " = "), this.GS.itsY);
            } else {
                g.setColor(this.GS.myColor);
                g.drawString(this.LengthStr, this.GS.itsX, this.GS.itsY);
            }
        } else if (this.GS.itsLabelStatus) {
            g.setColor(this.GS.colorWhenSelected);
            if (this.debug) {
                g.drawString("ID: " + this.getID(), this.GS.itsX, this.GS.itsY);
            } else {
                g.drawString(String.valueOf(this.GS.itsLabel) + " = " + this.LengthStr, this.GS.itsX, this.GS.itsY);
            }
        } else {
            g.setColor(this.GS.colorWhenSelected);
            g.drawString(this.LengthStr, this.GS.itsX, this.GS.itsY);
        }
    }

    @Override
    public final int getClassID() {
        return 5031;
    }

    @Override
    public void setState(ConversionFunctions view, State s) {
        this.itsTmp = (LengthState)s;
        this.itsLength = view.worldLengthToScreen(this.itsTmp.itsLength);
        this.GS.itsDefinedStatus = this.itsTmp.itsDefinedStatus;
    }

    @Override
    public State getState(ConversionFunctions view) {
        LengthState ls = new LengthState();
        ls.itsMID = this.itsID;
        ls.itsDefinedStatus = this.GS.itsDefinedStatus;
        ls.itsLength = view.screenLengthToWorld(this.itsLength);
        return ls;
    }

    @Override
    public boolean inside(Rectangle rect) {
        if (!this.GS.itsDefinedStatus || !this.GS.itsVisibleStatus) {
            return false;
        }
        return this.GS.itsX >= rect.x && this.GS.itsX <= rect.x + rect.width && this.GS.itsY >= rect.y && this.GS.itsY <= rect.y + rect.height && this.GS.itsX + this.length >= rect.x && this.GS.itsX + this.length <= rect.x + rect.width && this.GS.itsY - 20 >= rect.y && this.GS.itsY - 20 <= rect.y + rect.height;
    }

    public String toString() {
        return "ID: " + this.getID() + " ClassID: " + this.getClassID() + " Construction: " + this.getConstructionID() + "\n";
    }

    private String valueOf(double x) {
        String a = GraphicUtilities.roundValue(x, this.precision);
        if (this.showUM) {
            return String.valueOf(a) + this.UNITARY_MEASURE;
        }
        return a;
    }

    @Override
    public boolean hasKernelState() {
        return true;
    }

    @Override
    public boolean GUIonly() {
        return true;
    }

    @Override
    public String getDescription() {
        return "tamanho " + this.GS.itsLabel;
    }

    public void setReferenceName(String s) {
        this.GS.itsReferenceName = s;
    }

    public String getReferenceName() {
        return this.GS.itsReferenceName;
    }

    @Override
    public float getXSource() {
        return this.GS.itsX;
    }

    @Override
    public float getYSource() {
        return this.GS.itsY;
    }
}

