/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.graphic;

import br.ufrj.labma.enibam.graphic.GraphicLabel;
import br.ufrj.labma.enibam.graphic.GraphicObject;
import br.ufrj.labma.enibam.graphic.GraphicParameters;
import br.ufrj.labma.enibam.graphic.GraphicState;
import br.ufrj.labma.enibam.gui.ConversionFunctions;
import br.ufrj.labma.enibam.kernel.operations.CoorSys;
import br.ufrj.labma.enibam.kernel.operations.Utils;
import br.ufrj.labma.enibam.kernel.state.LocusState;
import br.ufrj.labma.enibam.kernel.state.State;
import br.ufrj.labma.enibam.tm.EPSGraphics2D;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;

public final class GraphicLocus
extends GraphicObject
implements GraphicParameters {
    private List itsPointList;
    private List itsSegmentList;
    private CoorSys would;
    private CoorSys could = new CoorSys();
    private LocusState itsTmp;
    private boolean itsVisiblePoints = false;
    private int NPOINTS = 0;
    private Line2D segment2D = new Line2D.Float();
    private Ellipse2D ellipse2D = new Ellipse2D.Float();

    public GraphicLocus() {
        this.GS = new GraphicState("Lugar Geometrico");
        this.setDotState(this.GS.itsDotStatus);
        this.itsPointList = new ArrayList();
        this.graphicLabel = new GraphicLabel(this);
    }

    public GraphicLocus(int n) {
        this.GS = new GraphicState("Lugar Geometrico");
        this.NPOINTS = n;
        this.itsPointList = new ArrayList(this.NPOINTS);
        this.setDotState(this.GS.itsDotStatus);
        this.graphicLabel = new GraphicLabel(this);
    }

    @Override
    public final void Move(int x, int y) {
    }

    @Override
    public final void translate(int dx, int dy) {
    }

    @Override
    public final boolean atMe(int x, int y) {
        if (!this.GS.itsDefinedStatus || !this.GS.itsVisibleStatus) {
            return false;
        }
        boolean _found = false;
        int _l = this.itsSegmentList.size();
        int _i = 0;
        while (_i < _l) {
            CoorSys c = (CoorSys)this.itsPointList.get(_i);
            if ((double)x < c.itsX + 4.0 && (double)x > c.itsX - 4.0 && (double)y < c.itsY + 4.0 && (double)y > c.itsY - 4.0) {
                return true;
            }
            ++_i;
        }
        _i = 0;
        while (_i < _l) {
            locSeg _s = (locSeg)this.itsSegmentList.get(_i);
            _found = _s.atMe(x, y);
            if (_found) {
                return true;
            }
            ++_i;
        }
        return false;
    }

    private void drawHideMode(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setPaint(GraphicObject.STROKE_COLOR);
        g2.setStroke(GraphicObject.STROKE_HIDE_MODE);
        int _l = this.itsSegmentList.size();
        if (this.itsVisiblePoints) {
            _l = this.itsPointList.size();
            int _i = 0;
            while (_i < _l) {
                CoorSys _p = (CoorSys)this.itsPointList.get(_i);
                this.ellipse2D.setFrame(_p.itsX - (double)this.GS.itsX, _p.itsY - (double)this.GS.itsX, this.GS.itsY, this.GS.itsY);
                g2.draw(this.ellipse2D);
                ++_i;
            }
        } else {
            int _i = 0;
            while (_i < _l) {
                locSeg _s = (locSeg)this.itsSegmentList.get(_i);
                _s.draw(g2);
                ++_i;
            }
        }
    }

    @Override
    public final void draw(Graphics g) {
        if (this.GS.hideMode) {
            this.drawHideMode(g);
            return;
        }
        if (!this.GS.itsDefinedStatus || !this.GS.itsVisibleStatus) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        if (this.isSelected) {
            g2.setPaint(this.GS.colorWhenSelected);
        } else {
            g2.setPaint(this.GS.myColor);
        }
        g2.setStroke(this.stroke);
        int _l = this.itsSegmentList.size();
        if (this.itsVisiblePoints) {
            _l = this.itsPointList.size();
            int _i = 0;
            while (_i < _l) {
                CoorSys _p = (CoorSys)this.itsPointList.get(_i);
                this.ellipse2D.setFrame(_p.itsX - (double)this.GS.itsX, _p.itsY - (double)this.GS.itsX, this.GS.itsY, this.GS.itsY);
                g2.draw(this.ellipse2D);
                ++_i;
            }
        } else {
            GeneralPath path = new GeneralPath(0, 2 * _l);
            int _i = 0;
            while (_i < _l) {
                locSeg _s = (locSeg)this.itsSegmentList.get(_i);
                _s.addToPath(path);
                ++_i;
            }
            g2.draw(path);
        }
    }

    @Override
    public final void toEPS(EPSGraphics2D g2) {
        if (!this.GS.itsDefinedStatus || !this.GS.itsVisibleStatus) {
            return;
        }
        if (this.isSelected) {
            g2.setPaint(this.GS.colorWhenSelected);
        } else {
            g2.setPaint(this.GS.myColor);
        }
        g2.setStroke(this.stroke);
        int _l = this.itsSegmentList.size();
        if (this.itsVisiblePoints) {
            _l = this.itsPointList.size();
            int _i = 0;
            while (_i < _l) {
                CoorSys _p = (CoorSys)this.itsPointList.get(_i);
                this.ellipse2D.setFrame(_p.itsX - (double)this.GS.itsX, _p.itsY - (double)this.GS.itsX, this.GS.itsY, this.GS.itsY);
                g2.draw(this.ellipse2D);
                ++_i;
            }
        } else {
            int _i = 0;
            while (_i < _l) {
                locSeg _s = (locSeg)this.itsSegmentList.get(_i);
                _s.toEPS(g2);
                ++_i;
            }
        }
    }

    public final void setRadius(int x) {
        this.GS.itsX = x;
        this.GS.itsY = 2 * this.GS.itsX;
    }

    @Override
    public final int getClassID() {
        return 5040;
    }

    @Override
    public void setState(ConversionFunctions view, State s) {
        this.itsTmp = (LocusState)s;
        if (this.itsPointList.size() == 0) {
            this.mountList(this.itsTmp.pointList);
        }
        int i = 0;
        while (i < this.itsPointList.size()) {
            this.would = (CoorSys)this.itsTmp.pointList.get(i);
            this.could = (CoorSys)this.itsPointList.get(i);
            view.ToScreen(this.would, this.could);
            ++i;
        }
        this.GS.itsDefinedStatus = this.itsTmp.itsDefinedStatus;
    }

    @Override
    public State getState(ConversionFunctions view) {
        LocusState cs = new LocusState();
        cs.itsMID = this.itsID;
        cs.itsDefinedStatus = this.GS.itsDefinedStatus;
        cs.sizeIt(this.itsPointList.size());
        int i = 0;
        while (i < this.itsPointList.size()) {
            this.would = (CoorSys)cs.pointList.get(i);
            this.could = (CoorSys)this.itsPointList.get(i);
            view.ToWorld(this.could, this.would);
            ++i;
        }
        return cs;
    }

    @Override
    public boolean inside(Rectangle rect) {
        if (!this.GS.itsDefinedStatus || !this.GS.itsVisibleStatus) {
            return false;
        }
        return false;
    }

    public void setInterpolate(boolean b) {
        this.itsVisiblePoints = !b;
    }

    public String toString() {
        return "ID: " + this.getID() + " ClassID: " + this.getClassID() + " Construction: " + this.getConstructionID() + "\n";
    }

    @Override
    public boolean hasKernelState() {
        return true;
    }

    @Override
    public boolean GUIonly() {
        return false;
    }

    @Override
    public float getXSource() {
        return 0.0f;
    }

    @Override
    public float getYSource() {
        return 0.0f;
    }

    @Override
    public String getDescription() {
        return "locus " + this.GS.itsLabel;
    }

    private void mountList(List p) {
        locSeg _e;
        int _i = 0;
        CoorSys _o1 = new CoorSys();
        int _s = p.size();
        if (_s < 2) {
            return;
        }
        if (this.NPOINTS == 0) {
            this.NPOINTS = _s;
        }
        if (this.itsPointList == null) {
            this.itsPointList = new ArrayList(this.NPOINTS);
        }
        this.itsSegmentList = new ArrayList(this.NPOINTS);
        CoorSys _tmp = (CoorSys)p.get(_i);
        this.itsPointList.add(new CoorSys((int)_tmp.itsX, (int)_tmp.itsY));
        Object _o2 = this.itsPointList.get(_i);
        _o1 = _o2;
        ++_i;
        while (_i < this.NPOINTS) {
            _tmp = (CoorSys)p.get(_i);
            this.itsPointList.add(new CoorSys((int)_tmp.itsX, (int)_tmp.itsY));
            _o2 = this.itsPointList.get(_i);
            _e = new locSeg(_o1, (CoorSys)_o2);
            this.itsSegmentList.add(_e);
            _o1 = _o2;
            ++_i;
        }
        _e = new locSeg((CoorSys)_o2, (CoorSys)_o2);
        this.itsSegmentList.add(_e);
    }

    private final class locSeg {
        public CoorSys a1;
        public CoorSys a2;
        private double _x1;
        private double _x2;
        private double _y1;
        private double _y2;
        protected double _dx1;
        protected double _dx2;
        protected double _dy1;
        protected double _dy2;
        protected double _d;

        private locSeg(CoorSys c1, CoorSys c2) {
            this.a1 = c1;
            this.a2 = c2;
        }

        private boolean atMe(double x, double y) {
            if (x > this._x1 - 6.0 && x < this._x1 + 6.0 && y < this._y1 + 6.0 && y > this._y1 - 6.0) {
                return true;
            }
            if (this._x1 - this._x2 > 200.0 || this._x1 - this._x2 < -200.0 || this._y1 - this._y2 > 200.0 || this._y1 - this._y2 < -200.0 || this._x1 > 32000.0 || this._y1 > 32000.0 || this._x2 > 32000.0 || this._y2 > 32000.0 || this._x1 < -32000.0 || this._y1 < -32000.0 || this._x2 < -32000.0 || this._y2 < -32000.0) {
                return false;
            }
            this._dx1 = this.a1.itsX;
            this._dy1 = this.a1.itsY;
            this._dx2 = this.a2.itsX;
            this._dy2 = this.a2.itsY;
            double dAB = Utils.distance(this._dx1, this._dy1, x, y);
            double dBC = Utils.distance(x, y, this._dx2, this._dy2);
            double dAC = Utils.distance(this._dx1, this._dy1, this._dx2, this._dy2);
            double r = Math.abs(dAC - dAB - dBC);
            return r <= 1.0;
        }

        private final boolean outOfBounds(double _x1, double _y1, double _x2, double _y2) {
            return _x1 - _x2 > 200.0 || _x1 - _x2 < -200.0 || _y1 - _y2 > 200.0 || _y1 - _y2 < -200.0 || _x1 > 32000.0 || _y1 > 32000.0 || _x2 > 32000.0 || _y2 > 32000.0 || _x1 < -32000.0 || _y1 < -32000.0 || _x2 < -32000.0 || _y2 < -32000.0;
        }

        private void draw(Graphics2D g) {
            this._x1 = this.a1.itsX;
            this._y1 = this.a1.itsY;
            this._x2 = this.a2.itsX;
            this._y2 = this.a2.itsY;
            if (this.outOfBounds(this._x1, this._y1, this._x2, this._y2)) {
                return;
            }
            GraphicLocus.this.segment2D.setLine(this._x1, this._y1, this._x2, this._y2);
            g.draw(GraphicLocus.this.segment2D);
        }

        private void addToPath(GeneralPath path) {
            Point2D p = path.getCurrentPoint();
            if (p == null || p.getX() != this.a1.itsX || p.getY() != this.a1.itsY) {
                path.moveTo(this.a1.itsX, this.a1.itsY);
            }
            if (this.outOfBounds(this.a1.itsX, this.a1.itsY, this.a2.itsX, this.a2.itsY)) {
                path.moveTo(this.a2.itsX, this.a2.itsY);
            } else {
                path.lineTo(this.a2.itsX, this.a2.itsY);
            }
        }

        private void toEPS(EPSGraphics2D g) {
            this._x1 = this.a1.itsX;
            this._y1 = this.a1.itsY;
            this._x2 = this.a2.itsX;
            this._y2 = this.a2.itsY;
            if (this._x1 - this._x2 > 200.0 || this._x1 - this._x2 < -200.0 || this._y1 - this._y2 > 200.0 || this._y1 - this._y2 < -200.0 || this._x1 > 32000.0 || this._y1 > 32000.0 || this._x2 > 32000.0 || this._y2 > 32000.0 || this._x1 < -32000.0 || this._y1 < -32000.0 || this._x2 < -32000.0 || this._y2 < -32000.0) {
                return;
            }
            GraphicLocus.this.segment2D.setLine(this._x1, this._y1, this._x2, this._y2);
            g.draw(GraphicLocus.this.segment2D);
        }
    }
}

