/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.graphic;

import br.ufrj.labma.enibam.graphic.GraphicLabel;
import br.ufrj.labma.enibam.graphic.GraphicParameters;
import br.ufrj.labma.enibam.graphic.GraphicState;
import br.ufrj.labma.enibam.gui.ConversionFunctions;
import br.ufrj.labma.enibam.kernel.operations.CoorSys;
import br.ufrj.labma.enibam.kernel.state.State;
import br.ufrj.labma.enibam.tm.EPSGraphics2D;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Stroke;
import java.io.Serializable;

public abstract class GraphicObject
implements GraphicParameters,
Serializable {
    protected boolean decoratorOverMe = false;
    protected Integer itsID;
    protected boolean isSelected = false;
    protected CoorSys coord = new CoorSys();
    protected CoorSys world = new CoorSys();
    protected boolean debug = false;
    protected GraphicLabel graphicLabel;
    protected GraphicState GS;
    protected BasicStroke stroke;
    public static final Stroke STROKE_HIDE_MODE = new BasicStroke(1.0f, 1, 1, 0.0f, new float[]{4.0f, 4.0f, 12.0f, 4.0f}, 0.0f);
    public static final Color STROKE_COLOR = Color.lightGray;
    public static final Stroke SOLID_STROKE = new BasicStroke(2.0f);
    public static final Color DECORATOR_STROKE_COLOR = new Color(235, 180, 180);
    public static final Stroke DECORATOR_SOLID_STROKE = new BasicStroke(2.0f, 1, 1, 0.0f, new float[]{4.0f, 4.0f, 12.0f, 4.0f}, 0.0f);

    public abstract void Move(int var1, int var2);

    public abstract void translate(int var1, int var2);

    public abstract boolean atMe(int var1, int var2);

    public boolean decoratorOverMe(int x, int y) {
        this.decoratorOverMe = this.atMe(x, y);
        return this.decoratorOverMe;
    }

    public void setDecoratorOverMeStatus(boolean b) {
        this.decoratorOverMe = b;
    }

    public abstract void draw(Graphics var1);

    public abstract void toEPS(EPSGraphics2D var1);

    public abstract int getClassID();

    public final int getConstructionID() {
        return this.GS.itsConstructionID;
    }

    public final void setConstructionID(int i) {
        this.GS.itsConstructionID = i;
    }

    public final Integer getID() {
        return this.itsID;
    }

    public final void setID(int i) {
        this.itsID = new Integer(i);
    }

    public void selected(boolean b) {
        this.isSelected = b;
    }

    public final boolean isSelected() {
        return this.isSelected;
    }

    public abstract void setState(ConversionFunctions var1, State var2);

    public abstract State getState(ConversionFunctions var1);

    public abstract boolean hasKernelState();

    public abstract boolean GUIonly();

    public abstract String getDescription();

    public final void setDebugMode(boolean b) {
        this.debug = b;
    }

    public final boolean isDebugMode() {
        return this.debug;
    }

    public final void setHideMode(boolean b) {
        this.GS.hideMode = b;
    }

    @Override
    public void setColor(Color c) {
        this.GS.myColor = c;
    }

    @Override
    public final Color getColor() {
        return this.GS.myColor;
    }

    @Override
    public void setColorWhenSelected(Color c) {
        this.GS.colorWhenSelected = c;
    }

    @Override
    public final Color getColorWhenSelected() {
        return this.GS.colorWhenSelected;
    }

    @Override
    public final void setLabelColor(Color c) {
        this.GS.labelColor = c;
    }

    @Override
    public final Color getLabelColor() {
        return this.GS.labelColor;
    }

    @Override
    public final void setLabel(String str) {
        this.GS.itsLabel = str;
    }

    @Override
    public final String getLabel() {
        return this.GS.itsLabel;
    }

    @Override
    public final GraphicLabel getGraphicLabel() {
        return this.graphicLabel;
    }

    @Override
    public final void setFont(Font f) {
        this.GS.itsFont = f;
    }

    @Override
    public final void setThickness(int x) {
        this.GS.thickness = x;
        this.stroke = this.GS.itsDotStatus ? new BasicStroke(this.GS.thickness, 1, 2, 0.0f, this.GS.dash, 0.0f) : new BasicStroke(this.GS.thickness);
    }

    @Override
    public final int getThickness() {
        return this.GS.thickness;
    }

    @Override
    public final void setDotState(boolean b) {
        this.GS.itsDotStatus = b;
        this.stroke = this.GS.itsDotStatus ? new BasicStroke(this.GS.thickness, 1, 2, 0.0f, this.GS.dash, 0.0f) : new BasicStroke(this.GS.thickness);
    }

    @Override
    public final void setGraphicState(GraphicState gs) {
        this.GS = gs;
        this.setDotState(this.GS.itsDotStatus);
    }

    @Override
    public final GraphicState getGraphicState() {
        return this.GS;
    }

    @Override
    public final boolean getDotState() {
        return this.GS.itsDotStatus;
    }

    @Override
    public final Font getFont() {
        return this.GS.itsFont;
    }

    @Override
    public final void setVisibleStatus(boolean b) {
        this.GS.itsVisibleStatus = b;
    }

    @Override
    public final boolean getVisibleStatus() {
        return this.GS.itsVisibleStatus;
    }

    @Override
    public final void setLabelStatus(boolean b) {
        this.GS.itsLabelStatus = b;
    }

    @Override
    public final boolean getLabelStatus() {
        return this.GS.itsLabelStatus;
    }

    @Override
    public final boolean getDefinedStatus() {
        return this.GS.itsDefinedStatus;
    }
}

