/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.graphic;

import br.ufrj.labma.enibam.graphic.GraphicObject;
import br.ufrj.labma.enibam.graphic.GraphicState;
import br.ufrj.labma.enibam.graphic.label.CircularObjectLabel;
import br.ufrj.labma.enibam.graphic.label.GraphicPointLabel;
import br.ufrj.labma.enibam.gui.ConversionFunctions;
import br.ufrj.labma.enibam.kernel.state.PointState;
import br.ufrj.labma.enibam.kernel.state.State;
import br.ufrj.labma.enibam.tm.EPSGraphics2D;
import br.ufrj.labma.enibam.util.GraphicUtilities;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.geom.Ellipse2D;
import java.awt.image.ImageObserver;
import java.net.URL;

public final class GraphicPoint
extends GraphicObject
implements CircularObjectLabel {
    private Image itsImage;
    private Image itsImageModel;
    private Image itsImageSelected;
    private PointState itsTmp;
    private int itsX;
    private int itsY;
    private ImageObserver itsObserver;
    private boolean noPaint = false;
    private Ellipse2D elipse = new Ellipse2D.Float();

    public GraphicPoint() {
        this.GS = new GraphicState("P");
        this.itsY = 0;
        this.itsX = 0;
        this.GS.itsX = 5;
        this.GS.itsY = 10;
        this.setDotState(this.GS.itsDotStatus);
        this.graphicLabel = new GraphicPointLabel(this);
    }

    public GraphicPoint(int x, int y) {
        this.GS = new GraphicState("P");
        this.itsX = x;
        this.itsY = y;
        this.GS.itsX = 5;
        this.GS.itsY = 10;
        this.setDotState(this.GS.itsDotStatus);
        this.graphicLabel = new GraphicPointLabel(this);
    }

    public GraphicPoint(int x, int y, String path_img, String path_img_model) {
        this.GS = new GraphicState("P");
        this.itsImage = path_img != null ? Toolkit.getDefaultToolkit().getImage(path_img) : null;
        Image image = this.itsImageModel = path_img_model != null ? Toolkit.getDefaultToolkit().getImage(path_img_model) : null;
        if (this.itsImageModel != null) {
            this.itsImageSelected = GraphicUtilities.colorScale(this.itsImageModel, this.GS.colorWhenSelected, false);
        }
        this.itsX = x;
        this.itsY = y;
        this.GS.itsX = 5;
        this.GS.itsY = 10;
        this.setDotState(this.GS.itsDotStatus);
        this.setColor(this.GS.myColor);
        this.graphicLabel = new GraphicPointLabel(this);
    }

    public final void set_XY(int x, int y) {
        this.itsX = x;
        this.itsY = y;
    }

    public final int get_X() {
        return this.itsX;
    }

    public final int get_Y() {
        return this.itsY;
    }

    public final void setRadius(int x) {
        this.GS.itsX = x;
        this.GS.itsY = 2 * this.GS.itsX;
    }

    @Override
    public final int getRadius() {
        return this.GS.itsX;
    }

    public final void setGraphic(URL path_img, URL path_img_model, ImageObserver observer) {
        this.itsImage = path_img != null ? Toolkit.getDefaultToolkit().getImage(path_img) : null;
        Image image = this.itsImageModel = path_img_model != null ? Toolkit.getDefaultToolkit().getImage(path_img_model) : null;
        if (this.itsImageModel != null) {
            this.itsImageSelected = GraphicUtilities.colorScale(this.itsImageModel, this.GS.colorWhenSelected, false);
        }
        this.itsObserver = observer;
        this.setColor(this.GS.myColor);
    }

    public final void setGraphic(Image img, Image img_model, ImageObserver observer) {
        this.itsImage = img;
        this.itsObserver = observer;
        this.itsImageModel = img_model;
        if (this.itsImageModel != null) {
            this.itsImageSelected = GraphicUtilities.colorScale(this.itsImageModel, this.GS.colorWhenSelected, false);
        }
        this.setColor(this.GS.myColor);
    }

    @Override
    public final void Move(int x, int y) {
        this.itsX = x;
        this.itsY = y;
    }

    @Override
    public final void translate(int dx, int dy) {
        this.itsX += dx;
        this.itsY += dy;
    }

    @Override
    public final boolean atMe(int x, int y) {
        if (!this.GS.itsDefinedStatus || !this.GS.itsVisibleStatus) {
            return false;
        }
        int dr = this.GS.itsX <= 5 ? 5 : this.GS.itsX;
        double _x0 = this.itsX - dr;
        double _x1 = this.itsX + dr;
        double _y0 = this.itsY - dr;
        double _y1 = this.itsY + dr;
        boolean _b = _x0 < (double)x && _x1 > (double)x && _y0 < (double)y && _y1 > (double)y;
        return _b;
    }

    private void drawHideMode(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setPaint(GraphicObject.STROKE_COLOR);
        g2.setStroke(GraphicObject.STROKE_HIDE_MODE);
        this.elipse.setFrame(this.itsX - this.GS.itsX, this.itsY - this.GS.itsX, this.GS.itsY, this.GS.itsY);
        g2.fill(this.elipse);
    }

    @Override
    public final void draw(Graphics g) {
        if (this.GS.hideMode) {
            this.drawHideMode(g);
            return;
        }
        if (!this.GS.itsDefinedStatus || !this.GS.itsVisibleStatus || this.noPaint) {
            return;
        }
        if (!this.isSelected) {
            if (this.itsImage != null) {
                g.drawImage(this.itsImage, this.itsX - this.GS.itsY, this.itsY - this.GS.itsY, 2 * this.GS.itsY, 2 * this.GS.itsY, this.itsObserver);
            } else {
                g.setColor(this.GS.myColor);
                g.fillOval(this.itsX - this.GS.itsX, this.itsY - this.GS.itsX, this.GS.itsY, this.GS.itsY);
            }
        } else if (this.itsImageSelected != null) {
            g.drawImage(this.itsImageSelected, this.itsX - this.GS.itsY, this.itsY - this.GS.itsY, 2 * this.GS.itsY, 2 * this.GS.itsY, this.itsObserver);
        } else {
            g.setColor(this.GS.colorWhenSelected);
            g.fillOval(this.itsX - this.GS.itsX, this.itsY - this.GS.itsX, this.GS.itsY, this.GS.itsY);
        }
        this.graphicLabel.draw((Graphics2D)g);
        if (this.decoratorOverMe) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setPaint(GraphicObject.DECORATOR_STROKE_COLOR);
            g2.setStroke(GraphicObject.DECORATOR_SOLID_STROKE);
            this.elipse.setFrame(this.itsX - this.GS.itsX - 5, this.itsY - this.GS.itsX - 5, this.GS.itsY + 10, this.GS.itsY + 10);
            g2.draw(this.elipse);
        }
    }

    public final void print(Graphics g) {
        if (!this.GS.itsDefinedStatus || !this.GS.itsVisibleStatus || this.noPaint) {
            return;
        }
        if (!this.isSelected) {
            g.setColor(this.GS.myColor);
            g.fillOval(this.itsX - this.GS.itsX, this.itsY - this.GS.itsX, this.GS.itsY, this.GS.itsY);
        } else {
            g.setColor(this.GS.colorWhenSelected);
            g.fillOval(this.itsX - this.GS.itsX, this.itsY - this.GS.itsX, this.GS.itsY, this.GS.itsY);
        }
        this.graphicLabel.draw((Graphics2D)g);
    }

    @Override
    public final void toEPS(EPSGraphics2D g) {
        if (!this.GS.itsDefinedStatus || !this.GS.itsVisibleStatus || this.noPaint) {
            return;
        }
        if (!this.isSelected) {
            g.setColor(this.GS.myColor);
            g.fillOval(this.itsX - this.GS.itsX, this.itsY - this.GS.itsX, this.GS.itsY, this.GS.itsY);
        } else {
            g.setColor(this.GS.colorWhenSelected);
            g.fillOval(this.itsX - this.GS.itsX, this.itsY - this.GS.itsX, this.GS.itsY, this.GS.itsY);
        }
        this.graphicLabel.draw(g);
    }

    @Override
    public final int getClassID() {
        return 5000;
    }

    @Override
    public void setState(ConversionFunctions view, State s) {
        this.itsTmp = (PointState)s;
        this.world.itsX = this.itsTmp.itsX;
        this.world.itsY = this.itsTmp.itsY;
        view.ToScreen(this.world, this.coord);
        this.Move((int)this.coord.itsX, (int)this.coord.itsY);
        this.GS.itsDefinedStatus = this.itsTmp.itsDefinedStatus;
    }

    @Override
    public State getState(ConversionFunctions view) {
        PointState ps = new PointState();
        ps.itsMID = this.itsID;
        ps.itsDefinedStatus = this.GS.itsDefinedStatus;
        this.coord.itsX = this.get_X();
        this.coord.itsY = this.get_Y();
        view.ToWorld(this.coord, this.world);
        ps.itsX = this.world.itsX;
        ps.itsY = this.world.itsY;
        return ps;
    }

    @Override
    public boolean inside(Rectangle rect) {
        if (!this.GS.itsDefinedStatus || !this.GS.itsVisibleStatus) {
            return false;
        }
        return this.itsX >= rect.x && this.itsX <= rect.x + rect.width && this.itsY >= rect.y && this.itsY <= rect.y + rect.height;
    }

    @Override
    public void setColor(Color c) {
        super.setColor(c);
        if (this.itsImageModel != null) {
            this.itsImage = GraphicUtilities.colorScale(this.itsImageModel, this.GS.myColor, false);
        }
    }

    @Override
    public void setColorWhenSelected(Color c) {
        super.setColorWhenSelected(c);
        if (this.itsImageModel != null) {
            this.itsImageSelected = GraphicUtilities.colorScale(this.itsImageModel, this.GS.colorWhenSelected, false);
        }
    }

    public void noPaint(boolean x) {
        this.noPaint = x;
    }

    public String toString() {
        return "ID: " + this.getID() + " ClassID: " + this.getClassID() + " Construction: " + this.getConstructionID() + "(" + this.get_X() + "," + this.get_Y() + "  \n";
    }

    @Override
    public boolean hasKernelState() {
        return true;
    }

    @Override
    public boolean GUIonly() {
        return false;
    }

    public int getParameter() {
        return this.GS.nsegment;
    }

    @Override
    public String getDescription() {
        return "ponto " + this.GS.itsLabel;
    }

    public void setParameter(int p) {
        this.GS.nsegment = p;
    }

    @Override
    public float getXSource() {
        return this.itsX;
    }

    @Override
    public float getYSource() {
        return this.itsY;
    }
}

