/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.graphic;

import br.ufrj.labma.enibam.graphic.GraphicLabel;
import br.ufrj.labma.enibam.graphic.GraphicObject;
import br.ufrj.labma.enibam.graphic.GraphicParameters;
import br.ufrj.labma.enibam.graphic.GraphicState;
import br.ufrj.labma.enibam.gui.ConversionFunctions;
import br.ufrj.labma.enibam.kernel.operations.CoorSys;
import br.ufrj.labma.enibam.kernel.state.PolygonState;
import br.ufrj.labma.enibam.kernel.state.State;
import br.ufrj.labma.enibam.tm.EPSGraphics2D;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.util.Iterator;

public final class GraphicPolygon
extends GraphicObject
implements GraphicParameters {
    private CoorSys P1 = new CoorSys();
    private PolygonState itsTmp;
    private GeneralPath pol;
    private boolean SELECTEDFILL = false;
    private boolean CLOSED = false;
    private double lastx;
    private double lasty;
    private double firstx;
    private double firsty;
    private int NPOINTS = 0;

    public GraphicPolygon() {
        this.GS = new GraphicState("Poligono");
        this.pol = new GeneralPath(0);
        this.pol.moveTo(0.0f, 0.0f);
        this.firstx = 0.0;
        this.firsty = 0.0;
        this.setDotState(this.GS.itsDotStatus);
        this.setSelectedFill(true);
        this.graphicLabel = new GraphicLabel(this);
    }

    public GraphicPolygon(int i) {
        this.GS = new GraphicState("Poligono");
        this.pol = new GeneralPath(0);
        this.pol.moveTo(0.0f, 0.0f);
        this.setDotState(this.GS.itsDotStatus);
        this.setSelectedFill(true);
        this.NPOINTS = i;
        this.graphicLabel = new GraphicLabel(this);
    }

    public void setNPoints(int g) {
        this.NPOINTS = g;
    }

    public int getNPoints() {
        return this.NPOINTS;
    }

    @Override
    public final void Move(int x, int y) {
    }

    @Override
    public final void translate(int dx, int dy) {
    }

    @Override
    public final boolean atMe(int x, int y) {
        if (!this.GS.itsDefinedStatus || !this.GS.itsVisibleStatus) {
            return false;
        }
        return this.pol.contains(x, y);
    }

    private void drawHideMode(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setPaint(GraphicObject.STROKE_COLOR);
        g2.setStroke(GraphicObject.STROKE_HIDE_MODE);
        if (this.SELECTEDFILL) {
            g2.fill(this.pol);
        } else {
            g2.draw(this.pol);
        }
        if (!this.CLOSED) {
            g2.drawLine((int)this.lastx, (int)this.lasty, (int)this.firstx, (int)this.firsty);
        }
    }

    @Override
    public final void draw(Graphics g) {
        if (this.GS.hideMode) {
            this.drawHideMode(g);
            return;
        }
        if (!this.GS.itsDefinedStatus || !this.GS.itsVisibleStatus) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        if (this.isSelected) {
            g2.setPaint(this.GS.colorWhenSelected);
        } else {
            g2.setPaint(this.GS.myColor);
        }
        g2.setStroke(this.stroke);
        if (this.SELECTEDFILL) {
            g2.fill(this.pol);
        } else {
            g2.draw(this.pol);
        }
        if (!this.CLOSED) {
            g2.drawLine((int)this.lastx, (int)this.lasty, (int)this.firstx, (int)this.firsty);
        }
        this.graphicLabel.draw(g2);
    }

    @Override
    public final void toEPS(EPSGraphics2D g2) {
        if (!this.GS.itsDefinedStatus || !this.GS.itsVisibleStatus) {
            return;
        }
        if (this.isSelected) {
            g2.setPaint(this.GS.colorWhenSelected);
        } else {
            g2.setPaint(this.GS.myColor);
        }
        g2.setStroke(this.stroke);
        if (this.SELECTEDFILL) {
            g2.fill(this.pol);
        } else {
            g2.draw(this.pol);
        }
        if (!this.CLOSED) {
            g2.drawLine((int)this.lastx, (int)this.lasty, (int)this.firstx, (int)this.firsty);
        }
        this.graphicLabel.draw(g2);
    }

    public boolean getSelectedFill() {
        return this.SELECTEDFILL;
    }

    public void setSelectedFill(boolean b) {
        this.SELECTEDFILL = b;
    }

    public void update(double x, double y) {
        this.pol.lineTo((float)x, (float)y);
        this.lastx = x;
        this.lasty = y;
        ++this.NPOINTS;
    }

    public void close() {
        this.pol.closePath();
        this.CLOSED = true;
    }

    @Override
    public final int getClassID() {
        return 5070;
    }

    @Override
    public void setState(ConversionFunctions view, State s) {
        this.itsTmp = (PolygonState)s;
        int j = 1;
        if (this.NPOINTS == 0) {
            this.NPOINTS = this.itsTmp.itsCoorSysList.size();
        }
        this.pol.reset();
        Iterator i = this.itsTmp.itsCoorSysList.iterator();
        if (i.hasNext()) {
            this.world = (CoorSys)i.next();
            view.ToScreen(this.world, this.P1);
            this.pol.moveTo((float)this.P1.itsX, (float)this.P1.itsY);
        }
        while (i.hasNext() && j < this.NPOINTS) {
            this.world = (CoorSys)i.next();
            view.ToScreen(this.world, this.P1);
            this.pol.lineTo((float)this.P1.itsX, (float)this.P1.itsY);
            ++j;
        }
        if (this.itsTmp.itsCoorSysList.size() > 1) {
            this.pol.closePath();
        }
        this.GS.itsDefinedStatus = this.itsTmp.itsDefinedStatus;
    }

    @Override
    public State getState(ConversionFunctions view) {
        PolygonState ls = new PolygonState();
        ls.itsMID = this.itsID;
        ls.itsDefinedStatus = this.GS.itsDefinedStatus;
        PathIterator pi = this.pol.getPathIterator(null);
        double[] c = new double[6];
        while (!pi.isDone()) {
            pi.currentSegment(c);
            this.coord.itsX = c[0];
            this.coord.itsY = c[1];
            view.ToWorld(this.coord, this.world);
            ls.itsCoorSysList.add(new CoorSys(this.world.itsX, this.world.itsY));
            pi.next();
        }
        return ls;
    }

    @Override
    public boolean inside(Rectangle rect) {
        if (!this.GS.itsDefinedStatus || !this.GS.itsVisibleStatus) {
            return false;
        }
        return this.pol.intersects(rect.x, rect.y, rect.width, rect.height);
    }

    public String toString() {
        return "ID: " + this.getID() + " ClassID: " + this.getClassID() + " Construction: " + this.getConstructionID() + "\n";
    }

    @Override
    public String getDescription() {
        return "pol\u00edgono " + this.GS.itsLabel;
    }

    @Override
    public boolean hasKernelState() {
        return true;
    }

    @Override
    public boolean GUIonly() {
        return false;
    }

    @Override
    public float getXSource() {
        return (float)(this.pol.getCurrentPoint().getX() + 5.0);
    }

    @Override
    public float getYSource() {
        return (float)(this.pol.getCurrentPoint().getY() + 5.0);
    }
}

