/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.graphic;

import br.ufrj.labma.enibam.graphic.GraphicLabel;
import br.ufrj.labma.enibam.graphic.GraphicObject;
import br.ufrj.labma.enibam.graphic.GraphicParameters;
import br.ufrj.labma.enibam.graphic.GraphicState;
import br.ufrj.labma.enibam.gui.ConversionFunctions;
import br.ufrj.labma.enibam.kernel.state.RatioState;
import br.ufrj.labma.enibam.kernel.state.State;
import br.ufrj.labma.enibam.tm.EPSGraphics2D;
import br.ufrj.labma.enibam.util.GraphicUtilities;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;

public final class GraphicRatio
extends GraphicObject
implements GraphicParameters {
    private double itsRatio = 0.0;
    private String ratioStr = "";
    private FontMetrics fm;
    private int itsLength;
    private RatioState itsTmp;
    private int precision = 3;
    private Rectangle2D rect2D = new Rectangle2D.Float();

    public GraphicRatio() {
        this.GS = new GraphicState("Ratio: ");
        this.GS.itsX = 10;
        this.GS.itsY = 10;
        this.setDotState(this.GS.itsDotStatus);
        this.graphicLabel = new GraphicLabel(this);
    }

    public GraphicRatio(int x, int y) {
        this.GS = new GraphicState("Ratio: ");
        this.GS.itsX = x - 10;
        this.GS.itsY = y - 10;
        this.graphicLabel = new GraphicLabel(this);
        this.setDotState(this.GS.itsDotStatus);
    }

    public final double getRatio() {
        return this.itsRatio;
    }

    @Override
    public final void Move(int x, int y) {
        this.GS.itsX = x - 10;
        this.GS.itsY = y - 10;
    }

    @Override
    public final void translate(int dx, int dy) {
        this.GS.itsX += dx;
        this.GS.itsY += dy;
    }

    @Override
    public final boolean atMe(int x, int y) {
        if (!this.GS.itsDefinedStatus || !this.GS.itsVisibleStatus) {
            return false;
        }
        double _x0 = this.GS.itsX;
        double _x1 = this.GS.itsX + this.itsLength;
        double _y0 = this.GS.itsY - 20;
        double _y1 = this.GS.itsY + 5;
        boolean _b = _x0 < (double)x && _x1 > (double)x && _y0 < (double)y && _y1 > (double)y;
        return _b;
    }

    private void drawHideMode(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setPaint(GraphicObject.STROKE_COLOR);
        g2.setStroke(GraphicObject.STROKE_HIDE_MODE);
        this.ratioStr = this.valueOf(this.itsRatio);
        g2.drawString("\u00a7" + this.GS.itsLabel + " = " + this.ratioStr, this.GS.itsX, this.GS.itsY);
    }

    @Override
    public final void draw(Graphics g) {
        if (this.GS.hideMode) {
            this.drawHideMode(g);
            return;
        }
        if (!this.GS.itsDefinedStatus || !this.GS.itsVisibleStatus) {
            return;
        }
        g.setFont(this.GS.itsFont);
        this.fm = g.getFontMetrics(this.GS.itsFont);
        this.ratioStr = this.valueOf(this.itsRatio);
        if (!this.isSelected) {
            if (this.GS.itsLabelStatus) {
                g.setColor(this.GS.labelColor);
                if (this.debug) {
                    g.drawString("ID: " + this.getID(), this.GS.itsX, this.GS.itsY);
                } else {
                    g.drawString("\u00a7" + this.GS.itsLabel + " = ", this.GS.itsX, this.GS.itsY);
                }
                g.setColor(this.GS.myColor);
                g.drawString(this.ratioStr, this.GS.itsX + this.fm.stringWidth("\u00a7" + this.GS.itsLabel + " = "), this.GS.itsY);
                this.itsLength = this.fm.stringWidth("\u00a7" + this.GS.itsLabel + " = " + this.ratioStr);
            } else {
                g.setColor(this.GS.myColor);
                g.drawString(this.ratioStr, this.GS.itsX, this.GS.itsY);
                this.itsLength = this.fm.stringWidth(this.ratioStr);
            }
        } else if (this.GS.itsLabelStatus) {
            g.setColor(this.GS.colorWhenSelected);
            if (this.debug) {
                g.drawString("ID: " + this.getID(), this.GS.itsX, this.GS.itsY);
            } else {
                g.drawString("\u00a7" + this.GS.itsLabel + " = " + this.ratioStr, this.GS.itsX, this.GS.itsY);
            }
            this.itsLength = this.fm.stringWidth("\u00a7" + this.GS.itsLabel + " = " + this.ratioStr);
        } else {
            g.setColor(this.GS.colorWhenSelected);
            g.drawString(this.ratioStr, this.GS.itsX, this.GS.itsY);
            this.itsLength = this.fm.stringWidth(this.ratioStr);
        }
        if (this.decoratorOverMe) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setPaint(GraphicObject.DECORATOR_STROKE_COLOR);
            g2.setStroke(GraphicObject.DECORATOR_SOLID_STROKE);
            this.rect2D = this.GS.itsLabelStatus ? this.fm.getStringBounds(("\u00a7" + this.GS.itsLabel + " = " + this.ratioStr).trim(), g) : this.fm.getStringBounds(this.ratioStr.trim(), g);
            this.rect2D.setFrame(this.GS.itsX - 5, this.GS.itsY - 15, this.rect2D.getWidth() + 10.0, this.rect2D.getHeight() + 5.0);
            g2.draw(this.rect2D);
        }
    }

    @Override
    public final void toEPS(EPSGraphics2D g) {
        if (!this.GS.itsDefinedStatus || !this.GS.itsVisibleStatus) {
            return;
        }
        g.setFont(this.GS.itsFont);
        this.fm = g.getFontMetrics(this.GS.itsFont);
        this.ratioStr = this.valueOf(this.itsRatio);
        if (!this.isSelected) {
            if (this.GS.itsLabelStatus) {
                g.setColor(this.GS.labelColor);
                if (this.debug) {
                    g.drawString("ID: " + this.getID(), this.GS.itsX, this.GS.itsY);
                } else {
                    g.drawString("\u00a7" + this.GS.itsLabel + " = ", this.GS.itsX, this.GS.itsY);
                }
                g.setColor(this.GS.myColor);
                g.drawString(this.ratioStr, this.GS.itsX + this.fm.stringWidth("\u00a7" + this.GS.itsLabel + " = "), this.GS.itsY);
                this.itsLength = this.fm.stringWidth("\u00a7" + this.GS.itsLabel + this.ratioStr);
            } else {
                g.setColor(this.GS.myColor);
                g.drawString(this.ratioStr, this.GS.itsX, this.GS.itsY);
                this.itsLength = this.fm.stringWidth(this.ratioStr);
            }
        } else if (this.GS.itsLabelStatus) {
            g.setColor(this.GS.colorWhenSelected);
            if (this.debug) {
                g.drawString("ID: " + this.getID(), this.GS.itsX, this.GS.itsY);
            } else {
                g.drawString("\u00a7" + this.GS.itsLabel + " = " + this.ratioStr, this.GS.itsX, this.GS.itsY);
            }
            this.itsLength = this.fm.stringWidth("\u00a7" + this.GS.itsLabel + this.ratioStr);
        } else {
            g.setColor(this.GS.colorWhenSelected);
            g.drawString(this.ratioStr, this.GS.itsX, this.GS.itsY);
            this.itsLength = this.fm.stringWidth(this.ratioStr);
        }
    }

    @Override
    public final int getClassID() {
        return 5025;
    }

    @Override
    public void setState(ConversionFunctions view, State s) {
        this.itsTmp = (RatioState)s;
        this.itsRatio = this.itsTmp.itsRatio;
        this.GS.itsDefinedStatus = this.itsTmp.itsDefinedStatus;
    }

    @Override
    public State getState(ConversionFunctions view) {
        RatioState ls = new RatioState();
        ls.itsMID = this.itsID;
        ls.itsDefinedStatus = this.GS.itsDefinedStatus;
        ls.itsRatio = this.itsRatio;
        return ls;
    }

    @Override
    public boolean inside(Rectangle rect) {
        if (!this.GS.itsDefinedStatus || !this.GS.itsVisibleStatus) {
            return false;
        }
        return this.GS.itsX >= rect.x && this.GS.itsX <= rect.x + rect.width && this.GS.itsY >= rect.y && this.GS.itsY <= rect.y + rect.height && this.GS.itsX + this.itsLength >= rect.x && this.GS.itsX + this.itsLength <= rect.x + rect.width && this.GS.itsY - 20 >= rect.y && this.GS.itsY - 20 <= rect.y + rect.height;
    }

    public String toString() {
        return "ID: " + this.getID() + " ClassID: " + this.getClassID() + " Construction: " + this.getConstructionID() + "\n";
    }

    @Override
    public boolean hasKernelState() {
        return true;
    }

    @Override
    public boolean GUIonly() {
        return true;
    }

    @Override
    public String getDescription() {
        return "raz\u00e3o " + this.GS.itsLabel;
    }

    private String valueOf(double x) {
        return GraphicUtilities.roundValue(x, this.precision);
    }

    @Override
    public float getXSource() {
        return this.GS.itsX;
    }

    @Override
    public float getYSource() {
        return this.GS.itsY;
    }
}

