/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.graphic;

import br.ufrj.labma.enibam.graphic.GraphicLabel;
import br.ufrj.labma.enibam.graphic.GraphicObject;
import br.ufrj.labma.enibam.graphic.GraphicParameters;
import br.ufrj.labma.enibam.graphic.GraphicPoint;
import br.ufrj.labma.enibam.graphic.GraphicState;
import br.ufrj.labma.enibam.gui.ConversionFunctions;
import br.ufrj.labma.enibam.gui.ViewportInterface;
import br.ufrj.labma.enibam.kernel.operations.CoorSys;
import br.ufrj.labma.enibam.kernel.state.GenericLineState;
import br.ufrj.labma.enibam.kernel.state.State;
import br.ufrj.labma.enibam.tm.EPSGraphics2D;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Line2D;

public final class GraphicRay
extends GraphicObject
implements GraphicParameters {
    double vx;
    double vy;
    double modulo;
    double VunitX;
    double VunitY;
    private CoorSys P1 = new CoorSys();
    private CoorSys P2 = new CoorSys();
    private double _dx1;
    private double _dx2;
    private double _dy1;
    private double _dy2;
    private GenericLineState itsTmp;
    private static final double TOLERANCE = 4.0;
    private int MAX_VALUE = 1000;
    private int LABEL_VALUE = 100;
    private Line2D ray2D = new Line2D.Float();

    public GraphicRay() {
        this.GS = new GraphicState("Semi-reta");
        this.P1.itsX = 0.0;
        this.P1.itsY = 0.0;
        this.P2.itsX = 0.0;
        this.P2.itsY = 0.0;
        this.setDotState(this.GS.itsDotStatus);
        this.graphicLabel = new GraphicLabel(this);
    }

    public GraphicRay(GraphicPoint p1, GraphicPoint p2) {
        this.GS = new GraphicState("Semi-reta");
        this.P1.itsX = p1.get_X();
        this.P1.itsY = p1.get_Y();
        this.P2.itsX = p2.get_X();
        this.P2.itsY = p2.get_Y();
        this.setDotState(this.GS.itsDotStatus);
        this.graphicLabel = new GraphicLabel(this);
    }

    @Override
    public final void Move(int x, int y) {
        this.P2.itsX = x;
        this.P2.itsY = y;
    }

    @Override
    public final void translate(int dx, int dy) {
    }

    @Override
    public final boolean atMe(int x, int y) {
        if (!this.GS.itsDefinedStatus || !this.GS.itsVisibleStatus) {
            return false;
        }
        if (Math.abs(this.P2.itsX - this.P1.itsX) < 1.0) {
            if (Math.abs((double)x - this.P1.itsX) < 4.0) {
                if (this.P2.itsY > this.P1.itsY && (double)y > this.P1.itsY) {
                    return true;
                }
                if (this.P2.itsY < this.P1.itsY && (double)y < this.P1.itsY) {
                    return true;
                }
            }
            return false;
        }
        double tx = ((double)x - this.P1.itsX) / (this.P2.itsX - this.P1.itsX);
        this._dx1 = this.P2.itsY - this.P1.itsY;
        this._dx2 = this.P1.itsX - this.P2.itsX;
        this._dy1 = this._dx1 * (double)x + this._dx2 * (double)y + (this.P2.itsX * this.P1.itsY - this.P1.itsX * this.P2.itsY);
        this._dy2 = this._dx1 * this._dx1 + this._dx2 * this._dx2;
        return Math.abs(this._dy1 / Math.sqrt(this._dy2)) < 4.0 && tx >= 0.0;
    }

    private void drawHideMode(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setPaint(GraphicObject.STROKE_COLOR);
        g2.setStroke(GraphicObject.STROKE_HIDE_MODE);
        this.vx = this.P1.itsX - this.P2.itsX;
        this.vy = this.P1.itsY - this.P2.itsY;
        this.modulo = Math.sqrt(Math.pow(this.vx, 2.0) + Math.pow(this.vy, 2.0));
        this.VunitX = this.vx / this.modulo;
        this.VunitY = this.vy / this.modulo;
        this.ray2D.setLine(this.P1.itsX, this.P1.itsY, this.P1.itsX - (double)this.MAX_VALUE * this.VunitX, this.P1.itsY - (double)this.MAX_VALUE * this.VunitY);
        if (this.vx != 0.0 || this.vy != 0.0) {
            g2.draw(this.ray2D);
        }
    }

    @Override
    public final void draw(Graphics g) {
        if (this.GS.hideMode) {
            this.drawHideMode(g);
            return;
        }
        if (!this.GS.itsDefinedStatus || !this.GS.itsVisibleStatus) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        if (this.isSelected) {
            g2.setPaint(this.GS.colorWhenSelected);
        } else {
            g2.setPaint(this.GS.myColor);
        }
        this.vx = this.P1.itsX - this.P2.itsX;
        this.vy = this.P1.itsY - this.P2.itsY;
        this.modulo = Math.sqrt(Math.pow(this.vx, 2.0) + Math.pow(this.vy, 2.0));
        this.VunitX = this.vx / this.modulo;
        this.VunitY = this.vy / this.modulo;
        g2.setStroke(this.stroke);
        this.ray2D.setLine(this.P1.itsX, this.P1.itsY, this.P1.itsX - (double)this.MAX_VALUE * this.VunitX, this.P1.itsY - (double)this.MAX_VALUE * this.VunitY);
        if (this.vx != 0.0 || this.vy != 0.0) {
            g2.draw(this.ray2D);
        }
        this.graphicLabel.draw(g2);
        if (this.decoratorOverMe) {
            g2.setPaint(GraphicObject.DECORATOR_STROKE_COLOR);
            g2.setStroke(GraphicObject.DECORATOR_SOLID_STROKE);
            int dx = 5;
            int dy = 5;
            this.ray2D.setLine(this.ray2D.getX1() - (double)dx, this.ray2D.getY1() - (double)dy, this.ray2D.getX2() - (double)dx, this.ray2D.getY2() - (double)dy);
            g2.draw(this.ray2D);
            this.ray2D.setLine(this.ray2D.getX1() + (double)(2 * dx), this.ray2D.getY1() + (double)(2 * dy), this.ray2D.getX2() + (double)(2 * dx), this.ray2D.getY2() + (double)(2 * dy));
            g2.draw(this.ray2D);
        }
    }

    @Override
    public float getXSource() {
        return (float)(this.P2.itsX - (double)this.LABEL_VALUE * this.VunitX);
    }

    @Override
    public float getYSource() {
        return (float)(this.P2.itsY - (double)this.LABEL_VALUE * this.VunitY + 10.0);
    }

    @Override
    public final void toEPS(EPSGraphics2D g2) {
        if (!this.GS.itsDefinedStatus || !this.GS.itsVisibleStatus) {
            return;
        }
        if (this.isSelected) {
            g2.setPaint(this.GS.colorWhenSelected);
        } else {
            g2.setPaint(this.GS.myColor);
        }
        this.vx = this.P1.itsX - this.P2.itsX;
        this.vy = this.P1.itsY - this.P2.itsY;
        this.modulo = Math.sqrt(Math.pow(this.vx, 2.0) + Math.pow(this.vy, 2.0));
        this.VunitX = this.vx / this.modulo;
        this.VunitY = this.vy / this.modulo;
        g2.setStroke(this.stroke);
        this.ray2D.setLine(this.P1.itsX, this.P1.itsY, this.P1.itsX - (double)this.MAX_VALUE * this.VunitX, this.P1.itsY - (double)this.MAX_VALUE * this.VunitY);
        if (this.vx != 0.0 || this.vy != 0.0) {
            g2.draw(this.ray2D);
        }
        this.graphicLabel.draw(g2);
    }

    @Override
    public final int getClassID() {
        return 5015;
    }

    @Override
    public void setState(ConversionFunctions view, State s) {
        this.itsTmp = (GenericLineState)s;
        this.world.itsX = this.itsTmp.itsX1;
        this.world.itsY = this.itsTmp.itsY1;
        view.ToScreen(this.world, this.P1);
        this.world.itsX = this.itsTmp.itsX2;
        this.world.itsY = this.itsTmp.itsY2;
        view.ToScreen(this.world, this.P2);
        this.MAX_VALUE = ((ViewportInterface)view).getDiagonal();
        this.GS.itsDefinedStatus = this.itsTmp.itsDefinedStatus;
    }

    @Override
    public State getState(ConversionFunctions view) {
        GenericLineState ls = new GenericLineState();
        ls.itsMID = this.itsID;
        ls.itsDefinedStatus = this.GS.itsDefinedStatus;
        this.coord.itsX = this.P1.itsX;
        this.coord.itsY = this.P1.itsY;
        view.ToWorld(this.coord, this.world);
        ls.itsX1 = this.world.itsX;
        ls.itsY1 = this.world.itsY;
        this.coord.itsX = this.P2.itsX;
        this.coord.itsY = this.P2.itsY;
        view.ToWorld(this.coord, this.world);
        ls.itsX2 = this.world.itsX;
        ls.itsY2 = this.world.itsY;
        return ls;
    }

    @Override
    public boolean inside(Rectangle rect) {
        if (!this.GS.itsDefinedStatus || !this.GS.itsVisibleStatus) {
            return false;
        }
        return this.P1.itsX >= (double)rect.x && this.P1.itsX <= (double)(rect.x + rect.width) && this.P1.itsY >= (double)rect.y && this.P1.itsY <= (double)(rect.y + rect.height) && this.P2.itsX >= (double)rect.x && this.P2.itsX <= (double)(rect.x + rect.width) && this.P2.itsY >= (double)rect.y && this.P2.itsY <= (double)(rect.y + rect.height);
    }

    public String toString() {
        return "ID: " + this.getID() + " ClassID: " + this.getClassID() + " Construction: " + this.getConstructionID() + "\n";
    }

    @Override
    public String getDescription() {
        return "semi-reta " + this.GS.itsLabel;
    }

    @Override
    public boolean hasKernelState() {
        return true;
    }

    @Override
    public boolean GUIonly() {
        return false;
    }
}

