/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.graphic;

import br.ufrj.labma.enibam.graphic.GraphicLabel;
import br.ufrj.labma.enibam.graphic.GraphicObject;
import br.ufrj.labma.enibam.graphic.GraphicParameters;
import br.ufrj.labma.enibam.graphic.GraphicState;
import br.ufrj.labma.enibam.gui.ConversionFunctions;
import br.ufrj.labma.enibam.kernel.operations.CoorSys;
import br.ufrj.labma.enibam.kernel.state.LocusState;
import br.ufrj.labma.enibam.kernel.state.State;
import br.ufrj.labma.enibam.tm.EPSGraphics2D;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.List;

public final class GraphicRayLocus
extends GraphicObject
implements GraphicParameters {
    private List itsPointList;
    private List itsRayList;
    private CoorSys would;
    private CoorSys could = new CoorSys();
    private LocusState itsTmp;
    private boolean itsVisiblePoints;
    private int NPOINTS = 0;
    private Line2D line2D = new Line2D.Float();

    public GraphicRayLocus() {
        this.GS = new GraphicState("Lugar Geometrico");
        this.setDotState(this.GS.itsDotStatus);
        this.itsPointList = new ArrayList();
        this.graphicLabel = new GraphicLabel(this);
    }

    public GraphicRayLocus(int n) {
        this.GS = new GraphicState("Lugar Geometrico");
        this.NPOINTS = n + n;
        this.itsPointList = new ArrayList(this.NPOINTS);
        this.setDotState(this.GS.itsDotStatus);
        this.graphicLabel = new GraphicLabel(this);
    }

    @Override
    public final void Move(int x, int y) {
    }

    @Override
    public final void translate(int dx, int dy) {
    }

    @Override
    public final boolean atMe(int x, int y) {
        if (!this.GS.itsDefinedStatus || !this.GS.itsVisibleStatus) {
            return false;
        }
        boolean _found = false;
        int _l = this.itsRayList.size();
        int _i = 0;
        while (_i < _l) {
            locSeg _s = (locSeg)this.itsRayList.get(_i);
            _found = _s.atMe(x, y);
            if (_found) {
                return true;
            }
            ++_i;
        }
        return false;
    }

    private void drawHideMode(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setPaint(GraphicObject.STROKE_COLOR);
        g2.setStroke(GraphicObject.STROKE_HIDE_MODE);
        int _l = this.itsRayList.size();
        int _i = 0;
        while (_i < _l) {
            locSeg _s = (locSeg)this.itsRayList.get(_i);
            _s.draw(g2);
            ++_i;
        }
    }

    @Override
    public final void draw(Graphics g) {
        if (this.GS.hideMode) {
            this.drawHideMode(g);
            return;
        }
        if (!this.GS.itsDefinedStatus || !this.GS.itsVisibleStatus) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        if (this.isSelected) {
            g2.setPaint(this.GS.colorWhenSelected);
        } else {
            g2.setPaint(this.GS.myColor);
        }
        g2.setStroke(this.stroke);
        int _l = this.itsRayList.size();
        int _i = 0;
        while (_i < _l) {
            locSeg _s = (locSeg)this.itsRayList.get(_i);
            _s.draw(g2);
            ++_i;
        }
    }

    @Override
    public final void toEPS(EPSGraphics2D g2) {
        if (!this.GS.itsDefinedStatus || !this.GS.itsVisibleStatus) {
            return;
        }
        if (this.isSelected) {
            g2.setPaint(this.GS.colorWhenSelected);
        } else {
            g2.setPaint(this.GS.myColor);
        }
        g2.setStroke(this.stroke);
        int _l = this.itsRayList.size();
        int _i = 0;
        while (_i < _l) {
            locSeg _s = (locSeg)this.itsRayList.get(_i);
            _s.toEPS(g2);
            ++_i;
        }
    }

    @Override
    public final int getClassID() {
        return 5099;
    }

    @Override
    public boolean inside(Rectangle rect) {
        if (!this.GS.itsDefinedStatus || !this.GS.itsVisibleStatus) {
            return false;
        }
        return false;
    }

    public String toString() {
        return "ID: " + this.getID() + " ClassID: " + this.getClassID() + " Construction: " + this.getConstructionID() + "\n";
    }

    @Override
    public boolean hasKernelState() {
        return true;
    }

    @Override
    public boolean GUIonly() {
        return false;
    }

    @Override
    public String getDescription() {
        return "locus de semi-reta " + this.GS.itsLabel;
    }

    @Override
    public void setState(ConversionFunctions view, State s) {
        this.itsTmp = (LocusState)s;
        if (this.itsPointList.size() == 0) {
            this.mountList(this.itsTmp.pointList);
        }
        int i = 0;
        while (i < this.itsPointList.size()) {
            this.would = (CoorSys)this.itsTmp.pointList.get(i);
            this.could = (CoorSys)this.itsPointList.get(i);
            view.ToScreen(this.would, this.could);
            ++i;
        }
        this.GS.itsDefinedStatus = this.itsTmp.itsDefinedStatus;
    }

    @Override
    public State getState(ConversionFunctions view) {
        LocusState cs = new LocusState();
        cs.itsMID = this.itsID;
        cs.itsDefinedStatus = this.GS.itsDefinedStatus;
        cs.sizeIt(this.itsPointList.size());
        int i = 0;
        while (i < this.itsPointList.size()) {
            this.would = (CoorSys)cs.pointList.get(i);
            this.could = (CoorSys)this.itsPointList.get(i);
            view.ToWorld(this.could, this.would);
            ++i;
        }
        return cs;
    }

    @Override
    public float getXSource() {
        return 0.0f;
    }

    @Override
    public float getYSource() {
        return 0.0f;
    }

    private void mountList(List p) {
        this.itsVisiblePoints = false;
        int _i = 0;
        int _s = p.size();
        if (_s < 2) {
            return;
        }
        if (this.NPOINTS == 0) {
            this.NPOINTS = _s;
        }
        if (this.itsPointList == null) {
            this.itsPointList = new ArrayList(this.NPOINTS);
        }
        this.itsRayList = new ArrayList(this.NPOINTS / 2);
        while (_i < this.NPOINTS) {
            CoorSys _tmp1 = (CoorSys)p.get(_i);
            _tmp1 = new CoorSys(_tmp1.itsX, _tmp1.itsY);
            this.itsPointList.add(_tmp1);
            if (++_i >= this.NPOINTS) continue;
            CoorSys _tmp2 = (CoorSys)p.get(_i);
            _tmp2 = new CoorSys(_tmp1.itsX, _tmp1.itsY);
            this.itsPointList.add(_tmp2);
            locSeg _e = new locSeg(_tmp1, _tmp2);
            this.itsRayList.add(_e);
            ++_i;
        }
    }

    private final class locSeg {
        private double vx;
        private double vy;
        private double modulo;
        private double VunitX;
        private double VunitY;
        private int MAX_VALUE = 1000;
        public CoorSys a1;
        public CoorSys a2;
        private double _x1;
        private double _x2;
        private double _y1;
        private double _y2;
        protected double _dx1;
        protected double _dx2;
        protected double _dy1;
        protected double _dy2;
        protected double _d;
        private static final double TOLERANCE = 4.0;

        private locSeg(CoorSys c1, CoorSys c2) {
            this.a1 = c1;
            this.a2 = c2;
        }

        private boolean atMe(double x, double y) {
            if (Math.abs(this.a2.itsX - this.a1.itsX) < 1.0) {
                if (Math.abs(x - this.a1.itsX) < 4.0) {
                    if (this.a2.itsY > this.a1.itsY && y > this.a1.itsY) {
                        return true;
                    }
                    if (this.a2.itsY < this.a1.itsY && y < this.a1.itsY) {
                        return true;
                    }
                }
                return false;
            }
            this._dx1 = this.a1.itsX;
            this._dy1 = this.a1.itsY;
            double tx = (x - this.a1.itsX) / (this.a2.itsX - this.a1.itsX);
            this._dx1 = this.a2.itsY - this.a1.itsY;
            this._dx2 = this.a1.itsX - this.a2.itsX;
            this._dy1 = this._dx1 * x + this._dx2 * y + (this.a2.itsX * this.a1.itsY - this.a1.itsX * this.a2.itsY);
            this._dy2 = this._dx1 * this._dx1 + this._dx2 * this._dx2;
            return Math.abs(this._dy1 / Math.sqrt(this._dy2)) < 4.0 && tx >= 0.0;
        }

        private void draw(Graphics2D g) {
            this._x1 = this.a1.itsX;
            this._y1 = this.a1.itsY;
            this._x2 = this.a2.itsX;
            this._y2 = this.a2.itsY;
            this.vx = this._x1 - this._x2;
            this.vy = this._y1 - this._y2;
            this.modulo = Math.sqrt(Math.pow(this.vx, 2.0) + Math.pow(this.vy, 2.0));
            this.VunitX = this.vx / this.modulo;
            this.VunitY = this.vy / this.modulo;
            GraphicRayLocus.this.line2D.setLine(this._x1, this._y1, this._x1 - (double)this.MAX_VALUE * this.VunitX, this._y1 - (double)this.MAX_VALUE * this.VunitY);
            g.draw(GraphicRayLocus.this.line2D);
        }

        private void toEPS(EPSGraphics2D g) {
            this._x1 = this.a1.itsX;
            this._y1 = this.a1.itsY;
            this._x2 = this.a2.itsX;
            this._y2 = this.a2.itsY;
            this.vx = this._x1 - this._x2;
            this.vy = this._y1 - this._y2;
            this.modulo = Math.sqrt(Math.pow(this.vx, 2.0) + Math.pow(this.vy, 2.0));
            this.VunitX = this.vx / this.modulo;
            this.VunitY = this.vy / this.modulo;
            GraphicRayLocus.this.line2D.setLine(this._x1, this._y1, this._x1 - (double)this.MAX_VALUE * this.VunitX, this._y1 - (double)this.MAX_VALUE * this.VunitY);
            g.draw(GraphicRayLocus.this.line2D);
        }
    }
}

