/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.graphic;

import br.ufrj.labma.enibam.graphic.GraphicLabel;
import br.ufrj.labma.enibam.graphic.GraphicObject;
import br.ufrj.labma.enibam.graphic.GraphicParameters;
import br.ufrj.labma.enibam.graphic.GraphicPoint;
import br.ufrj.labma.enibam.graphic.GraphicState;
import br.ufrj.labma.enibam.gui.ConversionFunctions;
import br.ufrj.labma.enibam.gui.GraphicEnviroment;
import br.ufrj.labma.enibam.kernel.operations.CoorSys;
import br.ufrj.labma.enibam.kernel.operations.Utils;
import br.ufrj.labma.enibam.kernel.state.GenericLineState;
import br.ufrj.labma.enibam.kernel.state.State;
import br.ufrj.labma.enibam.tm.EPSGraphics2D;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Line2D;

public class GraphicSegment
extends GraphicObject
implements GraphicParameters {
    protected int itsWidth;
    protected int itsHeight;
    protected int itsPx = 0;
    protected int itsPy = 0;
    protected CoorSys P1 = new CoorSys();
    protected CoorSys P2 = new CoorSys();
    protected boolean _status = false;
    protected int _x1;
    protected int _x2;
    protected int _y1;
    protected int _y2;
    protected int i;
    protected int j;
    protected double _dx1;
    protected double _dx2;
    protected double _dy1;
    protected double _dy2;
    protected double _d;
    protected CoorSys c1 = new CoorSys();
    protected CoorSys c2 = new CoorSys();
    protected double te = 0.0;
    protected double tl = 1.0;
    protected GenericLineState itsTmp;
    private static final double TOLERANCE = 0.1;
    protected Line2D segment2D = new Line2D.Float();
    private int maxX;
    private int maxY;

    public GraphicSegment() {
        this.GS = new GraphicState("Segmento");
        this.P1.itsX = 0.0;
        this.P1.itsY = 0.0;
        this.P2.itsX = 0.0;
        this.P2.itsY = 0.0;
        this.setDotState(this.GS.itsDotStatus);
        this.graphicLabel = new GraphicLabel(this);
        GraphicEnviroment ge = GraphicEnviroment.getInstance();
        this.maxX = ge.getWidth();
        this.maxY = ge.getHeight();
    }

    public GraphicSegment(GraphicPoint p1, GraphicPoint p2) {
        this.GS = new GraphicState("Segmento");
        this.P1.itsX = p1.get_X();
        this.P1.itsY = p1.get_Y();
        this.P2.itsX = p2.get_X();
        this.P2.itsY = p2.get_Y();
        this.setDotState(this.GS.itsDotStatus);
        this.graphicLabel = new GraphicLabel(this);
        GraphicEnviroment ge = GraphicEnviroment.getInstance();
        this.maxX = ge.getWidth();
        this.maxY = ge.getHeight();
    }

    @Override
    public final void Move(int x, int y) {
        this.P2.itsX = x;
        this.P2.itsY = y;
    }

    @Override
    public final void translate(int dx, int dy) {
    }

    @Override
    public final boolean atMe(int x, int y) {
        if (!this.GS.itsDefinedStatus || !this.GS.itsVisibleStatus) {
            return false;
        }
        this._dx1 = this.P1.itsX;
        this._dy1 = this.P1.itsY;
        this._dx2 = this.P2.itsX;
        this._dy2 = this.P2.itsY;
        double dAB = Utils.distance(this._dx1, this._dy1, x, y);
        double dBC = Utils.distance(x, y, this._dx2, this._dy2);
        double dAC = Utils.distance(this._dx1, this._dy1, this._dx2, this._dy2);
        return Math.abs(dAC - dAB - dBC) <= 0.1;
    }

    void drawHideMode(Graphics g) {
        this.c1.itsX = this.P1.itsX;
        this.c1.itsY = this.P1.itsY;
        this.c2.itsX = this.P2.itsX;
        this.c2.itsY = this.P2.itsY;
        if (!this.clip2d(this.c1, this.c2)) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.setPaint(GraphicObject.STROKE_COLOR);
        g2.setStroke(GraphicObject.STROKE_HIDE_MODE);
        this.segment2D.setLine(this.c1.itsX, this.c1.itsY, this.c2.itsX, this.c2.itsY);
        g2.draw(this.segment2D);
    }

    @Override
    public void draw(Graphics g) {
        if (this.GS.hideMode) {
            this.drawHideMode(g);
            return;
        }
        this.c1.itsX = this.P1.itsX;
        this.c1.itsY = this.P1.itsY;
        this.c2.itsX = this.P2.itsX;
        this.c2.itsY = this.P2.itsY;
        if (!this.clip2d(this.c1, this.c2)) {
            return;
        }
        if (!this.GS.itsDefinedStatus || !this.GS.itsVisibleStatus) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        if (this.isSelected) {
            g2.setPaint(this.GS.colorWhenSelected);
        } else {
            g2.setPaint(this.GS.myColor);
        }
        g2.setStroke(this.stroke);
        this.segment2D.setLine(this.c1.itsX, this.c1.itsY, this.c2.itsX, this.c2.itsY);
        g2.draw(this.segment2D);
        this.graphicLabel.draw(g2);
        if (this.decoratorOverMe) {
            g2.setPaint(GraphicObject.DECORATOR_STROKE_COLOR);
            g2.setStroke(GraphicObject.DECORATOR_SOLID_STROKE);
            int dx = Math.abs(this.c2.itsY - this.c1.itsY) < 5.0 ? 0 : 5;
            int dy = Math.abs(this.c2.itsX - this.c1.itsX) < 5.0 ? 0 : 5;
            this.segment2D.setLine(this.c1.itsX - (double)dx, this.c1.itsY - (double)dy, this.c2.itsX - (double)dx, this.c2.itsY - (double)dy);
            g2.draw(this.segment2D);
            this.segment2D.setLine(this.c1.itsX + (double)dx, this.c1.itsY + (double)dy, this.c2.itsX + (double)dx, this.c2.itsY + (double)dy);
            g2.draw(this.segment2D);
        }
    }

    protected boolean clip2d(CoorSys p1, CoorSys p2) {
        p1.itsY = -p1.itsY;
        p2.itsY = -p2.itsY;
        double dx = p2.itsX - p1.itsX;
        double dy = p2.itsY - p1.itsY;
        boolean xmin = false;
        int xmax = this.maxX;
        int ymin = -this.maxY;
        boolean ymax = false;
        boolean visible = false;
        if (dx == 0.0 && dy == 0.0 && p1.itsX >= (double)xmin && p1.itsY >= (double)ymin && p1.itsX <= (double)xmax && p1.itsY >= (double)ymax) {
            visible = true;
        } else {
            this.te = 0.0;
            this.tl = 1.0;
            if (this.clipt(dx, (double)xmin - p1.itsX) && this.clipt(-dx, p1.itsX - (double)xmax) && this.clipt(dy, (double)ymin - p1.itsY) && this.clipt(-dy, p1.itsY - (double)ymax)) {
                visible = true;
                if (this.tl < 1.0) {
                    p2.itsX = p1.itsX + this.tl * dx;
                    p2.itsY = p1.itsY + this.tl * dy;
                }
                if (this.te > 0.0) {
                    p1.itsX += this.te * dx;
                    p1.itsY += this.te * dy;
                }
            }
        }
        p1.itsY = -p1.itsY;
        p2.itsY = -p2.itsY;
        return visible;
    }

    protected boolean clipt(double denom, double num) {
        double t = 0.0;
        if (denom > 0.0) {
            t = num / denom;
            if (t > this.tl) {
                return false;
            }
            if (t > this.te) {
                this.te = t;
            }
        } else if (denom < 0.0) {
            t = num / denom;
            if (t < this.te) {
                return false;
            }
            if (t < this.tl) {
                this.tl = t;
            }
        } else if (num > 0.0) {
            return false;
        }
        return true;
    }

    @Override
    public void toEPS(EPSGraphics2D g2) {
        if (!this.GS.itsDefinedStatus || !this.GS.itsVisibleStatus) {
            return;
        }
        if (this.isSelected) {
            g2.setPaint(this.GS.colorWhenSelected);
        } else {
            g2.setPaint(this.GS.myColor);
        }
        g2.setStroke(this.stroke);
        this.segment2D.setLine(this.P1.itsX, this.P1.itsY, this.P2.itsX, this.P2.itsY);
        g2.draw(this.segment2D);
        this.graphicLabel.draw(g2);
    }

    @Override
    public int getClassID() {
        return 5010;
    }

    @Override
    public void setState(ConversionFunctions view, State s) {
        this.itsTmp = (GenericLineState)s;
        this.world.itsX = this.itsTmp.itsX1;
        this.world.itsY = this.itsTmp.itsY1;
        view.ToScreen(this.world, this.P1);
        this.world.itsX = this.itsTmp.itsX2;
        this.world.itsY = this.itsTmp.itsY2;
        view.ToScreen(this.world, this.P2);
        this.GS.itsDefinedStatus = this.itsTmp.itsDefinedStatus;
    }

    @Override
    public State getState(ConversionFunctions view) {
        GenericLineState ls = new GenericLineState();
        ls.itsMID = this.itsID;
        ls.itsDefinedStatus = this.GS.itsDefinedStatus;
        view.ToWorld(this.P1, this.world);
        ls.itsX1 = this.world.itsX;
        ls.itsY1 = this.world.itsY;
        view.ToWorld(this.P2, this.world);
        ls.itsX2 = this.world.itsX;
        ls.itsY2 = this.world.itsY;
        return ls;
    }

    @Override
    public boolean inside(Rectangle rect) {
        if (!this.GS.itsDefinedStatus || !this.GS.itsVisibleStatus) {
            return false;
        }
        return this.P1.itsX >= (double)rect.x && this.P1.itsX <= (double)(rect.x + rect.width) && this.P1.itsY >= (double)rect.y && this.P1.itsY <= (double)(rect.y + rect.height) && this.P2.itsX >= (double)rect.x && this.P2.itsX <= (double)(rect.x + rect.width) && this.P2.itsY >= (double)rect.y && this.P2.itsY <= (double)(rect.y + rect.height);
    }

    public String toString() {
        return "ID: " + this.getID() + " ClassID: " + this.getClassID() + " Construction: " + this.getConstructionID() + "\n";
    }

    @Override
    public String getDescription() {
        return "segmento " + this.GS.itsLabel;
    }

    @Override
    public boolean hasKernelState() {
        return true;
    }

    @Override
    public boolean GUIonly() {
        return false;
    }

    @Override
    public float getXSource() {
        return (float)((this.P1.itsX + this.P2.itsX) / 2.0);
    }

    @Override
    public float getYSource() {
        return (float)((this.P1.itsY + this.P2.itsY) / 2.0);
    }
}

