/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.graphic;

import br.ufrj.labma.enibam.graphic.GraphicLabel;
import br.ufrj.labma.enibam.graphic.GraphicObject;
import br.ufrj.labma.enibam.graphic.GraphicParameters;
import br.ufrj.labma.enibam.graphic.GraphicState;
import br.ufrj.labma.enibam.gui.ConversionFunctions;
import br.ufrj.labma.enibam.kernel.state.State;
import br.ufrj.labma.enibam.kernel.state.TextState;
import br.ufrj.labma.enibam.tm.EPSGraphics2D;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.StringTokenizer;

public final class GraphicText
extends GraphicObject
implements GraphicParameters {
    private FontMetrics fm;
    private int length;
    private String itsText = "";
    private TextState itsTmp;
    private String[] texto = new String[]{""};
    private Rectangle2D rect2D = new Rectangle2D.Float();

    public GraphicText() {
        this.GS = new GraphicState("text: ");
        this.setDotState(this.GS.itsDotStatus);
        this.graphicLabel = new GraphicLabel(this);
    }

    public GraphicText(int x, int y) {
        this.GS = new GraphicState("text: ");
        this.GS.itsX = x - 10;
        this.GS.itsY = y - 10;
        this.setDotState(this.GS.itsDotStatus);
        this.graphicLabel = new GraphicLabel(this);
    }

    @Override
    public final void Move(int x, int y) {
        this.GS.itsX = x;
        this.GS.itsY = y;
    }

    @Override
    public final void translate(int dx, int dy) {
        this.GS.itsX += dx;
        this.GS.itsY += dy;
    }

    @Override
    public final boolean atMe(int x, int y) {
        if (!this.GS.itsDefinedStatus || !this.GS.itsVisibleStatus) {
            return false;
        }
        if (this.texto == null) {
            return false;
        }
        int i = 0;
        while (i < this.texto.length) {
            if (this.clickInLine(x, y, i)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void drawHideMode(Graphics g) {
        ((Graphics2D)g).setStroke(GraphicObject.STROKE_HIDE_MODE);
        this.drawText(g, GraphicObject.STROKE_COLOR);
    }

    @Override
    public final void draw(Graphics g) {
        if (this.GS.hideMode) {
            this.drawHideMode(g);
            return;
        }
        if (!this.GS.itsDefinedStatus || !this.GS.itsVisibleStatus) {
            return;
        }
        if (!this.isSelected) {
            if (this.debug) {
                g.drawString("ID:" + this.getID(), this.GS.itsX - 20, this.GS.itsY);
                this.drawText(g, this.GS.myColor);
            } else {
                this.drawText(g, this.GS.myColor);
            }
        } else if (this.debug) {
            g.drawString("ID:" + this.getID(), this.GS.itsX - 20, this.GS.itsY);
            this.drawText(g, this.GS.colorWhenSelected);
        } else {
            this.drawText(g, this.GS.colorWhenSelected);
        }
        if (this.decoratorOverMe) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setPaint(GraphicObject.DECORATOR_STROKE_COLOR);
            g2.setStroke(GraphicObject.DECORATOR_SOLID_STROKE);
            double width = 0.0;
            double height = 0.0;
            int i = 0;
            while (i < this.texto.length) {
                this.rect2D = this.fm.getStringBounds(this.texto[i].trim(), g);
                height += this.rect2D.getHeight() + 1.0;
                width = this.rect2D.getWidth() > width ? this.rect2D.getWidth() : width;
                ++i;
            }
            this.rect2D.setFrame(this.GS.itsX - 5, this.GS.itsY - 15, width + 10.0, height + 5.0);
            g2.draw(this.rect2D);
        }
    }

    @Override
    public final void toEPS(EPSGraphics2D g) {
        if (!this.GS.itsDefinedStatus || !this.GS.itsVisibleStatus) {
            return;
        }
        g.setFont(this.GS.itsFont);
        if (!this.isSelected) {
            if (this.debug) {
                g.drawString("ID:" + this.getID(), this.GS.itsX - 20, this.GS.itsY);
                this.drawText(g, this.GS.myColor);
            } else {
                this.drawText(g, this.GS.myColor);
            }
        } else if (this.debug) {
            g.drawString("ID:" + this.getID(), this.GS.itsX - 20, this.GS.itsY);
            this.drawText(g, this.GS.colorWhenSelected);
        } else {
            this.drawText(g, this.GS.colorWhenSelected);
        }
    }

    @Override
    public final int getClassID() {
        return 9050;
    }

    @Override
    public void setState(ConversionFunctions view, State s) {
        this.itsTmp = (TextState)s;
        if (this.itsText == null || !this.itsText.equals(this.itsTmp.itsText)) {
            this.textGenerator(this.itsTmp.itsText);
            this.itsText = this.itsTmp.itsText;
        }
        this.GS.itsDefinedStatus = this.itsTmp.itsDefinedStatus;
    }

    @Override
    public State getState(ConversionFunctions view) {
        TextState ts = new TextState();
        ts.itsMID = this.itsID;
        ts.itsDefinedStatus = this.GS.itsDefinedStatus;
        ts.itsText = this.itsText;
        return ts;
    }

    @Override
    public boolean inside(Rectangle rect) {
        if (!this.GS.itsDefinedStatus || !this.GS.itsVisibleStatus) {
            return false;
        }
        return this.GS.itsX >= rect.x && this.GS.itsX <= rect.x + rect.width && this.GS.itsY >= rect.y && this.GS.itsY <= rect.y + rect.height && this.GS.itsX + this.length >= rect.x && this.GS.itsX + this.length <= rect.x + rect.width && this.GS.itsY - 20 >= rect.y && this.GS.itsY - 20 <= rect.y + rect.height;
    }

    public String toString() {
        return "ID: " + this.getID() + " ClassID: " + this.getClassID() + " Construction: " + this.getConstructionID() + "\n";
    }

    @Override
    public boolean hasKernelState() {
        return true;
    }

    @Override
    public boolean GUIonly() {
        return true;
    }

    @Override
    public String getDescription() {
        return "Texto " + this.GS.itsLabel;
    }

    public String getText() {
        String value = "";
        int i = 0;
        while (i < this.texto.length) {
            value = String.valueOf(value) + this.texto[i] + "\n";
            ++i;
        }
        return value;
    }

    public void setText(String str) {
        this.itsTmp.itsText = str;
        this.itsText = str;
        this.textGenerator(str);
    }

    private void textGenerator(String str) {
        StringTokenizer ST = new StringTokenizer(str, "\u00fe");
        this.texto = new String[ST.countTokens()];
        int i = 0;
        while (ST.hasMoreElements()) {
            this.texto[i++] = ST.nextToken();
        }
    }

    private void drawText(Graphics g, Color c) {
        if (this.texto == null) {
            return;
        }
        g.setFont(this.GS.itsFont);
        this.fm = g.getFontMetrics(this.GS.itsFont);
        int offset = this.fm.getHeight();
        this.graphicLabel.draw((Graphics2D)g);
        g.setColor(c);
        int i = 0;
        while (i < this.texto.length) {
            g.drawString(this.texto[i], this.GS.itsX, this.GS.itsY + i * offset);
            ++i;
        }
    }

    private void drawText(EPSGraphics2D g, Color c) {
        if (this.texto == null) {
            return;
        }
        g.setFont(this.GS.itsFont);
        this.fm = g.getFontMetrics(this.GS.itsFont);
        int offset = this.fm.getHeight();
        this.graphicLabel.draw(g);
        g.setColor(c);
        int i = 0;
        while (i < this.texto.length) {
            g.drawString(this.texto[i], this.GS.itsX, this.GS.itsY + i * offset);
            ++i;
        }
    }

    private final boolean clickInLine(int x, int y, int offset) {
        if (offset > this.texto.length || offset < 0) {
            return false;
        }
        int y1 = this.GS.itsY + this.fm.getHeight() * offset;
        int y0 = y1 - this.fm.getHeight();
        int x0 = this.GS.itsX;
        int x1 = this.GS.itsX + this.fm.stringWidth(this.texto[offset]);
        return x0 < x && x1 > x && y0 < y && y1 > y;
    }

    @Override
    public float getXSource() {
        return this.GS.itsX - 20;
    }

    @Override
    public float getYSource() {
        return this.GS.itsY;
    }
}

