/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.graphic;

import br.ufrj.labma.enibam.graphic.GraphicLabel;
import br.ufrj.labma.enibam.graphic.GraphicObject;
import br.ufrj.labma.enibam.graphic.GraphicParameters;
import br.ufrj.labma.enibam.graphic.GraphicPoint;
import br.ufrj.labma.enibam.graphic.GraphicState;
import br.ufrj.labma.enibam.gui.ConversionFunctions;
import br.ufrj.labma.enibam.kernel.operations.CoorSys;
import br.ufrj.labma.enibam.kernel.operations.Utils;
import br.ufrj.labma.enibam.kernel.state.State;
import br.ufrj.labma.enibam.kernel.state.TriangleState;
import br.ufrj.labma.enibam.tm.EPSGraphics2D;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Line2D;

public class GraphicTriangle
extends GraphicObject
implements GraphicParameters {
    protected int itsWidth;
    protected int itsHeight;
    protected int itsPx = 0;
    protected int itsPy = 0;
    protected CoorSys P1 = new CoorSys();
    protected CoorSys P2 = new CoorSys();
    protected CoorSys P3 = new CoorSys();
    protected boolean _status = false;
    protected int _x1;
    protected int _x2;
    protected int _y1;
    protected int _y2;
    protected int i;
    protected int j;
    protected double _dx1;
    protected double _dx2;
    protected double _dy1;
    protected double _dy2;
    protected double _d;
    protected TriangleState itsTmp;
    private static final double TOLERANCE = 0.1;
    private Line2D Segment2D = new Line2D.Float();

    public GraphicTriangle() {
        this.GS = new GraphicState("Triangle");
        this.P1.itsX = 0.0;
        this.P1.itsY = 0.0;
        this.P2.itsX = 0.0;
        this.P2.itsY = 0.0;
        this.P3.itsX = 0.0;
        this.P3.itsY = 0.0;
        this.setDotState(this.GS.itsDotStatus);
        this.graphicLabel = new GraphicLabel(this);
    }

    public GraphicTriangle(GraphicPoint p1, GraphicPoint p2, GraphicPoint p3) {
        this.GS = new GraphicState("Triangle");
        this.P1.itsX = p1.get_X();
        this.P1.itsY = p1.get_Y();
        this.P2.itsX = p2.get_X();
        this.P2.itsY = p2.get_Y();
        this.P3.itsX = p3.get_X();
        this.P3.itsY = p3.get_Y();
        this.setDotState(this.GS.itsDotStatus);
        this.graphicLabel = new GraphicLabel(this);
    }

    @Override
    public final void Move(int x, int y) {
        this.i = x - this.itsPx;
        this.j = y - this.itsPy;
        this.itsPx = x;
        this.itsPy = y;
    }

    @Override
    public final void translate(int dx, int dy) {
    }

    @Override
    public final boolean atMe(int x, int y) {
        if (!this.GS.itsDefinedStatus || !this.GS.itsVisibleStatus) {
            return false;
        }
        boolean has = false;
        this._dx1 = this.P1.itsX;
        this._dy1 = this.P1.itsY;
        this._dx2 = this.P2.itsX;
        this._dy2 = this.P2.itsY;
        double dAB = Utils.distance(this._dx1, this._dy1, x, y);
        double dBC = Utils.distance(x, y, this._dx2, this._dy2);
        double dAC = Utils.distance(this._dx1, this._dy1, this._dx2, this._dy2);
        has = Math.abs(dAC - dAB - dBC) <= 0.1;
        this._dx1 = this.P3.itsX;
        this._dy1 = this.P3.itsY;
        this._dx2 = this.P2.itsX;
        this._dy2 = this.P2.itsY;
        dAB = Utils.distance(this._dx1, this._dy1, x, y);
        dBC = Utils.distance(x, y, this._dx2, this._dy2);
        dAC = Utils.distance(this._dx1, this._dy1, this._dx2, this._dy2);
        has = Math.abs(dAC - dAB - dBC) <= 0.1 || has;
        this._dx1 = this.P1.itsX;
        this._dy1 = this.P1.itsY;
        this._dx2 = this.P3.itsX;
        this._dy2 = this.P3.itsY;
        dAB = Utils.distance(this._dx1, this._dy1, x, y);
        dBC = Utils.distance(x, y, this._dx2, this._dy2);
        dAC = Utils.distance(this._dx1, this._dy1, this._dx2, this._dy2);
        has = Math.abs(dAC - dAB - dBC) <= 0.1 || has;
        return has;
    }

    private void drawHideMode(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setPaint(GraphicObject.STROKE_COLOR);
        g2.setStroke(GraphicObject.STROKE_HIDE_MODE);
        this.Segment2D.setLine(this.P1.itsX, this.P1.itsY, this.P2.itsX, this.P2.itsY);
        g2.draw(this.Segment2D);
        this.Segment2D.setLine(this.P3.itsX, this.P3.itsY, this.P2.itsX, this.P2.itsY);
        g2.draw(this.Segment2D);
        this.Segment2D.setLine(this.P1.itsX, this.P1.itsY, this.P3.itsX, this.P3.itsY);
        g2.draw(this.Segment2D);
        g2.draw(this.Segment2D);
    }

    @Override
    public void draw(Graphics g) {
        if (this.GS.hideMode) {
            this.drawHideMode(g);
            return;
        }
        if (!this.GS.itsDefinedStatus || !this.GS.itsVisibleStatus) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        if (this.isSelected) {
            g2.setPaint(this.GS.colorWhenSelected);
        } else {
            g2.setPaint(this.GS.myColor);
        }
        g2.setStroke(this.stroke);
        this.Segment2D.setLine(this.P1.itsX, this.P1.itsY, this.P2.itsX, this.P2.itsY);
        g2.draw(this.Segment2D);
        this.Segment2D.setLine(this.P3.itsX, this.P3.itsY, this.P2.itsX, this.P2.itsY);
        g2.draw(this.Segment2D);
        this.Segment2D.setLine(this.P1.itsX, this.P1.itsY, this.P3.itsX, this.P3.itsY);
        g2.draw(this.Segment2D);
        this.graphicLabel.draw(g2);
    }

    @Override
    public void toEPS(EPSGraphics2D g2) {
        if (!this.GS.itsDefinedStatus || !this.GS.itsVisibleStatus) {
            return;
        }
        if (this.isSelected) {
            g2.setPaint(this.GS.colorWhenSelected);
        } else {
            g2.setPaint(this.GS.myColor);
        }
        g2.setStroke(this.stroke);
        this.Segment2D.setLine(this.P1.itsX, this.P1.itsY, this.P2.itsX, this.P2.itsY);
        g2.draw(this.Segment2D);
        this.Segment2D.setLine(this.P3.itsX, this.P3.itsY, this.P2.itsX, this.P2.itsY);
        g2.draw(this.Segment2D);
        this.Segment2D.setLine(this.P1.itsX, this.P1.itsY, this.P3.itsX, this.P3.itsY);
        g2.draw(this.Segment2D);
        this.graphicLabel.draw(g2);
    }

    @Override
    public int getClassID() {
        return 5060;
    }

    @Override
    public void setState(ConversionFunctions view, State s) {
        this.itsTmp = (TriangleState)s;
        this.world.itsX = this.itsTmp.itsX1;
        this.world.itsY = this.itsTmp.itsY1;
        view.ToScreen(this.world, this.P1);
        this.world.itsX = this.itsTmp.itsX2;
        this.world.itsY = this.itsTmp.itsY2;
        view.ToScreen(this.world, this.P2);
        this.world.itsX = this.itsTmp.itsX3;
        this.world.itsY = this.itsTmp.itsY3;
        view.ToScreen(this.world, this.P3);
        this.GS.itsDefinedStatus = this.itsTmp.itsDefinedStatus;
    }

    @Override
    public State getState(ConversionFunctions view) {
        TriangleState ls = new TriangleState();
        ls.itsMID = this.itsID;
        ls.itsDefinedStatus = this.GS.itsDefinedStatus;
        this.coord.itsX = this.P1.itsX;
        this.coord.itsY = this.P1.itsY;
        view.ToWorld(this.coord, this.world);
        ls.itsX1 = this.world.itsX;
        ls.itsY1 = this.world.itsY;
        this.coord.itsX = this.P2.itsX;
        this.coord.itsY = this.P2.itsY;
        view.ToWorld(this.coord, this.world);
        ls.itsX2 = this.world.itsX;
        ls.itsY2 = this.world.itsY;
        this.coord.itsX = this.P3.itsX;
        this.coord.itsY = this.P3.itsY;
        view.ToWorld(this.coord, this.world);
        ls.itsX3 = this.world.itsX;
        ls.itsY3 = this.world.itsY;
        return ls;
    }

    @Override
    public boolean inside(Rectangle rect) {
        if (!this.GS.itsDefinedStatus || !this.GS.itsVisibleStatus) {
            return false;
        }
        return false;
    }

    public String toString() {
        return "ID: " + this.getID() + " ClassID: " + this.getClassID() + " Construction: " + this.getConstructionID() + "\n";
    }

    @Override
    public boolean hasKernelState() {
        return true;
    }

    @Override
    public boolean GUIonly() {
        return false;
    }

    @Override
    public String getDescription() {
        return "tr\u00edangulo " + this.GS.itsLabel;
    }

    @Override
    public float getXSource() {
        return (float)((this.P1.itsX + this.P2.itsX) / 2.0);
    }

    @Override
    public float getYSource() {
        return (float)((this.P1.itsY + this.P2.itsY) / 2.0);
    }
}

