/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.graphic;

import br.ufrj.labma.enibam.graphic.GraphicObject;
import br.ufrj.labma.enibam.graphic.GraphicPoint;
import br.ufrj.labma.enibam.graphic.GraphicSegment;
import br.ufrj.labma.enibam.gui.ConversionFunctions;
import br.ufrj.labma.enibam.kernel.state.State;
import br.ufrj.labma.enibam.kernel.state.VectorState;
import br.ufrj.labma.enibam.tm.EPSGraphics2D;
import br.ufrj.labma.enibam.util.MathVector;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;

public final class GraphicVector
extends GraphicSegment {
    private VectorState itsTmp2;
    private MathVector v1 = new MathVector();
    private MathVector v2 = new MathVector();
    int[] _polxs = new int[3];
    int[] _polys = new int[3];

    public GraphicVector(GraphicPoint p1, GraphicPoint p2) {
        super(p1, p2);
        this.GS.itsLabel = "Vetor";
        this.setDotState(this.GS.itsDotStatus);
    }

    public GraphicVector() {
        this.GS.itsLabel = "Vetor";
        this.setDotState(this.GS.itsDotStatus);
    }

    @Override
    public void setState(ConversionFunctions view, State s) {
        this.itsTmp2 = (VectorState)s;
        this.world.itsX = this.itsTmp2.itsX1;
        this.world.itsY = this.itsTmp2.itsY1;
        view.ToScreen(this.world, this.P1);
        this.world.itsX = this.itsTmp2.itsX2;
        this.world.itsY = this.itsTmp2.itsY2;
        view.ToScreen(this.world, this.P2);
        this.GS.itsDefinedStatus = this.itsTmp2.itsDefinedStatus;
    }

    @Override
    public State getState(ConversionFunctions view) {
        VectorState ls = new VectorState();
        ls.itsMID = this.itsID;
        ls.itsDefinedStatus = this.GS.itsDefinedStatus;
        view.ToWorld(this.P1, this.world);
        ls.itsX1 = this.world.itsX;
        ls.itsY1 = this.world.itsY;
        view.ToWorld(this.P2, this.world);
        ls.itsX2 = this.world.itsX;
        ls.itsY2 = this.world.itsY;
        return ls;
    }

    @Override
    public int getClassID() {
        return 5035;
    }

    @Override
    void drawHideMode(Graphics g) {
        this.c1.itsX = this.P1.itsX;
        this.c1.itsY = this.P1.itsY;
        this.c2.itsX = this.P2.itsX;
        this.c2.itsY = this.P2.itsY;
        if (!this.clip2d(this.c1, this.c2)) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.setPaint(GraphicObject.STROKE_COLOR);
        g2.setStroke(GraphicObject.STROKE_HIDE_MODE);
        this.segment2D.setLine(this.c1.itsX, this.c1.itsY, this.c2.itsX, this.c2.itsY);
        g2.draw(this.segment2D);
        this.drawArrow(g, (int)this.c1.itsX, (int)this.c1.itsY, (int)this.c2.itsX, (int)this.c2.itsY);
    }

    @Override
    public final void draw(Graphics g) {
        if (this.GS.hideMode) {
            this.drawHideMode(g);
            return;
        }
        this.c1.itsX = this.P1.itsX;
        this.c1.itsY = this.P1.itsY;
        this.c2.itsX = this.P2.itsX;
        this.c2.itsY = this.P2.itsY;
        if (!this.clip2d(this.c1, this.c2)) {
            return;
        }
        if (!this.GS.itsDefinedStatus || !this.GS.itsVisibleStatus) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        if (this.isSelected) {
            g2.setPaint(this.GS.colorWhenSelected);
        } else {
            g2.setPaint(this.GS.myColor);
        }
        g2.setStroke(this.stroke);
        this.segment2D.setLine(this.c1.itsX, this.c1.itsY, this.c2.itsX, this.c2.itsY);
        g2.draw(this.segment2D);
        this.drawArrow(g, (int)this.c1.itsX, (int)this.c1.itsY, (int)this.c2.itsX, (int)this.c2.itsY);
        this.graphicLabel.draw(g2);
        if (this.decoratorOverMe) {
            g2.setPaint(GraphicObject.DECORATOR_STROKE_COLOR);
            g2.setStroke(GraphicObject.DECORATOR_SOLID_STROKE);
            int dx = 5;
            int dy = 5;
            this.segment2D.setLine(this.segment2D.getX1() - (double)dx, this.segment2D.getY1() - (double)dy, this.segment2D.getX2() - (double)dx, this.segment2D.getY2() - (double)dy);
            g2.draw(this.segment2D);
            this.segment2D.setLine(this.segment2D.getX1() + (double)(2 * dx), this.segment2D.getY1() + (double)(2 * dy), this.segment2D.getX2() + (double)(2 * dx), this.segment2D.getY2() + (double)(2 * dy));
            g2.draw(this.segment2D);
        }
    }

    @Override
    public final void toEPS(EPSGraphics2D g2) {
        if (!this.GS.itsDefinedStatus || !this.GS.itsVisibleStatus) {
            return;
        }
        super.toEPS(g2);
        g2.setPaint(this.GS.myColor);
        this.drawArrow(g2, (int)this.P1.itsX, (int)this.P1.itsY, (int)this.P2.itsX, (int)this.P2.itsY);
    }

    @Override
    public String getDescription() {
        return "vetor " + this.GS.itsLabel;
    }

    public void drawArrow(Graphics g, double p1x, double p1y, double p2x, double p2y) {
        int _arrowsize = 15;
        double _dx = p2x - p1x;
        double _dy = p2y - p1y;
        this.v1.setX(_dx);
        this.v1.setY(_dy);
        double _dis = this.v1.modulus();
        this.v2.setVector(this.v1.unitario().productByNumber(_dis -= (double)_arrowsize));
        this.v1.setX(_dx);
        this.v1.setY(_dy);
        this.v1.setVector(this.v2.sub(this.v1));
        double _t1 = this.v1.getX();
        double _t2 = this.v1.getY();
        this.v2.setVector(this.v1.rotation(0.4487989505128276));
        this.v1.setX(_t1);
        this.v1.setY(_t2);
        this.v1.setVector(this.v1.rotation(-0.4487989505128276));
        this._polxs[0] = (int)p2x;
        this._polys[0] = (int)p2y;
        this._polxs[1] = (int)(this.v2.getX() + p2x);
        this._polys[1] = (int)(this.v2.getY() + p2y);
        this._polxs[2] = (int)(this.v1.getX() + p2x);
        this._polys[2] = (int)(this.v1.getY() + p2y);
        this.v1.setX(_dx);
        this.v1.setY(_dy);
        Polygon _pol = new Polygon(this._polxs, this._polys, 3);
        g.fillPolygon(_pol);
    }
}

