/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.gui;

import br.ufrj.labma.enibam.graphic.GraphicAngle;
import br.ufrj.labma.enibam.graphic.GraphicLocus;
import br.ufrj.labma.enibam.graphic.GraphicObject;
import br.ufrj.labma.enibam.graphic.GraphicParameters;
import br.ufrj.labma.enibam.graphic.GraphicPoint;
import br.ufrj.labma.enibam.kernel.CollaborativeKernel;
import br.ufrj.labma.enibam.kernel.KernelProxy;
import br.ufrj.labma.enibam.kernel.TabulaeKernel;
import br.ufrj.labma.enibam.tm.manager.ConfigurationManager;
import br.ufrj.labma.enibam.util.GraphicAttribute;
import br.ufrj.labma.enibam.util.GraphicUtilities;
import br.ufrj.labma.enibam.util.Resolution;
import java.awt.Dimension;
import java.awt.Font;

public class GraphicEnviroment {
    private static GraphicEnviroment instance = new GraphicEnviroment();
    private int width = 10000;
    private int height = 10000;
    private int offsetX = 4700;
    private int offsetY = 4700;
    private int xsource = 5000;
    private int ysource = 5000;
    private double zoom = 1.0;
    private KernelProxy itsProxy;
    private CollaborativeKernel itsCollaborativeProxy;

    public static GraphicEnviroment getInstance() {
        if (instance == null) {
            instance = new GraphicEnviroment();
        }
        return instance;
    }

    public static Resolution getResolution() {
        GraphicUtilities.loadScreenDimension();
        return new Resolution(GraphicUtilities.getXResolution(), GraphicUtilities.getYResolution());
    }

    public int getXSource() {
        return this.xsource;
    }

    public int getYSource() {
        return this.ysource;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getXOffset() {
        return this.offsetX;
    }

    public int getYOffset() {
        return this.offsetY;
    }

    public double getZoom() {
        return this.zoom;
    }

    public void setZoom(double x) {
        this.zoom = x;
    }

    public int getDiagonal() {
        return (int)Math.sqrt(Math.pow(this.getWidth(), 2.0) + Math.pow(this.getWidth(), 2.0));
    }

    public void setDimension(int w, int h) {
        this.width = w;
        this.height = h;
    }

    public Dimension getDimension() {
        return new Dimension(this.width, this.height);
    }

    public Dimension getOffset() {
        return new Dimension(this.offsetX, this.offsetY);
    }

    public void setOffset(int x, int y) {
        this.offsetX = x;
        this.offsetY = y;
    }

    public GraphicAttribute getGraphicAttribute() {
        return new GraphicAttribute(this.width, this.height, this.offsetX, this.offsetY, this.xsource, this.ysource, this.zoom);
    }

    public void setGraphicAttribute(GraphicAttribute g) {
        this.width = g.getWidth();
        this.height = g.getHeight();
        this.offsetX = g.getXOffset();
        this.offsetY = g.getYOffset();
        this.xsource = g.getXSource();
        this.ysource = g.getYSource();
        this.zoom = g.getZoom();
    }

    public KernelProxy getKernel() {
        if (this.itsProxy == null) {
            this.itsProxy = new TabulaeKernel();
        }
        return this.itsProxy;
    }

    public CollaborativeKernel getCollaborativeKernel() {
        if (this.itsCollaborativeProxy == null) {
            this.itsCollaborativeProxy = new CollaborativeKernel();
        }
        return this.itsCollaborativeProxy;
    }

    public static final void setGraphicParameters(GraphicParameters graphic, int classID) {
        if (classID == 5000) {
            ((GraphicPoint)graphic).setRadius(ConfigurationManager.getInstance().CS.RAY_POINT);
        } else if (classID == 5040) {
            ((GraphicLocus)graphic).setInterpolate(ConfigurationManager.getInstance().CS.INTERPOLATE);
        } else if (classID == 5030) {
            ((GraphicAngle)graphic).setDegree(ConfigurationManager.getInstance().CS.DEGREE);
        }
        graphic.setThickness(ConfigurationManager.getInstance().CS.THICKNESS);
        graphic.setDotState(ConfigurationManager.getInstance().CS.DOTED_STATUS);
        graphic.setColor(ConfigurationManager.getInstance().getByCID((GraphicObject)graphic));
        graphic.setLabelColor(ConfigurationManager.getInstance().CS.LABEL_COLOR);
        graphic.setFont(new Font(ConfigurationManager.getInstance().CS.FONT_NAME, ConfigurationManager.getInstance().CS.FONT_STYLE, ConfigurationManager.getInstance().CS.FONT_SIZE));
    }
}

