/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.gui;

import br.ufrj.labma.enibam.creation.CreationMachine;
import br.ufrj.labma.enibam.gui.BorderPanel;
import br.ufrj.labma.enibam.gui.ButtonMachineComponent;
import br.ufrj.labma.enibam.gui.GUI;
import br.ufrj.labma.enibam.gui.MachineComponent;
import br.ufrj.labma.enibam.gui.MenuBase;
import br.ufrj.labma.enibam.gui.MenuComponentInterface;
import br.ufrj.labma.enibam.gui.MenuElement;
import br.ufrj.labma.enibam.gui.MenuMachineComponent;
import br.ufrj.labma.enibam.gui.MenuStore;
import br.ufrj.labma.enibam.gui.SessionViewport;
import br.ufrj.labma.enibam.gui.ViewportManager;
import br.ufrj.labma.enibam.gui.text.EditMenuText;
import br.ufrj.labma.enibam.gui.window.WindowManager;
import br.ufrj.labma.enibam.tm.manager.MenuUpdateManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.event.MenuListener;

public class MenuMap
implements Serializable,
ActionListener {
    private GUI itsGUI;
    private Image itsImage;
    private static final Insets itsMARGIN = new Insets(1, 1, 1, 1);
    private HashMap itsHash = new HashMap();
    private HashMap hashComponent = new HashMap();
    private JToggleButton toggleButton;
    private HashMap map = MenuStore.getInstance().FocusMap();
    private HashMap menumap = new HashMap();
    private BorderPanel panelTools;
    private JPanel toolsPanel;
    private JMenuBar theMenuBar;
    private List buttonsFamily = new ArrayList();
    private List constructionButtons = new ArrayList();
    private AbstractButton selectionButton;

    private MenuMap() {
    }

    public MenuMap(GUI app, URL path_img) {
        this.itsGUI = app;
        this.itsImage = path_img != null ? Toolkit.getDefaultToolkit().getImage(path_img) : null;
    }

    public JMenuBar createMenu(Color bg, Color fg, Color border_color, Color m_fg, Color m_bg) {
        JMenuBar menuBar = new JMenuBar(){

            @Override
            public void paint(Graphics g) {
                if (MenuMap.this.itsImage != null) {
                    g.drawImage(MenuMap.this.itsImage, 0, 0, this.getWidth(), this.getHeight(), this);
                }
                super.paint(g);
            }
        };
        menuBar.setOpaque(false);
        menuBar.setBackground(bg);
        menuBar.setForeground(fg);
        menuBar.setBorder(BorderFactory.createLineBorder(border_color, 0));
        this.itsGUI.setJMenuBar(menuBar);
        this.constructionDynamicMenu(menuBar, bg, fg, m_fg, m_bg);
        this.theMenuBar = menuBar;
        return menuBar;
    }

    private void constructionMenu(Color bg, Color fg) {
        List list = this.itsGUI.getViewport().getTM().getCreationMachine();
        int i = 0;
        while (i < list.size()) {
            CreationMachine cm = (CreationMachine)list.get(i);
            JMenuItem mi = cm.getMenuComponent();
            JMenu menu = (JMenu)this.menumap.get(cm.getBaseMenuBar());
            if (mi != null && menu != null) {
                mi.addActionListener(this);
                mi.setBackground(bg);
                mi.setForeground(fg);
                this.fillMenu(menu, mi, cm.getMenuBase());
                this.map.put(mi.getText(), mi);
            }
            ++i;
        }
    }

    private void constructionDynamicMenu(JMenuBar menubar, Color bg, Color fg, Color m_fg, Color m_bg) {
        MenuStore store = MenuStore.getInstance();
        int i = 0;
        while (i < store.getCount()) {
            MenuBase mp = store.CreateByID(i);
            JMenu menu = new JMenu(mp.getLabel());
            menu.addMenuListener((MenuListener)MenuUpdateManager.getInstance());
            menu.setMnemonic(mp.getMnemonic());
            menu.setOpaque(false);
            menu.setBackground(m_bg);
            menu.setForeground(m_fg);
            this.fillMenu(menu, mp.getObjectList(), bg, fg);
            menubar.add(menu);
            this.menumap.put(mp.getLabel(), menu);
            ++i;
        }
        this.constructionMenu(bg, fg);
    }

    public void fillMenu(JMenu menu, JMenuItem menuItem, String key) {
        if (key == null) {
            menu.add(menuItem);
        } else {
            JMenu me = (JMenu)this.itsHash.get(key);
            if (me != null) {
                me.add(menuItem);
            } else {
                JMenu meTmp = new JMenu(key);
                meTmp.setOpaque(true);
                meTmp.setBackground(menuItem.getBackground());
                meTmp.setForeground(menuItem.getForeground());
                meTmp.add(menuItem);
                menu.add(meTmp);
                this.itsHash.put(key, meTmp);
            }
        }
    }

    public void fillMenu(JMenu menu, List list, Color bg, Color fg) {
        JMenu menuTmp = menu;
        boolean filehistory = false;
        int i = 0;
        while (i < list.size()) {
            MenuElement me = (MenuElement)list.get(i);
            int x = me.getType();
            switch (x) {
                case 110: {
                    JMenuItem mi = (JMenuItem)me.getMenuItem();
                    if (!filehistory) {
                        mi.addActionListener(this);
                    }
                    mi.setBackground(bg);
                    mi.setForeground(fg);
                    menuTmp.add(mi);
                    this.map.put(mi.getText(), mi);
                    break;
                }
                case 113: {
                    menuTmp.addSeparator();
                    break;
                }
                case 111: {
                    menuTmp = new JMenu(me.getText());
                    menuTmp.setBackground(bg);
                    menuTmp.setForeground(fg);
                    menuTmp.setOpaque(true);
                    break;
                }
                case 112: {
                    menu.add(menuTmp);
                    menuTmp = menu;
                    break;
                }
                case 120: {
                    filehistory = true;
                    break;
                }
                case 121: {
                    filehistory = false;
                }
            }
            ++i;
        }
        menu.validate();
        menu.repaint();
    }

    public void setCreationBar(BorderPanel panel) {
        this.panelTools = panel;
        List list = this.itsGUI.getViewport().getTM().getCreationMachine();
        int i = 0;
        while (i < list.size()) {
            try {
                CreationMachine cm = (CreationMachine)list.get(i);
                if (cm.hasButton()) {
                    AbstractButton mi = (AbstractButton)cm.getComponent();
                    mi.setOpaque(false);
                    mi.addActionListener(this);
                    mi.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
                    mi.setRolloverEnabled(true);
                    mi.setPressedIcon(cm.getIcon32Selected());
                    mi.setSelectedIcon(cm.getIcon32Selected());
                    mi.setRolloverIcon(cm.getIcon32Selected());
                    mi.setRolloverIcon(cm.getIcon32Selected());
                    mi.setBorderPainted(false);
                    mi.setContentAreaFilled(false);
                    if (cm.isRootFamily()) {
                        this.panelTools.add((Component)mi);
                    } else {
                        this.constructionButtons.add(mi);
                    }
                    this.hashComponent.put(new Integer(((MenuComponentInterface)mi).getIdentification()), mi);
                }
            }
            catch (Exception e) {
                System.out.println("Exception setCreationBar()");
                System.out.println(e);
            }
            ++i;
        }
        this.panelTools.setSeparator();
    }

    public void setToolBar(JPanel panel) {
        try {
            int id;
            AbstractButton but;
            MenuElement me;
            int j;
            List list;
            MenuBase mp;
            this.toolsPanel = panel;
            MenuStore store = MenuStore.getInstance();
            int selectionButID = 0;
            int i = 0;
            while (i < store.getCount()) {
                mp = store.CreateByID(i);
                list = mp.getObjectList();
                j = 0;
                while (j < list.size()) {
                    me = (MenuElement)list.get(j);
                    but = (AbstractButton)me.getButton();
                    if (but != null && (id = ((MenuComponentInterface)but).getIdentification()) == 74) {
                        this.selectionButton = but;
                        selectionButID = me.getID();
                        this.selectionButton.setPressedIcon(new ImageIcon(EditMenuText.SELECT_ICON_32_SELECTED));
                        this.selectionButton.setSelectedIcon(new ImageIcon(EditMenuText.SELECT_ICON_32_SELECTED));
                        this.selectionButton.setRolloverIcon(new ImageIcon(EditMenuText.SELECT_ICON_32_SELECTED));
                        this.selectionButton.setRolloverIcon(new ImageIcon(EditMenuText.SELECT_ICON_32_SELECTED));
                    }
                    ++j;
                }
                ++i;
            }
            this.selectionButton.setOpaque(false);
            this.selectionButton.addActionListener(this);
            this.selectionButton.setMargin(itsMARGIN);
            this.selectionButton.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
            this.selectionButton.setBorderPainted(false);
            this.selectionButton.setContentAreaFilled(false);
            panel.add(this.selectionButton);
            this.hashComponent.put(new Integer(selectionButID), this.selectionButton);
            i = 0;
            while (i < store.getCount()) {
                mp = store.CreateByID(i);
                list = mp.getObjectList();
                j = 0;
                while (j < list.size()) {
                    me = (MenuElement)list.get(j);
                    but = (AbstractButton)me.getButton();
                    if (but != null && (id = ((MenuComponentInterface)but).getIdentification()) != 74) {
                        but.setOpaque(false);
                        but.addActionListener(this);
                        but.setMargin(itsMARGIN);
                        but.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
                        but.setBorderPainted(false);
                        but.setContentAreaFilled(false);
                        panel.add(but);
                        this.hashComponent.put(new Integer(me.getID()), but);
                    }
                    ++j;
                }
                ++i;
            }
            this.selectionMode();
        }
        catch (Exception e) {
            System.out.println("Error: MenuMap");
        }
    }

    public void selectionMode() {
        if (this.selectionButton != null) {
            this.selectionButton.doClick();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        int action = src instanceof MachineComponent ? ((MachineComponent)src).getIdentification() : (src instanceof MenuComponentInterface ? ((MenuComponentInterface)src).getIdentification() : 0);
        this.endProgram(action);
        if (!this.createViewport(action)) {
            this.itsGUI.getViewport().getTM().setToggleComponentSelected(src);
        } else {
            this.itsGUI.getViewport().getTM().setToggleComponentSelected(null);
        }
        this.setComponentSelected(src, true);
    }

    public void setComponentSelected(Object src, boolean run) {
        if (src == null) {
            return;
        }
        if (this.theMenuBar != null) {
            this.theMenuBar.repaint();
        }
        if (this.toolsPanel != null) {
            this.toolsPanel.repaint();
        }
        if (src instanceof MachineComponent) {
            MachineComponent mc = (MachineComponent)src;
            if (this.toggleButton != null) {
                this.toggleButton.setSelected(false);
            }
            if (mc instanceof ButtonMachineComponent) {
                JToggleButton tmp = (JToggleButton)this.hashComponent.get(new Integer(mc.getIdentification()));
                tmp.setSelected(true);
                this.toggleButton = tmp;
                this.updateButtonsFamily((ButtonMachineComponent)this.toggleButton);
                this.itsGUI.getViewport().getTM().openTransaction(mc.getIdentification());
                this.itsGUI.setMessage(mc.getMessage());
            } else if (mc instanceof MenuMachineComponent && run) {
                if (this.itsGUI.getViewport() instanceof SessionViewport) {
                    if (((SessionViewport)this.itsGUI.getViewport()).canBuild()) {
                        this.itsGUI.getViewport().getTM().create(mc.getIdentification());
                    } else if (!this.itsGUI.getViewport().getTM().ignoreProhibitionMessage(mc.getIdentification())) {
                        this.itsGUI.setMessage("Opera\u00e7\u00e3o n\u00e3o permitida.");
                        WindowManager.getInstance().showAlertDialog((Object)"Voc\u00ea n\u00e3o tem permiss\u00e3o para executar esta opera\u00e7\u00e3o na \u00e1rea p\u00fablica.", (Component)this.itsGUI);
                    }
                } else {
                    this.itsGUI.getViewport().getTM().create(mc.getIdentification());
                }
            }
        } else if (src instanceof MenuComponentInterface) {
            MenuComponentInterface mc = (MenuComponentInterface)src;
            try {
                JToggleButton tmp = (JToggleButton)this.hashComponent.get(new Integer(mc.getIdentification()));
                if (tmp != null) {
                    if (this.toggleButton != null) {
                        this.toggleButton.setSelected(false);
                    }
                    tmp.setSelected(true);
                    this.toggleButton = tmp;
                    this.updateButtonsFamily(null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (run) {
                if (this.itsGUI.getViewport() instanceof SessionViewport) {
                    if (((SessionViewport)this.itsGUI.getViewport()).canBuild()) {
                        this.itsGUI.getViewport().getTM().execute(mc.getIdentification(), mc.getMessage(), true);
                        this.itsGUI.setMessage(mc.getMessage());
                    } else if (!this.itsGUI.getViewport().getTM().execute(mc.getIdentification(), mc.getMessage(), false)) {
                        if (!this.itsGUI.getViewport().getTM().ignoreProhibitionMessage(mc.getIdentification())) {
                            this.itsGUI.setMessage("Opera\u00e7\u00e3o n\u00e3o permitida.");
                            WindowManager.getInstance().showAlertDialog((Object)"Voc\u00ea n\u00e3o tem permiss\u00e3o para executar esta opera\u00e7\u00e3o na \u00e1rea p\u00fablica.", (Component)this.itsGUI);
                        }
                    } else {
                        this.itsGUI.setMessage(mc.getMessage());
                    }
                } else {
                    this.itsGUI.getViewport().getTM().execute(mc.getIdentification(), mc.getMessage(), true);
                    this.itsGUI.setMessage(mc.getMessage());
                }
            }
        }
    }

    private boolean createViewport(int action) {
        if (action == 11 || action == 10) {
            ViewportManager.getInstance().createViewport(this.itsGUI);
            return true;
        }
        return false;
    }

    private boolean endProgram(int action) {
        if (action == 21) {
            ViewportManager.getInstance().closeAll();
            return true;
        }
        return false;
    }

    public void setEnabled(boolean b) {
        Component[] comp = this.panelTools.getComponents();
        int i = 0;
        while (i < comp.length) {
            comp[i].setEnabled(b);
            ++i;
        }
        comp = this.toolsPanel.getComponents();
        i = 0;
        while (i < comp.length) {
            comp[i].setEnabled(b);
            ++i;
        }
        Collection list = this.itsHash.values();
        Iterator<Object> i2 = list.iterator();
        while (i2.hasNext()) {
            ((JMenu)i2.next()).setEnabled(b);
        }
        i2 = this.buttonsFamily.iterator();
        while (i2.hasNext()) {
            ((ButtonMachineComponent)i2.next()).setEnabled(b);
        }
        this.theMenuBar.setEnabled(b);
    }

    private void updateButtonsFamily(ButtonMachineComponent bmc) {
        Iterator i = this.buttonsFamily.iterator();
        while (i.hasNext()) {
            this.panelTools.removeFromScroller((Component)i.next());
        }
        this.buttonsFamily.clear();
        if (bmc != null) {
            String family = bmc.getFamily();
            for (ButtonMachineComponent BMC : this.constructionButtons) {
                if (!BMC.getFamily().equals(family)) continue;
                this.buttonsFamily.add(BMC);
            }
            Iterator i2 = this.buttonsFamily.iterator();
            while (i2.hasNext()) {
                this.panelTools.addToScroller((Component)((AbstractButton)i2.next()));
            }
        }
        this.panelTools.validate();
        this.panelTools.repaint();
    }

    public JMenu getMenu(String label) {
        return (JMenu)this.menumap.get(label);
    }

    public JMenuBar getTheMenuBar() {
        return this.theMenuBar;
    }
}

