/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.gui;

import br.ufrj.labma.enibam.aat.model.Activity;
import br.ufrj.labma.enibam.gui.GraphicInterface;
import br.ufrj.labma.enibam.gui.SessionRemoteHandler;
import br.ufrj.labma.enibam.gui.SessionViewport;
import br.ufrj.labma.enibam.gui.Telepointer;
import br.ufrj.labma.enibam.gui.Viewport;
import br.ufrj.labma.enibam.gui.ViewportInterface;
import br.ufrj.labma.enibam.gui.component.TaskButton;
import br.ufrj.labma.enibam.gui.text.HelpMenuText;
import br.ufrj.labma.enibam.gui.window.WindowManager;
import br.ufrj.labma.enibam.network.data.command.AbstractSessionCommand;
import br.ufrj.labma.enibam.network.data.response.ResponseContext;
import br.ufrj.labma.enibam.network.manager.GroupwareAdapter;
import br.ufrj.labma.enibam.tm.TransactionManager;
import br.ufrj.labma.enibam.tm.manager.ConfigurationManager;
import br.xdev.framework.logging.Logger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkListener;

public class ReviewViewport
extends SessionViewport
implements MouseMotionListener,
MouseListener,
ViewportInterface,
KeyListener,
ComponentListener,
AdjustmentListener,
Runnable,
ChangeListener {
    private static final ImageIcon stopIcon = new ImageIcon(HelpMenuText.STOP_ICON_16);
    private static final ImageIcon stopIcon2 = new ImageIcon(HelpMenuText.STOP_ICON_16_2);
    private static final ImageIcon playIcon = new ImageIcon(HelpMenuText.PLAY_ICON_16);
    private static final ImageIcon playIcon2 = new ImageIcon(HelpMenuText.PLAY_ICON_16_2);
    private static final ImageIcon pauseIcon = new ImageIcon(HelpMenuText.PAUSE_ICON_16);
    private static final ImageIcon pauseIcon2 = new ImageIcon(HelpMenuText.PAUSE_ICON_16_2);
    private static final ImageIcon forwardIcon = new ImageIcon(HelpMenuText.FORWARD_ICON_16);
    private static final ImageIcon forwardIcon2 = new ImageIcon(HelpMenuText.FORWARD_ICON_16_2);
    private int step;
    private boolean isRunning;
    private boolean isStop;
    private boolean isForward;
    private TaskButton playButton;
    private TaskButton stopButton;
    private TaskButton pauseButton;
    private TaskButton forwardButton;
    private AbstractSessionCommand[] fullContext;
    private JProgressBar progressBar;
    private JSlider delay;
    private static int TIME_SLEEP = 1000;
    private static int TIME_STEP_MOVIE = 500;
    private static int TIME_FRAME = 25;
    private static final int TIME_SLEEP_MAX = 1000;
    private static final int TIME_STEP_MOVIE_MAX = 2000;
    private static final int TIME_FRAME_MAX = 100;
    private boolean firstTime;

    @Override
    public void stateChanged(ChangeEvent e) {
        TIME_FRAME = 100 - ((JSlider)e.getSource()).getValue();
    }

    public ReviewViewport(GraphicInterface app, int x, int y, Activity activity) {
        super(app, x, y, activity);
        this.FLICK_NUMBER = 1;
        this.firstTime = true;
    }

    public ReviewViewport(GraphicInterface app, int x, int y, URL path_img, Activity activity) {
        super(app, x, y, path_img, activity);
        this.FLICK_NUMBER = 1;
        this.firstTime = true;
    }

    protected void initialize() {
        super.initialize();
        this.remoteHandler = new SessionRemoteHandler((SessionViewport)this);
        this.itsTM = new TransactionManager((Viewport)((Object)this), true);
        this.commandpool = new ArrayList();
        this.delay = new JSlider(0, 100, 10);
        this.delay.addChangeListener(this);
        this.delay.setMajorTickSpacing(50);
        this.delay.setMinorTickSpacing(1);
        this.delay.setPaintLabels(false);
        this.delay.setSnapToTicks(true);
        this.commandpool = new ArrayList();
        if (this.networkMessage == null) {
            this.networkMessage = new JEditorPane();
            this.networkMessage.addHyperlinkListener((HyperlinkListener)WindowManager.getInstance());
        } else {
            this.networkContentMessage = "";
            this.networkMessage.setText(this.networkContentMessage);
        }
        this.networkMessage.setContentType("text/html");
        this.networkMessage.setEditable(false);
        this.networkMessage.setMinimumSize(new Dimension(0, 0));
    }

    @Override
    public final JComponent getComponentBase() {
        JPanel panel = new JPanel(new BorderLayout());
        JPanel buttonpanel = new JPanel(new FlowLayout(0));
        buttonpanel.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        buttonpanel.setBackground(new Color(187, 194, 146));
        this.helpbutton = new TaskButton(new ImageIcon(HelpMenuText.DETAIL_SESSION_ICON_16), "Configura\u00e7\u00e3o da Sess\u00e3o Colaborativa ...", 4002);
        this.helpbutton.addActionListener((ActionListener)((Object)this));
        this.helpbutton.setOpaque(false);
        this.helpbutton.setBackground(Color.black);
        buttonpanel.add((Component)this.helpbutton);
        JLabel spaceLabel = new JLabel("                     ");
        spaceLabel.setBorder(BorderFactory.createEmptyBorder());
        spaceLabel.setOpaque(false);
        buttonpanel.add(spaceLabel);
        this.playButton = new TaskButton(new ImageIcon(HelpMenuText.PLAY_ICON_16), "Iniciar", 4010);
        this.playButton.addActionListener((ActionListener)((Object)this));
        this.playButton.setOpaque(false);
        this.playButton.setBackground(Color.black);
        this.playButton.setEnabled(false);
        buttonpanel.add((Component)this.playButton);
        this.stopButton = new TaskButton(new ImageIcon(HelpMenuText.STOP_ICON_16), "Parar", 4011);
        this.stopButton.addActionListener((ActionListener)((Object)this));
        this.stopButton.setOpaque(false);
        this.stopButton.setBackground(Color.black);
        this.stopButton.setEnabled(false);
        buttonpanel.add((Component)this.stopButton);
        this.pauseButton = new TaskButton(new ImageIcon(HelpMenuText.PAUSE_ICON_16), "Pausa", 4012);
        this.pauseButton.addActionListener((ActionListener)((Object)this));
        this.pauseButton.setOpaque(false);
        this.pauseButton.setBackground(Color.black);
        this.pauseButton.setEnabled(false);
        buttonpanel.add((Component)this.pauseButton);
        this.forwardButton = new TaskButton(new ImageIcon(HelpMenuText.FORWARD_ICON_16), "Avan\u00e7ar", 4013);
        this.forwardButton.addActionListener((ActionListener)((Object)this));
        this.forwardButton.setOpaque(false);
        this.forwardButton.setBackground(Color.black);
        this.forwardButton.setEnabled(false);
        buttonpanel.add((Component)this.forwardButton);
        panel.add("North", buttonpanel);
        JScrollPane viewportscroll = this.getViewportBase();
        this.telepointer = new Telepointer();
        this.messagescroll = new JScrollPane(this.networkMessage);
        this.messagescroll.setMinimumSize(new Dimension(0, 0));
        this.splitPane = new JSplitPane(0, viewportscroll, this.messagescroll);
        this.splitPane.setOneTouchExpandable(false);
        this.splitPane.setContinuousLayout(false);
        this.splitPane.setMinimumSize(new Dimension(400, 300));
        this.splitPane.setDividerLocation(455);
        panel.add("Center", this.splitPane);
        this.setTelepointer(false);
        this.progressBar = new JProgressBar();
        this.progressBar.setPreferredSize(new Dimension(20, 5));
        this.progressBar.setBorderPainted(true);
        this.progressBar.setForeground(Color.blue);
        this.progressBar.setValue(0);
        panel.add("South", this.progressBar);
        this.activity = GroupwareAdapter.getInstance().getActivity(this.activity.getCode());
        return panel;
    }

    public void refresh() {
        WindowManager.getInstance().getProgressBar().setMaximum(5);
        this.roles = GroupwareAdapter.getInstance().requestMyRolesInActivity(this.activity);
        WindowManager.getInstance().getProgressBar().setValue(WindowManager.getInstance().getProgressBar().getValue() + 1);
        this.sessionUser = GroupwareAdapter.getInstance().requestActivedSessionUsers(this.activity);
        WindowManager.getInstance().getProgressBar().setValue(WindowManager.getInstance().getProgressBar().getValue() + 1);
        this.sessionroles = GroupwareAdapter.getInstance().requestUsersAndRoles(this.activity);
        WindowManager.getInstance().getProgressBar().setValue(WindowManager.getInstance().getProgressBar().getValue() + 1);
        this.typeComments = GroupwareAdapter.getInstance().requestAllTypeOfComment();
        WindowManager.getInstance().getProgressBar().setValue(WindowManager.getInstance().getProgressBar().getValue() + 1);
        WindowManager.getInstance().getProgressBar().setValue(0);
        WindowManager.getInstance().getProgressBar().setBackground(new Color(255, 255, 225));
        WindowManager.getInstance().getProgressBar().setForeground(Color.GREEN);
        WindowManager.getInstance().getProgressBar().setBorder(BorderFactory.createEmptyBorder());
        Logger.debug((Object)"########## FULL CONTEXT ############");
        ResponseContext context = GroupwareAdapter.getInstance().requestContext(this.activity, ConfigurationManager.getInstance().CS.USE_DATA_COMPRESSION);
        if (context != null) {
            this.fullContext = context.getCommands();
        }
        Logger.debug((Object)"########## END FULL CONTEXT ############");
        this.resetControls();
        WindowManager.getInstance().getProgressBar().setValue(WindowManager.getInstance().getProgressBar().getMaximum());
        WindowManager.getInstance().hideHintFrame();
    }

    public boolean hasRole(int r) {
        return r == 3;
    }

    public void play() {
        this.resetMovie();
        this.playButton.setEnabled(false);
        this.stopButton.setEnabled(true);
        this.pauseButton.setEnabled(true);
        this.playButton.setIcon((Icon)playIcon2);
        this.isStop = false;
        this.isForward = false;
        this.isRunning = true;
        new Thread(this).start();
    }

    public void stop() {
        this.isStop = true;
        this.isForward = false;
        this.isRunning = false;
        this.stopButton.setEnabled(false);
        this.playButton.setEnabled(true);
        this.pauseButton.setEnabled(false);
        this.playButton.setIcon((Icon)playIcon);
        this.stopButton.setIcon((Icon)stopIcon2);
        this.pauseButton.setIcon((Icon)pauseIcon);
        this.forwardButton.setIcon((Icon)forwardIcon);
    }

    public void forward() {
        this.isForward = true;
        this.isStop = false;
        this.playButton.setIcon((Icon)playIcon);
        this.stopButton.setIcon((Icon)stopIcon);
        this.pauseButton.setIcon((Icon)pauseIcon2);
        this.forwardButton.setIcon((Icon)forwardIcon2);
        if (this.fullContext != null && this.step < this.fullContext.length) {
            this.forwardButton.setEnabled(true);
            this.pauseButton.setEnabled(true);
        } else {
            this.resetControls();
        }
    }

    public void pause() {
        this.isForward = false;
        this.isStop = false;
        this.isRunning = !this.isRunning;
        this.forwardButton.setEnabled(!this.isRunning);
        this.stopButton.setEnabled(this.isRunning);
        this.playButton.setEnabled(false);
        this.playButton.setIcon((Icon)playIcon);
        this.stopButton.setIcon((Icon)stopIcon);
        this.pauseButton.setIcon((Icon)(this.isRunning ? pauseIcon : pauseIcon2));
        this.forwardButton.setIcon((Icon)forwardIcon);
    }

    @Override
    public void run() {
        if (this.firstTime) {
            this.firstTime = false;
            this.refresh();
        }
        if (this.fullContext != null) {
            this.progressBar.setValue(0);
            this.progressBar.setMaximum(this.fullContext.length * TIME_STEP_MOVIE);
            this.step = 0;
            while (this.step < this.fullContext.length) {
                if (this.isStop) break;
                this.isForward = false;
                Logger.debug((Object)this.fullContext[this.step]);
                this.progressBar.setValue((this.step + 1) * TIME_STEP_MOVIE);
                this.remoteHandler.handle((Object)this.fullContext[this.step]);
                if (!this.isRunning) {
                    while (!this.isRunning && !this.isForward) {
                        try {
                            if (!this.isStop) {
                                Thread.sleep(TIME_SLEEP);
                                continue;
                            }
                            break;
                        }
                        catch (InterruptedException e) {
                            Logger.error((Object)e.getMessage(), (Throwable)e);
                        }
                    }
                } else {
                    if (this.step + 1 >= this.fullContext.length) break;
                    try {
                        int nframes = TIME_STEP_MOVIE / TIME_FRAME;
                        int i = 0;
                        while (i < nframes) {
                            if (this.isStop) break;
                            this.progressBar.setValue((this.step + 1) * TIME_STEP_MOVIE + i * TIME_FRAME);
                            Thread.sleep(TIME_FRAME);
                            ++i;
                        }
                    }
                    catch (InterruptedException e) {
                        Logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
                ++this.step;
            }
            this.resetControls();
        }
    }

    private void resetControls() {
        this.stopButton.setEnabled(false);
        this.stopButton.setIcon((Icon)stopIcon);
        this.pauseButton.setEnabled(false);
        this.pauseButton.setIcon((Icon)pauseIcon);
        this.forwardButton.setEnabled(false);
        this.forwardButton.setIcon((Icon)forwardIcon);
        this.playButton.setEnabled(true);
        this.playButton.setIcon((Icon)playIcon);
    }

    private void resetMovie() {
        this.initialize();
        this.clear();
        this.resetControls();
    }
}

