/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.gui;

import br.ufrj.labma.enibam.creation.CreationManager;
import br.ufrj.labma.enibam.graphic.GraphicLabel;
import br.ufrj.labma.enibam.graphic.GraphicObject;
import br.ufrj.labma.enibam.graphic.GraphicParameters;
import br.ufrj.labma.enibam.graphic.GraphicPoint;
import br.ufrj.labma.enibam.gui.ConversionFunctions;
import br.ufrj.labma.enibam.gui.GraphicEnviroment;
import br.ufrj.labma.enibam.gui.GraphicInterface;
import br.ufrj.labma.enibam.gui.JLabelre;
import br.ufrj.labma.enibam.gui.ViewportInterface;
import br.ufrj.labma.enibam.gui.window.WindowManagerApplet;
import br.ufrj.labma.enibam.history.AEConversion;
import br.ufrj.labma.enibam.history.ControlVersion;
import br.ufrj.labma.enibam.history.HistoryInterface;
import br.ufrj.labma.enibam.history.ae.MakeElement;
import br.ufrj.labma.enibam.kernel.CollaborativeKernel;
import br.ufrj.labma.enibam.kernel.KernelProxy;
import br.ufrj.labma.enibam.kernel.operations.CoorSys;
import br.ufrj.labma.enibam.kernel.state.State;
import br.ufrj.labma.enibam.macro.MacroInspector;
import br.ufrj.labma.enibam.tm.TransactionInterface;
import br.ufrj.labma.enibam.util.FileAttribute;
import br.ufrj.labma.enibam.util.GraphicAttribute;
import br.ufrj.labma.enibam.util.GraphicUtilities;
import br.ufrj.labma.enibam.util.Identification;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class TabulaeAppletViewer
extends JPanel
implements MouseMotionListener,
ViewportInterface,
ConversionFunctions,
MouseListener,
KeyListener,
AdjustmentListener {
    private GraphicEnviroment GE;
    private JScrollPane scroller;
    protected GraphicInterface itsGUI;
    private GraphicObject itsSelected;
    private List theSelectedList;
    private List theObjectList;
    private List selectedObjects;
    private List theClassifiedObjectsList;
    private int classified = 0;
    private int ismoved = 0;
    private Map theHashMap;
    private Color SelectionColor = Color.RED;
    private double worldWidth;
    private double worldHeight;
    private double scale = 1.0;
    private boolean isSave = true;
    private Image IMAGEESPIRAL;
    private static Image IMAGE_POINT;
    private static Image IMAGE_POINT_SELECTED;
    protected int modifiers = 0;
    private GraphicObject selectedID = null;
    private GraphicObject selectedIDtmp = null;
    private boolean isKeyPressed = false;
    private boolean hasSelectionArea = true;
    private boolean zoomMode = false;
    private Rectangle selectionArea = new Rectangle(0, 0, 500, 500);
    private int startX;
    private int startY;
    public final transient float[] dash = new float[]{12.0f, 12.0f};
    private BasicStroke stroke = new BasicStroke(1.0f, 1, 2, 0.0f, this.dash, 0.0f);
    private Rectangle2D clipping = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
    private GraphicLabel labelSelected;
    private Integer labelObjectID;
    private CoorSys world = new CoorSys();
    private CoorSys screen = new CoorSys();
    private CoorSys itsPosition = new CoorSys();
    private Set theUpdateSet = new HashSet();
    private int itsSelectedOID = -10;
    private KernelProxy itsProxy;
    private Set objectSet = new HashSet();
    private CoorSys screenBuffer = new CoorSys();
    private List itsTmpList = new ArrayList();
    private List Obsevers = new ArrayList();
    private int videostate = 0;
    private State itsState;

    @Override
    public void clear() {
        this.removeall();
    }

    @Override
    public HistoryInterface getHistory() {
        return null;
    }

    @Override
    public boolean isSave() {
        return false;
    }

    public void removeall() {
        Iterator i = this.theObjectList.iterator();
        while (i.hasNext()) {
            this.theHashMap.remove(((GraphicObject)i.next()).getID());
            this.theObjectList.remove((GraphicObject)i.next());
            this.GE.getKernel().destroy(((GraphicObject)i.next()).getID());
        }
    }

    @Override
    public void remove(Collection list) {
        boolean clear = false;
        for (Integer id : list) {
            GraphicObject graphic = (GraphicObject)this.theHashMap.get(id);
            this.theHashMap.remove(id);
            this.theObjectList.remove(graphic);
            clear = true;
        }
        if (clear) {
            if (this.selectedObjects != null) {
                this.selectedObjects.clear();
            }
            if (this.theClassifiedObjectsList != null) {
                this.theClassifiedObjectsList.clear();
            }
        }
        this.isSave = false;
    }

    @Override
    public TransactionInterface getTM() {
        return null;
    }

    public TabulaeAppletViewer(GraphicInterface app, int x, int y) {
        this(app, x, y, null);
    }

    public TabulaeAppletViewer(GraphicInterface app, int x, int y, URL path_img) {
        super(null);
        this.itsGUI = app;
        this.scroller = new JScrollPane(this);
        this.scroller.setRowHeaderView(new JLabelre(new ImageIcon(this.getClass().getResource("/icon/espiral2.gif"))));
        this.scroller.getVerticalScrollBar().addAdjustmentListener(this);
        this.initialize();
    }

    public TabulaeAppletViewer(GraphicInterface g) {
        this.itsGUI = g;
        this.scroller = new JScrollPane(this);
        this.initialize();
    }

    @Override
    public final JScrollPane getViewportBase() {
        return this.scroller;
    }

    @Override
    public JComponent getComponentBase() {
        return this.scroller;
    }

    @Override
    public final int getCount() {
        return this.theObjectList.size();
    }

    @Override
    public final GraphicObject getGraphicObject(int i) {
        return (GraphicObject)this.theObjectList.get(i);
    }

    @Override
    public final GraphicObject getGraphicObject(Integer id) {
        return (GraphicObject)this.theHashMap.get(id);
    }

    @Override
    public void insert(GraphicObject tmp) {
        int y = 0;
        int x = 0;
        if (tmp.getClassID() == 5000) {
            GraphicPoint p = (GraphicPoint)tmp;
            x = p.get_X();
            y = p.get_Y();
            p.Move(x, y);
        }
        this.ObjectAdd(tmp);
        this.theHashMap.put(tmp.getID(), tmp);
    }

    public void open(String value) {
        AEConversion ce = new AEConversion();
        this.clear();
        this.moveViewToVisible();
        boolean result = true;
        CreationManager cm = new CreationManager();
        ControlVersion CV = ControlVersion.getInstance();
        int _count = 0;
        if (ce != null) {
            result = ce.read(value);
            FileAttribute fa = ce.getFileAttribute();
            MakeElement me = CV.convert(ce.remove(), fa);
            while (me != null && result) {
                ++_count;
                List glist = cm.create(me, this.itsProxy, this, true, false);
                if (glist != null) {
                    int i = 0;
                    while (i < glist.size()) {
                        GraphicObject graphic = (GraphicObject)glist.get(i);
                        if (graphic != null) {
                            this.insert(graphic);
                            MakeElement ae = new MakeElement((State)me.getState().clone(), me.getActionID());
                            ae.setGraphicState(me.getGraphicState());
                            ae.setParents(me.getParents());
                            ae.setParameterList(me.getParameterList());
                            ae.setObjectID(graphic.getID(), MacroInspector.identifyOrder(graphic.getID(), this.itsProxy));
                            ae.setScale(this.getZoom());
                        } else {
                            result = false;
                        }
                        ++i;
                    }
                    this.updateall();
                } else {
                    result = false;
                }
                me = CV.convert(ce.remove(), fa);
            }
        } else {
            result = false;
        }
        if (!result) {
            WindowManagerApplet.getInstance().showErrorDialogApplet(this, "Este arquivo est\u00e1 corrompido\n ou n\u00e3o cont\u00e9m informa\u00e7\u00f5es para\n este sistema. ", "Erro");
        }
    }

    @Override
    public final int getSelected(int x, int y) {
        boolean hasPoint = false;
        this.theSelectedList.removeAll(this.theSelectedList);
        int i = 0;
        while (i < this.theObjectList.size()) {
            this.itsSelected = (GraphicObject)this.theObjectList.get(i);
            if (this.itsSelected.atMe(x, y)) {
                if (this.itsSelected.getClassID() == 5000) {
                    hasPoint = true;
                }
                if (hasPoint && this.itsSelected.getClassID() == 5000) {
                    this.theSelectedList.add(this.itsSelected);
                } else if (!hasPoint) {
                    this.theSelectedList.add(this.itsSelected);
                }
            } else {
                this.removeSelectedObject(this.itsSelected.getClassID());
            }
            ++i;
        }
        if (this.theSelectedList.size() == 0) {
            this.classified = 0;
            this.selectedIDtmp = null;
            this.theClassifiedObjectsList.clear();
            return -10;
        }
        if (this.theClassifiedObjectsList.equals(this.theSelectedList)) {
            this.selectedIDtmp = (GraphicObject)this.theSelectedList.get(this.classified++ % this.theSelectedList.size());
            return this.selectedIDtmp.getID();
        }
        this.classified = 0;
        this.theClassifiedObjectsList = this.theSelectedList;
        this.selectedIDtmp = (GraphicObject)this.theSelectedList.get(0);
        return this.selectedIDtmp.getID();
    }

    public final GraphicLabel getSelectedLabel(int x, int y) {
        int i = 0;
        while (i < this.theObjectList.size()) {
            this.itsSelected = (GraphicObject)this.theObjectList.get(i);
            if (this.itsSelected.getGraphicLabel().atMe(x, y)) {
                return this.itsSelected.getGraphicLabel();
            }
            ++i;
        }
        return null;
    }

    public GraphicObject getCurrentSelectedObject() {
        return this.itsSelected;
    }

    @Override
    public final List getSelectedList(int x, int y) {
        this.theSelectedList.clear();
        int i = 0;
        while (i < this.theObjectList.size()) {
            this.itsSelected = (GraphicObject)this.theObjectList.get(i);
            if (this.itsSelected.atMe(x, y)) {
                this.theSelectedList.add(new Identification(this.itsSelected.getID().intValue(), this.itsSelected.getClassID()));
                if (this.itsSelected.getClassID() == 5000) {
                    return this.theSelectedList;
                }
            }
            ++i;
        }
        return this.theSelectedList;
    }

    public final List getSelectedLabelList(int x, int y) {
        this.theSelectedList.clear();
        int i = 0;
        while (i < this.theObjectList.size()) {
            this.itsSelected = (GraphicObject)this.theObjectList.get(i);
            if (this.itsSelected.getGraphicLabel().atMe(x, y)) {
                this.theSelectedList.add(this.itsSelected.getGraphicLabel());
            }
            ++i;
        }
        return this.theSelectedList;
    }

    public final void getSelectedList(int x, int y, List lst) {
        lst.clear();
        int i = 0;
        while (i < this.theObjectList.size()) {
            this.itsSelected = (GraphicObject)this.theObjectList.get(i);
            if (this.itsSelected.atMe(x, y)) {
                lst.add(this.itsSelected.getID());
                if (this.itsSelected.getClassID() == 5000) {
                    return;
                }
            }
            ++i;
        }
    }

    public final boolean resetSelection() {
        this.selectedIDtmp = null;
        if (this.selectedID != null) {
            this.selectedID.selected(false);
            return true;
        }
        return false;
    }

    @Override
    public final void GraphicObjectUpdate(int id, State state) {
        this.itsSelected = (GraphicObject)this.theHashMap.get(new Integer(id));
        if (this.itsSelected != null) {
            this.itsSelected.setState(this, state);
        }
    }

    public final State getGraphicObjectState(int id) {
        this.itsSelected = (GraphicObject)this.theHashMap.get(new Integer(id));
        return this.itsSelected != null ? this.itsSelected.getState(this) : null;
    }

    @Override
    public final boolean ToWorld(CoorSys screen, CoorSys world) {
        if (this.zoomMode) {
            screen.itsX -= (double)this.GE.getXSource();
            screen.itsY -= (double)this.GE.getYSource();
            this.zoomMode = false;
        }
        world.itsX = ((double)(-this.GE.getXSource()) + screen.itsX) * this.GE.getZoom();
        world.itsY = ((double)this.GE.getYSource() - screen.itsY) * this.GE.getZoom();
        return world.itsX < 0.0 || world.itsY < 0.0 || world.itsX > this.worldWidth || world.itsY > this.worldHeight;
    }

    @Override
    public final boolean ToScreen(CoorSys world, CoorSys screen) {
        screen.itsX = world.itsX / this.GE.getZoom() + (double)this.GE.getXSource();
        screen.itsY = (double)this.GE.getYSource() - world.itsY / this.GE.getZoom();
        if (this.zoomMode) {
            screen.itsX += (double)this.GE.getXSource();
            screen.itsY += (double)this.GE.getYSource();
            this.zoomMode = false;
        }
        return screen.itsX < 0.0 || screen.itsY < 0.0 || screen.itsX > (double)this.scroller.getWidth() || screen.itsY > (double)this.scroller.getHeight();
    }

    @Override
    public final boolean ToScale(CoorSys screen, CoorSys world) {
        world.itsX = screen.itsX * this.GE.getZoom();
        world.itsY = -screen.itsY * this.GE.getZoom();
        return true;
    }

    @Override
    public double worldLengthToScreen(double a) {
        return a / this.scale;
    }

    @Override
    public double screenLengthToWorld(double a) {
        return a * this.scale;
    }

    @Override
    public double worldAreaToScreen(double a) {
        return a / this.scale / this.scale;
    }

    @Override
    public double screenAreaToWorld(double a) {
        return a * this.scale * this.scale;
    }

    @Override
    public double getScale() {
        return this.scale;
    }

    @Override
    public void setScale(double a) {
        this.scale = a;
    }

    @Override
    public final void selectedState(int id, boolean b) {
        this.itsSelected = (GraphicObject)this.theHashMap.get(new Integer(id));
        if (this.itsSelected != null) {
            this.itsSelected.selected(b);
        }
        if (b && this.itsSelected != null) {
            this.itsGUI.setSelected(this.itsSelected.getLabel());
        } else {
            this.itsGUI.setSelected("");
        }
        this.repaint();
    }

    @Override
    public final GraphicObject getAt(int id) {
        return (GraphicObject)this.theHashMap.get(new Integer(id));
    }

    @Override
    public int getDiagonal() {
        return (int)Math.sqrt(Math.pow(this.getWidth(), 2.0) + Math.pow(this.getHeight(), 2.0));
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.requestFocus();
        this.itsGUI.setSelected("");
        this.modifiers = e.getModifiers();
        if (this.modifiers == 16 || this.modifiers == 17) {
            this.select(e.getX(), e.getY());
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int i = 0;
        while (i < this.theObjectList.size()) {
            if (((GraphicObject)this.theObjectList.get(i)).inside(this.selectionArea)) {
                ((GraphicObject)this.theObjectList.get(i)).selected(true);
            }
            ++i;
        }
        this.moveGraphicObject(e.getX(), e.getY());
    }

    public boolean moveLabels(int x, int y) {
        if (this.labelSelected == null || this.labelObjectID == null) {
            return false;
        }
        this.getGraphicObject(new Integer(this.labelObjectID)).getGraphicLabel().translate(x, y);
        this.repaint();
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public void moveGraphicObject(int x, int y) {
        ++this.videostate;
        this.objectSet.clear();
        if (this.itsSelectedOID != -10) {
            this.screen.itsX = (double)x - this.itsPosition.itsX;
            this.screen.itsY = (double)y - this.itsPosition.itsY;
            this.itsPosition.itsX = x;
            this.itsPosition.itsY = y;
            this.ToScale(this.screen, this.world);
            if (this.isKeyPressed()) {
                if (!this.getSelectedList().contains(new Integer(this.itsSelectedOID))) {
                    return;
                }
                i = 0;
                while (i < this.HowManySelected()) {
                    try {
                        obj = this.getAt(this.getSelected(i));
                        if (obj.hasKernelState()) {
                            if (!obj.GUIonly()) {
                                if (this.itsProxy.isTranslatable(this.getSelected(i))) {
                                    this.objectSet.add(this.getSelected(i));
                                }
                            } else {
                                this.moveGUIObject(obj.getID(), (int)this.screen.itsX, (int)this.screen.itsY, false);
                                this.theUpdateSet.clear();
                                this.theUpdateSet.add(this.getSelected(i));
                            }
                        } else {
                            this.moveGUIObject(obj.getID(), (int)this.screen.itsX, (int)this.screen.itsY, false);
                        }
                    }
                    catch (Exception e) {
                        System.out.println(e + "Erro na movimentacao 2");
                    }
                    ++i;
                }
            } else {
                this.removeSelectedObjects();
                this.selectedState(this.itsSelectedOID, true);
                try {
                    obj = this.getAt(this.itsSelectedOID);
                    if (obj.hasKernelState()) {
                        if (!obj.GUIonly()) {
                            if (obj.getClassID() == 5021 || obj.getClassID() == 5086 || obj.getClassID() == 5087 || obj.getClassID() == 5022 || obj.getClassID() == 5023) {
                                l = this.itsProxy.getImediateParents(new Integer(this.itsSelectedOID));
                                this.objectSet.add(l.get(0));
                            }
                            if (!this.itsProxy.isTranslatable(obj.getID())) ** GOTO lbl58
                            this.objectSet.add(obj.getID());
                        }
                        this.moveGUIObject(obj.getID(), (int)this.screen.itsX, (int)this.screen.itsY, false);
                        this.theUpdateSet.clear();
                        this.theUpdateSet.add(new Integer(this.itsSelectedOID));
                    }
                    this.moveGUIObject(obj.getID(), (int)this.screen.itsX, (int)this.screen.itsY, false);
                }
                catch (Exception e) {
                    System.out.println(e + "Erro na movimentacao");
                }
            }
lbl58:
            // 6 sources

            this.translateSet(this.objectSet, this.world.itsX, this.world.itsY, false);
        } else {
            this.resizeSelectionArea(x, y);
        }
    }

    public void moveGUIObject(int mathID, int x, int y, boolean isRemote) {
        this.getGraphicObject(new Integer(mathID)).translate(x, y);
    }

    public void translateSet(Set objectSet, double x, double y, boolean isRemote) {
        if (objectSet.size() != 0) {
            this.world.itsX = x;
            this.world.itsY = y;
            if (isRemote) {
                ((CollaborativeKernel)this.itsProxy).translateSet(objectSet, this.world, this.theUpdateSet, true);
            } else {
                this.itsProxy.translateSet(objectSet, this.world, this.theUpdateSet);
            }
            this.update();
        } else {
            this.repaint();
        }
    }

    private void update() {
        if (this.theUpdateSet.size() != 0) {
            for (Integer id : this.theUpdateSet) {
                this.itsState = this.itsProxy.getState(id);
                this.GraphicObjectUpdate(id, this.itsState);
            }
            this.repaint();
        }
    }

    private void updateall() {
        if (this.theObjectList.size() != 0) {
            Iterator _i = this.theObjectList.iterator();
            while (_i.hasNext()) {
                Integer id = ((GraphicObject)_i.next()).getID();
                this.itsState = this.itsProxy.getState(id);
                this.GraphicObjectUpdate(id, this.itsState);
            }
            this.repaint();
        }
    }

    @Override
    public final void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.hasSelectionArea = false;
        int i = 0;
        while (i < this.theObjectList.size()) {
            if (((GraphicObject)this.theObjectList.get(i)).isSelected()) {
                this.theSelectedList.add((GraphicObject)this.theObjectList.get(i));
            }
            ++i;
        }
        this.repaint();
    }

    @Override
    public final void mouseEntered(MouseEvent e) {
        this.keyReleased(null);
    }

    @Override
    public final void mouseExited(MouseEvent e) {
        this.keyReleased(null);
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.isKeyPressed = false;
        if (e.getKeyCode() == 16) {
            this.isKeyPressed = true;
            System.out.println("teste de evento");
            return;
        }
        if (e.getKeyCode() != 27) {
            if (e.getKeyCode() == 37) {
                this.moveViewToVisible(this.GE.getXOffset() - 100, this.GE.getYOffset());
            } else if (e.getKeyCode() == 39) {
                this.moveViewToVisible(this.GE.getXOffset() + 100, this.GE.getYOffset());
            } else if (e.getKeyCode() == 38) {
                this.moveViewToVisible(this.GE.getXOffset(), this.GE.getYOffset() - 100);
            } else if (e.getKeyCode() == 40) {
                this.moveViewToVisible(this.GE.getXOffset(), this.GE.getYOffset() + 100);
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.isKeyPressed = false;
    }

    @Override
    public boolean isKeyPressed() {
        return this.isKeyPressed;
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        System.out.println("h " + this.scroller.getHorizontalScrollBar().getValue());
        System.out.println("v " + this.scroller.getVerticalScrollBar().getValue());
        this.GE.setOffset(this.scroller.getHorizontalScrollBar().getValue(), this.scroller.getVerticalScrollBar().getValue());
        ((JLabelre)this.scroller.getRowHeader().getComponent(0)).setSize(22, 10000);
        ((JLabelre)this.scroller.getRowHeader().getComponent(0)).setscroll(this.scroller.getVerticalScrollBar().getValue());
        ((JLabelre)this.scroller.getRowHeader().getComponent(0)).repaint();
        this.scroller.repaint();
    }

    @Override
    public void zoom(double x) {
        if (x == 0.0 || this.GE.getZoom() <= 0.1 && x < 1.0 || this.GE.getZoom() >= 8.0 && x > 1.0) {
            return;
        }
        double zoom_tmp = this.GE.getZoom();
        for (GraphicObject _p : this.theObjectList) {
            this.setZoomMode(true);
            State st = _p.getState(this);
            this.GE.setZoom(this.GE.getZoom() * x);
            this.worldWidth = this.GE.getZoom() * this.worldWidth;
            this.worldHeight = this.GE.getZoom() * this.worldHeight;
            this.setZoomMode(true);
            _p.setState(this, st);
            this.worldWidth /= this.GE.getZoom();
            this.worldHeight /= this.GE.getZoom();
            this.GE.setZoom(zoom_tmp);
        }
        this.GE.setZoom(this.GE.getZoom() * x);
        this.worldWidth = this.GE.getZoom() * this.worldWidth;
        this.worldHeight = this.GE.getZoom() * this.worldHeight;
        this.repaint();
    }

    @Override
    public double getZoom() {
        return this.GE.getZoom();
    }

    public void setZoom(double x) {
        this.GE.setZoom(x);
    }

    @Override
    public boolean hasZoomIn() {
        return this.GE.getZoom() > 0.1;
    }

    @Override
    public boolean hasZoomOut() {
        return this.GE.getZoom() < 8.0;
    }

    @Override
    protected void paintComponent(Graphics g) {
        this.clipping.setRect(0.0, 0.0, this.getWidth(), this.getHeight());
        ((Graphics2D)g).clip(this.clipping);
        super.paintComponent(g);
        int i = this.theObjectList.size() - 1;
        while (i >= 0) {
            GraphicObject GO = (GraphicObject)this.theObjectList.get(i);
            if (!this.theSelectedList.contains(GO)) {
                GO.selected(false);
            }
            GO.draw(g);
            --i;
        }
        if (this.hasSelectionArea) {
            g.setColor(this.SelectionColor);
            ((Graphics2D)g).setStroke(this.stroke);
            ((Graphics2D)g).draw(this.selectionArea);
        }
    }

    public void moveViewToVisible() {
        System.out.println("move...");
        this.moveViewToVisible(4700, 4700);
    }

    public void moveViewToVisible(int x, int y) {
        if (x <= 0) {
            x = 0;
        } else if (x >= this.GE.getWidth()) {
            x = this.GE.getWidth();
        }
        if (y <= 0) {
            y = 0;
        } else if (y >= this.GE.getHeight()) {
            y = this.GE.getHeight();
        }
        this.scroller.getVerticalScrollBar().setValue(4700);
        this.scroller.getHorizontalScrollBar().setValue(4700);
        this.scroller.getVerticalScrollBar().setValue(4700);
        this.scroller.getHorizontalScrollBar().setValue(4700);
        System.out.println("PQP1H" + this.scroller.getHorizontalScrollBar().getValue());
        System.out.println("PQP2V" + this.scroller.getVerticalScrollBar().getValue());
        this.GE.setOffset(x, y);
    }

    public GraphicAttribute getGraphicAttribute() {
        return this.GE.getGraphicAttribute();
    }

    public void setGraphicAttribute(GraphicAttribute g) {
        this.GE.setGraphicAttribute(g);
        this.updateViewportDimension();
        this.moveViewToVisible(this.GE.getXOffset(), this.GE.getYOffset());
        this.revalidate();
    }

    public void updateViewportDimension() {
        this.setPreferredSize(new Dimension(this.GE.getWidth(), this.GE.getHeight()));
        this.revalidate();
        this.scroller.revalidate();
    }

    private void ObjectAdd(GraphicObject o) {
        if (o != null) {
            if (this.theObjectList.isEmpty()) {
                this.theObjectList.add(o);
                return;
            }
            int i = 0;
            while (i < this.theObjectList.size()) {
                if (o.getClassID() < ((GraphicObject)this.theObjectList.get(i)).getClassID()) {
                    this.theObjectList.add(i, o);
                    return;
                }
                ++i;
            }
            this.theObjectList.add(o);
        }
    }

    @Override
    public void addSelectedObject(int id) {
        Integer Id = new Integer(id);
        if (this.selectedObjects.contains(Id)) {
            this.selectedState(id, false);
            this.selectedObjects.remove(Id);
        } else {
            this.selectedState(id, true);
            this.selectedObjects.add(Id);
        }
    }

    @Override
    public void removeSelectedObject(int id) {
        this.selectedState(id, false);
        this.selectedObjects.remove(new Integer(id));
    }

    @Override
    public void removeSelectedObjects() {
        int i = 0;
        while (i < this.selectedObjects.size()) {
            Integer id = (Integer)this.selectedObjects.get(i);
            this.selectedState(id, false);
            ++i;
        }
        this.selectedObjects.clear();
        this.keyReleased(null);
    }

    @Override
    public void SelectionArea(int x, int y, boolean b) {
        this.hasSelectionArea = b;
        this.startX = this.selectionArea.x = x;
        this.startY = this.selectionArea.y = y;
        this.selectionArea.height = 0;
        this.selectionArea.width = 0;
    }

    public Rectangle getSelectionArea() {
        if (this.selectionArea.x == 0 && this.selectionArea.y == 0 && this.selectionArea.width == 500 && this.selectionArea.height == 500 || this.selectionArea.width == 0 && this.selectionArea.height == 0) {
            return null;
        }
        return this.selectionArea;
    }

    @Override
    public void resizeSelectionArea(int endX, int endY) {
        if (endX > this.startX) {
            this.selectionArea.x = this.startX;
            this.selectionArea.width = endX - this.startX;
        } else {
            this.selectionArea.x = endX;
            this.selectionArea.width = this.startX - endX;
        }
        if (endY > this.startY) {
            this.selectionArea.y = this.startY;
            this.selectionArea.height = endY - this.startY;
        } else {
            this.selectionArea.y = endY;
            this.selectionArea.height = this.startY - endY;
        }
        this.theSelectedList.removeAll(new ArrayList());
        int j = 0;
        while (j < this.theObjectList.size()) {
            ((GraphicObject)this.theObjectList.get(j)).selected(false);
            ++j;
        }
        int i = 0;
        while (i < this.theObjectList.size()) {
            if (((GraphicObject)this.theObjectList.get(i)).inside(this.selectionArea)) {
                ((GraphicObject)this.theObjectList.get(i)).selected(true);
            }
            ++i;
        }
        this.repaint();
    }

    @Override
    public Integer getSelected(int i) {
        return (Integer)this.selectedObjects.get(i);
    }

    @Override
    public int HowManySelected() {
        return this.selectedObjects.size();
    }

    @Override
    public List getSelectedList() {
        return new ArrayList(this.selectedObjects);
    }

    public List getSelectedIDList() {
        ArrayList<Identification> list = new ArrayList<Identification>();
        for (Integer ID : this.selectedObjects) {
            GraphicObject object = null;
            if (ID != null && (object = this.getGraphicObject(ID)) != null) {
                list.add(new Identification(ID.intValue(), object.getClassID()));
                continue;
            }
            System.out.println("LIST: " + list + "\nID " + ID + "\nGO" + this.getGraphicObject(ID));
        }
        return list;
    }

    @Override
    public void SelectionObjects() {
        int i = 0;
        while (i < this.theObjectList.size()) {
            Integer Id;
            GraphicParameters GP = (GraphicParameters)this.theObjectList.get(i);
            if (GP.inside(this.selectionArea) && !this.selectedObjects.contains(Id = ((GraphicObject)GP).getID())) {
                this.selectedState(Id, true);
                this.selectedObjects.add(Id);
            }
            ++i;
        }
    }

    public void setZoomMode(boolean x) {
        this.zoomMode = x;
    }

    private void init_image() {
        IMAGE_POINT = Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource(this.itsGUI.getImagePoint()));
        IMAGE_POINT_SELECTED = GraphicUtilities.grayScale(IMAGE_POINT, false);
    }

    private void initialize() {
        this.GE = GraphicEnviroment.getInstance();
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setBackground(Color.white);
        this.scroller.getHorizontalScrollBar().addAdjustmentListener(this);
        this.scroller.getVerticalScrollBar().addAdjustmentListener(this);
        this.theHashMap = new HashMap(150, 0.75f);
        this.theSelectedList = new ArrayList();
        this.theObjectList = new ArrayList();
        this.selectedObjects = new ArrayList();
        this.theClassifiedObjectsList = new ArrayList();
        this.itsProxy = GraphicEnviroment.getInstance().getKernel();
        this.setPreferredSize(this.GE.getDimension());
        this.revalidate();
    }

    public boolean select(int x, int y) {
        this.labelSelected = this.getSelectedLabel(x, y);
        if (this.labelSelected != null) {
            GraphicObject obj = this.getCurrentSelectedObject();
            this.labelObjectID = obj.getID();
            this.itsSelectedOID = -10;
        } else {
            this.itsSelectedOID = this.getSelected(x, y);
        }
        this.itsPosition.itsX = x;
        this.itsPosition.itsY = y;
        if (this.itsSelectedOID != -10) {
            this.SelectionArea(x, y, false);
            if (this.isKeyPressed()) {
                this.addSelectedObject(this.itsSelectedOID);
            } else {
                this.selectedState(this.itsSelectedOID, true);
            }
            this.screenBuffer.itsX = x;
            this.screenBuffer.itsY = y;
            return true;
        }
        this.SelectionArea(x, y, true);
        if (!this.isKeyPressed()) {
            this.removeSelectedObjects();
        }
        return false;
    }

    public void attach(Object obsever) {
        this.Obsevers.add(obsever);
    }

    public void detach(Object observer) {
        int i = this.Obsevers.indexOf(observer);
        if (i == -1) {
            System.out.println("nao \u00e9 observador");
        } else {
            this.Obsevers.remove(i);
        }
    }

    public int getstate() {
        return this.videostate;
    }

    public void setstate(int state) {
        this.videostate = state;
    }
}

