/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.gui;

import br.ufrj.labma.enibam.graphic.GraphicLabel;
import br.ufrj.labma.enibam.graphic.GraphicObject;
import br.ufrj.labma.enibam.graphic.GraphicParameters;
import br.ufrj.labma.enibam.graphic.GraphicPoint;
import br.ufrj.labma.enibam.gui.ConversionFunctions;
import br.ufrj.labma.enibam.gui.CustomerCursor;
import br.ufrj.labma.enibam.gui.GraphicEnviroment;
import br.ufrj.labma.enibam.gui.GraphicInterface;
import br.ufrj.labma.enibam.gui.Trace;
import br.ufrj.labma.enibam.gui.ViewportInterface;
import br.ufrj.labma.enibam.gui.menu.MenuStateStore;
import br.ufrj.labma.enibam.gui.text.WindowMenuText;
import br.ufrj.labma.enibam.history.History;
import br.ufrj.labma.enibam.history.HistoryInterface;
import br.ufrj.labma.enibam.kernel.operations.CoorSys;
import br.ufrj.labma.enibam.kernel.state.State;
import br.ufrj.labma.enibam.tm.TransactionInterface;
import br.ufrj.labma.enibam.tm.TransactionManager;
import br.ufrj.labma.enibam.tm.manager.MenuUpdateManager;
import br.ufrj.labma.enibam.util.FileAttribute;
import br.ufrj.labma.enibam.util.GraphicAttribute;
import br.ufrj.labma.enibam.util.GraphicUtilities;
import br.ufrj.labma.enibam.util.Identification;
import br.ufrj.labma.enibam.video.TabulaeVideoObserver;
import br.ufrj.labma.enibam.video.VideoSubject;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;

public class Viewport
extends JPanel
implements MouseMotionListener,
MouseListener,
ViewportInterface,
KeyListener,
ComponentListener,
AdjustmentListener,
VideoSubject {
    protected GraphicEnviroment GE;
    private JScrollPane scroller;
    private JScrollBar vertical_scroll;
    private JScrollBar horizontal_scroll;
    private Image itsImage = null;
    protected TransactionInterface itsTM;
    protected GraphicInterface itsGUI;
    private GraphicObject itsSelected;
    private List theSelectedList;
    private List theObjectList;
    private List selectedObjects;
    private List theClassifiedObjectsList;
    private List simulationList;
    private Map traceMap;
    private Collection traceList;
    private int classified = 0;
    private Map theHashMap;
    private HistoryInterface itsHistory;
    private Color SelectionColor = Color.black;
    private double worldWidth;
    private double worldHeight;
    private double scale = 1.0;
    protected int modifiers = 0;
    private GraphicObject selectedID = null;
    private GraphicObject selectedIDtmp = null;
    private boolean isKeyPressed = false;
    private boolean hasSelectionArea = false;
    private boolean simulate = false;
    private boolean zoomMode = false;
    private boolean isSave = true;
    private boolean actived = false;
    private Rectangle selectionArea = new Rectangle(0, 0, 500, 500);
    private int startX;
    private int startY;
    private static Image IMAGE_POINT;
    private static Image IMAGE_POINT_SELECTED;
    private MenuUpdateManager MUM;
    public final transient float[] dash = new float[]{12.0f, 12.0f};
    private BasicStroke stroke = new BasicStroke(1.0f, 1, 2, 0.0f, this.dash, 0.0f);
    private Rectangle2D clipping = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
    private FileAttribute FA;
    private JInternalFrame parent;
    protected TabulaeVideoObserver videoRecorder = null;
    private long lastRecordCall = 0L;
    private long TIME_FRAME_TO_RECORD = 400L;

    public Viewport(GraphicInterface app, int x, int y) {
        this(app, x, y, null);
    }

    public Viewport(GraphicInterface app, int x, int y, URL path_img) {
        super(null);
        this.itsImage = path_img != null ? Toolkit.getDefaultToolkit().getImage(path_img) : null;
        this.itsGUI = app;
        this.scroller = new JScrollPane(this);
        this.scroller.setPreferredSize(new Dimension(x, y));
        this.initialize();
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.MUM = MenuUpdateManager.getInstance();
    }

    @Override
    public JScrollPane getViewportBase() {
        this.scroller.setRowHeaderView(new JLabel(new ImageIcon(WindowMenuText.VIEWPORT_ESPIRAL)));
        return this.scroller;
    }

    @Override
    public JComponent getComponentBase() {
        return this.getViewportBase();
    }

    @Override
    public final int getCount() {
        return this.theObjectList.size();
    }

    @Override
    public final GraphicObject getGraphicObject(int i) {
        return (GraphicObject)this.theObjectList.get(i);
    }

    @Override
    public final GraphicObject getGraphicObject(Integer id) {
        return (GraphicObject)this.theHashMap.get(id);
    }

    @Override
    public final void clear() {
        this.theHashMap.clear();
        this.theObjectList.clear();
        this.theSelectedList.clear();
        this.selectedObjects.clear();
        this.traceMap.clear();
        this.traceList.clear();
        this.keyReleased(null);
        this.selectedID = null;
        this.selectedIDtmp = null;
        this.GE.setZoom(1.0);
        this.theClassifiedObjectsList.clear();
        this.classified = 0;
        this.isSave = true;
        this.moveViewToVisible();
        this.itsTM.initializeUnitaryMeasure();
        this.itsHistory.removeAll();
        this.repaint();
    }

    @Override
    public void insert(GraphicObject tmp) {
        int y = 0;
        int x = 0;
        if (tmp.getClassID() == 5000) {
            GraphicPoint p = (GraphicPoint)tmp;
            p.setGraphic(IMAGE_POINT, IMAGE_POINT_SELECTED, (ImageObserver)this);
            x = p.get_X();
            y = p.get_Y();
            p.Move(x, y);
        }
        this.ObjectAdd(tmp);
        this.theHashMap.put(tmp.getID(), tmp);
        this.isSave = false;
    }

    @Override
    public final void remove(Collection list) {
        boolean clear = false;
        for (Integer id : list) {
            GraphicObject graphic = (GraphicObject)this.theHashMap.get(id);
            this.removeTrace(graphic);
            this.theHashMap.remove(id);
            this.theObjectList.remove(graphic);
            clear = true;
        }
        if (clear) {
            if (this.selectedObjects != null) {
                this.selectedObjects.clear();
            }
            if (this.theClassifiedObjectsList != null) {
                this.theClassifiedObjectsList.clear();
            }
            if (this.simulationList != null) {
                this.simulationList.clear();
            }
        }
        this.isSave = false;
    }

    @Override
    public final int getSelected(int x, int y) {
        boolean hasPoint = false;
        this.theSelectedList.removeAll(this.theSelectedList);
        int i = 0;
        while (i < this.theObjectList.size()) {
            this.itsSelected = (GraphicObject)this.theObjectList.get(i);
            if (this.itsSelected.atMe(x, y)) {
                if (this.itsSelected.getClassID() == 5000) {
                    hasPoint = true;
                }
                if (hasPoint && this.itsSelected.getClassID() == 5000) {
                    this.theSelectedList.add(this.itsSelected);
                } else if (!hasPoint) {
                    this.theSelectedList.add(this.itsSelected);
                }
            }
            ++i;
        }
        if (this.theSelectedList.size() == 0) {
            this.classified = 0;
            this.selectedIDtmp = null;
            this.theClassifiedObjectsList.clear();
            return -10;
        }
        if (this.theClassifiedObjectsList.equals(this.theSelectedList)) {
            this.selectedIDtmp = (GraphicObject)this.theSelectedList.get(this.classified++ % this.theSelectedList.size());
            return this.selectedIDtmp.getID();
        }
        this.classified = 0;
        this.theClassifiedObjectsList = this.theSelectedList;
        this.selectedIDtmp = (GraphicObject)this.theSelectedList.get(0);
        return this.selectedIDtmp.getID();
    }

    public final GraphicLabel getSelectedLabel(int x, int y) {
        int i = 0;
        while (i < this.theObjectList.size()) {
            this.itsSelected = (GraphicObject)this.theObjectList.get(i);
            if (this.itsSelected.getGraphicLabel().atMe(x, y)) {
                return this.itsSelected.getGraphicLabel();
            }
            ++i;
        }
        return null;
    }

    public GraphicObject getCurrentSelectedObject() {
        return this.itsSelected;
    }

    @Override
    public final List getSelectedList(int x, int y) {
        this.theSelectedList.clear();
        int i = 0;
        while (i < this.theObjectList.size()) {
            this.itsSelected = (GraphicObject)this.theObjectList.get(i);
            if (this.itsSelected.atMe(x, y)) {
                this.theSelectedList.add(new Identification(this.itsSelected.getID().intValue(), this.itsSelected.getClassID()));
                if (this.itsSelected.getClassID() == 5000) {
                    return this.theSelectedList;
                }
            }
            ++i;
        }
        return this.theSelectedList;
    }

    public final List getSelectedLabelList(int x, int y) {
        this.theSelectedList.clear();
        int i = 0;
        while (i < this.theObjectList.size()) {
            this.itsSelected = (GraphicObject)this.theObjectList.get(i);
            if (this.itsSelected.getGraphicLabel().atMe(x, y)) {
                this.theSelectedList.add(this.itsSelected.getGraphicLabel());
            }
            ++i;
        }
        return this.theSelectedList;
    }

    public final void getSelectedList(int x, int y, List lst) {
        lst.clear();
        int i = 0;
        while (i < this.theObjectList.size()) {
            this.itsSelected = (GraphicObject)this.theObjectList.get(i);
            if (this.itsSelected.atMe(x, y)) {
                lst.add(this.itsSelected.getID());
                if (this.itsSelected.getClassID() == 5000) {
                    return;
                }
            }
            ++i;
        }
    }

    public final boolean showSelected(int x, int y) {
        GraphicObject tmpID = this.selectedID;
        int i = 0;
        while (i < this.theObjectList.size()) {
            this.selectedID = (GraphicObject)this.theObjectList.get(i);
            if (this.selectedID.atMe(x, y)) {
                if (tmpID != null) {
                    tmpID.selected(false);
                }
                this.selectedID.selected(true);
                return true;
            }
            ++i;
        }
        if (tmpID != null) {
            tmpID.selected(false);
        }
        return false;
    }

    public final boolean resetSelection() {
        this.selectedIDtmp = null;
        if (this.selectedID != null) {
            this.selectedID.selected(false);
            return true;
        }
        return false;
    }

    @Override
    public final void GraphicObjectUpdate(int id, State state) {
        this.itsSelected = (GraphicObject)this.theHashMap.get(new Integer(id));
        if (this.itsSelected != null) {
            this.itsSelected.setState(this, state);
            Trace trace = (Trace)this.traceMap.get(this.itsSelected);
            if (trace != null) {
                trace.add(state);
            }
        }
        this.isSave = false;
    }

    @Override
    public final boolean ToWorld(CoorSys screen, CoorSys world) {
        if (this.zoomMode) {
            screen.itsX -= (double)this.GE.getXSource();
            screen.itsY -= (double)this.GE.getYSource();
            this.zoomMode = false;
        }
        world.itsX = ((double)(-this.GE.getXSource()) + screen.itsX) * this.GE.getZoom();
        world.itsY = ((double)this.GE.getYSource() - screen.itsY) * this.GE.getZoom();
        return world.itsX < 0.0 || world.itsY < 0.0 || world.itsX > this.worldWidth || world.itsY > this.worldHeight;
    }

    public Component getParents() {
        return (Component)((Object)this.getGUI());
    }

    public GraphicInterface getGUI() {
        return this.itsGUI;
    }

    @Override
    public TransactionInterface getTM() {
        return this.itsTM;
    }

    @Override
    public final boolean ToScreen(CoorSys world, CoorSys screen) {
        screen.itsX = world.itsX / this.GE.getZoom() + (double)this.GE.getXSource();
        screen.itsY = (double)this.GE.getYSource() - world.itsY / this.GE.getZoom();
        if (this.zoomMode) {
            screen.itsX += (double)this.GE.getXSource();
            screen.itsY += (double)this.GE.getYSource();
            this.zoomMode = false;
        }
        return screen.itsX < 0.0 || screen.itsY < 0.0 || screen.itsX > (double)this.scroller.getWidth() || screen.itsY > (double)this.scroller.getHeight();
    }

    @Override
    public final boolean ToScale(CoorSys screen, CoorSys world) {
        world.itsX = screen.itsX * this.GE.getZoom();
        world.itsY = -screen.itsY * this.GE.getZoom();
        return true;
    }

    @Override
    public double worldLengthToScreen(double a) {
        return a / this.scale;
    }

    @Override
    public double screenLengthToWorld(double a) {
        return a * this.scale;
    }

    @Override
    public double worldAreaToScreen(double a) {
        return a / this.scale / this.scale;
    }

    @Override
    public double screenAreaToWorld(double a) {
        return a * this.scale * this.scale;
    }

    @Override
    public double getScale() {
        return this.scale;
    }

    @Override
    public void setScale(double a) {
        this.scale = a;
    }

    @Override
    public final void selectedState(int id, boolean b) {
        this.itsSelected = (GraphicObject)this.theHashMap.get(new Integer(id));
        if (this.itsSelected != null) {
            this.itsSelected.selected(b);
        }
        if (b && this.itsSelected != null) {
            this.itsGUI.setSelected(this.itsSelected.getLabel());
        } else {
            this.itsGUI.setSelected("");
        }
        this.isSave = false;
        this.repaint();
    }

    @Override
    public final GraphicObject getAt(int id) {
        return (GraphicObject)this.theHashMap.get(new Integer(id));
    }

    @Override
    public int getDiagonal() {
        return (int)Math.sqrt(Math.pow(this.getWidth(), 2.0) + Math.pow(this.getHeight(), 2.0));
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.requestFocus();
        this.itsGUI.setSelected("");
        int i = 0;
        while (i < this.theObjectList.size()) {
            GraphicObject GO = (GraphicObject)this.theObjectList.get(i);
            if (GO.decoratorOverMe(e.getX(), e.getY()) && GO.getClassID() == 5000) break;
            ++i;
        }
        if (!this.isActived()) {
            this.setActived(true);
            return;
        }
        this.modifiers = e.getModifiers();
        if (this.modifiers == 16 || this.modifiers == 17) {
            this.itsTM.select(e.getX(), e.getY());
            this.itsTM.create(e.getX(), e.getY());
        } else if (this.modifiers == 4) {
            this.itsTM.reopenTransaction();
        }
        this.itsTM.verifyConvertionTypes();
        this.record();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        boolean off = false;
        int i = 0;
        while (i < this.theObjectList.size()) {
            GraphicObject GO = (GraphicObject)this.theObjectList.get(i);
            if (!off) {
                if (GO.decoratorOverMe(e.getX(), e.getY()) && GO.getClassID() == 5000) {
                    off = true;
                }
            } else {
                GO.setDecoratorOverMeStatus(false);
            }
            ++i;
        }
        if (!this.isActived()) {
            return;
        }
        this.itsTM.simulate(e.getX(), e.getY());
        if (Calendar.getInstance().getTime().getTime() - this.lastRecordCall > this.TIME_FRAME_TO_RECORD) {
            this.lastRecordCall = Calendar.getInstance().getTime().getTime();
            this.record();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this.isActived()) {
            return;
        }
        if (this.itsTM.moveLabels(e.getX(), e.getY())) {
            return;
        }
        this.itsTM.move(e.getX(), e.getY());
        this.itsTM.simulate(e.getX(), e.getY());
        if (Calendar.getInstance().getTime().getTime() - this.lastRecordCall > this.TIME_FRAME_TO_RECORD) {
            this.lastRecordCall = Calendar.getInstance().getTime().getTime();
            this.record();
        }
    }

    @Override
    public final void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        GraphicObject GO;
        boolean off = false;
        int i = 0;
        while (i < this.theObjectList.size()) {
            GraphicObject GO2 = (GraphicObject)this.theObjectList.get(i);
            if (!off) {
                if (GO2.decoratorOverMe(e.getX(), e.getY()) && GO2.getClassID() == 5000) {
                    off = true;
                }
            } else {
                GO2.setDecoratorOverMeStatus(false);
            }
            ++i;
        }
        this.record();
        if (!this.isActived()) {
            return;
        }
        int x = e.getX();
        int y = e.getY();
        this.itsTM.setMousePosition(x, y);
        this.itsTM.execute(25, null, true);
        MenuStateStore.getInstance().CreateByName("Calcular").setValue((Object)"Unidade de refer\u00eancia", false);
        if (this.HowManySelected() == 1 && (GO = this.getGraphicObject(this.getSelected(0))) != null && GO.getClassID() == 5010) {
            MenuStateStore.getInstance().CreateByName("Calcular").setValue((Object)"Unidade de refer\u00eancia", true);
        }
        this.itsTM.verifyConvertionTypes();
    }

    @Override
    public final void mouseEntered(MouseEvent e) {
        this.setCursor(this.itsTM.getCursor());
        this.requestFocus();
        this.repaint();
        this.keyReleased(null);
    }

    @Override
    public final void mouseExited(MouseEvent e) {
        this.setCursor(CustomerCursor.getDefaultCursor());
        this.keyReleased(null);
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.isKeyPressed = false;
        if (e.getKeyCode() == 16) {
            this.isKeyPressed = true;
            return;
        }
        if (e.getKeyCode() == 27) {
            this.itsTM.reopenTransaction();
        } else if (e.getKeyCode() == 37) {
            this.moveViewToVisible(this.GE.getXOffset() - 100, this.GE.getYOffset());
        } else if (e.getKeyCode() == 39) {
            this.moveViewToVisible(this.GE.getXOffset() + 100, this.GE.getYOffset());
        } else if (e.getKeyCode() == 38) {
            this.moveViewToVisible(this.GE.getXOffset(), this.GE.getYOffset() - 100);
        } else if (e.getKeyCode() == 40) {
            this.moveViewToVisible(this.GE.getXOffset(), this.GE.getYOffset() + 100);
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.isKeyPressed = false;
        this.setCursor(this.itsTM.getCursor());
    }

    @Override
    public boolean isKeyPressed() {
        return this.isKeyPressed;
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.GE.setOffset(this.horizontal_scroll.getValue(), this.vertical_scroll.getValue());
    }

    @Override
    public void zoom(double x) {
        if (x == 0.0 || this.GE.getZoom() <= 0.1 && x < 1.0 || this.GE.getZoom() >= 8.0 && x > 1.0) {
            return;
        }
        double zoom_tmp = this.GE.getZoom();
        for (GraphicObject _p : this.theObjectList) {
            this.setZoomMode(true);
            State st = _p.getState(this);
            this.GE.setZoom(this.GE.getZoom() * x);
            this.worldWidth = this.GE.getZoom() * this.worldWidth;
            this.worldHeight = this.GE.getZoom() * this.worldHeight;
            this.setZoomMode(true);
            _p.setState(this, st);
            this.worldWidth /= this.GE.getZoom();
            this.worldHeight /= this.GE.getZoom();
            this.GE.setZoom(zoom_tmp);
        }
        this.GE.setZoom(this.GE.getZoom() * x);
        this.worldWidth = this.GE.getZoom() * this.worldWidth;
        this.worldHeight = this.GE.getZoom() * this.worldHeight;
        this.itsTM.disturbAndValidate(0, 0);
        this.repaint();
        this.isSave = false;
    }

    @Override
    public double getZoom() {
        return this.GE.getZoom();
    }

    public void setZoom(double x) {
        this.GE.setZoom(x);
    }

    @Override
    public boolean hasZoomIn() {
        return this.GE.getZoom() > 0.1;
    }

    @Override
    public boolean hasZoomOut() {
        return this.GE.getZoom() < 8.0;
    }

    @Override
    protected void paintComponent(Graphics g) {
        this.clipping.setRect(0.0, 0.0, this.getWidth(), this.getHeight());
        ((Graphics2D)g).clip(this.clipping);
        super.paintComponent(g);
        if (this.simulate) {
            this.printSimulation(g);
        }
        boolean b = true;
        if (this.traceList.size() > 0) {
            Iterator i = this.traceList.iterator();
            while (i.hasNext()) {
                ((Trace)i.next()).drawTrace(g, (ConversionFunctions)this);
            }
        }
        int i = this.theObjectList.size() - 1;
        while (i >= 0) {
            GraphicObject GO = (GraphicObject)this.theObjectList.get(i);
            if (this.selectedIDtmp != null && b && GO.getClassID() == 5000) {
                this.selectedIDtmp.draw(g);
                b = false;
            }
            GO.draw(g);
            --i;
        }
        if (this.hasSelectionArea) {
            g.setColor(this.SelectionColor);
            ((Graphics2D)g).setStroke(this.stroke);
            ((Graphics2D)g).draw(this.selectionArea);
        }
    }

    public void moveViewToVisible() {
        this.moveViewToVisible(4700, 4700);
    }

    public void moveViewToVisible(int x, int y) {
        if (x <= 0) {
            x = 0;
        } else if (x >= this.GE.getWidth()) {
            x = this.GE.getWidth();
        }
        if (y <= 0) {
            y = 0;
        } else if (y >= this.GE.getHeight()) {
            y = this.GE.getHeight();
        }
        this.vertical_scroll.setValue(y);
        this.horizontal_scroll.setValue(x);
        this.GE.setOffset(this.horizontal_scroll.getValue(), this.vertical_scroll.getValue());
    }

    public FileAttribute getFileAttribute() {
        this.FA = this.FA != null ? new FileAttribute(this.FA) : new FileAttribute();
        return this.FA;
    }

    public void setFileAttribute(FileAttribute f) {
        this.FA = f;
    }

    public GraphicAttribute getGraphicAttribute() {
        return this.GE.getGraphicAttribute();
    }

    public void setGraphicAttribute(GraphicAttribute g) {
        this.GE.setGraphicAttribute(g);
        this.updateViewportDimension();
        this.moveViewToVisible(this.GE.getXOffset(), this.GE.getYOffset());
        this.revalidate();
    }

    public void updateViewportDimension() {
        this.setPreferredSize(new Dimension(this.GE.getWidth(), this.GE.getHeight()));
        this.revalidate();
        this.scroller.revalidate();
    }

    private void ObjectAdd(GraphicObject o) {
        if (o != null) {
            this.isSave = false;
            if (this.theObjectList.isEmpty()) {
                this.theObjectList.add(o);
                return;
            }
            int i = 0;
            while (i < this.theObjectList.size()) {
                if (o.getClassID() < ((GraphicObject)this.theObjectList.get(i)).getClassID()) {
                    this.theObjectList.add(i, o);
                    return;
                }
                ++i;
            }
            this.theObjectList.add(o);
        }
    }

    @Override
    public String toString() {
        return this.getTitle();
    }

    @Override
    public void addSelectedObject(int id) {
        Integer Id = new Integer(id);
        if (this.selectedObjects.contains(Id)) {
            this.selectedState(id, false);
            this.selectedObjects.remove(Id);
        } else {
            this.selectedState(id, true);
            this.selectedObjects.add(Id);
        }
    }

    @Override
    public void removeSelectedObject(int id) {
        this.selectedState(id, false);
        this.selectedObjects.remove(new Integer(id));
    }

    @Override
    public void removeSelectedObjects() {
        int i = 0;
        while (i < this.selectedObjects.size()) {
            Integer id = (Integer)this.selectedObjects.get(i);
            this.selectedState(id, false);
            ++i;
        }
        this.selectedObjects.clear();
        this.keyReleased(null);
    }

    @Override
    public void SelectionArea(int x, int y, boolean b) {
        this.hasSelectionArea = b;
        this.startX = this.selectionArea.x = x;
        this.startY = this.selectionArea.y = y;
        this.selectionArea.height = 0;
        this.selectionArea.width = 0;
    }

    public Rectangle getSelectionArea() {
        if (this.selectionArea.x == 0 && this.selectionArea.y == 0 && this.selectionArea.width == 500 && this.selectionArea.height == 500 || this.selectionArea.width == 0 && this.selectionArea.height == 0) {
            return null;
        }
        return this.selectionArea;
    }

    @Override
    public void resizeSelectionArea(int endX, int endY) {
        if (endX > this.startX) {
            this.selectionArea.x = this.startX;
            this.selectionArea.width = endX - this.startX;
        } else {
            this.selectionArea.x = endX;
            this.selectionArea.width = this.startX - endX;
        }
        if (endY > this.startY) {
            this.selectionArea.y = this.startY;
            this.selectionArea.height = endY - this.startY;
        } else {
            this.selectionArea.y = endY;
            this.selectionArea.height = this.startY - endY;
        }
        this.repaint();
    }

    @Override
    public Integer getSelected(int i) {
        return (Integer)this.selectedObjects.get(i);
    }

    @Override
    public int HowManySelected() {
        return this.selectedObjects.size();
    }

    @Override
    public List getSelectedList() {
        return new ArrayList(this.selectedObjects);
    }

    public List getSelectedIDList() {
        ArrayList<Identification> list = new ArrayList<Identification>();
        for (Integer ID : this.selectedObjects) {
            GraphicObject object = null;
            if (ID != null && (object = this.getGraphicObject(ID)) != null) {
                list.add(new Identification(ID.intValue(), object.getClassID()));
                continue;
            }
            System.out.println("LIST: " + list + "\nID " + ID + "\nGO" + this.getGraphicObject(ID));
        }
        return list;
    }

    @Override
    public void SelectionObjects() {
        int i = 0;
        while (i < this.theObjectList.size()) {
            Integer Id;
            GraphicParameters GP = (GraphicParameters)this.theObjectList.get(i);
            if (GP.inside(this.selectionArea) && !this.selectedObjects.contains(Id = ((GraphicObject)GP).getID())) {
                this.selectedState(Id, true);
                this.selectedObjects.add(Id);
            }
            ++i;
        }
    }

    public void setSimulate(boolean x) {
        this.simulate = x;
    }

    public void setSimulationList(List simulation) {
        this.simulationList = simulation;
    }

    @Override
    public boolean isSave() {
        return this.isSave;
    }

    public void setSave(boolean b) {
        this.isSave = b;
    }

    private void printSimulation(Graphics g) {
        if (this.simulationList != null) {
            int i = 0;
            while (i < this.simulationList.size()) {
                ((GraphicObject)this.simulationList.get(i)).draw(g);
                ++i;
            }
        }
    }

    public void setZoomMode(boolean x) {
        this.zoomMode = x;
    }

    private void init_image() {
        IMAGE_POINT = Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource(this.itsGUI.getImagePoint()));
        IMAGE_POINT_SELECTED = GraphicUtilities.grayScale(IMAGE_POINT, false);
    }

    protected void initVariables() {
        this.GE = GraphicEnviroment.getInstance();
        this.theHashMap = new HashMap(150, 0.75f);
        this.itsHistory = new History((ViewportInterface)this);
        this.theSelectedList = new ArrayList();
        this.theObjectList = new ArrayList();
        this.selectedObjects = new ArrayList();
        this.traceList = new ArrayList();
        this.traceMap = new HashMap();
        this.theClassifiedObjectsList = new ArrayList();
        this.scroller.addComponentListener(this);
        this.horizontal_scroll = this.scroller.getHorizontalScrollBar();
        this.horizontal_scroll.addAdjustmentListener(this);
        this.vertical_scroll = this.scroller.getVerticalScrollBar();
        this.vertical_scroll.addAdjustmentListener(this);
        this.setPreferredSize(this.GE.getDimension());
        this.revalidate();
    }

    protected void initialize() {
        this.initVariables();
        this.itsTM = new TransactionManager(this, false);
        this.scroller.setBorder(BorderFactory.createLineBorder(this.itsGUI.getBorderColor(), 0));
        this.init_image();
        this.setCursor(this.itsTM.getCursor());
        this.itsTM.initializeUnitaryMeasure();
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.worldWidth = this.GE.getZoom() * (double)this.scroller.getWidth();
        this.worldHeight = this.GE.getZoom() * (double)this.scroller.getHeight();
        this.itsTM.disturb(0, 0);
    }

    public Point getNewFixedObjectLocation(int px, int py) {
        if (this.theObjectList != null && this.theObjectList.size() > 0) {
            int i = 0;
            while (i < this.theObjectList.size()) {
                if (((GraphicObject)this.theObjectList.get(i)).atMe(px + 10, py - 10)) {
                    return null;
                }
                ++i;
            }
        }
        return new Point(px, py);
    }

    @Override
    public void componentMoved(ComponentEvent e) {
        this.worldWidth = this.GE.getZoom() * (double)this.scroller.getWidth();
        this.worldHeight = this.GE.getZoom() * (double)this.scroller.getHeight();
        this.itsTM.disturb(0, 0);
    }

    @Override
    public void componentShown(ComponentEvent e) {
        this.worldWidth = this.GE.getZoom() * (double)this.scroller.getWidth();
        this.worldHeight = this.GE.getZoom() * (double)this.scroller.getHeight();
        this.itsTM.disturb(0, 0);
    }

    @Override
    public void componentHidden(ComponentEvent e) {
        this.worldWidth = this.GE.getZoom() * (double)this.scroller.getWidth();
        this.worldHeight = this.GE.getZoom() * (double)this.scroller.getHeight();
        this.itsTM.disturb(0, 0);
    }

    public void addTrace(GraphicObject o) {
        if (this.traceMap.containsKey(o)) {
            this.removeTrace(o);
            return;
        }
        this.traceMap.put(o, new Trace(o));
        this.traceList = this.traceMap.values();
    }

    private void removeTrace(GraphicObject o) {
        this.traceMap.remove(o);
        this.traceList = this.traceMap.values();
    }

    public void setTitle(String name) {
        if (this.parent != null) {
            this.parent.setTitle(name);
        }
    }

    public String getTitle() {
        return this.parent != null ? this.parent.getTitle() : null;
    }

    @Override
    public HistoryInterface getHistory() {
        return this.itsHistory;
    }

    public void setParentFrame(JInternalFrame frame) {
        this.parent = frame;
    }

    public JInternalFrame getParentFrame() {
        return this.parent;
    }

    @Override
    public void attach(TabulaeVideoObserver observer) {
        this.detach(this.videoRecorder);
        if (observer != null) {
            this.videoRecorder = observer;
            this.videoRecorder.start();
        }
    }

    @Override
    public void detach(TabulaeVideoObserver observer) {
        if (observer != null) {
            observer.finish();
        }
        if (this.videoRecorder != null) {
            this.videoRecorder.finish();
        }
        this.videoRecorder = null;
    }

    @Override
    public void record() {
        if (this.videoRecorder != null) {
            this.videoRecorder.recordTempImage(this.scroller, this.scroller.getWidth(), this.scroller.getHeight());
        }
    }

    @Override
    public TabulaeVideoObserver getAttachment() {
        return this.videoRecorder;
    }

    public boolean isActived() {
        return this.actived;
    }

    public void setActived(boolean actived) {
        this.actived = actived;
    }
}

