/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.history;

import br.ufrj.labma.enibam.graphic.GraphicState;
import br.ufrj.labma.enibam.history.AbstractConversion;
import br.ufrj.labma.enibam.history.ae.MakeElement;
import br.ufrj.labma.enibam.kernel.ConstructionIDMap;
import br.ufrj.labma.enibam.kernel.exception.ConstructionNotFoundException;
import br.ufrj.labma.enibam.kernel.expression.ConstantOperand;
import br.ufrj.labma.enibam.kernel.expression.ExpressionNode;
import br.ufrj.labma.enibam.kernel.expression.KernelOperand;
import br.ufrj.labma.enibam.kernel.expression.Operator;
import br.ufrj.labma.enibam.kernel.expression.Syntactic;
import br.ufrj.labma.enibam.kernel.state.State;
import br.ufrj.labma.enibam.tm.manager.StateManager;
import br.ufrj.labma.enibam.tm.manager.StateManagerException;
import br.ufrj.labma.enibam.util.FileAttribute;
import br.ufrj.labma.enibam.util.GraphicAttribute;
import br.xdev.framework.logging.Logger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class AEConversion
extends AbstractConversion {
    private String itsPath;

    public AEConversion() {
        this.itsStore = new ArrayList();
    }

    public AEConversion(String path) {
        this.itsStore = new ArrayList();
        this.itsPath = path;
    }

    public OutputStream getOutputStream() {
        ByteArrayOutputStream out;
        block14: {
            out = new ByteArrayOutputStream();
            if (this.write(out)) break block14;
            try {
                out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }
        try {
            try {
                out.flush();
            }
            catch (IOException e) {
                Logger.debug((Object)e.getMessage(), (Throwable)e);
                try {
                    out.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return null;
            }
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
        return out;
    }

    @Override
    public boolean write() {
        File _outFile = new File(this.itsPath);
        FileWriter _out = null;
        try {
            _out = new FileWriter(_outFile);
            OutputStream bytes = this.getOutputStream();
            if (bytes != null) {
                _out.write(bytes.toString());
                return true;
            }
            return false;
        }
        catch (IOException e) {
            Logger.debug((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        finally {
            try {
                if (_out != null) {
                    _out.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean write(OutputStream _out) {
        StateManager _sManager = StateManager.getInstance();
        try {
            _out.write("<?xml version='1.0' encoding='ISO-8859-1'?>\n\n<!-- Tabulae - Geometrical Construction -->\n\n".getBytes());
            _out.write("<construction>\n\n <head>\n ".getBytes());
            this.writeFileAttribute(_out);
            this.writeGraphicAttribute(_out);
            _out.write("\n</head>\n<body>\n\n".getBytes());
            int _length = this.itsStore.size();
            int _i = 0;
            block8: while (true) {
                int _j;
                int _numTags;
                String _type;
                if (_i >= _length) {
                    _out.write("   </body>\n\n</construction>".getBytes());
                    return true;
                }
                MakeElement _me = (MakeElement)this.itsStore.get(_i);
                try {
                    _type = ConstructionIDMap.parseString(_me.getActionID());
                }
                catch (ConstructionNotFoundException _e) {
                    return false;
                }
                String _id = String.valueOf(_me.getObjectID());
                String joker = _me.isJokerElement() ? " joker=\"" + _me.isJokerElement() + "\" " : "";
                String output = _me.isOutput() ? " output=\"" + _me.isOutput() + "\" " : "";
                int order = _me.getOrder();
                String param_order = "";
                if (order >= 0) {
                    param_order = "order=\"" + order + "\"";
                }
                _out.write(("   <object ID=\"" + _id + "\" type=\"" + _type + "\" " + param_order + " " + joker + " " + output + ">\n").getBytes());
                try {
                    Map _defMap = _sManager.createMap(_me.getActionID(), _me.getState());
                    _numTags = _defMap.size();
                    Object[] _defMapTypes = _defMap.keySet().toArray();
                    _j = 0;
                    while (_j < _numTags) {
                        _out.write(("      <state type=\"" + _defMapTypes[_j] + "\" value=\"" + this.encode(_defMap.get(_defMapTypes[_j]).toString()) + "\"/>\n").getBytes());
                        ++_j;
                    }
                }
                catch (StateManagerException ex) {
                    return false;
                }
                List _parList = _me.getParents();
                _numTags = _parList.size();
                _j = 0;
                while (true) {
                    if (_j >= _numTags) {
                        try {
                            Map _attMap = _sManager.createMap(_me.getActionID(), _me.getGraphicState());
                            _numTags = _attMap.size();
                            Object[] _attMapTypes = _attMap.keySet().toArray();
                            _j = 0;
                            while (_j < _numTags) {
                                _out.write(("      <attribute type=\"" + _attMapTypes[_j] + "\" value=\"" + this.encode(_attMap.get(_attMapTypes[_j]).toString()) + "\"/>\n").getBytes());
                                ++_j;
                            }
                            break;
                        }
                        catch (StateManagerException ex) {
                            return false;
                        }
                    }
                    _out.write(("      <parent value=\"" + String.valueOf(_parList.get(_j)) + "\"/>\n").getBytes());
                    ++_j;
                }
                List parametersList = _me.getParameterList();
                _numTags = parametersList.size();
                int _j2 = 0;
                while (true) {
                    if (_j2 >= _numTags) {
                        _out.write("   </object>\n\n".getBytes());
                        ++_i;
                        continue block8;
                    }
                    Object obj = parametersList.get(_j2);
                    if (obj instanceof Operator) {
                        _out.write(("      <expression  type=\"operator\" value=\"" + ((Operator)obj).getDescription() + "\" /> \n").getBytes());
                    } else if (obj instanceof ConstantOperand) {
                        _out.write(("      <expression type=\"constant\" value=\"" + ((ConstantOperand)obj).getValue() + "\" /> \n").getBytes());
                    } else if (obj instanceof KernelOperand) {
                        _out.write(("      <expression type=\"operand\" value=\"" + ((KernelOperand)obj).getMID() + "\" /> \n").getBytes());
                    } else if (obj instanceof String) {
                        _out.write(("      <parameter string=\"" + this.encode(obj.toString()) + "\"/>\n").getBytes());
                    } else {
                        _out.write(("      <parameter value=\"" + this.encode(String.valueOf(obj)) + "\"/> \n").getBytes());
                    }
                    ++_j2;
                }
                break;
            }
        }
        catch (IOException _e) {
            return false;
        }
    }

    public String decode(String h) {
        try {
            return URLDecoder.decode(h, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public String encode(String h) {
        try {
            return URLEncoder.encode(h, "UTF-8");
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public boolean read() {
        MakeElement _me = null;
        Document _doc = this.parse(new File(this.itsPath));
        if (_doc == null) {
            return false;
        }
        if (!this.readHeader(_doc)) {
            return false;
        }
        NodeList _objectList = _doc.getElementsByTagName("object");
        int _length = _objectList.getLength();
        int _i = 0;
        while (_i < _length) {
            _me = this.convertToMakeElement((Element)_objectList.item(_i));
            if (_me == null) {
                return false;
            }
            this.itsStore.add(_me);
            ++_i;
        }
        return true;
    }

    public boolean read(String value) {
        MakeElement _me = null;
        Document _doc = this.parse(value);
        if (_doc == null) {
            return false;
        }
        if (!this.readHeader(_doc)) {
            return false;
        }
        NodeList _objectList = _doc.getElementsByTagName("object");
        int _length = _objectList.getLength();
        int _i = 0;
        while (_i < _length) {
            _me = this.convertToMakeElement((Element)_objectList.item(_i));
            if (_me == null) {
                return false;
            }
            this.itsStore.add(_me);
            ++_i;
        }
        return true;
    }

    private Document parse(String value) {
        Document _document;
        DocumentBuilderFactory _factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder _builder = _factory.newDocumentBuilder();
            _document = _builder.parse(new ByteArrayInputStream(value.getBytes()));
        }
        catch (Exception spe) {
            System.out.println(spe + "XmlConversion - 230");
            return null;
        }
        return _document;
    }

    private Document parse(File _f) {
        Document _document;
        DocumentBuilderFactory _factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder _builder = _factory.newDocumentBuilder();
            _document = _builder.parse(_f);
        }
        catch (SAXParseException spe) {
            System.out.println(spe + "XmlConversion - 230");
            return null;
        }
        catch (SAXException sxe) {
            System.out.println(sxe + "XmlConversion - 238");
            return null;
        }
        catch (ParserConfigurationException pce) {
            System.out.println(pce + "XmlConversion - 243");
            return null;
        }
        catch (IOException ioe) {
            System.out.println(ioe + "XmlConversion - 253");
            return null;
        }
        return _document;
    }

    private MakeElement convertToMakeElement(Element _e) {
        Element _att;
        int _cid;
        int _id;
        MakeElement _me = null;
        boolean _joker = false;
        boolean _output = false;
        int _order = -1;
        try {
            _id = Integer.parseInt(_e.getAttribute("ID"));
        }
        catch (NumberFormatException _exc) {
            return null;
        }
        try {
            _cid = ConstructionIDMap.parseInt(_e.getAttribute("type"));
        }
        catch (ConstructionNotFoundException _exc) {
            return null;
        }
        try {
            String joker = _e.getAttribute("joker");
            _joker = joker != null && joker.trim().equals("true");
        }
        catch (Exception e) {
            _joker = false;
        }
        try {
            String order = _e.getAttribute("order");
            _order = Integer.parseInt(order);
        }
        catch (Exception e) {
            _order = -1;
        }
        try {
            String output = _e.getAttribute("output");
            _output = output != null && output.trim().equals("true");
        }
        catch (Exception e) {
            _output = false;
        }
        StateManager _sManager = StateManager.getInstance();
        HashMap<String, Object> _defMap = new HashMap<String, Object>();
        NodeList _definitionList = _e.getElementsByTagName("state");
        int _length = _definitionList.getLength();
        int _i = 0;
        while (_i < _length) {
            _att = (Element)_definitionList.item(_i);
            try {
                double _value = Double.parseDouble(_att.getAttribute("value"));
                _defMap.put(_att.getAttribute("type").toUpperCase(), new Double(_value));
            }
            catch (NumberFormatException _exc) {
                String s_value = _att.getAttribute("value");
                if (s_value != null) {
                    _defMap.put(_att.getAttribute("type").toUpperCase(), this.decode(s_value));
                }
                return null;
            }
            ++_i;
        }
        try {
            State _s = _sManager.createState(_cid, _defMap);
            _me = new MakeElement(_s, _cid);
            _me.setObjectID(_id, _order);
            _me.setJokerElement(_joker);
            _me.setOutput(_output);
        }
        catch (StateManagerException ex) {
            return null;
        }
        HashMap<String, String> _attMap = new HashMap<String, String>();
        NodeList _attributeList = _e.getElementsByTagName("attribute");
        _length = _attributeList.getLength();
        _i = 0;
        while (_i < _length) {
            _att = (Element)_attributeList.item(_i);
            _attMap.put(_att.getAttribute("type").toUpperCase(), this.decode(_att.getAttribute("value")));
            ++_i;
        }
        try {
            GraphicState _gs = _sManager.createGraphicState(_cid, _attMap);
            _me.setGraphicState(_gs);
        }
        catch (StateManagerException ex) {
            return null;
        }
        ArrayList<Integer> _parents = new ArrayList<Integer>();
        NodeList _parentList = _e.getElementsByTagName("parent");
        _length = _parentList.getLength();
        _i = 0;
        while (_i < _length) {
            int _val;
            _att = (Element)_parentList.item(_i);
            try {
                _val = Integer.parseInt(_att.getAttribute("value"));
            }
            catch (NumberFormatException _exc) {
                return null;
            }
            _parents.add(new Integer(_val));
            ++_i;
        }
        _me.setParents(_parents);
        ArrayList<Object> parameters = new ArrayList<Object>();
        NodeList parametersList = _e.getElementsByTagName("parameter");
        int length = parametersList.getLength();
        int i = 0;
        while (i < length) {
            _att = (Element)parametersList.item(i);
            try {
                String obj1 = this.decode(_att.getAttribute("value"));
                String obj2 = this.decode(_att.getAttribute("string"));
                if (!obj2.equals("")) {
                    parameters.add(obj2);
                } else if (!obj1.equals("")) {
                    if (obj1.indexOf(46) != -1) {
                        parameters.add(new Double(obj1));
                    } else {
                        int value = Integer.parseInt(obj1);
                        parameters.add(new Integer(value));
                    }
                }
            }
            catch (NumberFormatException _exc) {
                return null;
            }
            ++i;
        }
        parametersList = _e.getElementsByTagName("expression");
        length = parametersList.getLength();
        i = 0;
        while (i < length) {
            block34: {
                _att = (Element)parametersList.item(i);
                try {
                    String value1 = _att.getAttribute("value");
                    String type1 = _att.getAttribute("type");
                    ExpressionNode enode = parameters.size() > 0 ? (ExpressionNode)parameters.get(parameters.size() - 1) : null;
                    ExpressionNode obj = Syntactic.generateNode(enode, type1, value1);
                    if (obj != null) {
                        parameters.add(obj);
                        break block34;
                    }
                    return null;
                }
                catch (Exception _exc) {
                    return null;
                }
            }
            ++i;
        }
        _me.setParameterList(parameters);
        return _me;
    }

    private void writeGraphicAttribute(OutputStream out) throws IOException {
        if (this.GA == null) {
            this.GA = new GraphicAttribute();
        }
        out.write(("\n<enviroment width=\"" + this.GA.getWidth() + "\" height=\"" + this.GA.getHeight() + "\" xoffset=\"" + this.GA.getXOffset() + "\" yoffset=\"" + this.GA.getYOffset() + "\" xsource=\"" + this.GA.getYSource() + "\" ysource=\"" + this.GA.getYSource() + "\" zoom=\"" + this.GA.getZoom() + "\" />").getBytes());
        out.write(("\n<system os-name=\"" + this.encode(System.getProperty("os.name")) + "\" os-arch=\"" + this.encode(System.getProperty("os.arch")) + "\" os-version=\"" + this.encode(System.getProperty("os.version")) + "\" java-version=\"" + this.encode(System.getProperty("java.version")) + "\" />").getBytes());
    }

    private void writeFileAttribute(OutputStream out) throws IOException {
        if (this.FA == null) {
            this.FA = new FileAttribute();
        }
        out.write(("\n<file version=\"" + this.FA.getVersion() + "\" author=\"" + this.FA.getAuthor() + "\" date=\"" + this.FA.getDate() + "\" time=\"" + this.FA.getTime() + "\" />").getBytes());
        if (this.FA.getDescription() != null && !this.FA.getDescription().trim().equals("")) {
            out.write(("\n<description>" + this.FA.getDescription() + "</description>").getBytes());
        }
    }

    private boolean readHeader(Document doc) {
        double zoom;
        NodeList objectList = doc.getElementsByTagName("head");
        if (objectList.getLength() <= 0) {
            return false;
        }
        Element node = (Element)objectList.item(0);
        int ysource = 0;
        int xsource = 0;
        int yoffset = 0;
        int xoffset = 0;
        int height = 0;
        int width = 0;
        Element env = (Element)node.getElementsByTagName("enviroment").item(0);
        Element file = (Element)node.getElementsByTagName("file").item(0);
        try {
            width = Integer.parseInt(env.getAttribute("width"));
        }
        catch (Exception _exc) {
            width = 10000;
        }
        try {
            height = Integer.parseInt(env.getAttribute("height"));
        }
        catch (Exception _exc) {
            height = 10000;
        }
        try {
            xoffset = Integer.parseInt(env.getAttribute("xoffset"));
        }
        catch (Exception _exc) {
            xoffset = 4700;
        }
        try {
            yoffset = Integer.parseInt(env.getAttribute("yoffset"));
        }
        catch (Exception _exc) {
            yoffset = 4700;
        }
        try {
            xsource = Integer.parseInt(env.getAttribute("xsource").trim());
        }
        catch (Exception _exc) {
            xsource = 5000;
        }
        try {
            ysource = Integer.parseInt(env.getAttribute("ysource"));
        }
        catch (Exception _exc) {
            ysource = 5000;
        }
        try {
            zoom = Double.parseDouble(env.getAttribute("zoom"));
        }
        catch (Exception _exc) {
            zoom = 1.0;
        }
        this.GA = new GraphicAttribute(width, height, xoffset, yoffset, xsource, ysource, zoom);
        String author = "";
        String date = "";
        String version = "";
        String description = "";
        try {
            version = file.getAttribute("version");
        }
        catch (Exception _exc) {
            version = "under version 57 DEV";
        }
        try {
            date = file.getAttribute("date");
        }
        catch (Exception _exc) {
            version = FileAttribute.DATE;
        }
        try {
            author = file.getAttribute("author");
        }
        catch (Exception _exc) {
            version = "";
        }
        NodeList nodeList = node.getElementsByTagName("description");
        if (nodeList != null && nodeList.getLength() > 0) {
            Element element = (Element)nodeList.item(0);
            description = element.getTextContent();
        }
        this.FA = new FileAttribute(version, date, author);
        this.FA.setDescription(description);
        return true;
    }
}

