/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.history;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class RelationshipTable {
    private HashMap itsHashMap;

    public RelationshipTable() {
        this.itsHashMap = new HashMap(150, 0.75f);
    }

    public RelationshipTable(RelationshipTable rt) {
        this.itsHashMap = new HashMap(rt.getMap());
    }

    public void insert(int stream_id, int kernel_id) {
        this.itsHashMap.put(new Integer(stream_id), new Integer(kernel_id));
    }

    public void insert(int stream_id, int[] vectorID) {
        int i = 0;
        while (i < vectorID.length) {
            Integer ID = new Integer(vectorID[i]);
            if (!this.itsHashMap.containsValue(ID)) {
                this.itsHashMap.put(new Integer(stream_id), ID);
                return;
            }
            ++i;
        }
    }

    public void insert(RelationshipTable rt) {
        this.itsHashMap.putAll(rt.getMap());
    }

    public void remove(int id) {
        this.itsHashMap.remove(new Integer(id));
    }

    public int getKernelID(int id) {
        Object integer = this.itsHashMap.get(new Integer(id));
        return integer != null ? (Integer)integer : -1;
    }

    public boolean isEmpty() {
        return this.itsHashMap.isEmpty();
    }

    public Map getMap() {
        return this.itsHashMap;
    }

    public String toString() {
        String result = "\tKERNEL\t\tGUI\n\n";
        Set set = this.itsHashMap.keySet();
        for (Integer ID_GUI : set) {
            result = String.valueOf(result) + "\t" + ID_GUI + "\t\t" + (Integer)this.itsHashMap.get(ID_GUI) + "\n";
        }
        return result;
    }

    public void clear() {
        this.itsHashMap.clear();
    }
}

