/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.kernel;

import br.ufrj.labma.enibam.kernel.AbstractKernelElement;
import br.ufrj.labma.enibam.kernel.KernelElement;
import br.ufrj.labma.enibam.kernel.KernelGenericLine;
import br.ufrj.labma.enibam.kernel.Program;
import br.ufrj.labma.enibam.kernel.Translatable;
import br.ufrj.labma.enibam.kernel.operations.CoorSys;
import br.ufrj.labma.enibam.kernel.state.GenericLineState;
import br.ufrj.labma.enibam.kernel.state.State;
import br.ufrj.labma.enibam.util.MathVector;

public abstract class AbstractKernelGenericLine2P
extends AbstractKernelElement
implements KernelGenericLine {
    protected double itsX1;
    protected double itsX2;
    protected double itsY1;
    protected double itsY2;
    private GenericLineState _st1 = new GenericLineState();
    private KernelElement[] itsFWSet;

    public AbstractKernelGenericLine2P(Integer mid, Program prog) {
        super(mid, prog);
    }

    @Override
    public abstract boolean contains(CoorSys var1);

    @Override
    public void getP1P2(CoorSys p1, CoorSys p2) {
        p1.itsX = this.itsX1;
        p1.itsY = this.itsY1;
        p2.itsX = this.itsX2;
        p2.itsY = this.itsY2;
    }

    @Override
    public double getX1() {
        return this.itsX1;
    }

    @Override
    public double getY1() {
        return this.itsY1;
    }

    @Override
    public double getX2() {
        return this.itsX2;
    }

    @Override
    public double getY2() {
        return this.itsY2;
    }

    @Override
    public void setP1P2(CoorSys p1, CoorSys p2) {
        this.itsX1 = p1.itsX;
        this.itsY1 = p1.itsY;
        this.itsX2 = p2.itsX;
        this.itsY2 = p2.itsY;
    }

    @Override
    public void setP1P2(double x1, double y1, double x2, double y2) {
        this.itsX1 = x1;
        this.itsY1 = y1;
        this.itsX2 = x2;
        this.itsY2 = y2;
    }

    @Override
    public void getVector(MathVector v) {
        v.setX(this.itsX2 - this.itsX1);
        v.setY(this.itsY2 - this.itsY1);
    }

    @Override
    public boolean isVertical() {
        return this.itsX1 == this.itsX2;
    }

    @Override
    public double getAngularCoef() throws ArithmeticException {
        double quoc = this.itsX2 - this.itsX1;
        if (quoc == 0.0) {
            throw new ArithmeticException("Trying to calculate the Angular Coef. of a vertical line!");
        }
        return (this.itsY2 - this.itsY1) / quoc;
    }

    @Override
    public double getA() {
        return this.itsY2 - this.itsY1;
    }

    @Override
    public double getB() {
        return this.itsX1 - this.itsX2;
    }

    @Override
    public double getC() {
        return this.itsX2 * this.itsY1 - this.itsX1 * this.itsY2;
    }

    @Override
    public boolean p1equalsp2() {
        return this.itsX1 == this.itsX2 && this.itsY1 == this.itsY2;
    }

    @Override
    public void changeState(State _state) throws ClassCastException {
        if (this.theConstraint == null || this.theConstraint.isOk(_state)) {
            GenericLineState _st = (GenericLineState)_state;
            this.itsDeletedStatus = _st.itsDeletedStatus;
            this.itsDefinedStatus = _st.itsDefinedStatus;
            this.itsX1 = _st.itsX1;
            this.itsX2 = _st.itsX2;
            this.itsY1 = _st.itsY1;
            this.itsY2 = _st.itsY2;
        }
    }

    @Override
    public void getState(State _state) throws ClassCastException {
        GenericLineState _st = (GenericLineState)_state;
        _st.itsMID = this.getMID();
        _st.itsDeletedStatus = this.itsDeletedStatus;
        _st.itsDefinedStatus = this.itsDefinedStatus;
        _st.itsX1 = this.itsX1;
        _st.itsX2 = this.itsX2;
        _st.itsY1 = this.itsY1;
        _st.itsY2 = this.itsY2;
    }

    @Override
    public void translate(double dx, double dy) {
        this._st1.itsX1 = this.itsX1 + dx;
        this._st1.itsY1 = this.itsY1 + dy;
        this._st1.itsX2 = this.itsX2 + dx;
        this._st1.itsY2 = this.itsY2 + dy;
        if (this.theConstraint == null || this.theConstraint.isOk(this._st1)) {
            GenericLineState _st = this._st1;
            this.itsDeletedStatus = _st.itsDeletedStatus;
            this.itsDefinedStatus = _st.itsDefinedStatus;
            this.itsX1 = _st.itsX1;
            this.itsX2 = _st.itsX2;
            this.itsY1 = _st.itsY1;
            this.itsY2 = _st.itsY2;
        } else if (this.itsFWSet != null) {
            this.forwardTranslate(dx, dy);
        }
    }

    @Override
    public void setFWSet(KernelElement[] FwSet) {
        this.itsFWSet = FwSet;
    }

    @Override
    public KernelElement[] getFWSet() {
        if (this.itsFWSet != null) {
            return (KernelElement[])this.itsFWSet.clone();
        }
        return null;
    }

    private void forwardTranslate(double dx, double dy) {
        int i = 0;
        while (i < this.itsFWSet.length) {
            Translatable _tmp = (Translatable)((Object)this.itsFWSet[i]);
            if (_tmp != null) {
                _tmp.translate(dx, dy);
            }
            ++i;
        }
    }

    @Override
    public String toString() {
        CoorSys _p1 = new CoorSys();
        CoorSys _p2 = new CoorSys();
        this.getP1P2(_p1, _p2);
        return String.valueOf(this.getClass().getName()) + ": MathID= " + this.getMID() + "\nP1= " + _p1 + " P2= " + _p2 + "\n A= " + this.getA() + " B= " + this.getB() + " C= " + this.getC() + "\nEstah Definido: " + this.getDefinedStatus() + "\nEstah Apagado: " + this.getDeletedStatus() + "\n";
    }
}

