/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.kernel;

import br.ufrj.labma.enibam.kernel.AbstractKernelElement;
import br.ufrj.labma.enibam.kernel.KernelArc;
import br.ufrj.labma.enibam.kernel.KernelCircle;
import br.ufrj.labma.enibam.kernel.KernelElement;
import br.ufrj.labma.enibam.kernel.KernelLine;
import br.ufrj.labma.enibam.kernel.KernelLocus;
import br.ufrj.labma.enibam.kernel.KernelPoint;
import br.ufrj.labma.enibam.kernel.KernelRay;
import br.ufrj.labma.enibam.kernel.KernelSegment;
import br.ufrj.labma.enibam.kernel.Program;
import br.ufrj.labma.enibam.kernel.dummy.KernelDummySegment;
import br.ufrj.labma.enibam.kernel.operations.CoorSys;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractKernelLocus
extends AbstractKernelElement
implements KernelLocus {
    protected List itsPointList;
    protected List itsSegmentList;
    protected int SegmentSelected = -1;
    protected int type = -1;
    protected KernelElement itsPath;

    public AbstractKernelLocus(Integer id, Program prog) {
        super(id, prog);
    }

    @Override
    public abstract void calculate(KernelElement var1, KernelPoint var2);

    @Override
    public abstract List build(KernelElement var1, KernelPoint var2, int var3);

    @Override
    public abstract void initDefault(KernelElement var1, KernelPoint var2, int var3, KernelElement var4);

    @Override
    public List getSegmentVector() {
        return this.itsSegmentList;
    }

    @Override
    public List getPointVector() {
        return this.itsPointList;
    }

    @Override
    public void setPointVector(List l) {
        this.itsPointList = l;
    }

    @Override
    public void makeSegmentVector() {
        KernelDummySegment _e;
        Object _o2;
        int _s = this.itsPointList.size();
        this.itsSegmentList = new ArrayList(_s);
        Object _o1 = _o2 = this.itsPointList.get(0);
        int _i = 1;
        while (_i < _s) {
            _o2 = this.itsPointList.get(_i);
            _e = new KernelDummySegment((CoorSys)_o1, (CoorSys)_o2);
            this.itsSegmentList.add(_e);
            _o1 = _o2;
            ++_i;
        }
        _e = new KernelDummySegment((CoorSys)_o2, (CoorSys)_o2);
        this.itsSegmentList.add(_e);
    }

    @Override
    public int getNumberOfPoints() {
        return this.itsPointList.size();
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getName()) + " : MathID= " + this.getMID() + "\nEstah Definido: " + this.getDefinedStatus() + "\nEstah Apagado: " + this.getDeletedStatus() + "\n";
    }

    public KernelDummySegment getSegment(int num) {
        KernelDummySegment _seg;
        try {
            _seg = (KernelDummySegment)this.itsSegmentList.get(num);
        }
        catch (IndexOutOfBoundsException e) {
            System.out.println("out of BOUNDS!");
            _seg = new KernelDummySegment(0.0, 0.0, 1.0, 1.0);
        }
        return new KernelDummySegment(_seg.getX1(), _seg.getY1(), _seg.getX2(), _seg.getY2());
    }

    @Override
    public KernelDummySegment getSelected() {
        return (KernelDummySegment)this.itsSegmentList.get(this.SegmentSelected);
    }

    protected void setType(KernelElement suport) {
        if (suport instanceof KernelLine) {
            this.type = 0;
            return;
        }
        if (suport instanceof KernelSegment) {
            this.type = 1;
            return;
        }
        if (suport instanceof KernelRay) {
            this.type = 2;
            return;
        }
        if (suport instanceof KernelCircle) {
            this.type = 3;
            return;
        }
        if (suport instanceof KernelLocus) {
            this.type = 4;
            return;
        }
        if (suport instanceof KernelArc) {
            this.type = 6;
            return;
        }
        this.type = 5;
    }
}

