/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.kernel;

import br.ufrj.labma.enibam.kernel.AbstractKernelElement;
import br.ufrj.labma.enibam.kernel.KernelTriangle;
import br.ufrj.labma.enibam.kernel.Program;
import br.ufrj.labma.enibam.kernel.operations.CoorSys;
import br.ufrj.labma.enibam.kernel.state.State;

public abstract class AbstractKernelTriangle
extends AbstractKernelElement
implements KernelTriangle {
    double itsX1;
    double itsX2;
    double itsX3;
    double itsY1;
    double itsY2;
    double itsY3;

    public AbstractKernelTriangle(Integer id, Program prog) {
        super(id, prog);
    }

    @Override
    public void getP1P2P3(CoorSys p1, CoorSys p2, CoorSys p3) {
        p1.itsX = this.itsX1;
        p1.itsY = this.itsY1;
        p2.itsX = this.itsX2;
        p2.itsY = this.itsY2;
        p3.itsX = this.itsX3;
        p3.itsY = this.itsY3;
    }

    @Override
    public double getX1() {
        return this.itsX1;
    }

    @Override
    public double getY1() {
        return this.itsY1;
    }

    @Override
    public double getX2() {
        return this.itsX2;
    }

    @Override
    public double getY2() {
        return this.itsY2;
    }

    @Override
    public double getX3() {
        return this.itsX3;
    }

    @Override
    public double getY3() {
        return this.itsY3;
    }

    @Override
    public void setP1P2P3(CoorSys p1, CoorSys p2, CoorSys p3) {
        this.itsX1 = p1.itsX;
        this.itsY1 = p1.itsY;
        this.itsX2 = p2.itsX;
        this.itsY2 = p2.itsY;
        this.itsX3 = p3.itsX;
        this.itsY3 = p3.itsY;
    }

    @Override
    public void setP1P2P3(double x1, double y1, double x2, double y2, double x3, double y3) {
        this.itsX1 = x1;
        this.itsY1 = y1;
        this.itsX2 = x2;
        this.itsY2 = y2;
        this.itsX3 = x3;
        this.itsY3 = y3;
    }

    @Override
    public double getArea() {
        return Math.abs((this.itsX1 - this.itsX2) * (this.itsY3 - this.itsY2) - (this.itsY1 - this.itsY2) * (this.itsY3 - this.itsY2)) / 2.0;
    }

    @Override
    public double getLength() {
        return Math.sqrt((this.itsX2 - this.itsX1) * (this.itsX2 - this.itsX1) + (this.itsY2 - this.itsY1) * (this.itsY2 - this.itsY1)) + Math.sqrt((this.itsX3 - this.itsX1) * (this.itsX3 - this.itsX1) + (this.itsY3 - this.itsY1) * (this.itsY3 - this.itsY1)) + Math.sqrt((this.itsX3 - this.itsX2) * (this.itsX3 - this.itsX2) + (this.itsY3 - this.itsY2) * (this.itsY3 - this.itsY2));
    }

    @Override
    public abstract void translate(double var1, double var3);

    @Override
    public abstract void changeState(State var1);

    @Override
    public abstract void getState(State var1);

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getName()) + ": MathID= " + this.getMID() + "\nX1= " + this.getX1() + " Y1= " + this.getY1() + "\nX2= " + this.getX2() + " Y2= " + this.getY2() + "\nX3= " + this.getX3() + " Y3= " + this.getY3() + "\nEstah Definido: " + this.getDefinedStatus() + "\nEstah Apagado: " + this.getDeletedStatus() + "\n";
    }
}

