/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.kernel;

import br.ufrj.labma.enibam.kernel.ConstructionIDMap;
import br.ufrj.labma.enibam.kernel.GraphManager;
import br.ufrj.labma.enibam.kernel.exception.AmbiguousFatherRequestException;
import java.io.Serializable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public final class CachedGraphManager
implements GraphManager {
    private Map childGraph = new HashMap();
    private Map parentGraph = new HashMap();
    private Cache childCache = new Cache();
    private Cache parentCache = new Cache();
    private Cache updateOrigCache = new Cache();
    private Cache updateRecvCache = new Cache();
    private long opCount = 0L;

    @Override
    public void add(Integer MID, Set FathersMIDs, Integer ConstructionID) {
        ParentGraphVertex _pgv = new ParentGraphVertex(MID, FathersMIDs, ConstructionID);
        this.parentGraph.put(MID, _pgv);
        ChildGraphVertex _cgv = new ChildGraphVertex(MID, FathersMIDs, ConstructionID);
        this.childGraph.put(MID, _cgv);
        this.parentCache.createEntry(MID);
        this.childCache.createEntry(MID);
        this.updateOrigCache.createEntry(MID);
        this.updateRecvCache.createEntry(MID);
        ++this.opCount;
        this.childCache.lastWrite = this.opCount;
        this.updateRecvCache.lastWrite = this.opCount;
    }

    @Override
    public Set remove(Integer MID) {
        Set _s = this.removeAllChildren(MID);
        Set _parents = this.getImediateParents(MID);
        ChildGraphVertex _vertex = (ChildGraphVertex)this.childGraph.get(MID);
        for (Integer _mid : _parents) {
            ((ChildGraphVertex)this.childGraph.get(_mid)).removeChild(_vertex);
        }
        this.childGraph.remove(MID);
        this.parentGraph.remove(MID);
        this.childCache.remove(MID);
        this.parentCache.remove(MID);
        this.updateOrigCache.remove(MID);
        this.updateRecvCache.remove(MID);
        _s.add(MID);
        ++this.opCount;
        this.childCache.lastWrite = this.opCount;
        this.updateRecvCache.lastWrite = this.opCount;
        return _s;
    }

    @Override
    public Set removeAllChildren(Integer MID) {
        HashSet _s = new HashSet();
        this.getAllChildren(MID, _s);
        TreeSet<Integer> _allChildren = new TreeSet<Integer>(new VertexComparator());
        Iterator _i = _s.iterator();
        while (_i.hasNext()) {
            _allChildren.add((Integer)_i.next());
        }
        for (Integer _mid : _allChildren) {
            ChildGraphVertex _vertex = (ChildGraphVertex)this.childGraph.get(_mid);
            for (Integer _parentMID : this.getImediateParents(_mid)) {
                if ((ChildGraphVertex)this.childGraph.get(_parentMID) == null) continue;
                ((ChildGraphVertex)this.childGraph.get(_parentMID)).removeChild(_vertex);
            }
            this.childGraph.remove(_mid);
            this.parentGraph.remove(_mid);
            this.childCache.remove(_mid);
            this.parentCache.remove(_mid);
            this.updateOrigCache.remove(_mid);
            this.updateRecvCache.remove(_mid);
        }
        ((ChildGraphVertex)this.childGraph.get(MID)).itsChildren.clear();
        ++this.opCount;
        this.childCache.lastWrite = this.opCount;
        this.updateRecvCache.lastWrite = this.opCount;
        return _s;
    }

    @Override
    public void dontUpdate(Integer origem, Integer destino) {
        ((ChildGraphVertex)this.childGraph.get(origem)).removeUpdateRecv(destino);
        ((ParentGraphVertex)this.parentGraph.get(destino)).removeUpdateOrig(origem);
        ++this.opCount;
        this.updateOrigCache.lastWrite = this.opCount;
        this.updateRecvCache.lastWrite = this.opCount;
    }

    @Override
    public Set getAllEssentialUpdateOriginators(Integer MID) {
        if (this.updateOrigCache.isDirty(MID)) {
            Set _s = this.getAllParents(MID);
            Set _exc = ((ParentGraphVertex)this.parentGraph.get(MID)).updateOrigExc;
            Iterator _i = _exc.iterator();
            while (_i.hasNext()) {
                _s.remove(((ParentGraphVertex)_i.next()).itsMID);
            }
            this.updateOrigCache.update(MID, _s);
            return _s;
        }
        return (HashSet)this.updateOrigCache.get(MID).getValue();
    }

    @Override
    public Set getAllEssentialUpdateReceivers(Integer MID) {
        if (this.updateRecvCache.isDirty(MID)) {
            Iterator _i;
            HashSet _s = new HashSet();
            if (ConstructionIDMap.isInversePropagationConstruction(this.getConstructionID(MID))) {
                Set _parents = this.getImediateParents(MID);
                _i = _parents.iterator();
                HashSet _children = new HashSet();
                while (_i.hasNext()) {
                    this.getAllChildren((Integer)_i.next(), _children);
                    _s.addAll(_children);
                }
                _s.remove(MID);
                _s.addAll(_parents);
            } else {
                this.getAllChildren(MID, _s);
            }
            Set _exc = ((ChildGraphVertex)this.childGraph.get(MID)).updateRecvExc;
            _i = _exc.iterator();
            while (_i.hasNext()) {
                _s.remove(((ChildGraphVertex)_i.next()).itsMID);
            }
            this.updateRecvCache.update(MID, _s);
            return _s;
        }
        return (HashSet)this.updateRecvCache.get(MID).getValue();
    }

    @Override
    public Set getImediateParents(Integer MID) {
        return new HashSet(((ParentGraphVertex)this.parentGraph.get(MID)).getParentsMIDs());
    }

    @Override
    public void getImediateParents(Integer MID, Set s) {
        s.clear();
        s.addAll(((ParentGraphVertex)this.parentGraph.get(MID)).getParentsMIDs());
    }

    @Override
    public Set getAllParents(Integer MID) {
        if (this.parentCache.isDirty(MID)) {
            HashSet _allParents = new HashSet();
            HashSet _parents = this.getImediateParents(MID);
            while (_parents.size() > 0) {
                _allParents.addAll(_parents);
                HashSet _grandParents = new HashSet();
                Iterator _i = _parents.iterator();
                while (_i.hasNext()) {
                    _grandParents.addAll(this.getImediateParents((Integer)_i.next()));
                }
                _parents = _grandParents;
            }
            this.parentCache.update(MID, _allParents);
            return _allParents;
        }
        return (HashSet)this.parentCache.get(MID).getValue();
    }

    @Override
    public void getAllParents(Integer MID, Set s) {
        s.clear();
        if (this.parentCache.isDirty(MID)) {
            HashSet _parents = this.getImediateParents(MID);
            while (_parents.size() > 0) {
                s.addAll(_parents);
                HashSet _grandParents = new HashSet();
                Iterator _i = _parents.iterator();
                while (_i.hasNext()) {
                    _grandParents.addAll(this.getImediateParents((Integer)_i.next()));
                }
                _parents = _grandParents;
            }
            this.parentCache.update(MID, new HashSet(s));
        } else {
            s.addAll((HashSet)this.parentCache.get(MID).getValue());
        }
    }

    @Override
    public int getLevel(Integer MID) {
        return ((ChildGraphVertex)this.childGraph.get(MID)).itsLevel;
    }

    @Override
    public Integer getConstructionID(Integer MID) {
        return ((ChildGraphVertex)this.childGraph.get(MID)).itsConstID;
    }

    @Override
    public Integer getTheParent(Integer MID) throws AmbiguousFatherRequestException {
        Set s = ((ParentGraphVertex)this.parentGraph.get(MID)).itsParents;
        if (s.size() != 1) {
            throw new AmbiguousFatherRequestException("Esse Elemento n\u00e3o possui pai ou possui v\u00e1rios pais!");
        }
        return ((ParentGraphVertex)s.iterator().next()).itsMID;
    }

    @Override
    public void getImediateChildren(Integer MID, Set s) {
        ((ChildGraphVertex)this.childGraph.get(MID)).getChildrenMIDs(s);
    }

    public Set getImediateChildren(Integer MID) {
        return ((ChildGraphVertex)this.childGraph.get(MID)).getChildrenMIDs();
    }

    @Override
    public void getAllChildren(Integer MID, Set s) {
        s.clear();
        if (this.childCache.isDirty(MID)) {
            HashSet _children = this.getImediateChildren(MID);
            while (_children.size() > 0) {
                s.addAll(_children);
                HashSet _grandChildren = new HashSet();
                Iterator _i = _children.iterator();
                while (_i.hasNext()) {
                    _grandChildren.addAll(this.getImediateChildren((Integer)_i.next()));
                }
                _children = _grandChildren;
            }
            this.childCache.update(MID, new HashSet(s));
        } else {
            s.addAll((HashSet)this.childCache.get(MID).getValue());
        }
    }

    @Override
    public SortedSet getAllChildrenLevelOrdered(Integer MID) {
        HashSet _s = new HashSet();
        this.getAllChildren(MID, _s);
        TreeSet<Integer> _allChildren = new TreeSet<Integer>(new LevelComparator());
        Iterator _i = _s.iterator();
        while (_i.hasNext()) {
            _allChildren.add((Integer)_i.next());
        }
        return _allChildren;
    }

    public String toString() {
        String str = "===================\n";
        str = String.valueOf(str) + "   GRAPH MANAGER   \n";
        str = String.valueOf(str) + "===================\n\n";
        str = String.valueOf(str) + "  ChildGraph:\n";
        for (Map.Entry _e : this.childGraph.entrySet()) {
            str = String.valueOf(str) + "    " + _e.getValue() + "\n";
        }
        str = String.valueOf(str) + "\n  ParentGraph:\n";
        for (Map.Entry _e : this.parentGraph.entrySet()) {
            str = String.valueOf(str) + "    " + _e.getValue() + "\n";
        }
        return str;
    }

    private final class Cache
    extends HashMap
    implements Serializable {
        private long lastWrite = 0L;

        private Cache() {
        }

        private void createEntry(Integer MID) {
            super.put(MID, new CacheElmt(-1L, null));
        }

        private void update(Integer MID, Object value) {
            super.remove(MID);
            super.put(MID, new CacheElmt(this.lastWrite, value));
        }

        private CacheElmt get(Integer MID) {
            return (CacheElmt)super.get(MID);
        }

        private boolean isDirty(Integer MID) {
            return this.get(MID).isDirtyAfter(this.lastWrite);
        }
    }

    private final class CacheElmt
    implements Serializable {
        private long lastUpdate;
        private Object theValue;

        private CacheElmt(long opTime, Object value) {
            this.lastUpdate = opTime;
            this.theValue = value;
        }

        private boolean isDirtyAfter(long lastWrite) {
            return lastWrite > this.lastUpdate;
        }

        private Object getValue() {
            return this.theValue;
        }
    }

    private final class ChildGraphVertex
    implements Serializable {
        private Integer itsMID;
        private Integer itsConstID;
        private Set itsChildren;
        private Set updateRecvExc;
        private int itsLevel;

        private ChildGraphVertex(Integer MID, Set Parents, Integer ConstID) {
            int maxParentLevel = -1;
            this.itsMID = MID;
            this.itsConstID = ConstID;
            this.updateRecvExc = new HashSet();
            this.itsChildren = new HashSet();
            Iterator _i = Parents.iterator();
            while (_i.hasNext()) {
                ChildGraphVertex _parent = (ChildGraphVertex)CachedGraphManager.this.childGraph.get((Integer)_i.next());
                _parent.addChild(this);
                if (_parent.getLevel() <= maxParentLevel) continue;
                maxParentLevel = _parent.getLevel();
            }
            this.itsLevel = maxParentLevel + 1;
        }

        private void addChild(ChildGraphVertex vertex) {
            this.itsChildren.add(vertex);
        }

        private void removeChild(ChildGraphVertex vertex) {
            this.itsChildren.remove(vertex);
        }

        private void removeUpdateRecv(Integer MID) {
            this.updateRecvExc.add(CachedGraphManager.this.childGraph.get(MID));
        }

        private int getLevel() {
            return this.itsLevel;
        }

        private Set getChildrenMIDs() {
            HashSet<Integer> _s = new HashSet<Integer>();
            Iterator _i = this.itsChildren.iterator();
            while (_i.hasNext()) {
                _s.add(((ChildGraphVertex)_i.next()).itsMID);
            }
            return _s;
        }

        private void getChildrenMIDs(Set s) {
            s.clear();
            Iterator _i = this.itsChildren.iterator();
            while (_i.hasNext()) {
                s.add(((ChildGraphVertex)_i.next()).itsMID);
            }
        }

        public String toString() {
            String str = "<CGV ";
            str = String.valueOf(str) + "MID=\"" + this.itsMID + "\" ConstID=\"" + this.itsConstID + "\" ";
            str = String.valueOf(str) + "Level=\"" + this.itsLevel + "\" ";
            str = String.valueOf(str) + "Children=\"" + this.childSetToStr(this.itsChildren) + "\" />";
            return str;
        }

        private String childSetToStr(Set s) {
            Iterator _i = s.iterator();
            String str = "{";
            while (_i.hasNext()) {
                str = String.valueOf(str) + ((ChildGraphVertex)_i.next()).itsMID;
                if (!_i.hasNext()) continue;
                str = String.valueOf(str) + ", ";
            }
            str = String.valueOf(str) + "}";
            return str;
        }
    }

    private final class LevelComparator
    implements Comparator,
    Serializable {
        private LevelComparator() {
        }

        public int compare(Object o1, Object o2) {
            int _res = ((ChildGraphVertex)CachedGraphManager.this.childGraph.get((Integer)o2)).itsLevel - ((ChildGraphVertex)CachedGraphManager.this.childGraph.get((Integer)o1)).itsLevel;
            if (_res == 0) {
                _res = 1;
            }
            return _res;
        }

        public boolean equals(Object o1, Object o2) {
            return (Integer)o1 == (Integer)o2;
        }
    }

    private final class ParentGraphVertex
    implements Serializable {
        private Integer itsMID;
        private Integer itsConstID;
        private Set itsParents;
        private Set updateOrigExc;

        private ParentGraphVertex(Integer MID, Set Parents, Integer ConstID) {
            this.itsMID = MID;
            this.itsConstID = ConstID;
            this.updateOrigExc = new HashSet();
            this.itsParents = new HashSet();
            Iterator _i = Parents.iterator();
            while (_i.hasNext()) {
                ParentGraphVertex _parent = (ParentGraphVertex)CachedGraphManager.this.parentGraph.get((Integer)_i.next());
                this.itsParents.add(_parent);
            }
        }

        private Set getParentsMIDs() {
            HashSet<Integer> _s = new HashSet<Integer>();
            Iterator _i = this.itsParents.iterator();
            while (_i.hasNext()) {
                _s.add(((ParentGraphVertex)_i.next()).itsMID);
            }
            return _s;
        }

        private void removeUpdateOrig(Integer MID) {
            this.updateOrigExc.add(CachedGraphManager.this.parentGraph.get(MID));
        }

        public String toString() {
            String str = "<PGV ";
            str = String.valueOf(str) + "MID=\"" + this.itsMID + "\" ConstID=\"" + this.itsConstID + "\" ";
            str = String.valueOf(str) + "Parents=\"" + this.parentSetToStr(this.itsParents) + "\" />";
            return str;
        }

        private String parentSetToStr(Set s) {
            Iterator _i = s.iterator();
            String str = "{";
            while (_i.hasNext()) {
                str = String.valueOf(str) + ((ParentGraphVertex)_i.next()).itsMID;
                if (!_i.hasNext()) continue;
                str = String.valueOf(str) + ", ";
            }
            str = String.valueOf(str) + "}";
            return str;
        }
    }

    private final class VertexComparator
    implements Comparator,
    Serializable {
        private VertexComparator() {
        }

        public int compare(Object o1, Object o2) {
            int _res = ((ChildGraphVertex)CachedGraphManager.this.childGraph.get((Integer)o1)).itsLevel - ((ChildGraphVertex)CachedGraphManager.this.childGraph.get((Integer)o2)).itsLevel;
            if (_res == 0) {
                _res = 1;
            }
            return _res;
        }

        public boolean equals(Object o1, Object o2) {
            return (Integer)o1 == (Integer)o2;
        }
    }
}

