/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.kernel;

import br.ufrj.labma.enibam.kernel.exception.ConstructionNotFoundException;
import java.lang.reflect.Field;

public final class ConstructionIDMap {
    public static final int FreePoint = 1000;
    public static final int FreeLine = 1010;
    public static final int FreeSegment = 1011;
    public static final int FreeRay = 1012;
    public static final int FreeCircle = 1020;
    public static final int FreeVector = 1030;
    public static final int FreeRatio = 1040;
    public static final int FreeAngle = 1050;
    public static final int FreeArea = 1051;
    public static final int FreeLength = 1052;
    public static final int FreePolygon = 1090;
    public static final int FreeText = 1091;
    public static final int FreeUnitaryMeasure = 1100;
    public static final int PointInLine = 2000;
    public static final int PointInSegment = 2001;
    public static final int PointInRay = 2002;
    public static final int PointAxes = 2003;
    public static final int Coordinate = 2004;
    public static final int PointInCircle = 2010;
    public static final int PointInsideCircle = 2011;
    public static final int PointInLocus = 2020;
    public static final int PointInArc = 2030;
    public static final int GLineGLineIntersection = 3000;
    public static final int CircleCircleIntersection = 3010;
    public static final int GLineCircleIntersection = 3020;
    public static final int ArcArcIntersection = 3030;
    public static final int ArcCircleIntersection = 3040;
    public static final int ArcGenericLineIntersection = 3050;
    public static final int MiddlePoint2P = 3100;
    public static final int MiddlePointS = 3101;
    public static final int ParallelLine = 3200;
    public static final int PerpendicularLine = 3210;
    public static final int BissectorRay = 3220;
    public static final int PointTranslated = 4010;
    public static final int LineTranslated = 4020;
    public static final int RayTranslated = 4030;
    public static final int SegmentTranslated = 4040;
    public static final int CircleTranslated = 4050;
    public static final int PointCentralSymmetry = 4060;
    public static final int LineCentralSymmetry = 4070;
    public static final int RayCentralSymmetry = 4080;
    public static final int SegmentCentralSymmetry = 4090;
    public static final int CircleCentralSymmetry = 4100;
    public static final int PointReflected = 4110;
    public static final int LineReflected = 4120;
    public static final int RayReflected = 4130;
    public static final int SegmentReflected = 4140;
    public static final int CircleReflected = 4150;
    public static final int PointPlaneProjected = 4151;
    public static final int Ratio2S = 4160;
    public static final int Ratio3P = 4162;
    public static final int Ratio2M = 4163;
    public static final int PointDilated = 4170;
    public static final int Angle3P = 4180;
    public static final int DotProduct2V = 4185;
    public static final int PointRotated = 4190;
    public static final int CircleDilated = 4200;
    public static final int LineDilated = 4210;
    public static final int SegmentDilated = 4211;
    public static final int RayDilated = 4212;
    public static final int CircleRotated = 4220;
    public static final int LineRotated = 4230;
    public static final int SegmentRotated = 4231;
    public static final int RayRotated = 4232;
    public static final int PointInverted = 4233;
    public static final int PointInverted2 = 4242;
    public static final int CircleInverted = 4234;
    public static final int LineInverted = 4235;
    public static final int SegmentInverted = 4236;
    public static final int RayInverted = 4237;
    public static final int TangentLine = 4240;
    public static final int TangentPoint = 4241;
    public static final int Locus = 5010;
    public static final int PointLocusRotated = 5011;
    public static final int GLineLocusRotated = 5012;
    public static final int CircleLocusRotated = 5013;
    public static final int PointLocusTranslated = 5014;
    public static final int GLineLocusTranslated = 5015;
    public static final int CircleLocusTranslated = 5016;
    public static final int PointLocusCentralSymmetry = 5017;
    public static final int GLineLocusCentralSymmetry = 5018;
    public static final int CircleLocusCentralSymmetry = 5019;
    public static final int PointLocusDilated = 5021;
    public static final int GLineLocusDilated = 5022;
    public static final int CircleLocusDilated = 5023;
    public static final int PointLocusReflected = 5024;
    public static final int GLineLocusReflected = 5025;
    public static final int CircleLocusReflected = 5026;
    public static final int PointLocusInverted = 5027;
    public static final int GLineLocusInverted = 5028;
    public static final int CircleLocusInverted = 5029;
    public static final int SegmentLocusCentralSymmetry = 5033;
    public static final int SegmentLocusDilated = 5034;
    public static final int SegmentLocusInverted = 5035;
    public static final int SegmentLocusReflected = 5036;
    public static final int SegmentLocusRotated = 5037;
    public static final int SegmentLocusTranslated = 5038;
    public static final int RayLocusCentralSymmetry = 5043;
    public static final int RayLocusDilated = 5044;
    public static final int RayLocusInverted = 5045;
    public static final int RayLocusReflected = 5046;
    public static final int RayLocusRotated = 5047;
    public static final int RayLocusTranslated = 5048;
    public static final int NSegment = 5020;
    public static final int NCircle = 5039;
    public static final int NArc = 5100;
    public static final int Mediatriz = 5030;
    public static final int SumOfVectors = 5031;
    public static final int VectorMultiplyedByNumber = 5032;
    public static final int Area = 5040;
    public static final int Length = 5041;
    public static final int Function = 5042;
    public static final int CircularSector3P = 5050;
    public static final int CircularSegment2PC = 5055;
    public static final int UnitaryMeasureL = 5060;
    public static final int CircleInterior = 5065;
    public static final int ArcInteriorSector = 5066;
    public static final int ArcInteriorSegment = 5067;
    public static final int Expression = 5200;
    public static final int ExpressionAngle = 5201;
    public static final int ExpressionArea = 5202;
    public static final int ExpressionLength = 5203;
    public static final int CircleCenter = 5300;
    public static final int ArcCenter = 5301;
    public static final int CircularSectorCenter = 5302;
    public static final int CircleRadius = 5310;
    public static final int ArcRadius = 5311;
    public static final int CircularSectorRadius = 5312;
    public static final int Axes3P = 5400;
    public static final int CoordinateP = 5410;
    public static final int Line2P = 6010;
    public static final int Segment2P = 6011;
    public static final int Ray2P = 6012;
    public static final int RayPV = 6060;
    public static final int LinePV = 6061;
    public static final int Circle2P = 6020;
    public static final int Circle3P = 6021;
    public static final int CirclePV = 6022;
    public static final int CirclePS = 6023;
    public static final int Vector2P = 6030;
    public static final int Conic5P = 6050;
    public static final int ConicTranslated = 6051;
    public static final int ConicRotated = 6052;
    public static final int ConicReflected = 6053;
    public static final int ConicCentralSymmetry = 6054;
    public static final int ConicDilated = 6055;
    public static final int ConicInverted = 6056;
    public static final int Triangle3P = 6070;
    public static final int PolygonNP = 6090;
    public static final int PolygonReflected = 6091;
    public static final int PolygonTranslated = 6092;
    public static final int PolygonCentralSymmetry = 6093;
    public static final int PolygonDilated = 6094;
    public static final int PolygonInverted = 6095;
    public static final int PolygonRotated = 6096;
    public static final int Arc3P = 6100;
    public static final int ArcReflected = 6101;
    public static final int ArcTranslated = 6102;
    public static final int ArcCentralSymmetry = 6103;
    public static final int ArcDilated = 6104;
    public static final int ArcInverted = 6105;
    public static final int ArcRotated = 6106;
    public static final int HypLine2P = 7001;
    public static final int HypRay2P = 7002;
    public static final int HypSegment2P = 7003;
    public static final int HypPerp = 7004;
    public static final int HypCircleCP = 7005;
    public static final int HypCompas = 7006;
    public static final int HypComPerp = 7007;
    public static final int HypMediatriz = 7008;
    public static final int HypMiddlePoint2P = 7009;
    public static final int KleinLine2P = 7101;
    public static final int KleinRay2P = 7102;
    public static final int KleinSegment2P = 7103;
    public static final int KleinPerp = 7104;
    public static final int KleinComPerp = 7105;
    public static final int KleinCircleCP = 7106;
    public static final int KleinCompas = 7107;
    public static final int SplineLocus = 8010;
    public static final int PolyLocus = 8020;
    public static final int LineLocus = 8030;
    public static final int CircleLocus = 8040;
    public static final int SegmentLocus = 8050;
    public static final int RayLocus = 8060;
    public static final int AdapLocus = 8070;

    public static int parseInt(String CID) throws ConstructionNotFoundException {
        try {
            Class<?> clazz;
            try {
                clazz = Class.forName("br.ufrj.labma.enibam.kernel.ConstructionIDMap");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            Field f = clazz.getDeclaredField(CID);
            return f.getInt(null);
        }
        catch (NoSuchFieldException e) {
            if (CID.equals("GLineGLinez_zz_zzz_zzzz_g_bn")) {
                return 3000;
            }
            if (CID.equals("CircleCirclez_zz_zzz_zzzz_g_bn")) {
                return 3010;
            }
            if (CID.equals("GLineCirclez_zz_zzz_zzzz_g_bn")) {
                return 3020;
            }
            if (CID.equals("Pointz_zz_zzz_zzzz_g_bi")) {
                return 4060;
            }
            if (CID.equals("Linez_zz_zzz_zzzz_g_bi")) {
                return 4070;
            }
            if (CID.equals("Rayz_zz_zzz_zzzz_g_bi")) {
                return 4080;
            }
            if (CID.equals("Segmentz_zz_zzz_zzzz_g_bi")) {
                return 4090;
            }
            if (CID.equals("Circlez_zz_zzz_zzzz_g_bi")) {
                return 4100;
            }
            if (CID.equals("z_zz_zzz_zzzz_g_bl2V")) {
                return 4185;
            }
            if (CID.equals("PointLocusz_zz_zzz_zzzz_g_bi")) {
                return 5017;
            }
            if (CID.equals("GLineLocusz_zz_zzz_zzzz_g_bi")) {
                return 5018;
            }
            if (CID.equals("CircleLocusz_zz_zzz_zzzz_g_bi")) {
                return 5019;
            }
            if (CID.equals("Conicz_zz_zzz_zzzz_g_bi")) {
                return 6054;
            }
            if (CID.equals("Polygonz_zz_zzz_zzzz_g_bi")) {
                return 6093;
            }
            if (CID.equals("Arcz_zz_zzz_zzzz_g_bi")) {
                return 6103;
            }
            throw new ConstructionNotFoundException();
        }
        catch (SecurityException e) {
            throw new ConstructionNotFoundException();
        }
        catch (IllegalAccessException e) {
            throw new ConstructionNotFoundException();
        }
    }

    public static String parseString(int CID) throws ConstructionNotFoundException {
        try {
            Class<?> clazz;
            try {
                clazz = Class.forName("br.ufrj.labma.enibam.kernel.ConstructionIDMap");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            Field[] f = clazz.getDeclaredFields();
            int i = 0;
            while (i < f.length) {
                if (f[i].getInt(null) == CID) {
                    return f[i].getName();
                }
                ++i;
            }
            throw new ConstructionNotFoundException();
        }
        catch (IllegalAccessException e) {
            throw new ConstructionNotFoundException();
        }
        catch (SecurityException e) {
            throw new ConstructionNotFoundException();
        }
    }

    public static final boolean isFreeConstruction(int CID) {
        return CID >= 1000 && CID < 2000;
    }

    public static final boolean isTrailConstruction(int CID) {
        return CID >= 2000 && CID < 3000;
    }

    public static final boolean isOutputConstruction(int CID) {
        return CID >= 3000 && CID < 6000;
    }

    public static final boolean isInversePropagationConstruction(int CID) {
        return CID >= 6000 && CID < 7000;
    }

    public static final boolean isNonEuclidConstruction(int CID) {
        return CID >= 7001 && CID < 7200;
    }
}

