/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.kernel;

import br.ufrj.labma.enibam.kernel.GraphManager;
import br.ufrj.labma.enibam.kernel.exception.AmbiguousFatherRequestException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;

public final class GraphManager2
implements GraphManager {
    private Map itsGraphMap = new HashMap();

    @Override
    public void add(Integer MID, Set FathersMIDs, Integer ConstructionID) {
        Vertex _entry = new Vertex(MID, ConstructionID, FathersMIDs);
        this.itsGraphMap.put(MID, _entry);
        _entry.initDefault();
    }

    @Override
    public Set remove(Integer MID) {
        Vertex v = this.getVertex(MID);
        HashSet<Vertex> s = new HashSet<Vertex>(v.itsAllChildren);
        s.add(v);
        return this.remove(s);
    }

    @Override
    public Set removeAllChildren(Integer MID) {
        Vertex v = this.getVertex(MID);
        HashSet s = new HashSet(v.itsAllChildren);
        return this.remove(s);
    }

    private Set remove(Set s) {
        for (Vertex vfilho : s) {
            for (Vertex tmp : vfilho.itsImediateParents) {
                tmp.deattachImediateChild(vfilho);
                tmp.updateToTop();
            }
            this.itsGraphMap.remove(vfilho.itsMID);
        }
        return this.VertexSetToMIDSet(s);
    }

    @Override
    public Set getAllEssentialUpdateOriginators(Integer MID) {
        return this.VertexSetToMIDSet(this.getVertex(MID).itsUpdateOriginList);
    }

    @Override
    public Set getAllEssentialUpdateReceivers(Integer MID) {
        return this.VertexSetToMIDSet(this.getVertex(MID).itsUpdateReceivList);
    }

    @Override
    public void dontUpdate(Integer origem, Integer destino) {
        Vertex _origem = (Vertex)this.itsGraphMap.get(origem);
        Vertex _destino = (Vertex)this.itsGraphMap.get(destino);
        _origem.removeUpdateReceivList(destino);
        _destino.removeUpdateOriginList(origem);
        _origem.updateToTop();
    }

    @Override
    public Set getImediateParents(Integer MID) {
        return new HashSet(this.VertexSetToMIDSet(((Vertex)this.itsGraphMap.get(MID)).itsImediateParents));
    }

    @Override
    public void getImediateParents(Integer MID, Set s) {
        s.clear();
        s.addAll(this.VertexSetToMIDSet(((Vertex)this.itsGraphMap.get(MID)).itsImediateParents));
    }

    @Override
    public Set getAllParents(Integer MID) {
        return new HashSet(this.VertexSetToMIDSet(((Vertex)this.itsGraphMap.get(MID)).itsAllParents));
    }

    @Override
    public void getAllParents(Integer MID, Set s) {
        s.clear();
        s.addAll(this.VertexSetToMIDSet(((Vertex)this.itsGraphMap.get(MID)).itsAllParents));
    }

    @Override
    public int getLevel(Integer MID) {
        return ((Vertex)this.itsGraphMap.get(MID)).itsLevel;
    }

    @Override
    public Integer getConstructionID(Integer MID) {
        return ((Vertex)this.itsGraphMap.get(MID)).itsConstructionID;
    }

    @Override
    public Integer getTheParent(Integer MID) throws AmbiguousFatherRequestException {
        Set s = ((Vertex)this.itsGraphMap.get(MID)).itsImediateParents;
        if (s.size() != 1) {
            throw new AmbiguousFatherRequestException("Esse Elemento n\u00e3o possui pai ou possui v\u00e1rios pais!");
        }
        return ((Vertex)s.iterator().next()).itsMID;
    }

    @Override
    public void getImediateChildren(Integer MID, Set s) {
        s.clear();
        s.addAll(this.VertexSetToMIDSet(this.getVertex(MID).itsImediateChildren));
    }

    @Override
    public void getAllChildren(Integer MID, Set s) {
        s.clear();
        s.addAll(this.VertexSetToMIDSet(this.getVertex(MID).itsAllChildren));
    }

    private Vertex getVertex(Integer MID) {
        return (Vertex)this.itsGraphMap.get(MID);
    }

    private Set VertexSetToMIDSet(Set VList) {
        HashSet<Integer> s = new HashSet<Integer>();
        Iterator _i = VList.iterator();
        while (_i.hasNext()) {
            s.add(((Vertex)_i.next()).itsMID);
        }
        return s;
    }

    public String toString() {
        String str = "===================\n";
        str = String.valueOf(str) + "   GRAPH MANAGER   \n";
        str = String.valueOf(str) + "===================\n";
        for (Map.Entry _e : this.itsGraphMap.entrySet()) {
            str = String.valueOf(str) + "MID: " + _e.getKey() + "\n" + _e.getValue();
        }
        return str;
    }

    @Override
    public SortedSet getAllChildrenLevelOrdered(Integer MID) {
        return null;
    }

    private final class Vertex {
        private Integer itsMID;
        private Integer itsConstructionID;
        private Set itsImediateParents;
        private int itsLevel;
        private Set itsAllParents;
        private Set itsImediateChildren;
        private Set itsAllChildren;
        private Set itsUpdateOriginList;
        private Set itsUpdateReceivList;
        private Set itsUpdateReceivExclusionList;

        private Vertex(Integer MID, Integer ConstID, Set ImediateFathers) {
            this.itsMID = MID;
            this.itsConstructionID = ConstID;
            this.itsImediateParents = new HashSet();
            Iterator _i = ImediateFathers.iterator();
            while (_i.hasNext()) {
                this.itsImediateParents.add(GraphManager2.this.itsGraphMap.get(_i.next()));
            }
        }

        private void initDefault() {
            this.itsLevel = this.getLevel();
            this.itsAllParents = this.getAllFathers();
            this.itsImediateChildren = new HashSet();
            this.itsAllChildren = new HashSet();
            this.itsUpdateOriginList = this.getUpdateOriginList();
            this.itsUpdateReceivList = new HashSet();
            this.itsUpdateReceivExclusionList = new HashSet();
            Iterator _i = this.itsImediateParents.iterator();
            while (_i.hasNext()) {
                ((Vertex)_i.next()).attachImediateChild(this);
            }
            this.updateToTop();
        }

        private void removeUpdateReceivList(Integer MID) {
            this.itsUpdateReceivExclusionList.add(GraphManager2.this.getVertex(MID));
        }

        private void removeUpdateOriginList(Integer MID) {
            this.itsUpdateOriginList.remove(GraphManager2.this.getVertex(MID));
        }

        private Set getAllFathers() {
            HashSet _s = new HashSet(this.itsImediateParents);
            for (Vertex _entry : this.itsImediateParents) {
                _s.addAll(_entry.itsAllParents);
            }
            return _s;
        }

        private Set getUpdateOriginList() {
            HashSet _s = new HashSet(this.itsImediateParents);
            for (Vertex _entry : this.itsImediateParents) {
                _s.addAll(_entry.itsUpdateOriginList);
            }
            return _s;
        }

        private int getLevel() {
            int GreaterLevel = -1;
            for (Vertex e : this.itsImediateParents) {
                int temp = e.itsLevel;
                int n = GreaterLevel = temp > GreaterLevel ? temp : GreaterLevel;
            }
            return GreaterLevel + 1;
        }

        private void attachImediateChild(Vertex v) {
            this.itsImediateChildren.add(v);
        }

        private void deattachImediateChild(Vertex v) {
            this.itsImediateChildren.remove(v);
        }

        private void updateToTop() {
            Iterator _i = this.itsImediateChildren.iterator();
            this.itsAllChildren.clear();
            while (_i.hasNext()) {
                Vertex v = (Vertex)_i.next();
                this.itsAllChildren.add(v);
                this.itsAllChildren.addAll(v.itsAllChildren);
            }
            this.itsUpdateReceivList.clear();
            this.itsUpdateReceivList.addAll(this.itsAllChildren);
            this.itsUpdateReceivList.removeAll(this.itsUpdateReceivExclusionList);
            for (Vertex v : this.itsImediateParents) {
                v.updateToTop();
            }
        }

        public String toString() {
            return "Level: " + this.itsLevel + "\nImediateParents: " + GraphManager2.this.VertexSetToMIDSet(this.itsImediateParents) + "\nAllParents: " + GraphManager2.this.VertexSetToMIDSet(this.itsAllParents) + "\nUpdateOriginatorsSet : " + GraphManager2.this.VertexSetToMIDSet(this.itsUpdateOriginList) + "\nImediateChildren: " + GraphManager2.this.VertexSetToMIDSet(this.itsImediateChildren) + "\nAllChildren : " + GraphManager2.this.VertexSetToMIDSet(this.itsAllChildren) + "\nUpdateReceiversSet : " + GraphManager2.this.VertexSetToMIDSet(this.itsUpdateReceivList) + "\nUpdateReceiversExclusionList : " + GraphManager2.this.VertexSetToMIDSet(this.itsUpdateReceivExclusionList) + "\nConstructionID : " + this.itsConstructionID + "\n\n";
        }
    }
}

