/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.kernel;

import br.ufrj.labma.enibam.kernel.AbstractKernelArc;
import br.ufrj.labma.enibam.kernel.Program;
import br.ufrj.labma.enibam.kernel.operations.CoorSys;
import br.ufrj.labma.enibam.kernel.state.ArcState;
import br.ufrj.labma.enibam.kernel.state.State;

public class KernelArcCR2A
extends AbstractKernelArc {
    private double itsCenterX;
    private double itsCenterY;
    private double itsRadius;
    private double itsStartingAngle;
    private double itsArcAngle;
    private int itsOrientation;
    private ArcState _st1 = new ArcState();
    private CoorSys theP1 = new CoorSys();
    private CoorSys theP2 = new CoorSys();
    private CoorSys theP3 = new CoorSys();

    public KernelArcCR2A(Integer id, Program prog) {
        super(id, prog);
    }

    @Override
    public double getCenterX() {
        return this.itsCenterX;
    }

    @Override
    public double getCenterY() {
        return this.itsCenterY;
    }

    @Override
    public void getCenter(CoorSys ret) {
        ret.itsX = this.itsCenterX;
        ret.itsY = this.itsCenterY;
    }

    @Override
    public final double getRadius() {
        return this.itsRadius;
    }

    @Override
    public double getStartingAngle() {
        return this.itsStartingAngle;
    }

    @Override
    public double getArcAngle() {
        return this.itsArcAngle;
    }

    public double getArea() {
        return this.itsRadius * this.itsRadius * this.itsArcAngle / 2.0;
    }

    @Override
    public double getLength() {
        return Math.abs(this.itsArcAngle * this.itsRadius);
    }

    @Override
    public void setAngles(double startingAngle, double arcAngle) {
        this.itsStartingAngle = startingAngle;
        this.itsArcAngle = arcAngle;
    }

    @Override
    public void setCenterRadius(double xc, double yc, double r) {
        this.itsCenterX = xc;
        this.itsCenterY = yc;
        this.itsRadius = r;
    }

    @Override
    public void setCenterRadius(CoorSys c, double r) {
        this.itsCenterX = c.itsX;
        this.itsCenterY = c.itsY;
        this.itsRadius = r;
    }

    @Override
    public void set3Points(double x1, double y1, double x2, double y2, double x3, double y3) {
        boolean _hasIntersection;
        double A2;
        double NewV3y;
        this.theP1.itsX = x1;
        this.theP1.itsY = y1;
        this.theP2.itsX = x2;
        this.theP2.itsY = y2;
        this.theP3.itsX = x3;
        this.theP3.itsY = y3;
        double r = ((x1 - x2) * (x1 + x2) + (y1 - y2) * (y1 + y2)) / 2.0;
        double s = ((x2 - x3) * (x2 + x3) + (y2 - y3) * (y2 + y3)) / 2.0;
        double d = (x1 - x2) * (y2 - y3) - (x2 - x3) * (y1 - y2);
        this.itsCenterX = (r * (y2 - y3) - s * (y1 - y2)) / d;
        this.itsCenterY = (s * (x1 - x2) - r * (x2 - x3)) / d;
        this.itsRadius = Math.sqrt((x1 - this.itsCenterX) * (x1 - this.itsCenterX) + (y1 - this.itsCenterY) * (y1 - this.itsCenterY));
        double V1x = x1 - this.itsCenterX;
        double V1y = y1 - this.itsCenterY;
        double V2x = x2 - this.itsCenterX;
        double V2y = y2 - this.itsCenterY;
        double V3x = x3 - this.itsCenterX;
        double V3y = y3 - this.itsCenterY;
        double t1 = this.getAngle(V1x /= this.itsRadius, V1y /= this.itsRadius);
        double minangle = this.getAngle(V1x, V1y, V3x /= this.itsRadius, V3y /= this.itsRadius);
        double maxangle = Math.PI * 2 - minangle;
        this.itsStartingAngle = t1;
        double NewV2x = (V2x /= this.itsRadius) * Math.cos(t1) - (V2y /= this.itsRadius) * Math.sin(t1);
        double NewV2y = -V2x * Math.sin(t1) - V2y * Math.cos(t1);
        double NewV3x = V3x * Math.cos(t1) - V3y * Math.sin(t1);
        double A3 = this.getAngle(NewV3x, NewV3y = -V3x * Math.sin(t1) - V3y * Math.cos(t1));
        if (A3 < 0.0) {
            A3 += Math.PI * 2;
        }
        if ((A2 = this.getAngle(NewV2x, NewV2y)) < 0.0) {
            A2 += Math.PI * 2;
        }
        this.itsArcAngle = (_hasIntersection = this.hasInter(this.itsCenterX, this.itsCenterY, x2, y2, x1, y1, x3, y3)) ? minangle : maxangle;
        if (A3 > A2) {
            this.itsArcAngle = -this.itsArcAngle;
        }
        double d2 = this.itsStartingAngle = this.itsStartingAngle >= 0.0 ? this.itsStartingAngle : Math.PI * 2 + this.itsStartingAngle;
        if (this.itsArcAngle < 0.0) {
            this.itsOrientation = 0;
            this.itsStartingAngle += this.itsArcAngle;
            this.itsStartingAngle = this.itsStartingAngle >= 0.0 ? this.itsStartingAngle : Math.PI * 2 + this.itsStartingAngle;
            this.itsArcAngle = -this.itsArcAngle;
        } else {
            this.itsOrientation = 1;
        }
    }

    @Override
    public int getOrientation() {
        return this.itsOrientation;
    }

    private boolean hasInter(double A1x, double A1y, double A2x, double A2y, double B1x, double B1y, double B2x, double B2y) {
        double ta = ((A1x - B1x) * (B2y - B1y) - (A1y - B1y) * (B2x - B1x)) / ((A2y - A1y) * (B2x - B1x) - (A2x - A1x) * (B2y - B1y));
        double tb = ((B1y - A1y) * (A2x - A1x) - (B1x - A1x) * (A2y - A1y)) / ((B2x - B1x) * (A2y - A1y) - (B2y - B1y) * (A2x - A1x));
        return ta <= 1.0 && ta >= 0.0 && tb <= 1.0 && tb >= 0.0;
    }

    @Override
    public boolean contains(CoorSys p) {
        return this.contains(p.itsX, p.itsY);
    }

    @Override
    public boolean contains(double x, double y) {
        if (this.distance(this.theP1.itsX, this.theP1.itsY, x, y) < 1.0E-22 || this.distance(this.theP3.itsX, this.theP3.itsY, x, y) < 1.0E-22) {
            return true;
        }
        double dx = x - this.itsCenterX;
        double dx1 = dx / this.itsRadius;
        double dy = y - this.itsCenterY;
        double dy1 = dy / this.itsRadius;
        double pointAngle = this.getAngle(dx1, dy1);
        pointAngle = pointAngle >= 0.0 ? pointAngle : Math.PI * 2 + pointAngle;
        double _endAngle = this.itsArcAngle + this.itsStartingAngle;
        if (_endAngle <= Math.PI * 2) {
            return pointAngle <= _endAngle && pointAngle >= this.itsStartingAngle;
        }
        return pointAngle >= this.itsStartingAngle || pointAngle <= (_endAngle -= Math.PI * 2);
    }

    @Override
    public void set3Points(CoorSys p1, CoorSys p2, CoorSys p3) {
        this.set3Points(p1.itsX, p1.itsY, p2.itsX, p2.itsY, p3.itsX, p3.itsY);
    }

    @Override
    public void get3Points(CoorSys p1, CoorSys p2, CoorSys p3) {
        p1.itsX = this.theP1.itsX;
        p1.itsY = this.theP1.itsY;
        p2.itsX = this.theP2.itsX;
        p2.itsY = this.theP2.itsY;
        p3.itsX = this.theP3.itsX;
        p3.itsY = this.theP3.itsY;
    }

    @Override
    public void translate(double dx, double dy) {
        this._st1.itsDefinedStatus = true;
        this._st1.itsCenterX = this.itsCenterX + dx;
        this._st1.itsCenterY = this.itsCenterX + dy;
        this._st1.itsRadius = this.itsRadius;
        this._st1.itsStartingAngle = this.itsStartingAngle;
        this._st1.itsArcAngle = this.itsArcAngle;
        if (this.theConstraint == null || this.theConstraint.isOk(this._st1)) {
            ArcState _st = this._st1;
            this.itsDeletedStatus = _st.itsDeletedStatus;
            this.itsDefinedStatus = _st.itsDefinedStatus;
            this.itsCenterX = _st.itsCenterX;
            this.itsCenterY = _st.itsCenterY;
            this.itsRadius = this._st1.itsRadius;
            this.itsStartingAngle = this._st1.itsStartingAngle;
            this.itsArcAngle = this._st1.itsArcAngle;
        } else if (this.itsFWSet != null) {
            this.forwardTranslate(dx, dy);
        }
    }

    @Override
    public void changeState(State _state) throws ClassCastException {
        if (this.theConstraint == null || this.theConstraint.isOk(_state)) {
            ArcState _st = (ArcState)_state;
            this.itsDeletedStatus = _st.itsDeletedStatus;
            this.itsDefinedStatus = _st.itsDefinedStatus;
            this.itsCenterX = _st.itsCenterX;
            this.itsCenterY = _st.itsCenterY;
            this.itsRadius = _st.itsRadius;
            this.itsStartingAngle = _st.itsStartingAngle;
            this.itsArcAngle = _st.itsArcAngle;
        }
    }

    @Override
    public void getState(State _state) throws ClassCastException {
        ArcState _st = (ArcState)_state;
        _st.itsMID = this.getMID();
        _st.itsDeletedStatus = this.itsDeletedStatus;
        _st.itsDefinedStatus = this.itsDefinedStatus;
        _st.itsCenterX = this.itsCenterX;
        _st.itsCenterY = this.itsCenterY;
        _st.itsRadius = this.itsRadius;
        _st.itsStartingAngle = this.itsStartingAngle;
        _st.itsArcAngle = this.itsArcAngle;
    }

    private double getAngle(double cosT, double senT) {
        if (cosT < -1.0) {
            cosT = -1.0;
        } else if (cosT > 1.0) {
            cosT = 1.0;
        }
        if (senT > 0.0) {
            return -1.0 * Math.acos(cosT);
        }
        return Math.acos(cosT);
    }

    private double getAngle(double x1, double y1, double x2, double y2) {
        double innerprod = (x1 * x2 + y1 * y2) / Math.sqrt((x1 * x1 + y1 * y1) * (x2 * x2 + y2 * y2));
        if (innerprod < -1.0 || innerprod > 1.0) {
            return Math.PI;
        }
        return Math.acos(innerprod);
    }

    private double distance(double x1, double y1, double x2, double y2) {
        return (x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2);
    }
}

