/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.kernel;

import br.ufrj.labma.enibam.kernel.AbstractKernelElement;
import br.ufrj.labma.enibam.kernel.KernelAxes;
import br.ufrj.labma.enibam.kernel.Program;
import br.ufrj.labma.enibam.kernel.operations.CoorSys;
import br.ufrj.labma.enibam.kernel.state.AxesState;
import br.ufrj.labma.enibam.kernel.state.State;
import br.ufrj.labma.enibam.util.MathVector;

public class KernelAxes3P
extends AbstractKernelElement
implements KernelAxes {
    protected double itsOriginX;
    protected double itsX1;
    protected double itsX2;
    protected double itsOriginY;
    protected double itsY1;
    protected double itsY2;

    public KernelAxes3P(Integer mid, Program prog) {
        super(mid, prog);
    }

    @Override
    public void getOrigin(CoorSys p) {
        p.itsX = this.itsOriginX;
        p.itsY = this.itsOriginY;
    }

    @Override
    public void getP1(CoorSys p) {
        p.itsX = this.itsX1;
        p.itsY = this.itsY1;
    }

    @Override
    public void getP2(CoorSys p) {
        p.itsX = this.itsX2;
        p.itsY = this.itsY2;
    }

    @Override
    public double getScale1() {
        double dx = this.itsX1 - this.itsOriginX;
        double dy = this.itsY1 - this.itsOriginY;
        return Math.sqrt(dx * dx + dy * dy);
    }

    @Override
    public double getScale2() {
        double dx = this.itsX2 - this.itsOriginX;
        double dy = this.itsY2 - this.itsOriginY;
        return Math.sqrt(dx * dx + dy * dy);
    }

    @Override
    public void getVectorOriginP1(MathVector v) {
        v.setXY(this.itsX1 - this.itsOriginX, this.itsY1 - this.itsOriginY);
    }

    @Override
    public void getVectorOriginP2(MathVector v) {
        v.setXY(this.itsX2 - this.itsOriginX, this.itsY2 - this.itsOriginY);
    }

    @Override
    public void setOrigin(CoorSys p) {
        this.itsOriginX = p.itsX;
        this.itsOriginY = p.itsY;
    }

    @Override
    public void setP1(CoorSys p) {
        this.itsX1 = p.itsX;
        this.itsY1 = p.itsY;
    }

    @Override
    public void setP2(CoorSys p) {
        this.itsX2 = p.itsX;
        this.itsY2 = p.itsY;
    }

    @Override
    public void changeState(State _state) throws ClassCastException {
        if (this.theConstraint == null || this.theConstraint.isOk(_state)) {
            AxesState _st = (AxesState)_state;
            this.itsDeletedStatus = _st.itsDeletedStatus;
            this.itsDefinedStatus = _st.itsDefinedStatus;
            this.itsOriginX = _st.itsOriginX;
            this.itsOriginY = _st.itsOriginY;
            this.itsX1 = _st.itsX1;
            this.itsX2 = _st.itsX2;
            this.itsY1 = _st.itsY1;
            this.itsY2 = _st.itsY2;
        }
    }

    @Override
    public void getState(State _state) throws ClassCastException {
        AxesState _st = (AxesState)_state;
        _st.itsMID = this.getMID();
        _st.itsDeletedStatus = this.itsDeletedStatus;
        _st.itsDefinedStatus = this.itsDefinedStatus;
        _st.itsOriginX = this.itsOriginX;
        _st.itsOriginY = this.itsOriginY;
        _st.itsX1 = this.itsX1;
        _st.itsX2 = this.itsX2;
        _st.itsY1 = this.itsY1;
        _st.itsY2 = this.itsY2;
    }
}

