/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.kernel;

import br.ufrj.labma.enibam.kernel.AbstractKernelCircleInterior;
import br.ufrj.labma.enibam.kernel.Program;
import br.ufrj.labma.enibam.kernel.operations.CoorSys;
import br.ufrj.labma.enibam.kernel.state.CircleInteriorState;
import br.ufrj.labma.enibam.kernel.state.State;

public class KernelCircleInterior2P
extends AbstractKernelCircleInterior {
    private double itsCenterX;
    private double itsCenterY;
    private double itsPointX;
    private double itsPointY;

    public KernelCircleInterior2P(Integer id, Program prog) {
        super(id, prog);
    }

    @Override
    public double getCenterX() {
        return this.itsCenterX;
    }

    @Override
    public double getCenterY() {
        return this.itsCenterY;
    }

    @Override
    public void getCenter(CoorSys ret) {
        ret.itsX = this.itsCenterX;
        ret.itsY = this.itsCenterY;
    }

    @Override
    public final double getRadius() {
        double distX = this.itsCenterX - this.itsPointX;
        double distY = this.itsCenterY - this.itsPointY;
        double dist = Math.sqrt(distX * distX + distY * distY);
        return dist;
    }

    public final double getRadius2() {
        double distX = this.itsCenterX - this.itsPointX;
        double distY = this.itsCenterY - this.itsPointY;
        return distX * distX + distY * distY;
    }

    @Override
    public double getArea() {
        double r2 = this.getRadius2();
        return Math.PI * r2;
    }

    @Override
    public void setCenterPoint(double xc, double yc, double xp, double yp) {
        this.itsCenterX = xc;
        this.itsCenterY = yc;
        this.itsPointX = xp;
        this.itsPointY = yp;
    }

    @Override
    public void setCenterPoint(CoorSys c, CoorSys p) {
        this.itsCenterX = c.itsX;
        this.itsCenterY = c.itsY;
        this.itsPointX = p.itsX;
        this.itsPointY = p.itsY;
    }

    @Override
    public void setCenterRadius(double xc, double yc, double r) {
        this.itsCenterX = xc;
        this.itsCenterY = yc;
        this.itsPointX = xc + r;
        this.itsPointY = yc;
    }

    @Override
    public void setCenterRadius(CoorSys c, double r) {
        this.itsCenterX = c.itsX;
        this.itsCenterY = c.itsY;
        this.itsPointX = c.itsX + r;
        this.itsPointY = c.itsY;
    }

    @Override
    public void set3Points(double x1, double y1, double x2, double y2, double x3, double y3) {
        double r = ((x1 - x2) * (x1 + x2) + (y1 - y2) * (y1 + y2)) / 2.0;
        double s = ((x2 - x3) * (x2 + x3) + (y2 - y3) * (y2 + y3)) / 2.0;
        double d = (x1 - x2) * (y2 - y3) - (x2 - x3) * (y1 - y2);
        if (Math.abs(d) < 1.0E-15) {
            this.setDefinedStatus(false);
            return;
        }
        this.itsCenterX = (r * (y2 - y3) - s * (y1 - y2)) / d;
        this.itsCenterY = (s * (x1 - x2) - r * (x2 - x3)) / d;
        this.itsPointX = x1;
        this.itsPointY = y1;
    }

    @Override
    public void set3Points(CoorSys p1, CoorSys p2, CoorSys p3) {
        double r = ((p1.itsX - p2.itsX) * (p1.itsX + p2.itsX) + (p1.itsY - p2.itsY) * (p1.itsY + p2.itsY)) / 2.0;
        double s = ((p2.itsX - p3.itsX) * (p2.itsX + p3.itsX) + (p2.itsY - p3.itsY) * (p2.itsY + p3.itsY)) / 2.0;
        double d = (p1.itsX - p2.itsX) * (p2.itsY - p3.itsY) - (p2.itsX - p3.itsX) * (p1.itsY - p2.itsY);
        if (Math.abs(d) < 1.0E-15) {
            this.setDefinedStatus(false);
            return;
        }
        this.itsCenterX = (r * (p2.itsY - p3.itsY) - s * (p1.itsY - p2.itsY)) / d;
        this.itsCenterY = (s * (p1.itsX - p2.itsX) - r * (p2.itsX - p3.itsX)) / d;
        this.itsPointX = p1.itsX;
        this.itsPointY = p1.itsY;
    }

    @Override
    public void changeState(State _state) throws ClassCastException {
        if (this.theConstraint == null || this.theConstraint.isOk(_state)) {
            CircleInteriorState _st = (CircleInteriorState)_state;
            this.itsDeletedStatus = _st.itsDeletedStatus;
            this.itsDefinedStatus = _st.itsDefinedStatus;
            this.itsCenterX = _st.itsCenterX;
            this.itsCenterY = _st.itsCenterY;
            this.itsPointX = this.itsCenterX;
            this.itsPointY = this.itsCenterY + _st.itsRadius;
        }
    }

    @Override
    public void getState(State _state) throws ClassCastException {
        CircleInteriorState _st = (CircleInteriorState)_state;
        _st.itsMID = this.getMID();
        _st.itsDeletedStatus = this.itsDeletedStatus;
        _st.itsDefinedStatus = this.itsDefinedStatus;
        _st.itsCenterX = this.itsCenterX;
        _st.itsCenterY = this.itsCenterY;
        _st.itsRadius = this.getRadius();
    }
}

