/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.kernel;

import br.ufrj.labma.enibam.kernel.AbstractKernelLocus;
import br.ufrj.labma.enibam.kernel.KernelArc;
import br.ufrj.labma.enibam.kernel.KernelCircle;
import br.ufrj.labma.enibam.kernel.KernelElement;
import br.ufrj.labma.enibam.kernel.KernelGenericLine;
import br.ufrj.labma.enibam.kernel.KernelLocus;
import br.ufrj.labma.enibam.kernel.KernelPoint;
import br.ufrj.labma.enibam.kernel.KernelRay;
import br.ufrj.labma.enibam.kernel.KernelSegment;
import br.ufrj.labma.enibam.kernel.Program;
import br.ufrj.labma.enibam.kernel.Translatable;
import br.ufrj.labma.enibam.kernel.dummy.KernelDummySegment;
import br.ufrj.labma.enibam.kernel.operations.CoorSys;
import br.ufrj.labma.enibam.kernel.state.LocusState;
import br.ufrj.labma.enibam.kernel.state.State;
import br.ufrj.labma.enibam.util.GraphicUtilities;
import br.ufrj.labma.enibam.util.MathVector;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class KernelCircleLocus
extends AbstractKernelLocus {
    private MathVector _v = new MathVector();
    private CoorSys auxl1 = new CoorSys();
    private CoorSys auxl2 = new CoorSys();

    public KernelCircleLocus(Integer id, Program prog) {
        super(id, prog);
    }

    @Override
    public void changeState(State _state) throws ClassCastException {
        if (this.theConstraint == null || this.theConstraint.isOk(_state)) {
            LocusState _st = (LocusState)_state;
            this.itsDeletedStatus = _st.itsDeletedStatus;
            this.itsDefinedStatus = _st.itsDefinedStatus;
            int _n = _st.pointList.size();
            int _i = 0;
            while (_i < this.itsPointList.size() && _i < _n) {
                CoorSys _p1 = (CoorSys)_st.pointList.get(_i);
                CoorSys _p2 = (CoorSys)this.itsPointList.get(_i);
                _p2.itsX = _p1.itsX;
                _p2.itsY = _p1.itsY;
                ++_i;
            }
        }
    }

    @Override
    public void getState(State _state) throws ClassCastException {
        if (this.itsPointList.size() == 0) {
            return;
        }
        LocusState _st = (LocusState)_state;
        _st.itsDeletedStatus = this.itsDeletedStatus;
        _st.itsDefinedStatus = this.itsDefinedStatus;
        int _i = 0;
        while (_i < this.itsPointList.size() && _i < _st.pointList.size()) {
            CoorSys _p1 = (CoorSys)_st.pointList.get(_i);
            CoorSys _p2 = (CoorSys)this.itsPointList.get(_i);
            _p1.itsX = _p2.itsX;
            _p1.itsY = _p2.itsY;
            ++_i;
        }
    }

    @Override
    public void initDefault(KernelElement I, KernelPoint P, int numElements, KernelElement path) {
        GraphicUtilities.loadScreenDimension();
        this.setType(path);
        this.itsPath = path;
        this.itsPointList = this.build(I, P, numElements);
    }

    @Override
    public List build(KernelElement I, KernelPoint P, int numElements) {
        Translatable _c;
        KernelDummySegment _e;
        CoorSys _par1 = new CoorSys();
        CoorSys _par2 = new CoorSys();
        CoorSys _startP = new CoorSys();
        ArrayList<CoorSys> _l = new ArrayList<CoorSys>(numElements + numElements);
        this.itsSegmentList = new ArrayList(numElements);
        P.getXY(_startP);
        KernelCircle _I = (KernelCircle)I;
        if (this.type == 0 || this.type == 1 || this.type == 2) {
            KernelGenericLine _line = (KernelGenericLine)this.itsPath;
            _line.getP1P2(this.auxl1, this.auxl2);
            double _n = this.itsSegmentList.size();
            double step = (1000.0 + 2.0 * _n) / _n;
            _line.getVector(this._v);
            this._v.unitario().productByNumber(step);
            double _vx = this._v.getX();
            double _vy = this._v.getY();
            double startx = 0.5 * (this.auxl1.itsX + this.auxl2.itsX);
            double starty = 0.5 * (this.auxl1.itsY + this.auxl2.itsY);
            startx -= 0.5 * _n * _vx;
            starty -= 0.5 * _n * _vy;
            int _ii = 0;
            while (_ii < numElements) {
                P.move(startx += _vx, starty += _vy);
                P.updateFromLocus();
                _I.getCenter(this.auxl1);
                _par1 = new CoorSys(this.auxl1.itsX, this.auxl1.itsY);
                _l.add(_par1);
                _par2 = new CoorSys(_I.getRadius(), 0.0);
                _l.add(_par2);
                _e = new KernelDummySegment(_par1, _par2);
                this.itsSegmentList.add(_e);
                ++_ii;
            }
        }
        if (this.type == 3) {
            _c = (KernelCircle)this.itsPath;
            double _cx = _c.getCenterX();
            double _cy = _c.getCenterY();
            this._v.setVector(_cx, _cy, P.getX(), P.getY());
            double _stepp = Math.PI * 2 / (double)(numElements - 1);
            int _ii = 0;
            while (_ii < numElements) {
                this._v.rotation(_stepp);
                P.move(_cx + this._v.getX(), _cy + this._v.getY());
                P.updateFromLocus();
                _I.getCenter(this.auxl1);
                _par1 = new CoorSys(this.auxl1.itsX, this.auxl1.itsY);
                _l.add(_par1);
                _par2 = new CoorSys(_I.getRadius(), 0.0);
                _l.add(_par2);
                _e = new KernelDummySegment(_par1, _par2);
                this.itsSegmentList.add(_e);
                ++_ii;
            }
        }
        if (this.type == 4) {
            KernelLocus _loc = (KernelLocus)this.itsPath;
            ArrayList _points = (ArrayList)_loc.getPointVector();
            int j = 0;
            int _s = _points.size();
            int _i = 0;
            while (_i < _s) {
                CoorSys _o = (CoorSys)_points.get(_i);
                P.setXY(_o.itsX, _o.itsY);
                P.updateFromLocus();
                _I.getCenter(this.auxl1);
                _par1 = new CoorSys(this.auxl1.itsX, this.auxl1.itsY);
                _l.add(_par1);
                _par2 = new CoorSys(_I.getRadius(), 0.0);
                _l.add(_par2);
                _e = new KernelDummySegment(_par1, _par2);
                this.itsSegmentList.add(_e);
                if (++j == numElements) break;
                _i += 2;
            }
        }
        if (this.type == 5) {
            _l.add(new CoorSys(_I.getCenterX(), _I.getCenterY()));
            _l.add(new CoorSys(_I.getRadius(), 0.0));
        }
        if (this.type == 6) {
            _c = (KernelArc)this.itsPath;
            double _cx = _c.getCenterX();
            double _cy = _c.getCenterY();
            double _cr = _c.getRadius();
            this._v.setVector(_cx, _cy, _cx + _cr, _cy);
            this._v.rotation(-_c.getStartingAngle());
            double _stepp = -_c.getArcAngle() / (double)(numElements - 1);
            int _ii = 0;
            while (_ii < numElements) {
                this._v.rotation(_stepp);
                P.move(_cx + this._v.getX(), _cy + this._v.getY());
                P.updateFromLocus();
                _I.getCenter(this.auxl1);
                _par1 = new CoorSys(this.auxl1.itsX, this.auxl1.itsY);
                _l.add(_par1);
                _par2 = new CoorSys(_I.getRadius(), 0.0);
                _l.add(_par2);
                _e = new KernelDummySegment(_par1, _par2);
                this.itsSegmentList.add(_e);
                ++_ii;
            }
        }
        P.setXY(_startP.itsX, _startP.itsY);
        P.updateFromLocus();
        return _l;
    }

    @Override
    public void calculate(KernelElement theI, KernelPoint theP) {
        Translatable _c;
        KernelDummySegment _kseg;
        CoorSys o;
        int _i;
        double startx;
        double _vy;
        double _vx;
        double step;
        KernelGenericLine _line;
        GraphicUtilities.getXResolution();
        GraphicUtilities.getYResolution();
        CoorSys old = null;
        boolean first = true;
        double _l = this.itsPointList.size();
        KernelCircle _theI = (KernelCircle)theI;
        Iterator _ks = this.itsSegmentList.iterator();
        if (this.type == 0) {
            _line = (KernelGenericLine)this.itsPath;
            _line.getP1P2(this.auxl1, this.auxl2);
            step = (1000.0 + 2.0 * (_l / 2.0)) / (_l / 2.0);
            _line.getVector(this._v);
            this._v.unitario().productByNumber(step);
            _vx = this._v.getX();
            _vy = this._v.getY();
            startx = 0.5 * (this.auxl1.itsX + this.auxl2.itsX);
            double starty = 0.5 * (this.auxl1.itsY + this.auxl2.itsY);
            startx -= 0.5 * (_l / 2.0) * _vx;
            starty -= 0.5 * (_l / 2.0) * _vy;
            _i = 0;
            _i = 0;
            while ((double)_i < _l) {
                o = (CoorSys)this.itsPointList.get(_i);
                old = (CoorSys)this.itsPointList.get(++_i);
                theP.move(startx += _vx, starty += _vy);
                theP.updateFromLocus();
                o.itsX = _theI.getCenterX();
                o.itsY = _theI.getCenterY();
                old.itsX = _theI.getRadius();
                if (!_theI.getDefinedStatus()) {
                    o.itsX = -10000.0;
                    o.itsY = -10000.0;
                    old.itsX = 0.0;
                }
                if (first) {
                    first = false;
                } else {
                    _kseg = (KernelDummySegment)_ks.next();
                    _kseg.setP1P2(old, o);
                }
                ++_i;
            }
        }
        if (this.type == 1) {
            _line = (KernelSegment)this.itsPath;
            _line.getP1P2(this.auxl1, this.auxl2);
            _line.getVector(this._v);
            double _vx2 = 2.0 * this._v.getX() / _l;
            double _vy2 = 2.0 * this._v.getY() / _l;
            double startx2 = this.auxl1.itsX;
            double starty = this.auxl1.itsY;
            int _ii = 0;
            while ((double)_ii < _l) {
                o = (CoorSys)this.itsPointList.get(_ii);
                old = (CoorSys)this.itsPointList.get(++_ii);
                theP.move(startx2 += _vx2, starty += _vy2);
                theP.updateFromLocus();
                o.itsX = _theI.getCenterX();
                o.itsY = _theI.getCenterY();
                old.itsX = _theI.getRadius();
                if (!_theI.getDefinedStatus()) {
                    old.itsX = 0.0;
                    o.itsX = -10000.0;
                    o.itsY = -10000.0;
                }
                if (first) {
                    first = false;
                } else {
                    _kseg = (KernelDummySegment)_ks.next();
                    _kseg.setP1P2(old, o);
                }
                ++_ii;
            }
        }
        if (this.type == 2) {
            _line = (KernelRay)this.itsPath;
            _line.getP1P2(this.auxl1, this.auxl2);
            step = (1000.0 + 2.0 * (_l / 2.0)) / (_l / 2.0);
            _line.getVector(this._v);
            this._v.unitario().productByNumber(step);
            _vx = this._v.getX();
            _vy = this._v.getY();
            startx = this.auxl1.itsX;
            double starty = this.auxl1.itsY;
            _i = 0;
            _i = 0;
            while ((double)_i < _l) {
                o = (CoorSys)this.itsPointList.get(_i);
                old = (CoorSys)this.itsPointList.get(++_i);
                theP.move(startx += _vx, starty += _vy);
                theP.updateFromLocus();
                o.itsX = _theI.getCenterX();
                o.itsY = _theI.getCenterY();
                old.itsX = _theI.getRadius();
                if (!_theI.getDefinedStatus()) {
                    o.itsX = -10000.0;
                    o.itsY = -10000.0;
                    old.itsX = 0.0;
                }
                if (first) {
                    first = false;
                } else {
                    _kseg = (KernelDummySegment)_ks.next();
                    _kseg.setP1P2(old, o);
                }
                ++_i;
            }
        }
        if (this.type == 3) {
            _c = (KernelCircle)this.itsPath;
            double _cx = _c.getCenterX();
            double _cy = _c.getCenterY();
            this._v.setVector(_cx, _cy, theP.getX(), theP.getY());
            _l = this.itsSegmentList.size() - 1;
            double _stepp = Math.PI * 2 / _l;
            int _i2 = 0;
            while (_i2 < this.itsPointList.size()) {
                o = (CoorSys)this.itsPointList.get(_i2);
                old = (CoorSys)this.itsPointList.get(++_i2);
                this._v.rotation(_stepp);
                theP.move(_cx + this._v.getX(), _cy + this._v.getY());
                theP.updateFromLocus();
                o.itsX = _theI.getCenterX();
                o.itsY = _theI.getCenterY();
                old.itsX = _theI.getRadius();
                _kseg = (KernelDummySegment)_ks.next();
                _kseg.setP1P2(old, o);
                ++_i2;
            }
        }
        if (this.type == 4) {
            KernelLocus _loc = (KernelLocus)this.itsPath;
            ArrayList _points = (ArrayList)_loc.getPointVector();
            int _s = this.itsPointList.size();
            int _i3 = 0;
            while (_i3 < _s) {
                CoorSys _p = (CoorSys)_points.get(_i3);
                o = (CoorSys)this.itsPointList.get(_i3);
                old = (CoorSys)this.itsPointList.get(++_i3);
                theP.setXY(_p.itsX, _p.itsY);
                theP.updateFromLocus();
                o.itsX = _theI.getCenterX();
                o.itsY = _theI.getCenterY();
                old.itsX = _theI.getRadius();
                _kseg = (KernelDummySegment)_ks.next();
                _kseg.setP1P2(old, o);
                ++_i3;
            }
        }
        if (this.type == 5) {
            // empty if block
        }
        if (this.type == 6) {
            _c = (KernelArc)this.itsPath;
            double _cx = _c.getCenterX();
            double _cy = _c.getCenterY();
            double _cr = _c.getRadius();
            this._v.setVector(_cx, _cy, _cx + _cr, _cy);
            this._v.rotation(-_c.getStartingAngle());
            _l = this.itsSegmentList.size() - 1;
            double _stepp = -_c.getArcAngle() / _l;
            int _i4 = 0;
            while (_i4 < this.itsPointList.size()) {
                o = (CoorSys)this.itsPointList.get(_i4);
                old = (CoorSys)this.itsPointList.get(++_i4);
                this._v.rotation(_stepp);
                theP.move(_cx + this._v.getX(), _cy + this._v.getY());
                theP.updateFromLocus();
                o.itsX = _theI.getCenterX();
                o.itsY = _theI.getCenterY();
                old.itsX = _theI.getRadius();
                _kseg = (KernelDummySegment)_ks.next();
                _kseg.setP1P2(old, o);
                ++_i4;
            }
        }
    }
}

