/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.kernel;

import br.ufrj.labma.enibam.kernel.AbstractKernelCircularSegment;
import br.ufrj.labma.enibam.kernel.Program;
import br.ufrj.labma.enibam.kernel.operations.CoorSys;
import br.ufrj.labma.enibam.kernel.state.CircularSegmentState;
import br.ufrj.labma.enibam.kernel.state.State;

public class KernelCircularSegment2PC
extends AbstractKernelCircularSegment {
    private double itsCenterX;
    private double itsCenterY;
    private double itsRadius;
    private double itsStartingAngle;
    private double itsAngle;
    private CoorSys theP2 = new CoorSys();
    private CoorSys theP3 = new CoorSys();
    private CoorSys _u = new CoorSys();
    private CoorSys _v = new CoorSys();
    private CoorSys Vba = new CoorSys();
    private CoorSys Vbc = new CoorSys();

    public KernelCircularSegment2PC(Integer id, Program prog) {
        super(id, prog);
    }

    @Override
    public double getCenterX() {
        return this.itsCenterX;
    }

    @Override
    public double getCenterY() {
        return this.itsCenterY;
    }

    @Override
    public void getCenter(CoorSys ret) {
        ret.itsX = this.itsCenterX;
        ret.itsY = this.itsCenterY;
    }

    @Override
    public final double getRadius() {
        return this.itsRadius;
    }

    @Override
    public double getStartingAngle() {
        return this.itsStartingAngle;
    }

    @Override
    public double getAngle() {
        return this.itsAngle;
    }

    @Override
    public double getArea() {
        double arcArea = Math.abs(this.itsRadius * this.itsRadius * this.itsAngle) / 2.0;
        double b = Math.sqrt((this.theP2.itsX - this.theP3.itsX) * (this.theP2.itsX - this.theP3.itsX) + (this.theP2.itsY - this.theP3.itsY) * (this.theP2.itsY - this.theP3.itsY));
        double h = this.itsRadius * Math.cos(this.itsAngle / 2.0);
        double triangleArea = b * h / 2.0;
        return arcArea - triangleArea;
    }

    @Override
    public void set3Points(double x1, double y1, double x2, double y2, double x3, double y3) {
        this.itsCenterX = x1;
        this.itsCenterY = y1;
        this.theP2.itsX = x2;
        this.theP2.itsY = y2;
        this.theP3.itsX = x3;
        this.theP3.itsY = y3;
        this.itsRadius = Math.sqrt((this.theP2.itsX - this.itsCenterX) * (this.theP2.itsX - this.itsCenterX) + (this.theP2.itsY - this.itsCenterY) * (this.theP2.itsY - this.itsCenterY));
        this._u.itsX = this.itsCenterX + this.itsRadius;
        this._u.itsY = this.itsCenterY;
        this._v.itsX = this.itsCenterX;
        this._v.itsY = this.itsCenterY;
        this.itsStartingAngle = this.getAngle(this._u, this._v, this.theP2);
        double _angle = this.getAngle(this.theP2, this._v, this.theP3);
        if (_angle < 0.0) {
            _angle += Math.PI * 2;
        }
        this.itsAngle = _angle;
    }

    @Override
    public void set3Points(CoorSys p1, CoorSys p2, CoorSys p3) {
        this.set3Points(p1.itsX, p1.itsY, p2.itsX, p2.itsY, p3.itsX, p3.itsY);
    }

    @Override
    public void get3Points(CoorSys p1, CoorSys p2, CoorSys p3) {
        p1.itsX = this.itsCenterX;
        p1.itsY = this.itsCenterY;
        p2.itsX = this.theP2.itsX;
        p2.itsY = this.theP2.itsY;
        p3.itsX = this.theP3.itsX;
        p3.itsY = this.theP3.itsY;
    }

    @Override
    public void changeState(State _state) throws ClassCastException {
        if (this.theConstraint == null || this.theConstraint.isOk(_state)) {
            CircularSegmentState _st = (CircularSegmentState)_state;
            this.itsDeletedStatus = _st.itsDeletedStatus;
            this.itsDefinedStatus = _st.itsDefinedStatus;
            this.itsCenterX = _st.itsCenterX;
            this.itsCenterY = _st.itsCenterY;
            this.itsRadius = _st.itsRadius;
            this.itsStartingAngle = _st.itsStartingAngle;
            this.itsAngle = _st.itsAngle;
        }
    }

    @Override
    public void getState(State _state) throws ClassCastException {
        CircularSegmentState _st = (CircularSegmentState)_state;
        _st.itsMID = this.getMID();
        _st.itsDeletedStatus = this.itsDeletedStatus;
        _st.itsDefinedStatus = this.itsDefinedStatus;
        _st.itsCenterX = this.itsCenterX;
        _st.itsCenterY = this.itsCenterY;
        _st.itsRadius = this.itsRadius;
        _st.itsStartingAngle = this.itsStartingAngle;
        _st.itsAngle = this.itsAngle;
    }

    private double getAngle(CoorSys A, CoorSys B, CoorSys C) {
        double ab_sin;
        this.Vba.itsX = A.itsX - B.itsX;
        this.Vba.itsY = A.itsY - B.itsY;
        this.Vbc.itsX = C.itsX - B.itsX;
        this.Vbc.itsY = C.itsY - B.itsY;
        double cos = (this.Vba.itsX * this.Vbc.itsX + this.Vba.itsY * this.Vbc.itsY) / (Math.sqrt(this.Vba.itsX * this.Vba.itsX + this.Vba.itsY * this.Vba.itsY) * Math.sqrt(this.Vbc.itsX * this.Vbc.itsX + this.Vbc.itsY * this.Vbc.itsY));
        if (cos > 1.0) {
            cos = 1.0;
        }
        if (cos < -1.0) {
            cos = -1.0;
        }
        double _angle = (ab_sin = this.Vba.itsX * this.Vbc.itsY - this.Vba.itsY * this.Vbc.itsX) >= 0.0 ? Math.acos(cos) : -Math.acos(cos);
        return _angle;
    }
}

