/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.kernel;

import br.ufrj.labma.enibam.kernel.AbstractKernelConic;
import br.ufrj.labma.enibam.kernel.Program;
import br.ufrj.labma.enibam.kernel.dummy.KernelDummySegment;
import br.ufrj.labma.enibam.kernel.operations.CoorSys;
import br.ufrj.labma.enibam.kernel.state.ConicState;
import br.ufrj.labma.enibam.kernel.state.State;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class KernelConic5P
extends AbstractKernelConic {
    private int NP = 401;
    private static int HIPERBOLE = 0;
    private static int ELIPSE = 1;
    private static int PARABOLA = 2;
    private int TIPO_CONICA = 0;
    private double a = 0.0;
    private double b = 0.0;
    private double c = 0.0;
    private double d = 0.0;
    private double e = 0.0;
    private double f = 0.0;
    private double acanonico = 0.0;
    private double ccanonico = 0.0;
    private double angulorot;
    private double x0;
    private double y0;
    private CoorSys old = new CoorSys(0.0, 0.0);
    private ConicState _st = new ConicState();

    public KernelConic5P(Integer id, Program prog) {
        super(id, prog);
        this.init1();
    }

    public void init1() {
        this.itsPointList = new ArrayList(this.NP);
        this.itsSegmentList = new ArrayList(this.NP - 1);
        int i = 0;
        while (i < this.NP) {
            this.itsPointList.add(new CoorSys(0.0, 0.0));
            ++i;
        }
        Object _o1 = this.itsPointList.get(0);
        int _i = 1;
        while (_i < this.NP) {
            Object _o2 = this.itsPointList.get(_i);
            KernelDummySegment _e = new KernelDummySegment((CoorSys)_o1, (CoorSys)_o2);
            this.itsSegmentList.add(_e);
            _o1 = _o2;
            ++_i;
        }
    }

    @Override
    public void changeState(State _state) throws ClassCastException {
        if (this.theConstraint == null || this.theConstraint.isOk(_state)) {
            ConicState _st = (ConicState)_state;
            this.itsDeletedStatus = _st.itsDeletedStatus;
            this.itsDefinedStatus = _st.itsDefinedStatus;
            int _n = _st.pointList.size();
            int _i = 0;
            while (_i < _n) {
                CoorSys _p1 = (CoorSys)_st.pointList.get(_i);
                CoorSys _p2 = (CoorSys)this.itsPointList.get(_i);
                _p2.itsX = _p1.itsX;
                _p2.itsY = _p1.itsY;
                ++_i;
            }
        }
    }

    @Override
    public void getState(State _state) throws ClassCastException {
        ConicState _st = (ConicState)_state;
        _st.itsDeletedStatus = this.itsDeletedStatus;
        _st.itsDefinedStatus = this.itsDefinedStatus;
        int _n = _st.pointList.size();
        int _i = 0;
        while (_i < _n) {
            CoorSys _p1 = (CoorSys)_st.pointList.get(_i);
            CoorSys _p2 = (CoorSys)this.itsPointList.get(_i);
            _p1.itsX = _p2.itsX;
            _p1.itsY = _p2.itsY;
            ++_i;
        }
    }

    @Override
    public void translate(double dx, double dy) {
        this._st.itsDefinedStatus = true;
        int _n = this._st.pointList.size();
        int _i = 0;
        while (_i < _n) {
            CoorSys _p1 = (CoorSys)this._st.pointList.get(_i);
            CoorSys _p2 = (CoorSys)this.itsPointList.get(_i);
            _p1.itsX = _p2.itsX + dx;
            _p1.itsY = _p2.itsY + dy;
            ++_i;
        }
        if (this.theConstraint == null || this.theConstraint.isOk(this._st)) {
            this.itsDeletedStatus = this._st.itsDeletedStatus;
            this.itsDefinedStatus = this._st.itsDefinedStatus;
            int _n2 = this._st.pointList.size();
            int _i2 = 0;
            while (_i2 < _n2) {
                CoorSys _p1 = (CoorSys)this._st.pointList.get(_i2);
                CoorSys _p2 = (CoorSys)this.itsPointList.get(_i2);
                _p2.itsX = _p1.itsX;
                _p2.itsY = _p1.itsY;
                ++_i2;
            }
        } else if (this.itsFWSet != null) {
            this.forwardTranslate(dx, dy);
        }
    }

    @Override
    public void calculate(List plist) {
        KernelDummySegment _kseg;
        int i;
        double disc;
        CoorSys _c = (CoorSys)plist.get(0);
        double Ax = _c.itsX;
        double Ay = _c.itsY;
        _c = (CoorSys)plist.get(1);
        double Bx = _c.itsX;
        double By = _c.itsY;
        _c = (CoorSys)plist.get(2);
        double Cx = _c.itsX;
        double Cy = _c.itsY;
        _c = (CoorSys)plist.get(3);
        double Dx = _c.itsX;
        double Dy = _c.itsY;
        _c = (CoorSys)plist.get(4);
        double Ex = _c.itsX;
        double Ey = _c.itsY;
        double fator = (Math.abs(Ax) + Math.abs(Bx) + Math.abs(Cx) + Math.abs(Dx) + Math.abs(Ex)) / 5.0;
        if (fator < 1.0E-5 && fator > -1.0E-5) {
            fator = 1.0;
        }
        Ax /= fator;
        Ay /= fator;
        Bx /= fator;
        By /= fator;
        Cx /= fator;
        Cy /= fator;
        Dx /= fator;
        Ex /= fator;
        Ey /= fator;
        double tmp0 = Ax * (Dy /= fator);
        double tmp1 = By * Cx;
        double tmp2 = Bx * Cy;
        double tmp3 = Dx * By;
        double tmp4 = Ay * Dx;
        double eq1ind = -tmp0 * tmp1 + tmp0 * tmp2 + tmp4 * tmp1 - tmp4 * tmp2;
        double eq1x2 = Ay * By - Ay * Cy - Dy * By + Dy * Cy;
        double eq1y2 = Ax * Bx - Ax * Cx - Dx * Bx + Dx * Cx;
        double eq1xy = -Ax * By + Ax * Cy - Ay * Bx + Ay * Cx + Dy * Bx - Dy * Cx + tmp3 - Dx * Cy;
        double eq1x = tmp0 * By - tmp0 * Cy - Ay * tmp3 + tmp4 * Cy - Ay * tmp1 + Ay * tmp2 + Dy * tmp1 - Dy * tmp2;
        double eq1y = -tmp0 * Bx + tmp0 * Cx + Ax * tmp1 - Ax * tmp2 + tmp4 * Bx - tmp4 * Cx - Dx * tmp1 + Dx * tmp2;
        double eq2ind = tmp0 * tmp2 - Ax * tmp3 * Cy - Ay * Dy * Bx * Cx + tmp4 * tmp1;
        double eq2x2 = -Ay * Dy + Ay * By + Dy * Cy - By * Cy;
        double eq2y2 = -Ax * Dx + Ax * Bx + Dx * Cx - Bx * Cx;
        double eq2xy = tmp0 - Ax * By + tmp4 - Ay * Bx - Dy * Cx - Dx * Cy + tmp1 + tmp2;
        double eq2x = -tmp0 * Cy + Ax * By * Cy + Ay * Dy * Bx + Ay * Dy * Cx - Ay * tmp3 - Ay * tmp1 - Dy * tmp2 + tmp3 * Cy;
        double eq2y = -tmp0 * Bx + Ax * tmp3 + Ax * Dx * Cy - Ax * tmp2 - tmp4 * Cx + Ay * Bx * Cx + Dy * Bx * Cx - Dx * tmp1;
        double res1 = eq1x2 * Ex * Ex + eq1y2 * Ey * Ey + eq1xy * Ex * Ey + eq1x * Ex + eq1y * Ey + eq1ind;
        double res2 = eq2x2 * Ex * Ex + eq2y2 * Ey * Ey + eq2xy * Ex * Ey + eq2x * Ex + eq2y * Ey + eq2ind;
        if (res2 < 1.0E-9 && res2 > -1.0E-9) {
            this.a = eq2x2;
            this.b = eq2xy;
            this.c = eq2y2;
            this.d = eq2x;
            this.e = eq2y;
            this.f = eq2ind;
        } else {
            double lambda = -res1 / res2;
            this.a = eq1x2 + lambda * eq2x2;
            this.c = eq1y2 + lambda * eq2y2;
            this.b = eq1xy + lambda * eq2xy;
            this.d = eq1x + lambda * eq2x;
            this.e = eq1y + lambda * eq2y;
            this.f = eq1ind + lambda * eq2ind;
        }
        if (Math.abs(this.f) > 1.0E-5) {
            this.a /= this.f;
            this.b /= this.f;
            this.c /= this.f;
            this.d /= this.f;
            this.e /= this.f;
            this.f = 1.0;
        }
        this.TIPO_CONICA = Math.abs(disc = this.b * this.b - 4.0 * this.a * this.c) < 1.0E-9 ? PARABOLA : (disc > -1.0E-10 ? HIPERBOLE : ELIPSE);
        this.angulorot = 0.7853981633974483;
        if (Math.abs(this.a - this.c) > 1.0E-5) {
            this.angulorot = Math.atan(this.b / (this.a - this.c)) / 2.0;
            if (this.angulorot < 0.0) {
                this.angulorot += 1.5707963267948966;
            }
        }
        this.x0 = 0.0;
        this.y0 = 0.0;
        this.acanonico = 0.0;
        this.ccanonico = 0.0;
        if (this.TIPO_CONICA != PARABOLA) {
            this.x0 = (2.0 * this.c * this.d - this.b * this.e) / (this.b * this.b - 4.0 * this.a * this.c);
            this.y0 = (2.0 * this.a * this.e - this.b * this.d) / (this.b * this.b - 4.0 * this.a * this.c);
            this.f = 0.5 * this.d * this.x0 + 0.5 * this.e * this.y0 + this.f;
            if (this.f < 1.0E-12 && this.f > -1.0E-12) {
                this.f = 1.0E-12;
            }
            if (Math.abs(this.angulorot) > 1.0E-5) {
                this.acanonico = 0.5 * (this.b * Math.sqrt(Math.pow((this.a - this.c) / this.b, 2.0) + 1.0) + this.a + this.c);
                this.ccanonico = this.a + this.c - this.acanonico;
            } else {
                this.acanonico = this.a;
                this.ccanonico = this.c;
            }
            this.acanonico /= -this.f;
            this.ccanonico /= -this.f;
            this.f = 1.0;
            if (this.TIPO_CONICA == HIPERBOLE && this.acanonico < 0.0 && this.ccanonico > 0.0) {
                double tmp = this.acanonico;
                this.acanonico = this.ccanonico;
                this.ccanonico = tmp;
                this.angulorot += 1.5707963267948966;
            }
            this.acanonico = 1.0 / Math.sqrt(Math.abs(this.acanonico));
            this.ccanonico = 1.0 / Math.sqrt(Math.abs(this.ccanonico));
        }
        Iterator _ks = this.itsSegmentList.iterator();
        double npontos = this.NP;
        double x1 = this.acanonico;
        double y1 = 0.0;
        double xn = 0.0;
        double yn = 0.0;
        if (this.TIPO_CONICA == ELIPSE) {
            double dtheta = Math.PI * 2 / (npontos - 1.0);
            double cosdtheta = Math.cos(dtheta);
            double sindtheta = Math.sin(dtheta);
            double a1 = this.acanonico / this.ccanonico;
            double cosang = Math.cos(this.angulorot);
            double sinang = Math.sin(this.angulorot);
            i = 0;
            while ((double)i < npontos) {
                xn = x1 * cosdtheta - a1 * y1 * sindtheta;
                yn = x1 * sindtheta / a1 + y1 * cosdtheta;
                x1 = xn;
                y1 = yn;
                double xtmp = xn * cosang - yn * sinang;
                double ytmp = xn * sinang + yn * cosang;
                xn = xtmp;
                yn = ytmp;
                _c = (CoorSys)this.itsPointList.get(i);
                _c.itsX = (xn += this.x0) * fator;
                _c.itsY = (yn += this.y0) * fator;
                if (i > 1) {
                    _kseg = (KernelDummySegment)_ks.next();
                    _kseg.setP1P2(this.old, _c);
                }
                this.old.itsX = _c.itsX;
                this.old.itsY = _c.itsY;
                ++i;
            }
        }
        if (this.TIPO_CONICA == HIPERBOLE) {
            double xmax = this.acanonico + 300.0;
            double thetamax = Math.log(xmax / this.acanonico + Math.sqrt(xmax / this.acanonico * (xmax / this.acanonico) - 1.0));
            double dtheta = thetamax / (npontos / 4.0 - 1.0);
            double coshdtheta = this.cosh(dtheta);
            double sinhdtheta = this.sinh(dtheta);
            double a1 = this.acanonico / this.ccanonico;
            i = 0;
            while ((double)i < npontos / 4.0) {
                xn = x1 * coshdtheta + a1 * y1 * sinhdtheta;
                yn = x1 * sinhdtheta / a1 + y1 * coshdtheta;
                x1 = xn;
                y1 = yn;
                _c = (CoorSys)this.itsPointList.get((int)((double)i + npontos / 4.0));
                _c.itsX = xn;
                _c.itsY = yn;
                CoorSys atmp = (CoorSys)this.itsPointList.get((int)(npontos / 4.0 - (double)i - 1.0));
                atmp.itsX = _c.itsX;
                atmp.itsY = -_c.itsY;
                atmp = (CoorSys)this.itsPointList.get((int)((double)i + 3.0 * npontos / 4.0));
                atmp.itsX = -_c.itsX;
                atmp.itsY = _c.itsY;
                atmp = (CoorSys)this.itsPointList.get((int)(3.0 * npontos / 4.0 - (double)i - 1.0));
                atmp.itsX = -_c.itsX;
                atmp.itsY = -_c.itsY;
                ++i;
            }
            double cosang = Math.cos(this.angulorot);
            double sinang = Math.sin(this.angulorot);
            int i2 = 0;
            while ((double)i2 < npontos) {
                _c = (CoorSys)this.itsPointList.get(i2);
                double xtmp = _c.itsX * cosang - _c.itsY * sinang;
                double ytmp = _c.itsX * sinang + _c.itsY * cosang;
                _c.itsX = xtmp;
                _c.itsY = ytmp;
                _c.itsX += this.x0;
                _c.itsY += this.y0;
                _c.itsX *= fator;
                _c.itsY *= fator;
                if (i2 != 0) {
                    _kseg = (KernelDummySegment)_ks.next();
                    _kseg.setP1P2(this.old, _c);
                }
                this.old.itsX = _c.itsX;
                this.old.itsY = _c.itsY;
                ++i2;
            }
        }
    }

    @Override
    public double[] getEquation() {
        double[] g = new double[]{this.a, this.b, this.c, this.d, this.e, this.f};
        return g;
    }

    private double cosh(double a) {
        return (Math.pow(Math.E, a) + Math.pow(Math.E, -a)) * 0.5;
    }

    private double sinh(double a) {
        return (Math.pow(Math.E, a) - Math.pow(Math.E, -a)) * 0.5;
    }
}

