/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.kernel;

import br.ufrj.labma.enibam.kernel.CachedGraphManager;
import br.ufrj.labma.enibam.kernel.ConstraintComparator;
import br.ufrj.labma.enibam.kernel.FactoryCreationParameter;
import br.ufrj.labma.enibam.kernel.GraphManager;
import br.ufrj.labma.enibam.kernel.InstanceManager;
import br.ufrj.labma.enibam.kernel.KernelFactory;
import br.ufrj.labma.enibam.kernel.KernelFactory2;
import br.ufrj.labma.enibam.kernel.KernelUnitaryMeasure;
import br.ufrj.labma.enibam.kernel.ProgramManager;

public class KernelEnvironment {
    private KernelFactory itsKF;
    private InstanceManager itsIM;
    private GraphManager itsGM = new CachedGraphManager();
    private ProgramManager itsPM = new ProgramManager();
    private ConstraintComparator itsConstComp;
    private KernelUnitaryMeasure theFreeKernelUnitaryMeasure;

    public KernelEnvironment() {
        this.itsIM = new InstanceManager();
        this.itsConstComp = new ConstraintComparator(this.itsGM);
        this.itsKF = new KernelFactory2();
        this.itsKF.initFactory(this);
        FactoryCreationParameter FCP = new FactoryCreationParameter(new Integer(1100), null);
        int[] mid = this.itsKF.create(FCP);
        this.theFreeKernelUnitaryMeasure = (KernelUnitaryMeasure)this.itsIM.getInstance(new Integer(mid[0]));
    }

    public KernelFactory getKernelFactory() {
        return this.itsKF;
    }

    public InstanceManager getInstanceManager() {
        return this.itsIM;
    }

    public GraphManager getGraphManager() {
        return this.itsGM;
    }

    public ProgramManager getProgramManager() {
        return this.itsPM;
    }

    public ConstraintComparator getConstraintComparator() {
        return this.itsConstComp;
    }

    public KernelUnitaryMeasure getUnitaryMeasure() {
        return this.theFreeKernelUnitaryMeasure;
    }

    public boolean setUnitaryMeasure(Integer id) {
        KernelUnitaryMeasure um = (KernelUnitaryMeasure)this.itsIM.getInstance(id);
        if (um != null) {
            this.theFreeKernelUnitaryMeasure = um;
            return true;
        }
        return false;
    }
}

