/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.kernel;

import br.ufrj.labma.enibam.kernel.ConstructionIDMap;
import br.ufrj.labma.enibam.kernel.FactoryCreationParameter;
import br.ufrj.labma.enibam.kernel.GraphManager;
import br.ufrj.labma.enibam.kernel.InstanceManager;
import br.ufrj.labma.enibam.kernel.KernelElement;
import br.ufrj.labma.enibam.kernel.KernelEnvironment;
import br.ufrj.labma.enibam.kernel.KernelFactory;
import br.ufrj.labma.enibam.kernel.KernelFactoryInitializer;
import br.ufrj.labma.enibam.kernel.KernelFactoryRegister;
import br.ufrj.labma.enibam.kernel.ProgramManager;
import br.ufrj.labma.enibam.kernel.builder.Builder;
import br.ufrj.labma.enibam.kernel.constraint.Constraint;
import br.ufrj.labma.enibam.kernel.exception.BuilderException;
import br.ufrj.labma.enibam.kernel.exception.ConstructionNotFoundException;
import br.ufrj.labma.enibam.kernel.exception.ElementNotFoundException;
import br.ufrj.labma.enibam.kernel.exception.InvalidParameterException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class KernelFactory2
implements KernelFactory,
KernelFactoryRegister {
    private int nextMID = 1;
    private KernelEnvironment KEnv;
    private GraphManager GM;
    private ProgramManager PM;
    private InstanceManager IM;
    private FactoryCreationParameterStore FCPStore;
    private ZombiManipulator ZM;
    private Map itsBuilderMap = new HashMap();
    private Map itsDestroyerMap = new HashMap();

    public KernelFactory2() {
        this.FCPStore = new FactoryCreationParameterStore();
        this.ZM = new ZombiManipulator();
    }

    @Override
    public void initFactory(KernelEnvironment ke) {
        this.KEnv = ke;
        this.GM = this.KEnv.getGraphManager();
        this.IM = this.KEnv.getInstanceManager();
        this.PM = this.KEnv.getProgramManager();
        KernelFactoryInitializer.loadBuilders(this);
    }

    @Override
    public int[] getSiblings(FactoryCreationParameter FCP) {
        return this.FCPStore.mathIdentificationOf(FCP);
    }

    @Override
    public void attach(Builder b) {
        this.itsBuilderMap.put(b.getConstructionID(), b);
        b.setEnvironment(this.KEnv);
    }

    @Override
    public void deattach(Builder b) {
        this.itsBuilderMap.remove(b.getConstructionID());
    }

    @Override
    public int[] create(FactoryCreationParameter param) throws InvalidParameterException, ConstructionNotFoundException, BuilderException {
        int[] mid;
        Integer CID = param.getConstructionID();
        int cid = CID;
        if ((ConstructionIDMap.isOutputConstruction(cid) || ConstructionIDMap.isInversePropagationConstruction(cid)) && this.FCPStore.hasAlreadyBeenConstructed(param)) {
            System.out.println(param + " j\u00e1 foi constru\u00eddo!\n");
            mid = this.FCPStore.mathIdentificationOf(param);
        } else {
            try {
                Builder c = (Builder)this.itsBuilderMap.get(CID);
                if (c == null) {
                    throw new ConstructionNotFoundException("Constru\u00e7\u00e3o n\u00e3o dispon\u00edvel na Factory.");
                }
                mid = c.create(param);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidParameterException("Erro na passagem de Par\u00e2mentros para KernelFactory.\nVerifique se os MathID's da lista de argumentos representam Elementos\n do tipo certo e se est\u00e3o na ordem certa.");
            }
        }
        if (mid.length == 2 && mid[1] < mid[0]) {
            this.FCPStore.addConstructedElement(new int[]{mid[0]}, param);
        } else {
            this.FCPStore.addConstructedElement(mid, param);
        }
        this.ZM.removeZombi(mid);
        return mid;
    }

    @Override
    public Set destroy(Integer MID) {
        KernelElement ke = this.IM.getInstance(MID);
        Constraint c = ke.getConstraint();
        Set s = this.GM.removeAllChildren(MID);
        if (this.ZM.cantDelete(MID)) {
            s.remove(MID);
            this.ZM.addZombi(MID);
        } else if (c != null) {
            int i = 0;
            while (i < c.getOutputNumber()) {
                Integer _MID = c.getOutput(i).getMID();
                s.add(_MID);
                this.GM.remove(_MID);
                ++i;
            }
        } else {
            s.add(MID);
            this.GM.remove(MID);
        }
        System.out.println(s);
        for (Integer MID2 : s) {
            ke = this.IM.getInstance(MID2);
            this.PM.removeConstraint(ke.getConstraint());
            this.PM.removeProgram(ke.getProgram());
            ke.setConstraint(null);
            ke.setProgram(null);
            this.ZM.removeZombi(MID2);
            this.IM.remove(MID2);
            this.FCPStore.remove(MID2);
        }
        s.add(MID);
        return s;
    }

    @Override
    public void filterZombis(Set s) {
        this.ZM.filterZombis(s);
    }

    @Override
    public void checkExistence(Integer MID) {
        if (this.IM.getInstance(MID) == null || this.ZM.isZombi(MID)) {
            throw new ElementNotFoundException("CheckExistence=> " + MID + " N\u00e3o Existe!");
        }
    }

    @Override
    public int alocaMID() {
        return this.nextMID++;
    }

    public String toString() {
        String str = "====================\n";
        str = String.valueOf(str) + "   KERNEL FACTORY   \n";
        str = String.valueOf(str) + "====================\n";
        str = String.valueOf(str) + "\nPr\u00f3ximo MID dispon\u00edvel: " + this.nextMID + "\n";
        str = String.valueOf(str) + "Lista de Builders Dispon\u00edveis: \n";
        for (Map.Entry _e : this.itsBuilderMap.entrySet()) {
            str = String.valueOf(str) + "   Constr.ID: " + _e.getKey() + " " + (Builder)_e.getValue() + "\n";
        }
        str = String.valueOf(str) + this.FCPStore.toString();
        str = String.valueOf(str) + this.ZM.toString();
        return str;
    }

    @Override
    public FactoryCreationParameter getFCP(Integer MID) {
        return this.FCPStore.get(MID);
    }

    private class FactoryCreationParameterStore {
        private Map itsMIDMap = new HashMap();
        private Map itsFCPMap = new HashMap();

        private FactoryCreationParameterStore() {
        }

        private void addConstructedElement(int[] mid, FactoryCreationParameter FCP) {
            int _i = 0;
            while (_i < mid.length) {
                Integer MID = new Integer(mid[_i]);
                if (!this.itsMIDMap.containsKey(MID)) {
                    this.itsMIDMap.put(MID, FCP);
                }
                ++_i;
            }
            if (!this.itsFCPMap.containsKey(FCP)) {
                this.itsFCPMap.put(FCP, mid);
            }
        }

        private void remove(Integer MID) {
            FactoryCreationParameter _fcp = this.get(MID);
            this.itsMIDMap.remove(MID);
            int[] mid = (int[])this.itsFCPMap.get(_fcp);
            if (mid != null) {
                int i = 0;
                while (i < mid.length) {
                    if (this.get(new Integer(mid[i])) != null) {
                        return;
                    }
                    ++i;
                }
            }
            this.itsFCPMap.remove(_fcp);
        }

        private FactoryCreationParameter get(Integer MID) {
            return (FactoryCreationParameter)this.itsMIDMap.get(MID);
        }

        private boolean hasAlreadyBeenConstructed(FactoryCreationParameter FCP) {
            return this.itsFCPMap.containsKey(FCP);
        }

        public int[] mathIdentificationOf(FactoryCreationParameter FCP) {
            int[] mid = (int[])this.itsFCPMap.get(FCP);
            int[] mid2 = new int[mid.length];
            System.arraycopy(mid, 0, mid2, 0, mid.length);
            return mid2;
        }

        public String toString() {
            String str = "=================\n";
            str = String.valueOf(str) + " Kernel Factory  \n";
            str = String.valueOf(str) + "    FCPStore     \n";
            str = String.valueOf(str) + "=================\n";
            for (Map.Entry _e : this.itsMIDMap.entrySet()) {
                str = String.valueOf(str) + "MID: " + _e.getKey() + " " + (FactoryCreationParameter)_e.getValue() + "\n";
            }
            str = String.valueOf(str) + "\n=================\n\n";
            for (Map.Entry _e : this.itsFCPMap.entrySet()) {
                int[] _m = (int[])_e.getValue();
                int i = 0;
                while (i < _m.length) {
                    str = String.valueOf(str) + "MID: " + _m[i] + " " + (FactoryCreationParameter)_e.getKey() + "\n";
                    ++i;
                }
            }
            return str;
        }
    }

    private class ZombiManipulator {
        private Set ZombiSet = new HashSet();

        private ZombiManipulator() {
        }

        private void addZombi(Integer MID) {
            this.ZombiSet.add(MID);
        }

        private void removeZombi(Integer MID) {
            this.ZombiSet.remove(MID);
        }

        private void removeZombi(int[] mid) {
            int i = 0;
            while (i < mid.length) {
                this.ZombiSet.remove(new Integer(mid[i]));
                ++i;
            }
        }

        private void filterZombis(Set s) {
            s.removeAll(this.ZombiSet);
        }

        private boolean cantDelete(Integer MID) {
            int n;
            KernelElement elem = KernelFactory2.this.IM.getInstance(MID);
            Constraint c = elem.getConstraint();
            if (c == null || (n = c.getOutputNumber()) == 1) {
                return false;
            }
            int i = 0;
            while (i < n) {
                if (c.getOutput(i) != elem && !this.isZombi(c.getOutput(i).getMID())) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        private boolean isZombi(Integer MID) {
            return this.ZombiSet.contains(MID);
        }

        public String toString() {
            String str = "=================\n";
            str = String.valueOf(str) + " Kernel Factory  \n";
            str = String.valueOf(str) + "Zombi Manipulator\n";
            str = String.valueOf(str) + "=================\n";
            Iterator _i = this.ZombiSet.iterator();
            str = String.valueOf(str) + "Lista de MID's em estado 'zombi': ";
            while (_i.hasNext()) {
                Integer _MID = (Integer)_i.next();
                str = String.valueOf(str) + _MID + " ";
            }
            str = String.valueOf(str) + "\n=================\n";
            return str;
        }
    }
}

