/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.kernel;

import br.ufrj.labma.enibam.kernel.AbstractKernelLocus;
import br.ufrj.labma.enibam.kernel.KernelArc;
import br.ufrj.labma.enibam.kernel.KernelCircle;
import br.ufrj.labma.enibam.kernel.KernelElement;
import br.ufrj.labma.enibam.kernel.KernelGenericLine;
import br.ufrj.labma.enibam.kernel.KernelLocus;
import br.ufrj.labma.enibam.kernel.KernelPoint;
import br.ufrj.labma.enibam.kernel.KernelRay;
import br.ufrj.labma.enibam.kernel.KernelSegment;
import br.ufrj.labma.enibam.kernel.Program;
import br.ufrj.labma.enibam.kernel.Translatable;
import br.ufrj.labma.enibam.kernel.dummy.KernelDummySegment;
import br.ufrj.labma.enibam.kernel.operations.CoorSys;
import br.ufrj.labma.enibam.kernel.state.LocusState;
import br.ufrj.labma.enibam.kernel.state.State;
import br.ufrj.labma.enibam.util.GraphicUtilities;
import br.ufrj.labma.enibam.util.MathVector;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class KernelPolyLocus
extends AbstractKernelLocus {
    private MathVector _v = new MathVector();
    private CoorSys auxl1 = new CoorSys();
    private CoorSys auxl2 = new CoorSys();

    public KernelPolyLocus(Integer id, Program prog) {
        super(id, prog);
    }

    @Override
    public void changeState(State _state) throws ClassCastException {
        if (this.theConstraint == null || this.theConstraint.isOk(_state)) {
            LocusState _st = (LocusState)_state;
            this.itsDeletedStatus = _st.itsDeletedStatus;
            this.itsDefinedStatus = _st.itsDefinedStatus;
            int _n = _st.pointList.size();
            int _i = 0;
            while (_i < this.itsPointList.size() && _i < _n) {
                CoorSys _p1 = (CoorSys)_st.pointList.get(_i);
                CoorSys _p2 = (CoorSys)this.itsPointList.get(_i);
                _p2.itsX = _p1.itsX;
                _p2.itsY = _p1.itsY;
                ++_i;
            }
        }
    }

    @Override
    public void getState(State _state) throws ClassCastException {
        if (this.itsPointList.size() == 0) {
            return;
        }
        LocusState _st = (LocusState)_state;
        _st.itsDeletedStatus = this.itsDeletedStatus;
        _st.itsDefinedStatus = this.itsDefinedStatus;
        int _i = 0;
        while (_i < this.itsPointList.size() && _i < _st.pointList.size()) {
            CoorSys _p1 = (CoorSys)_st.pointList.get(_i);
            CoorSys _p2 = (CoorSys)this.itsPointList.get(_i);
            _p1.itsX = _p2.itsX;
            _p1.itsY = _p2.itsY;
            ++_i;
        }
    }

    @Override
    public void initDefault(KernelElement I, KernelPoint P, int numElements, KernelElement path) {
        KernelDummySegment _e;
        this.setType(path);
        this.itsPath = path;
        this.itsPointList = new ArrayList(numElements);
        int _ii = 0;
        while (_ii <= numElements) {
            this.itsPointList.add(new CoorSys(0.0, 0.0));
            ++_ii;
        }
        CoorSys _o1 = new CoorSys();
        this.itsSegmentList = new ArrayList(100);
        int _s = this.itsPointList.size();
        Object _o2 = this.itsPointList.get(0);
        _o1 = _o2;
        int _i = 1;
        while (_i < _s) {
            _o2 = this.itsPointList.get(_i);
            _e = new KernelDummySegment(_o1, (CoorSys)_o2);
            this.itsSegmentList.add(_e);
            _o1 = _o2;
            ++_i;
        }
        _e = new KernelDummySegment((CoorSys)_o2, (CoorSys)_o2);
        this.itsSegmentList.add(_e);
        GraphicUtilities.loadScreenDimension();
        CoorSys _startP = new CoorSys();
        P.getXY(_startP);
        this.calculate(I, P);
        P.setXY(_startP.itsX, _startP.itsY);
        P.updateFromLocus();
    }

    @Override
    public List build(KernelElement I, KernelPoint P, int numElements) {
        return null;
    }

    @Override
    public void calculate(KernelElement theI, KernelPoint theP) {
        Translatable _c;
        KernelDummySegment _kseg;
        CoorSys o;
        int _i;
        double startx;
        double _vy;
        double _vx;
        double step;
        KernelGenericLine _line;
        GraphicUtilities.getXResolution();
        GraphicUtilities.getYResolution();
        CoorSys old = this.auxl1;
        KernelPoint _theI = (KernelPoint)theI;
        boolean first = true;
        double _l = this.itsPointList.size();
        Iterator _ks = this.itsSegmentList.iterator();
        if (this.type == 0) {
            _line = (KernelGenericLine)this.itsPath;
            _line.getP1P2(this.auxl1, this.auxl2);
            step = (1000.0 + 2.0 * _l) / _l;
            _line.getVector(this._v);
            this._v.unitario().productByNumber(step);
            _vx = this._v.getX();
            _vy = this._v.getY();
            startx = 0.5 * (this.auxl1.itsX + this.auxl2.itsX);
            double starty = 0.5 * (this.auxl1.itsY + this.auxl2.itsY);
            startx -= 0.5 * _l * _vx;
            starty -= 0.5 * _l * _vy;
            _i = 0;
            _i = 0;
            while ((double)_i < _l) {
                o = (CoorSys)this.itsPointList.get(_i);
                theP.move(startx += _vx, starty += _vy);
                theP.updateFromLocus();
                o.itsX = _theI.getX();
                o.itsY = _theI.getY();
                if (!_theI.getDefinedStatus()) {
                    o.itsX = -10000.0;
                    o.itsY = -10000.0;
                }
                if (first) {
                    first = false;
                } else {
                    _kseg = (KernelDummySegment)_ks.next();
                    _kseg.setP1P2(old, o);
                }
                old.itsX = o.itsX;
                old.itsY = o.itsY;
                ++_i;
            }
        }
        if (this.type == 1) {
            _line = (KernelSegment)this.itsPath;
            _line.getP1P2(this.auxl1, this.auxl2);
            _line.getVector(this._v);
            double _vx2 = this._v.getX() / _l;
            double _vy2 = this._v.getY() / _l;
            double startx2 = this.auxl1.itsX;
            double starty = this.auxl1.itsY;
            int _ii = 0;
            while ((double)_ii < _l) {
                o = (CoorSys)this.itsPointList.get(_ii);
                theP.move(startx2 += _vx2, starty += _vy2);
                theP.updateFromLocus();
                o.itsX = _theI.getX();
                o.itsY = _theI.getY();
                if (!_theI.getDefinedStatus()) {
                    o.itsX = -10000.0;
                    o.itsY = -10000.0;
                }
                if (first) {
                    first = false;
                } else {
                    _kseg = (KernelDummySegment)_ks.next();
                    _kseg.setP1P2(old, o);
                }
                old.itsX = o.itsX;
                old.itsY = o.itsY;
                ++_ii;
            }
        }
        if (this.type == 2) {
            _line = (KernelRay)this.itsPath;
            _line.getP1P2(this.auxl1, this.auxl2);
            step = (1000.0 + 2.0 * _l) / _l;
            _line.getVector(this._v);
            this._v.unitario().productByNumber(step);
            _vx = this._v.getX();
            _vy = this._v.getY();
            startx = this.auxl1.itsX;
            double starty = this.auxl1.itsY;
            _i = 0;
            _i = 0;
            while ((double)_i < _l) {
                o = (CoorSys)this.itsPointList.get(_i);
                theP.move(startx += _vx, starty += _vy);
                theP.updateFromLocus();
                o.itsX = _theI.getX();
                o.itsY = _theI.getY();
                if (!_theI.getDefinedStatus()) {
                    o.itsX = -10000.0;
                    o.itsY = -10000.0;
                }
                if (first) {
                    first = false;
                } else {
                    _kseg = (KernelDummySegment)_ks.next();
                    _kseg.setP1P2(old, o);
                }
                old.itsX = o.itsX;
                old.itsY = o.itsY;
                ++_i;
            }
        }
        if (this.type == 3) {
            _c = (KernelCircle)this.itsPath;
            double _cx = _c.getCenterX();
            double _cy = _c.getCenterY();
            this._v.setVector(_cx, _cy, theP.getX(), theP.getY());
            _l = this.itsPointList.size() - 2;
            double _stepp = Math.PI * 2 / _l;
            _l += 2.0;
            int _i2 = 0;
            while ((double)_i2 < _l) {
                o = (CoorSys)this.itsPointList.get(_i2);
                this._v.rotation(_stepp);
                theP.move(_cx + this._v.getX(), _cy + this._v.getY());
                theP.updateFromLocus();
                o.itsX = _theI.getX();
                o.itsY = _theI.getY();
                if (!_theI.getDefinedStatus()) {
                    o.itsX = -10000.0;
                    o.itsY = -10000.0;
                }
                if (first) {
                    first = false;
                } else {
                    _kseg = (KernelDummySegment)_ks.next();
                    _kseg.setP1P2(old, o);
                }
                old.itsX = o.itsX;
                old.itsY = o.itsY;
                ++_i2;
            }
        }
        if (this.type == 4) {
            KernelLocus _loc = (KernelLocus)this.itsPath;
            ArrayList _points = (ArrayList)_loc.getPointVector();
            int _s = this.itsPointList.size();
            int _i3 = 0;
            while (_i3 < _s) {
                o = (CoorSys)this.itsPointList.get(_i3);
                CoorSys _p = (CoorSys)_points.get(_i3);
                theP.setXY(_p.itsX, _p.itsY);
                theP.updateFromLocus();
                o.itsX = _theI.getX();
                o.itsY = _theI.getY();
                if (!_theI.getDefinedStatus()) {
                    o.itsX = -10000.0;
                    o.itsY = -10000.0;
                }
                if (first) {
                    first = false;
                } else {
                    _kseg = (KernelDummySegment)_ks.next();
                    _kseg.setP1P2(old, o);
                }
                old.itsX = o.itsX;
                old.itsY = o.itsY;
                ++_i3;
            }
        }
        if (this.type == 5) {
            // empty if block
        }
        if (this.type == 6) {
            _c = (KernelArc)this.itsPath;
            double _cx = _c.getCenterX();
            double _cy = _c.getCenterY();
            double _cr = _c.getRadius();
            this._v.setVector(_cx, _cy, _cx + _cr, _cy);
            this._v.rotation(-_c.getStartingAngle());
            _l = this.itsPointList.size() - 1;
            double _stepp = -_c.getArcAngle() / _l;
            _l += 1.0;
            int _i4 = 0;
            while ((double)_i4 < _l) {
                o = (CoorSys)this.itsPointList.get(_i4);
                this._v.rotation(_stepp);
                theP.move(_cx + this._v.getX(), _cy + this._v.getY());
                theP.updateFromLocus();
                o.itsX = _theI.getX();
                o.itsY = _theI.getY();
                if (!_theI.getDefinedStatus()) {
                    o.itsX = -10000.0;
                    o.itsY = -10000.0;
                }
                if (first) {
                    first = false;
                } else {
                    _kseg = (KernelDummySegment)_ks.next();
                    _kseg.setP1P2(old, o);
                }
                old.itsX = o.itsX;
                old.itsY = o.itsY;
                ++_i4;
            }
        }
    }
}

