/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.kernel;

import br.ufrj.labma.enibam.kernel.AbstractKernelPolygon;
import br.ufrj.labma.enibam.kernel.Program;
import br.ufrj.labma.enibam.kernel.operations.CoorSys;
import br.ufrj.labma.enibam.kernel.state.PolygonState;
import br.ufrj.labma.enibam.kernel.state.State;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class KernelPolygonNP
extends AbstractKernelPolygon {
    private List itsCSList = new ArrayList();
    private PolygonState _st1 = new PolygonState();

    public KernelPolygonNP(Integer id, Program prog) {
        super(id, prog);
    }

    @Override
    public void translate(double dx, double dy) {
        this.updateCoorSysList(this._st1.itsCoorSysList);
        for (CoorSys cs : this._st1.itsCoorSysList) {
            cs.itsX += dx;
            cs.itsY += dy;
        }
        this._st1.itsDefinedStatus = true;
        if (this.theConstraint == null || this.theConstraint.isOk(this._st1)) {
            PolygonState _st = this._st1;
            this.itsDeletedStatus = _st.itsDeletedStatus;
            this.itsDefinedStatus = _st.itsDefinedStatus;
            this.setPoints(_st.itsCoorSysList);
        } else if (this.itsFWSet != null) {
            this.forwardTranslate(dx, dy);
        }
    }

    @Override
    public void changeState(State _state) throws ClassCastException {
        PolygonState _st = (PolygonState)_state;
        this.itsDeletedStatus = _st.itsDeletedStatus;
        this.itsDefinedStatus = _st.itsDefinedStatus;
        this.setPoints(_st.itsCoorSysList);
    }

    @Override
    public void getState(State _state) throws ClassCastException {
        PolygonState _st = (PolygonState)_state;
        _st.itsMID = this.getMID();
        _st.itsDeletedStatus = this.itsDeletedStatus;
        _st.itsDefinedStatus = this.itsDefinedStatus;
        this.updateCoorSysList(_st.itsCoorSysList);
    }

    @Override
    public List getPoints() {
        return this.createCoorSysList();
    }

    @Override
    public int getNumberOfPoints() {
        return this.itsCSList.size();
    }

    @Override
    public void setPoints(CoorSys[] Points) {
        if (Points.length == this.itsCSList.size()) {
            Iterator _i = this.itsCSList.iterator();
            int j = 0;
            while (j < Points.length) {
                CoorSys cs = (CoorSys)_i.next();
                cs.itsX = Points[j].itsX;
                cs.itsY = Points[j].itsY;
                ++j;
            }
        } else {
            this.itsCSList.clear();
            int j = 0;
            while (j < Points.length) {
                this.itsCSList.add(new CoorSys(Points[j].itsX, Points[j].itsY));
                ++j;
            }
        }
    }

    @Override
    public void setPoints(List Points) {
        if (Points.size() == this.itsCSList.size()) {
            Iterator _i = Points.iterator();
            Iterator _j = this.itsCSList.iterator();
            while (_i.hasNext()) {
                CoorSys cso = (CoorSys)_i.next();
                CoorSys csd = (CoorSys)_j.next();
                csd.itsX = cso.itsX;
                csd.itsY = cso.itsY;
            }
        } else {
            this.itsCSList.clear();
            for (CoorSys cso : Points) {
                this.itsCSList.add(new CoorSys(cso.itsX, cso.itsY));
            }
        }
    }

    @Override
    public boolean contains(CoorSys Point2) {
        return false;
    }

    @Override
    public double getArea() {
        if (this.itsCSList.size() < 3) {
            return 0.0;
        }
        double _area = 0.0;
        Iterator _i = this.itsCSList.iterator();
        CoorSys _cs = (CoorSys)_i.next();
        double p0x = _cs.itsX;
        double p0y = _cs.itsY;
        _cs = (CoorSys)_i.next();
        double pk1x = _cs.itsX;
        double pk1y = _cs.itsY;
        while (_i.hasNext()) {
            _cs = (CoorSys)_i.next();
            double pk2x = _cs.itsX;
            double pk2y = _cs.itsY;
            double ux = pk1x - p0x;
            double uy = pk1y - p0y;
            double vx = pk2x - p0x;
            double vy = pk2y - p0y;
            _area += ux * vy - uy * vx;
            pk1x = pk2x;
            pk1y = pk2y;
        }
        return _area / 2.0;
    }

    @Override
    public double getLength() {
        if (this.itsCSList.size() < 2) {
            return 0.0;
        }
        double _length = 0.0;
        Iterator _i = this.itsCSList.iterator();
        CoorSys _cs = (CoorSys)_i.next();
        double pk0x = _cs.itsX;
        double pk0y = _cs.itsY;
        while (_i.hasNext()) {
            _cs = (CoorSys)_i.next();
            double pk1x = _cs.itsX;
            double pk1y = _cs.itsY;
            double dx = pk1x - pk0x;
            double dy = pk1y - pk0y;
            _length += Math.sqrt(dx * dx + dy * dy);
            pk0x = pk1x;
            pk0y = pk1y;
        }
        return _length;
    }

    private void updateCoorSysList(List CSList) {
        Iterator _origem = this.itsCSList.iterator();
        Iterator _destino = CSList.iterator();
        while (_origem.hasNext() && _destino.hasNext()) {
            CoorSys cso = (CoorSys)_origem.next();
            CoorSys csd = (CoorSys)_destino.next();
            csd.itsX = cso.itsX;
            csd.itsY = cso.itsY;
        }
    }

    private List createCoorSysList() {
        ArrayList<CoorSys> _retorno = new ArrayList<CoorSys>();
        for (CoorSys cso : this.itsCSList) {
            _retorno.add(new CoorSys(cso.itsX, cso.itsY));
        }
        return _retorno;
    }
}

