/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.kernel;

import br.ufrj.labma.enibam.kernel.AbstractKernelGenericLine2P;
import br.ufrj.labma.enibam.kernel.KernelRay;
import br.ufrj.labma.enibam.kernel.Program;
import br.ufrj.labma.enibam.kernel.operations.CoorSys;

public class KernelRay2P
extends AbstractKernelGenericLine2P
implements KernelRay {
    private static final double TOLERANCE = 1.0E-5;

    public KernelRay2P(Integer id, Program prog) {
        super(id, prog);
    }

    @Override
    public boolean contains(CoorSys P) {
        double den_x = this.itsX2 - this.itsX1;
        double den_y = this.itsY2 - this.itsY1;
        if (Math.abs(den_x) <= 1.0E-5 && Math.abs(den_y) <= 1.0E-5) {
            return false;
        }
        if (Math.abs(den_x) <= 1.0E-5) {
            return Math.abs(P.itsX - this.itsX1) <= 1.0E-5 && (P.itsY - this.itsY1) / den_y >= 0.0;
        }
        if (Math.abs(den_y) <= 1.0E-5) {
            return Math.abs(P.itsY - this.itsY1) <= 1.0E-5 && (P.itsX - this.itsX1) / den_x >= 0.0;
        }
        double tx = (P.itsX - this.itsX1) / den_x;
        double ty = (P.itsY - this.itsY1) / den_y;
        return Math.abs(tx - ty) <= 1.0E-5 && tx >= 0.0;
    }

    @Override
    public boolean contains(double X, double Y) {
        double den_x = this.itsX2 - this.itsX1;
        double den_y = this.itsY2 - this.itsY1;
        if (Math.abs(den_x) <= 1.0E-5 && Math.abs(den_y) <= 1.0E-5) {
            return false;
        }
        if (Math.abs(den_x) <= 1.0E-5) {
            return X == this.itsX1 && (Y - this.itsY1) / den_y >= 0.0;
        }
        if (Math.abs(den_y) <= 1.0E-5) {
            return Y == this.itsY1 && (X - this.itsX1) / den_x >= 0.0;
        }
        double tx = (X - this.itsX1) / den_x;
        double ty = (Y - this.itsY1) / den_y;
        return Math.abs(tx - ty) <= 1.0E-5 && tx >= 0.0;
    }

    @Override
    public void getOrigin(CoorSys p) {
        p.itsX = this.itsX1;
        p.itsY = this.itsY1;
    }
}

