/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.kernel;

import br.ufrj.labma.enibam.kernel.AbstractKernelGenericLine2P;
import br.ufrj.labma.enibam.kernel.KernelSegment;
import br.ufrj.labma.enibam.kernel.Program;
import br.ufrj.labma.enibam.kernel.operations.CoorSys;
import br.ufrj.labma.enibam.kernel.operations.Distance;

public class KernelSegment2P
extends AbstractKernelGenericLine2P
implements KernelSegment {
    private static final double TOLERANCE = 1.0E-5;

    public KernelSegment2P(Integer id, Program prog) {
        super(id, prog);
    }

    @Override
    public boolean contains(CoorSys P) {
        double den_x = this.itsX2 - this.itsX1;
        double den_y = this.itsY2 - this.itsY1;
        if (Math.abs(den_x) <= 1.0E-5 && Math.abs(den_y) <= 1.0E-5) {
            return false;
        }
        if (Math.abs(den_x) <= 1.0E-5) {
            double ty = (P.itsY - this.itsY1) / den_y;
            return ty >= 0.0 && ty <= 1.0 && Math.abs(P.itsX - this.itsX1) <= 1.0E-5;
        }
        if (Math.abs(den_y) <= 1.0E-5) {
            double tx = (P.itsX - this.itsX1) / den_x;
            return tx >= 0.0 && tx <= 1.0 && Math.abs(P.itsY - this.itsY1) <= 1.0E-5;
        }
        double tx = (P.itsX - this.itsX1) / den_x;
        double ty = (P.itsY - this.itsY1) / den_y;
        return tx >= 0.0 && tx <= 1.0 && Math.abs(tx - ty) <= 1.0E-5;
    }

    @Override
    public boolean contains(double X, double Y) {
        double den_x = this.itsX2 - this.itsX1;
        double den_y = this.itsY2 - this.itsY1;
        if (Math.abs(den_x) <= 1.0E-5 && Math.abs(den_y) <= 1.0E-5) {
            return false;
        }
        if (Math.abs(den_x) <= 1.0E-5) {
            double ty = (Y - this.itsY1) / den_y;
            return ty >= 0.0 && ty <= 1.0 && Math.abs(X - this.itsX1) <= 1.0E-5;
        }
        if (Math.abs(den_y) <= 1.0E-5) {
            double tx = (X - this.itsX1) / den_x;
            return tx >= 0.0 && tx <= 1.0 && Math.abs(Y - this.itsY1) <= 1.0E-5;
        }
        double tx = (X - this.itsX1) / den_x;
        double ty = (Y - this.itsY1) / den_y;
        return tx >= 0.0 && tx <= 1.0 && Math.abs(tx - ty) <= 1.0E-5;
    }

    @Override
    public double getLength() {
        return Distance.getDistance(this.itsX1, this.itsY1, this.itsX2, this.itsY2);
    }
}

