/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.kernel;

import br.ufrj.labma.enibam.kernel.AbstractKernelLocus;
import br.ufrj.labma.enibam.kernel.KernelArc;
import br.ufrj.labma.enibam.kernel.KernelCircle;
import br.ufrj.labma.enibam.kernel.KernelElement;
import br.ufrj.labma.enibam.kernel.KernelGenericLine;
import br.ufrj.labma.enibam.kernel.KernelLocus;
import br.ufrj.labma.enibam.kernel.KernelPoint;
import br.ufrj.labma.enibam.kernel.KernelRay;
import br.ufrj.labma.enibam.kernel.KernelSegment;
import br.ufrj.labma.enibam.kernel.Program;
import br.ufrj.labma.enibam.kernel.Translatable;
import br.ufrj.labma.enibam.kernel.dummy.KernelDummySegment;
import br.ufrj.labma.enibam.kernel.operations.CoorSys;
import br.ufrj.labma.enibam.kernel.state.LocusState;
import br.ufrj.labma.enibam.kernel.state.State;
import br.ufrj.labma.enibam.util.GraphicUtilities;
import br.ufrj.labma.enibam.util.MathVector;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class KernelSplineLocus
extends AbstractKernelLocus {
    private int numpts;
    private double[] data_x;
    private double[] data_y;
    private double[] points_x;
    private double[] points_y;
    private double[] bspl_x;
    private double[] bspl_y;
    private double[] gamma;
    private double[] up;
    private double[] low;
    private double[] knot;
    private double[] aux;
    private double[] coeffa;
    private int l;
    private int DEGREE = 3;
    private int DENSE = 5;
    private MathVector _v = new MathVector();
    private CoorSys auxl1 = new CoorSys();
    private CoorSys auxl2 = new CoorSys();

    public KernelSplineLocus(Integer id, Program prog) {
        super(id, prog);
    }

    @Override
    public void changeState(State _state) throws ClassCastException {
        if (this.theConstraint == null || this.theConstraint.isOk(_state)) {
            LocusState _st = (LocusState)_state;
            this.itsDeletedStatus = _st.itsDeletedStatus;
            this.itsDefinedStatus = _st.itsDefinedStatus;
            int _n = _st.pointList.size();
            int _i = 0;
            while (_i < this.itsPointList.size() && _i < _n) {
                CoorSys _p1 = (CoorSys)_st.pointList.get(_i);
                CoorSys _p2 = (CoorSys)this.itsPointList.get(_i);
                _p2.itsX = _p1.itsX;
                _p2.itsY = _p1.itsY;
                ++_i;
            }
        }
    }

    @Override
    public void getState(State _state) throws ClassCastException {
        CoorSys _p1;
        int _m;
        if (this.itsPointList.size() == 0) {
            return;
        }
        LocusState _st = (LocusState)_state;
        _st.itsDeletedStatus = this.itsDeletedStatus;
        _st.itsDefinedStatus = this.itsDefinedStatus;
        int _n = _st.pointList.size();
        if (_n < (_m = this.itsSegmentList.size())) {
            _st.sizeIt(_m + 1);
        }
        int _i = 0;
        while (_i < _m) {
            _p1 = (CoorSys)_st.pointList.get(_i);
            KernelDummySegment _s = (KernelDummySegment)this.itsSegmentList.get(_i);
            _s.getP1P2(this.auxl1, this.auxl2);
            _p1.itsX = this.auxl1.itsX;
            _p1.itsY = this.auxl1.itsY;
            ++_i;
        }
        _p1 = (CoorSys)_st.pointList.get(_i);
        _p1.itsX = this.auxl2.itsX;
        _p1.itsY = this.auxl2.itsY;
    }

    @Override
    public void initDefault(KernelElement I, KernelPoint P, int numElements, KernelElement path) {
        GraphicUtilities.loadScreenDimension();
        this.setType(path);
        this.itsPath = path;
        this.numpts = numElements + 5;
        this.data_x = new double[this.numpts];
        this.data_y = new double[this.numpts];
        this.itsPointList = new ArrayList(numElements);
        int _ii = 0;
        while (_ii <= numElements) {
            this.itsPointList.add(new CoorSys(0.0, 0.0));
            ++_ii;
        }
        this.l = this.numpts - this.DEGREE;
        this.bspl_x = new double[this.l + this.DEGREE];
        this.bspl_y = new double[this.l + this.DEGREE];
        double[] alpha = new double[this.l + this.DEGREE];
        double[] beta = new double[this.l + this.DEGREE];
        this.gamma = new double[this.l + this.DEGREE];
        this.up = new double[this.l + this.DEGREE];
        this.low = new double[this.l + this.DEGREE];
        this.coeffa = new double[this.l + this.DEGREE];
        this.aux = new double[this.l + this.DEGREE];
        this.points_x = new double[this.l * (this.DENSE + 1) + 1];
        this.points_y = new double[this.l * (this.DENSE + 1) + 1];
        int l2n = this.l + 2 * this.DEGREE;
        this.knot = new double[l2n];
        this.knot[0] = 0.0;
        int _i = 1;
        while (_i < l2n) {
            this.knot[_i] = this.knot[_i - 1] + 1.0;
            ++_i;
        }
        this.SetUpSystem(this.knot, this.l, alpha, beta, this.gamma);
        this.LUSystem(alpha, beta, this.gamma, this.l, this.up, this.low);
        this.BesselEnds(this.data_x, this.knot, this.l);
        this.BesselEnds(this.data_y, this.knot, this.l);
        this.SolveSystem(this.up, this.low, this.gamma, this.l, this.data_x, this.bspl_x);
        this.SolveSystem(this.up, this.low, this.gamma, this.l, this.data_y, this.bspl_y);
        int _outpts = this.BsplToPoints(this.DEGREE, this.l, this.bspl_x, this.knot, this.DENSE, this.points_x);
        _outpts = this.BsplToPoints(this.DEGREE, this.l, this.bspl_y, this.knot, this.DENSE, this.points_y);
        int _segcount = 0;
        this.itsSegmentList = new ArrayList(100);
        CoorSys c1 = new CoorSys();
        CoorSys c2 = new CoorSys();
        _i = this.DENSE + 2;
        while (_i < _outpts - (this.DENSE + 1)) {
            if (_segcount != this.DENSE) {
                c1.itsX = this.points_x[_i - 1];
                c1.itsY = this.points_y[_i - 1];
                c2.itsX = this.points_x[_i];
                c2.itsY = this.points_y[_i];
                KernelDummySegment _e = new KernelDummySegment(c1, c2);
                this.itsSegmentList.add(_e);
                ++_segcount;
            } else {
                _segcount = 0;
            }
            ++_i;
        }
        CoorSys _startP = new CoorSys();
        P.getXY(_startP);
        this.calculate(I, P);
        P.setXY(_startP.itsX, _startP.itsY);
        P.updateFromLocus();
    }

    @Override
    public List build(KernelElement I, KernelPoint P, int numElements) {
        return null;
    }

    private void SetUpSystem(double[] knot, int l, double[] alpha, double[] beta, double[] gamma) {
        double delta_im2;
        int l1 = l - 1;
        if (l == 1) {
            alpha[0] = 0.0;
            alpha[1] = 0.0;
            beta[0] = 1.0;
            beta[1] = 1.0;
            gamma[0] = 0.0;
            gamma[1] = 0.0;
            return;
        }
        if (l == 2) {
            beta[0] = 1.0;
            double delta_im1 = knot[1] - knot[0];
            double delta_i = knot[2] - knot[1];
            double delta_ip1 = knot[3] - knot[2];
            double sum = delta_im1 + delta_i;
            alpha[1] = delta_i * delta_i / sum;
            beta[1] = delta_i * delta_im1 / sum + delta_im1 * delta_i / sum;
            gamma[1] = delta_im1 * delta_im1 / sum;
            alpha[1] = alpha[1] / sum;
            beta[1] = beta[1] / sum;
            gamma[1] = gamma[1] / sum;
            beta[2] = 1.0;
            alpha[2] = 0.0;
            gamma[2] = 0.0;
            return;
        }
        double delta_im1 = knot[1] - knot[0];
        double delta_i = knot[2] - knot[1];
        double delta_ip1 = knot[3] - knot[2];
        double sum = delta_im1 + delta_i;
        beta[0] = 1.0;
        gamma[0] = 0.0;
        alpha[1] = delta_i * delta_i / sum;
        beta[1] = delta_i * delta_im1 / sum + delta_im1 * (delta_i + delta_ip1) / (sum + delta_ip1);
        gamma[1] = delta_im1 * delta_im1 / (sum + delta_ip1);
        alpha[1] = alpha[1] / sum;
        beta[1] = beta[1] / sum;
        gamma[1] = gamma[1] / sum;
        int i = 2;
        while (i < l1) {
            delta_im2 = knot[i - 1] - knot[i - 2];
            delta_im1 = knot[i] - knot[i - 1];
            delta_i = knot[i + 1] - knot[i];
            delta_ip1 = knot[i + 2] - knot[i + 1];
            sum = delta_im1 + delta_i;
            alpha[i] = delta_i * delta_i / (delta_im2 + sum);
            beta[i] = delta_i * (delta_im2 + delta_im1) / (delta_im2 + sum) + delta_im1 * (delta_i + delta_ip1) / (sum + delta_ip1);
            gamma[i] = delta_im1 * delta_im1 / (sum + delta_ip1);
            alpha[i] = alpha[i] / sum;
            beta[i] = beta[i] / sum;
            gamma[i] = gamma[i] / sum;
            ++i;
        }
        delta_im2 = knot[l - 2] - knot[l - 3];
        delta_im1 = knot[l1] - knot[l - 2];
        delta_i = knot[l] - knot[l1];
        sum = delta_im1 + delta_i;
        alpha[l1] = delta_i * delta_i / (delta_im2 + sum);
        beta[l1] = delta_i * (delta_im2 + delta_im1) / (delta_im2 + sum) + delta_im1 * delta_i / sum;
        gamma[l1] = delta_im1 * delta_im1 / sum;
        alpha[l1] = alpha[l1] / sum;
        beta[l1] = beta[l1] / sum;
        gamma[l1] = gamma[l1] / sum;
        alpha[l] = 0.0;
        beta[l] = 1.0;
        gamma[l] = 0.0;
    }

    private void LUSystem(double[] alpha, double[] beta, double[] gamma, int l, double[] up, double[] low) {
        up[0] = beta[0];
        int i = 1;
        while (i <= l) {
            low[i] = alpha[i] / up[i - 1];
            up[i] = beta[i] - low[i] * gamma[i - 1];
            ++i;
        }
    }

    private void BesselEnds(double[] data, double[] knot, int l) {
        if (l == 1) {
            data[1] = (2.0 * data[0] + data[3]) / 3.0;
            data[2] = (2.0 * data[3] + data[0]) / 3.0;
        } else if (l == 2) {
            double alpha = (knot[2] - knot[1]) / (knot[2] - knot[0]);
            double beta = 1.0 - alpha;
            data[1] = (data[2] - alpha * alpha * data[0] - beta * beta * data[4]) / (2.0 * alpha * beta);
            data[1] = 2.0 * (alpha * data[0] + beta * data[1]) / 3.0 + data[0] / 3.0;
            alpha = (knot[2] - knot[1]) / (knot[2] - knot[0]);
            beta = 1.0 - alpha;
            data[3] = (data[2] - alpha * alpha * data[0] - beta * beta * data[4]) / (2.0 * alpha * beta);
            data[3] = 2.0 * (alpha * data[3] + beta * data[4]) / 3.0 + data[4] / 3.0;
        } else {
            double alpha = (knot[2] - knot[1]) / (knot[2] - knot[0]);
            double beta = 1.0 - alpha;
            data[1] = (data[2] - alpha * alpha * data[0] - beta * beta * data[3]) / (2.0 * alpha * beta);
            data[1] = 2.0 * (alpha * data[0] + beta * data[1]) / 3.0 + data[0] / 3.0;
            alpha = (knot[l] - knot[l - 1]) / (knot[l] - knot[l - 2]);
            beta = 1.0 - alpha;
            data[l + 1] = (data[l] - alpha * alpha * data[l - 1] - beta * beta * data[l + 2]) / (2.0 * alpha * beta);
            data[l + 1] = 2.0 * (alpha * data[l + 1] + beta * data[l + 2]) / 3.0 + data[l + 2] / 3.0;
        }
    }

    private void SolveSystem(double[] up, double[] low, double[] gamma, int l, double[] rhs, double[] d) {
        d[0] = rhs[0];
        d[1] = rhs[1];
        this.aux[0] = rhs[1];
        int i = 1;
        while (i <= l) {
            this.aux[i] = rhs[i + 1] - low[i] * this.aux[i - 1];
            ++i;
        }
        d[l + 1] = this.aux[l] / up[l];
        i = l - 1;
        while (i > 0) {
            d[i + 1] = (this.aux[i] - gamma[i] * d[i + 2]) / up[i];
            --i;
        }
        d[l + 2] = rhs[l + 2];
    }

    private double Deboor(int DEGREE, double[] coeff, double[] knot, double u, int i) {
        int j = i - DEGREE + 1;
        while (j <= i + 1) {
            this.coeffa[j] = coeff[j];
            ++j;
        }
        int k = 1;
        while (k <= DEGREE) {
            j = i + 1;
            while (j >= i - DEGREE + k + 1) {
                double t1 = (knot[j + DEGREE - k] - u) / (knot[j + DEGREE - k] - knot[j - 1]);
                double t2 = 1.0 - t1;
                this.coeffa[j] = t1 * this.coeffa[j - 1] + t2 * this.coeffa[j];
                --j;
            }
            ++k;
        }
        return this.coeffa[i + 1];
    }

    private int BsplToPoints(int DEGREE, int l, double[] coeff_x, double[] knot, int DENSE, double[] pts_x) {
        int _outpts = 0;
        int i = DEGREE - 1;
        while (i < l + DEGREE - 1) {
            if (knot[i + 1] > knot[i]) {
                int ii = 0;
                while (ii <= DENSE) {
                    double u = knot[i] + (double)ii * (knot[i + 1] - knot[i]) / (double)DENSE;
                    pts_x[_outpts] = this.Deboor(DEGREE, coeff_x, knot, u, i);
                    ++_outpts;
                    ++ii;
                }
            }
            ++i;
        }
        return _outpts;
    }

    @Override
    public void calculate(KernelElement theI, KernelPoint theP) {
        Translatable _c;
        double startx;
        double _vy;
        double _vx;
        double step;
        KernelGenericLine _line;
        GraphicUtilities.getXResolution();
        GraphicUtilities.getYResolution();
        KernelPoint _theI = (KernelPoint)theI;
        boolean _first = true;
        double _coordx = 0.0;
        double _coordy = 0.0;
        int _count = 0;
        double _l = this.itsPointList.size();
        if (this.type == 0) {
            _line = (KernelGenericLine)this.itsPath;
            _line.getP1P2(this.auxl1, this.auxl2);
            step = (1000.0 + _l) / _l;
            _line.getVector(this._v);
            this._v.unitario().productByNumber(step);
            _vx = this._v.getX();
            _vy = this._v.getY();
            startx = 0.5 * (this.auxl1.itsX + this.auxl2.itsX);
            double starty = 0.5 * (this.auxl1.itsY + this.auxl2.itsY);
            startx -= 0.5 * _l * _vx;
            starty -= 0.5 * _l * _vy;
            theP.move(startx -= _vx, starty -= _vy);
            theP.updateFromLocus();
            for (CoorSys o : this.itsPointList) {
                theP.move(startx += _vx, starty += _vy);
                theP.updateFromLocus();
                _coordx = _theI.getX();
                _coordy = _theI.getY();
                o.itsX = _coordx;
                o.itsY = _coordy;
                this.data_x[_count] = _coordx;
                this.data_y[_count] = _coordy;
                ++_count;
                if (!_first) continue;
                this.data_x[_count] = _coordx;
                this.data_y[_count] = _coordy;
                this.data_x[++_count] = _coordx;
                this.data_y[_count] = _coordy;
                ++_count;
                _first = false;
            }
        }
        if (this.type == 1) {
            _line = (KernelSegment)this.itsPath;
            _line.getP1P2(this.auxl1, this.auxl2);
            _line.getVector(this._v);
            double _vx2 = this._v.getX() / _l;
            double _vy2 = this._v.getY() / _l;
            double startx2 = this.auxl1.itsX;
            double starty = this.auxl1.itsY;
            for (CoorSys o : this.itsPointList) {
                theP.move(startx2 += _vx2, starty += _vy2);
                theP.updateFromLocus();
                _coordx = _theI.getX();
                _coordy = _theI.getY();
                o.itsX = _coordx;
                o.itsY = _coordy;
                this.data_x[_count] = _coordx;
                this.data_y[_count] = _coordy;
                ++_count;
                if (!_first) continue;
                this.data_x[_count] = _coordx;
                this.data_y[_count] = _coordy;
                this.data_x[++_count] = _coordx;
                this.data_y[_count] = _coordy;
                ++_count;
                _first = false;
            }
        }
        if (this.type == 2) {
            _line = (KernelRay)this.itsPath;
            _line.getP1P2(this.auxl1, this.auxl2);
            step = (1000.0 + _l) / _l;
            _line.getVector(this._v);
            this._v.unitario().productByNumber(step);
            _vx = this._v.getX();
            _vy = this._v.getY();
            startx = this.auxl1.itsX;
            double starty = this.auxl1.itsY;
            for (CoorSys o : this.itsPointList) {
                theP.move(startx += _vx, starty += _vy);
                theP.updateFromLocus();
                _coordx = _theI.getX();
                _coordy = _theI.getY();
                o.itsX = _coordx;
                o.itsY = _coordy;
                this.data_x[_count] = _coordx;
                this.data_y[_count] = _coordy;
                ++_count;
                if (!_first) continue;
                this.data_x[_count] = _coordx;
                this.data_y[_count] = _coordy;
                this.data_x[++_count] = _coordx;
                this.data_y[_count] = _coordy;
                ++_count;
                _first = false;
            }
        }
        if (this.type == 3) {
            _c = (KernelCircle)this.itsPath;
            double _cx = _c.getCenterX();
            double _cy = _c.getCenterY();
            this._v.setVector(_cx, _cy, theP.getX(), theP.getY());
            _l = this.itsPointList.size() - 2;
            double _stepp = Math.PI * 2 / _l;
            for (CoorSys o : this.itsPointList) {
                this._v.rotation(_stepp);
                theP.move(_cx + this._v.getX(), _cy + this._v.getY());
                theP.updateFromLocus();
                _coordx = _theI.getX();
                _coordy = _theI.getY();
                o.itsX = _coordx;
                o.itsY = _coordy;
                this.data_x[_count] = _coordx;
                this.data_y[_count] = _coordy;
                ++_count;
                if (!_first) continue;
                this.data_x[_count] = _coordx;
                this.data_y[_count] = _coordy;
                this.data_x[++_count] = _coordx;
                this.data_y[_count] = _coordy;
                ++_count;
                _first = false;
            }
        }
        if (this.type == 4) {
            KernelLocus _loc = (KernelLocus)this.itsPath;
            ArrayList _points = (ArrayList)_loc.getPointVector();
            Iterator _jj = _points.iterator();
            Iterator _i = this.itsPointList.iterator();
            while (_i.hasNext()) {
                CoorSys _p = (CoorSys)_jj.next();
                CoorSys _o = (CoorSys)_i.next();
                theP.setXY(_p.itsX, _p.itsY);
                theP.updateFromLocus();
                _coordx = _theI.getX();
                _coordy = _theI.getY();
                _o.itsX = _coordx;
                _o.itsY = _coordy;
                this.data_x[_count] = _coordx;
                this.data_y[_count] = _coordy;
                ++_count;
                if (!_first) continue;
                this.data_x[_count] = _coordx;
                this.data_y[_count] = _coordy;
                this.data_x[++_count] = _coordx;
                this.data_y[_count] = _coordy;
                ++_count;
                _first = false;
            }
        }
        if (this.type != 5) {
            this.data_x[_count] = _coordx;
            this.data_y[_count] = _coordy;
            this.data_x[++_count] = _coordx;
            this.data_y[_count] = _coordy;
        }
        this.SolveSystem(this.up, this.low, this.gamma, this.l, this.data_x, this.bspl_x);
        this.SolveSystem(this.up, this.low, this.gamma, this.l, this.data_y, this.bspl_y);
        int _outpts = this.BsplToPoints(this.DEGREE, this.l, this.bspl_x, this.knot, this.DENSE, this.points_x);
        _outpts = this.BsplToPoints(this.DEGREE, this.l, this.bspl_y, this.knot, this.DENSE, this.points_y);
        int _segcount = 0;
        Iterator _seg = this.itsSegmentList.iterator();
        int _ii = this.DENSE + 2;
        while (_ii < _outpts - (this.DENSE + 1)) {
            if (_segcount != this.DENSE) {
                KernelDummySegment _e = (KernelDummySegment)_seg.next();
                this.auxl1.itsX = this.points_x[_ii - 1];
                this.auxl1.itsY = this.points_y[_ii - 1];
                this.auxl2.itsX = this.points_x[_ii];
                this.auxl2.itsY = this.points_y[_ii];
                _e.setP1P2(this.auxl1, this.auxl2);
                ++_segcount;
            } else {
                _segcount = 0;
            }
            ++_ii;
        }
        if (this.type == 6) {
            _c = (KernelArc)this.itsPath;
            double _cx = _c.getCenterX();
            double _cy = _c.getCenterY();
            double _cr = _c.getRadius();
            this._v.setVector(_cx, _cy, _cx + _cr, _cy);
            this._v.rotation(-_c.getStartingAngle());
            _l = this.itsPointList.size() - 1;
            double _stepp = -_c.getArcAngle() / _l;
            _l += 1.0;
            int _i = 0;
            while ((double)_i < _l) {
                CoorSys o;
                o = (CoorSys)this.itsPointList.get(_i);
                this._v.rotation(_stepp);
                theP.move(_cx + this._v.getX(), _cy + this._v.getY());
                theP.updateFromLocus();
                _coordx = _theI.getX();
                _coordy = _theI.getY();
                o.itsX = _coordx;
                o.itsY = _coordy;
                this.data_x[_count] = _coordx;
                this.data_y[_count] = _coordy;
                ++_count;
                if (_first) {
                    this.data_x[_count] = _coordx;
                    this.data_y[_count] = _coordy;
                    this.data_x[++_count] = _coordx;
                    this.data_y[_count] = _coordy;
                    ++_count;
                    _first = false;
                }
                ++_i;
            }
        }
    }
}

