/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.kernel;

import br.ufrj.labma.enibam.kernel.AbstractKernelVector;
import br.ufrj.labma.enibam.kernel.Program;
import br.ufrj.labma.enibam.kernel.operations.CoorSys;
import br.ufrj.labma.enibam.kernel.state.State;
import br.ufrj.labma.enibam.kernel.state.VectorState;
import br.ufrj.labma.enibam.util.MathVector;

public class KernelVector2P
extends AbstractKernelVector {
    private double itsX1;
    private double itsY1;
    private double itsX2;
    private double itsY2;

    public KernelVector2P(Integer id, Program prog) {
        super(id, prog);
    }

    @Override
    public void changeState(State _state) throws ClassCastException {
        if (this.theConstraint == null || this.theConstraint.isOk(_state)) {
            VectorState _st = (VectorState)_state;
            this.itsDeletedStatus = _st.itsDeletedStatus;
            this.itsDefinedStatus = _st.itsDefinedStatus;
            this.itsX1 = _st.itsX1;
            this.itsX2 = _st.itsX2;
            this.itsY1 = _st.itsY1;
            this.itsY2 = _st.itsY2;
        }
    }

    @Override
    public void getState(State _state) throws ClassCastException {
        VectorState _st = (VectorState)_state;
        _st.itsMID = this.getMID();
        _st.itsDeletedStatus = this.itsDeletedStatus;
        _st.itsDefinedStatus = this.itsDefinedStatus;
        _st.itsX1 = this.itsX1;
        _st.itsX2 = this.itsX2;
        _st.itsY1 = this.itsY1;
        _st.itsY2 = this.itsY2;
    }

    @Override
    public void translate(double dx, double dy) {
        this._st1.itsX1 = this.itsX1 + dx;
        this._st1.itsY1 = this.itsY1 + dy;
        this._st1.itsX2 = this.itsX2 + dx;
        this._st1.itsY2 = this.itsY2 + dy;
        if (this.theConstraint == null || this.theConstraint.isOk(this._st1)) {
            VectorState _st = this._st1;
            this.itsDeletedStatus = _st.itsDeletedStatus;
            this.itsDefinedStatus = _st.itsDefinedStatus;
            this.itsX1 = _st.itsX1;
            this.itsX2 = _st.itsX2;
            this.itsY1 = _st.itsY1;
            this.itsY2 = _st.itsY2;
        } else if (this.itsFWSet != null) {
            this.forwardTranslate(dx, dy);
        }
    }

    @Override
    public double getX() {
        return this.itsX2 - this.itsX1;
    }

    @Override
    public double getY() {
        return this.itsY2 - this.itsY1;
    }

    @Override
    public void getXY(CoorSys p1) {
        p1.itsX = this.itsX2 - this.itsX1;
        p1.itsY = this.itsY2 - this.itsY1;
    }

    @Override
    public void setXY(CoorSys p1) {
        this.itsY1 = 0.0;
        this.itsX1 = 0.0;
        this.itsX2 = p1.itsX;
        this.itsY2 = p1.itsY;
    }

    @Override
    public void setXY(double X, double Y) {
        this.itsY1 = 0.0;
        this.itsX1 = 0.0;
        this.itsX2 = X;
        this.itsY2 = Y;
    }

    @Override
    public void getXY(MathVector v1) {
        v1.setX(this.itsX2 - this.itsX1);
        v1.setY(this.itsY2 - this.itsY1);
    }

    @Override
    public void setXY(MathVector v1) {
        this.itsY1 = 0.0;
        this.itsX1 = 0.0;
        this.itsX2 = v1.getX();
        this.itsY2 = v1.getY();
    }

    @Override
    public void setP1P2(CoorSys p1, CoorSys p2) {
        this.itsX1 = p1.itsX;
        this.itsX2 = p2.itsX;
        this.itsY1 = p1.itsY;
        this.itsY2 = p2.itsY;
    }

    @Override
    public void getP1P2(CoorSys p1, CoorSys p2) {
        p1.itsX = this.itsX1;
        p2.itsX = this.itsX2;
        p1.itsY = this.itsY1;
        p2.itsY = this.itsY2;
    }

    @Override
    public void setP1P2(double x1, double y1, double x2, double y2) {
        this.itsX1 = x1;
        this.itsX2 = x2;
        this.itsY1 = y1;
        this.itsY2 = y2;
    }

    @Override
    public double getLength() {
        return Math.sqrt((this.itsX2 - this.itsX1) * (this.itsX2 - this.itsX1) + (this.itsY2 - this.itsY1) * (this.itsY2 - this.itsY1));
    }
}

