/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.kernel;

import br.ufrj.labma.enibam.kernel.constraint.Constraint;
import java.io.Serializable;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public final class Program
implements Serializable {
    private Integer itsOwnerMID;
    private Set itsMIDFwSet;
    private SortedSet itsAlgoList;

    public Program(int ownerMID, Set MIDFwSet, Comparator c) {
        this.itsAlgoList = new TreeSet(c);
        this.itsOwnerMID = new Integer(ownerMID);
        this.itsMIDFwSet = MIDFwSet;
    }

    public Program(Program v) {
        this.itsAlgoList = new TreeSet(v.itsAlgoList);
        this.itsOwnerMID = v.itsOwnerMID;
        this.itsMIDFwSet = new HashSet(v.itsMIDFwSet);
    }

    public Program(int ownerMID, Set MIDFwSet, SortedSet s) {
        this.itsAlgoList = new TreeSet(s);
        this.itsOwnerMID = new Integer(ownerMID);
        this.itsMIDFwSet = MIDFwSet;
    }

    public Integer getOwnerMID() {
        return this.itsOwnerMID;
    }

    public void run() {
        Iterator _i = this.itsAlgoList.iterator();
        while (_i.hasNext()) {
            ((Constraint)_i.next()).calculate();
        }
    }

    public void runFromLocus() {
        Iterator _i = this.itsAlgoList.iterator();
        while (_i.hasNext()) {
            Constraint c = (Constraint)_i.next();
            if (c.getConstraintID() != 0) continue;
            c.calculate();
        }
    }

    public void add(Constraint a) {
        this.itsAlgoList.add(a);
    }

    public boolean remove(Constraint a) {
        Iterator i = this.itsAlgoList.iterator();
        boolean k = false;
        while (i.hasNext()) {
            Constraint b = (Constraint)i.next();
            if (a != b) continue;
            i.remove();
            k = true;
        }
        return k;
    }

    public boolean containSomeOfUs(Set MIDSet) {
        Iterator _i = MIDSet.iterator();
        while (_i.hasNext()) {
            if (!this.itsMIDFwSet.contains((Integer)_i.next())) continue;
            return true;
        }
        return false;
    }

    public SortedSet getAlgoSortedSet() {
        return new TreeSet(this.itsAlgoList);
    }

    public String toString() {
        String str = "===============================================\n";
        str = String.valueOf(str) + "Dono do Programa: MID= " + this.itsOwnerMID + "\nFwSet: " + this.itsMIDFwSet + "\n";
        str = String.valueOf(str) + "===============in\u00edcio do programa==============\n";
        Iterator _i = this.itsAlgoList.iterator();
        while (_i.hasNext()) {
            str = String.valueOf(str) + "\n" + ((Constraint)_i.next()).toString();
        }
        str = String.valueOf(str) + "================fim do programa================\n";
        return str;
    }
}

